/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/PsiPrecedences;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PRECEDENCE_OF_ATOMIC_EXPRESSION", "", "getPRECEDENCE_OF_ATOMIC_EXPRESSION", "()I", "PRECEDENCE_OF_POSTFIX_EXPRESSION", "getPRECEDENCE_OF_POSTFIX_EXPRESSION", "PRECEDENCE_OF_PREFIX_EXPRESSION", "getPRECEDENCE_OF_PREFIX_EXPRESSION", "precedence", "", "Lcom/intellij/psi/tree/IElementType;", "getPrecedence", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isTighter", "", "subject", "tighterThan", "idea-core"})
public final class PsiPrecedences {
    private static final Logger LOG;
    private static final Map<IElementType, Integer> precedence;
    private static final int PRECEDENCE_OF_ATOMIC_EXPRESSION = -1;
    private static final int PRECEDENCE_OF_PREFIX_EXPRESSION;
    private static final int PRECEDENCE_OF_POSTFIX_EXPRESSION;
    public static final PsiPrecedences INSTANCE;

    public final int getPRECEDENCE_OF_ATOMIC_EXPRESSION() {
        return PRECEDENCE_OF_ATOMIC_EXPRESSION;
    }

    public final int getPRECEDENCE_OF_PREFIX_EXPRESSION() {
        return PRECEDENCE_OF_PREFIX_EXPRESSION;
    }

    public final int getPRECEDENCE_OF_POSTFIX_EXPRESSION() {
        return PRECEDENCE_OF_POSTFIX_EXPRESSION;
    }

    public final int getPrecedence(@NotNull KtExpression expression2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtAnnotatedExpression || ktExpression instanceof KtLabeledExpression || ktExpression instanceof KtPrefixExpression) {
            n = PRECEDENCE_OF_PREFIX_EXPRESSION;
        } else if (ktExpression instanceof KtPostfixExpression) {
            n = PRECEDENCE_OF_POSTFIX_EXPRESSION;
        } else if (ktExpression instanceof KtOperationExpression) {
            IElementType operation = ((KtOperationExpression)expression2).getOperationReference().getReferencedNameElementType();
            Integer precedenceNumber = precedence.get(operation);
            if (precedenceNumber == null) {
                LOG.error("No precedence for operation: " + operation);
                n = precedence.size();
            } else {
                n = precedenceNumber;
            }
        } else {
            n = PRECEDENCE_OF_ATOMIC_EXPRESSION;
        }
        return n;
    }

    public final boolean isTighter(int subject, int tighterThan) {
        return subject < tighterThan;
    }

    private PsiPrecedences() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        PsiPrecedences psiPrecedences;
        INSTANCE = psiPrecedences = new PsiPrecedences();
        Logger logger = Logger.getInstance(PsiPrecedences.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(PsiPrecedences::class.java)");
        LOG = logger;
        HashMap builder = new HashMap();
        KotlinExpressionParsing.Precedence[] precedenceArray = KotlinExpressionParsing.Precedence.values();
        int n = precedenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            void i2;
            KotlinExpressionParsing.Precedence record2 = precedenceArray[n2];
            TokenSet tokenSet = record2.getOperations();
            Intrinsics.checkExpressionValueIsNotNull((Object)tokenSet, (String)"record.operations");
            for (IElementType elementType : tokenSet.getTypes()) {
                IElementType iElementType;
                Map map2 = builder;
                Intrinsics.checkExpressionValueIsNotNull((Object)elementType, (String)"elementType");
                Integer n3 = (int)i2;
                map2.put(iElementType, n3);
            }
            ++i2;
        }
        precedence = builder;
        PRECEDENCE_OF_ATOMIC_EXPRESSION = -1;
        PRECEDENCE_OF_PREFIX_EXPRESSION = KotlinExpressionParsing.Precedence.PREFIX.ordinal();
        PRECEDENCE_OF_POSTFIX_EXPRESSION = KotlinExpressionParsing.Precedence.POSTFIX.ordinal();
    }
}

