/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.declarationsSearch;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.ClassInheritorsSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearch;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchySearchRequest;
import org.jetbrains.kotlin.idea.search.declarationsSearch.HierarchyTraverser;
import org.jetbrains.kotlin.idea.search.declarationsSearch.KotlinPsiMethodOverridersSearch;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.search.declarationsSearch.PsiMethodOverridingHierarchyTraverser;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0018\u0010\b\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u00020\tj\b\u0012\u0004\u0012\u00020\u0002`\nH\u0014J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0014J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/search/declarationsSearch/KotlinPsiMethodOverridersSearch;", "Lorg/jetbrains/kotlin/idea/search/declarationsSearch/HierarchySearch;", "Lcom/intellij/psi/PsiMethod;", "()V", "doSearchDirect", "", "request", "Lorg/jetbrains/kotlin/idea/search/declarationsSearch/HierarchySearchRequest;", "consumer", "Lcom/intellij/util/Processor;", "Lorg/jetbrains/kotlin/compatibility/ExecutorProcessor;", "isApplicable", "", "searchDirectOverriders", "", "psiMethod", "idea-core"})
public final class KotlinPsiMethodOverridersSearch
extends HierarchySearch<PsiMethod> {
    public static final KotlinPsiMethodOverridersSearch INSTANCE;

    @NotNull
    public final Iterable<PsiMethod> searchDirectOverriders(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkParameterIsNotNull((Object)psiMethod, (String)"psiMethod");
        searchDirectOverriders.1 isAcceptable$ = searchDirectOverriders.1.INSTANCE;
        PsiClass psiClass2 = psiMethod.getContainingClass();
        if (psiClass2 == null) {
            List list2 = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.emptyList()");
            return list2;
        }
        LinkedHashMap classToMethod = new LinkedHashMap();
        HierarchyTraverser<PsiClass> classTraverser2 = new HierarchyTraverser<PsiClass>(classToMethod){
            final /* synthetic */ LinkedHashMap $classToMethod;

            @NotNull
            public Iterable<PsiClass> nextElements(@NotNull PsiClass current) {
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                Project project = current.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"current.project");
                Query query = DirectClassInheritorsSearch.search((PsiClass)current, (SearchScope)((SearchScope)SearchUtilKt.allScope(project)), (boolean)true);
                Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"DirectClassInheritorsSea\u2026rue\n                    )");
                return (Iterable)query;
            }

            public boolean shouldDescend(@NotNull PsiClass element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                return ClassInheritorsSearchKt.isInheritable(element3) && !this.$classToMethod.containsKey(element3);
            }
            {
                this.$classToMethod = $captured_local_variable$0;
            }

            public void forEach(@NotNull PsiClass initialElement, @NotNull Function1<? super PsiClass, Unit> body2) {
                Intrinsics.checkParameterIsNotNull((Object)initialElement, (String)"initialElement");
                Intrinsics.checkParameterIsNotNull(body2, (String)"body");
                HierarchyTraverser.DefaultImpls.forEach(this, initialElement, body2);
            }
        };
        classTraverser2.forEach((Object)psiClass2, (Function1)new Function1<PsiClass, Unit>(psiClass2, psiMethod, classToMethod){
            final /* synthetic */ PsiClass $psiClass;
            final /* synthetic */ PsiMethod $psiMethod;
            final /* synthetic */ LinkedHashMap $classToMethod;

            public final void invoke(@NotNull PsiClass inheritor) {
                Intrinsics.checkParameterIsNotNull((Object)inheritor, (String)"inheritor");
                PsiSubstitutor psiSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.$psiClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                Intrinsics.checkExpressionValueIsNotNull((Object)psiSubstitutor, (String)"TypeConversionUtil.getSu\u2026or, PsiSubstitutor.EMPTY)");
                PsiSubstitutor substitutor3 = psiSubstitutor;
                MethodSignature methodSignature = this.$psiMethod.getSignature(substitutor3);
                Intrinsics.checkExpressionValueIsNotNull((Object)methodSignature, (String)"psiMethod.getSignature(substitutor)");
                MethodSignature signature = methodSignature;
                PsiMethod candidate2 = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)signature, (boolean)false);
                if (candidate2 != null && searchDirectOverriders.1.INSTANCE.invoke(candidate2, inheritor, this.$psiMethod, this.$psiClass)) {
                    this.$classToMethod.put(inheritor, candidate2);
                }
            }
            {
                this.$psiClass = psiClass2;
                this.$psiMethod = psiMethod;
                this.$classToMethod = linkedHashMap;
                super(1);
            }
        });
        Collection collection = classToMethod.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"classToMethod.values");
        return collection;
    }

    @Override
    protected boolean isApplicable(@NotNull HierarchySearchRequest<PsiMethod> request) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        return (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(request){
            final /* synthetic */ HierarchySearchRequest $request;

            public final boolean invoke() {
                return OverridersSearchKt.isOverridableElement(this.$request.getOriginalElement());
            }
            {
                this.$request = hierarchySearchRequest;
                super(0);
            }
        });
    }

    @Override
    protected void doSearchDirect(@NotNull HierarchySearchRequest<PsiMethod> request, @NotNull Processor<? super PsiMethod> consumer2) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        Intrinsics.checkParameterIsNotNull(consumer2, (String)"consumer");
        Iterable<PsiMethod> $receiver$iv = this.searchDirectOverriders(request.getOriginalElement());
        Iterator<PsiMethod> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            PsiMethod element$iv;
            PsiMethod method = element$iv = iterator2.next();
            consumer2.process((Object)method);
        }
    }

    private KotlinPsiMethodOverridersSearch() {
        super(PsiMethodOverridingHierarchyTraverser.INSTANCE);
    }

    static {
        KotlinPsiMethodOverridersSearch kotlinPsiMethodOverridersSearch;
        INSTANCE = kotlinPsiMethodOverridersSearch = new KotlinPsiMethodOverridersSearch();
    }
}

