/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.script.configuration;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionsManager;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.idea.script.configuration.KotlinScriptDefinitionsModel;
import org.jetbrains.kotlin.idea.script.configuration.KotlinScriptDefinitionsModelDescriptor;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;

public class KotlinScriptingSettingsConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    public static final String ID = "preferences.language.Kotlin.scripting";
    private JPanel root;
    private JPanel panelScriptDefinitionsChooser;
    private JCheckBox scriptDependenciesAutoReload;
    private KotlinScriptDefinitionsModel model;
    private final ScriptDefinitionsManager manager;
    private final KotlinScriptingSettings settings;

    public KotlinScriptingSettingsConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.manager = ScriptDefinitionsManager.Companion.getInstance(project);
        this.settings = KotlinScriptingSettings.Companion.getInstance(project);
    }

    @Nullable
    public JComponent createComponent() {
        this.model = KotlinScriptDefinitionsModel.Companion.createModel(this.manager.getAllDefinitions(), this.settings);
        this.panelScriptDefinitionsChooser.setLayout(new BorderLayout());
        this.panelScriptDefinitionsChooser.add(ToolbarDecorator.createDecorator((JTable)new TableView((ListTableModel)this.model)).disableAddAction().disableRemoveAction().createPanel());
        return this.root;
    }

    public boolean isModified() {
        return this.isModified(this.scriptDependenciesAutoReload, this.settings.isAutoReloadEnabled()) || this.isScriptDefinitionsChanged();
    }

    public void apply() {
        this.settings.setAutoReloadEnabled(this.scriptDependenciesAutoReload.isSelected());
        if (this.isScriptDefinitionsChanged()) {
            for (KotlinScriptDefinitionsModelDescriptor item : this.model.getItems()) {
                KotlinScriptDefinition definition = item.getDefinition();
                this.settings.setOrder(definition, this.model.getItems().indexOf(item));
                this.settings.setEnabled(definition, item.isEnabled());
            }
            this.manager.reorderScriptDefinitions();
        }
    }

    public void reset() {
        this.scriptDependenciesAutoReload.setSelected(this.settings.isAutoReloadEnabled());
        this.model.setDefinitions(this.manager.getAllDefinitions(), this.settings);
    }

    private boolean isScriptDefinitionsChanged() {
        for (KotlinScriptDefinitionsModelDescriptor item : this.model.getItems()) {
            if (this.settings.isScriptDefinitionEnabled(item.getDefinition()) == item.isEnabled()) continue;
            return true;
        }
        return !this.model.getDefinitions().equals(this.manager.getAllDefinitions());
    }

    @Nls
    public String getDisplayName() {
        return "Kotlin Scripting";
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            KotlinScriptingSettingsConfigurable.$$$reportNull$$$0(0);
        }
        return ID;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.root = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Manage script definitions", (int)0, (int)0, null, null));
        this.panelScriptDefinitionsChooser = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.scriptDependenciesAutoReload = jCheckBox = new JCheckBox();
        jCheckBox.setText("Reload script dependencies on file change");
        jPanel4.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/script/configuration/KotlinScriptingSettingsConfigurable", "getId"));
    }
}

