/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.roots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinSourceRootTypeKt;
import org.jetbrains.kotlin.config.ResourceKotlinRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestResourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u000eH\u0002\u001a\u001e\u0010\u000f\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0002\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010*\u00020\u0012\u001a\u0014\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00110\u0011*\u00020\u0012H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"KOTLIN_AWARE_SOURCE_ROOT_TYPES", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "Lorg/jetbrains/jps/model/java/JavaSourceRootProperties;", "getKotlinAwareDestinationSourceRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "migrateNonJvmSourceFolders", "", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "collectKotlinAwareDestinationSourceRoots", "Lcom/intellij/openapi/module/Module;", "getMigratedSourceRootTypeWithProperties", "Lkotlin/Pair;", "Lorg/jetbrains/jps/model/JpsElement;", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRoot;", "getOrCreateProperties", "kotlin.jvm.PlatformType", "idea"})
public final class ProjectRootUtilsKt {
    private static final Set<JpsModuleSourceRootType<JavaSourceRootProperties>> KOTLIN_AWARE_SOURCE_ROOT_TYPES;

    private static final JpsElement getOrCreateProperties(@NotNull JpsModuleSourceRoot $receiver) {
        JpsElement jpsElement;
        block6: {
            block5: {
                jpsElement = $receiver.getProperties($receiver.getRootType());
                if (jpsElement == null) break block5;
                JpsElement jpsElement2 = jpsElement;
                JpsElement it = jpsElement2;
                JpsElement jpsElement3 = it;
                if (!(jpsElement3 instanceof JpsElementBase)) {
                    jpsElement3 = null;
                }
                JpsElementBase jpsElementBase = (JpsElementBase)jpsElement3;
                if (jpsElementBase != null) {
                    jpsElementBase.setParent(null);
                }
                if ((jpsElement = jpsElement2) != null) break block6;
            }
            jpsElement = (JpsElement)$receiver.getRootType().createDefaultProperties();
        }
        return jpsElement;
    }

    @Nullable
    public static final Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> getMigratedSourceRootTypeWithProperties(@NotNull JpsModuleSourceRoot $receiver) {
        JpsElementType jpsElementType;
        JpsModuleSourceRootType currentRootType;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        JpsModuleSourceRootType jpsModuleSourceRootType = $receiver.getRootType();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRootType, (String)"rootType");
        JpsModuleSourceRootType jpsModuleSourceRootType2 = currentRootType = jpsModuleSourceRootType;
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaSourceRootType.SOURCE)) {
            jpsElementType = (JpsElementType)SourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaSourceRootType.TEST_SOURCE)) {
            jpsElementType = (JpsElementType)TestSourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaResourceRootType.RESOURCE)) {
            jpsElementType = (JpsElementType)ResourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType2, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            jpsElementType = (JpsElementType)TestResourceKotlinRootType.INSTANCE;
        } else {
            return null;
        }
        if (jpsElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.jps.model.module.JpsModuleSourceRootType<org.jetbrains.jps.model.JpsElement>");
        }
        JpsModuleSourceRootType newSourceRootType = (JpsModuleSourceRootType)jpsElementType;
        return TuplesKt.to((Object)newSourceRootType, (Object)ProjectRootUtilsKt.getOrCreateProperties($receiver));
    }

    /*
     * WARNING - void declaration
     */
    public static final void migrateNonJvmSourceFolders(@NotNull ModifiableRootModel modifiableRootModel) {
        Intrinsics.checkParameterIsNotNull((Object)modifiableRootModel, (String)"modifiableRootModel");
        ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
        int n = contentEntryArray.length;
        for (int j = 0; j < n; ++j) {
            ContentEntry contentEntry;
            ContentEntry contentEntry2 = contentEntry = contentEntryArray[j];
            Intrinsics.checkExpressionValueIsNotNull((Object)contentEntry2, (String)"contentEntry");
            SourceFolder[] sourceFolderArray = contentEntry2.getSourceFolders();
            int n2 = sourceFolderArray.length;
            for (int k = 0; k < n2; ++k) {
                void newSourceRootType;
                String url;
                Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> pair2;
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = sourceFolderArray[k];
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder2, (String)"sourceFolder");
                JpsModuleSourceRoot jpsModuleSourceRoot = sourceFolder2.getJpsElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModuleSourceRoot, (String)"sourceFolder.jpsElement");
                if (ProjectRootUtilsKt.getMigratedSourceRootTypeWithProperties(jpsModuleSourceRoot) == null) {
                    continue;
                }
                JpsModuleSourceRootType jpsModuleSourceRootType = (JpsModuleSourceRootType)pair2.component1();
                JpsElement properties2 = (JpsElement)pair2.component2();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceFolder.getUrl(), (String)"sourceFolder.url");
                contentEntry.removeSourceFolder(sourceFolder);
                contentEntry.addSourceFolder(url, (JpsModuleSourceRootType)newSourceRootType, properties2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> getKotlinAwareDestinationSourceRoots(@NotNull Project project) {
        void var3_3;
        void $receiver$iv$iv;
        Module[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] moduleArray2 = $receiver$iv = moduleArray;
        Collection destination$iv$iv = new ArrayList();
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it;
            void v2 = it = (element$iv$iv = var4_4[j]);
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            Iterable list$iv$iv = ProjectRootUtilsKt.collectKotlinAwareDestinationSourceRoots((Module)v2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    private static final List<VirtualFile> collectKotlinAwareDestinationSourceRoots(@NotNull Module $receiver) {
        Object[] objectArray = ProjectUtil.getRootManager((Module)$receiver).getContentEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"rootManager\n        .contentEntries");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)collectKotlinAwareDestinationSourceRoots.1.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.2.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.3.INSTANCE));
    }

    static {
        Set set2 = JavaModuleSourceRootTypes.SOURCES;
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"JavaModuleSourceRootTypes.SOURCES");
        KOTLIN_AWARE_SOURCE_ROOT_TYPES = SetsKt.plus((Set)set2, (Iterable)KotlinSourceRootTypeKt.getALL_KOTLIN_SOURCE_ROOT_TYPES());
    }

    public static final /* synthetic */ Set access$getKOTLIN_AWARE_SOURCE_ROOT_TYPES$p() {
        return KOTLIN_AWARE_SOURCE_ROOT_TYPES;
    }
}

