/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ui;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeJavaClassChooserDialog;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.AbstractMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorComboBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.idea.completion.CompletionUtilsKt;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.projectView.KtClassOrObjectTreeNode;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberInfo;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionPanel;
import org.jetbrains.kotlin.idea.refactoring.memberInfo.KotlinMemberSelectionTable;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.KotlinMoveTargetForExistingElement;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.Mover;
import org.jetbrains.kotlin.idea.refactoring.ui.KotlinTypeReferenceEditorComboWithBrowseButton;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;

public class MoveKotlinNestedClassesDialog
extends RefactoringDialog {
    private static final String RECENTS_KEY = MoveKotlinNestedClassesDialog.class.getName() + ".RECENTS_KEY";
    private final KtClassOrObject originalClass;
    private final MoveCallback moveCallback;
    private JPanel mainPanel;
    private JTextField originalClassField;
    private JPanel membersInfoPanel;
    private KotlinTypeReferenceEditorComboWithBrowseButton targetClassChooser;
    private JCheckBox openInEditorCheckBox;
    private JPanel targetClassChooserPanel;
    private KotlinMemberSelectionTable memberTable;
    private PsiElement targetClass;

    public MoveKotlinNestedClassesDialog(@NotNull Project project, @NotNull List<KtClassOrObject> elementsToMove2, @NotNull KtClassOrObject originalClass, @NotNull KtClassOrObject targetClass, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(0);
        }
        if (elementsToMove2 == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(1);
        }
        if (originalClass == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(2);
        }
        if (targetClass == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(3);
        }
        super(project, true);
        this.originalClass = originalClass;
        this.targetClass = targetClass;
        this.moveCallback = moveCallback;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle(MoveHandler.REFACTORING_NAME);
        this.initClassChooser(targetClass);
        this.initMemberInfo(elementsToMove2);
        this.validateButtons();
    }

    private void initClassChooser(@NotNull KtClassOrObject initialTargetClass) {
        if (initialTargetClass == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(4);
        }
        this.originalClassField.setText(this.originalClass.getFqName().asString());
        this.targetClassChooser = new KotlinTypeReferenceEditorComboWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeJavaClassChooserDialog chooser2 = new TreeJavaClassChooserDialog(RefactoringBundle.message((String)"choose.destination.class"), MoveKotlinNestedClassesDialog.this.myProject, GlobalSearchScope.projectScope((Project)MoveKotlinNestedClassesDialog.this.myProject), new ClassFilter(){

                    public boolean isAccepted(PsiClass aClass2) {
                        if (!(aClass2 instanceof KtLightClassForSourceDeclaration)) {
                            return false;
                        }
                        KtClassOrObject classOrObject = ((KtLightClassForSourceDeclaration)aClass2).getKotlinOrigin();
                        if (classOrObject instanceof KtObjectDeclaration) {
                            return !((KtObjectDeclaration)classOrObject).isObjectLiteral();
                        }
                        if (classOrObject instanceof KtClass) {
                            KtClass ktClass2 = (KtClass)classOrObject;
                            return !ktClass2.isInner() && !ktClass2.isAnnotation();
                        }
                        return false;
                    }
                }, null, null, true){

                    @Nullable
                    protected PsiClass getSelectedFromTreeUserObject(DefaultMutableTreeNode node) {
                        PsiClass psiClass2 = super.getSelectedFromTreeUserObject(node);
                        if (psiClass2 != null) {
                            return psiClass2;
                        }
                        Object userObject = node.getUserObject();
                        if (!(userObject instanceof KtClassOrObjectTreeNode)) {
                            return null;
                        }
                        return LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObjectTreeNode)((Object)userObject)).getValue());
                    }
                };
                chooser2.selectDirectory((MoveKotlinNestedClassesDialog.this.targetClass != null ? MoveKotlinNestedClassesDialog.this.targetClass : MoveKotlinNestedClassesDialog.this.originalClass).getContainingFile().getContainingDirectory());
                chooser2.showDialog();
                PsiClass aClass2 = chooser2.getSelected();
                if (aClass2 instanceof KtLightClassForSourceDeclaration) {
                    MoveKotlinNestedClassesDialog.this.targetClass = ((KtLightClassForSourceDeclaration)aClass2).getKotlinOrigin();
                    MoveKotlinNestedClassesDialog.this.targetClassChooser.setText(aClass2.getQualifiedName());
                } else {
                    MoveKotlinNestedClassesDialog.this.targetClass = (PsiElement)aClass2;
                }
            }
        }, initialTargetClass.getFqName().asString(), this.originalClass, RECENTS_KEY);
        KtTypeCodeFragment codeFragment = this.targetClassChooser.getCodeFragment();
        if (codeFragment != null) {
            CompletionUtilsKt.setExtraCompletionFilter(codeFragment, (Function1<? super LookupElement, Boolean>)new Function1<LookupElement, Boolean>(){

                public Boolean invoke(LookupElement lookupElement2) {
                    Object lookupObject2 = lookupElement2.getObject();
                    if (!(lookupObject2 instanceof DeclarationLookupObject)) {
                        return false;
                    }
                    PsiElement psiElement2 = ((DeclarationLookupObject)lookupObject2).getPsiElement();
                    if (!(psiElement2 instanceof KtClassOrObject)) {
                        return false;
                    }
                    return KotlinRefactoringUtilKt.canRefactor(psiElement2);
                }
            });
        }
        ((EditorComboBox)this.targetClassChooser.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                PsiClass aClass2 = JavaPsiFacade.getInstance((Project)MoveKotlinNestedClassesDialog.this.myProject).findClass(MoveKotlinNestedClassesDialog.this.targetClassChooser.getText(), GlobalSearchScope.projectScope((Project)MoveKotlinNestedClassesDialog.this.myProject));
                MoveKotlinNestedClassesDialog.this.targetClass = aClass2 instanceof KtLightClassForSourceDeclaration ? ((KtLightClassForSourceDeclaration)aClass2).getKotlinOrigin() : aClass2;
                MoveKotlinNestedClassesDialog.this.validateButtons();
            }
        });
        this.targetClassChooserPanel.add((Component)((Object)this.targetClassChooser));
    }

    private void initMemberInfo(final @NotNull List<KtClassOrObject> elementsToMove2) {
        if (elementsToMove2 == null) {
            MoveKotlinNestedClassesDialog.$$$reportNull$$$0(5);
        }
        List memberInfos = CollectionsKt.mapNotNull(this.originalClass.getDeclarations(), (Function1)new Function1<KtDeclaration, KotlinMemberInfo>(){

            public KotlinMemberInfo invoke(KtDeclaration declaration2) {
                if (!(declaration2 instanceof KtClassOrObject)) {
                    return null;
                }
                KtClassOrObject classOrObject = (KtClassOrObject)declaration2;
                if (classOrObject instanceof KtClass && ((KtClass)classOrObject).isInner()) {
                    return null;
                }
                if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion()) {
                    return null;
                }
                KotlinMemberInfo memberInfo = new KotlinMemberInfo(classOrObject, false);
                memberInfo.setChecked(elementsToMove2.contains(declaration2));
                return memberInfo;
            }
        });
        KotlinMemberSelectionPanel selectionPanel = new KotlinMemberSelectionPanel(this.getTitle(), memberInfos, null);
        this.memberTable = selectionPanel.getTable();
        MemberInfoModelImpl memberInfoModel = new MemberInfoModelImpl();
        memberInfoModel.memberInfoChanged(new MemberInfoChange((Collection)memberInfos));
        selectionPanel.getTable().setMemberInfoModel((MemberInfoModel)memberInfoModel);
        selectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        this.membersInfoPanel.add((Component)((Object)selectionPanel), "Center");
    }

    private List<KtClassOrObject> getSelectedElementsToMove() {
        return CollectionsKt.map((Iterable)this.memberTable.getSelectedMemberInfos(), (Function1)new Function1<KotlinMemberInfo, KtClassOrObject>(){

            public KtClassOrObject invoke(KotlinMemberInfo info) {
                return (KtClassOrObject)info.getMember();
            }
        });
    }

    protected JComponent createCenterPanel() {
        return this.mainPanel;
    }

    protected String getDimensionServiceKey() {
        return "#" + ((Object)((Object)this)).getClass().getName();
    }

    protected void canRun() throws ConfigurationException {
        if (this.targetClass == null) {
            throw new ConfigurationException("No destination class specified");
        }
        if (!(this.targetClass instanceof KtClassOrObject)) {
            throw new ConfigurationException("Destination class must be a Kotlin class");
        }
        if (this.originalClass == this.targetClass) {
            throw new ConfigurationException(RefactoringBundle.message((String)"source.and.destination.classes.should.be.different"));
        }
        for (KtClassOrObject classOrObject : this.getSelectedElementsToMove()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)classOrObject, (PsiElement)this.targetClass, (boolean)false)) continue;
            throw new ConfigurationException("Cannot move nested class " + classOrObject.getName() + " to itself");
        }
    }

    protected void doAction() {
        List<KtClassOrObject> elementsToMove2 = this.getSelectedElementsToMove();
        KotlinMoveTargetForExistingElement target = new KotlinMoveTargetForExistingElement((KtClassOrObject)this.targetClass);
        MoveDeclarationsDelegate.NestedClass delegate = new MoveDeclarationsDelegate.NestedClass();
        MoveDeclarationsDescriptor descriptor2 = new MoveDeclarationsDescriptor(this.myProject, MoveKotlinDeclarationsProcessorKt.MoveSource(elementsToMove2), target, delegate, false, false, false, this.moveCallback, this.openInEditorCheckBox.isSelected());
        this.invokeRefactoring(new MoveKotlinDeclarationsProcessor(descriptor2, Mover.Default.INSTANCE));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.targetClassChooser.getChildComponent();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JPanel jPanel3;
        JTextField jTextField;
        JPanel jPanel4;
        this.mainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Move members from:");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.originalClassField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel5.add((Component)jTextField, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("To (fully qualified name):");
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.targetClassChooserPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel7, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.openInEditorCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Open moved members in editor");
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.membersInfoPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTargetClass";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/ui/MoveKotlinNestedClassesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "initClassChooser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "initMemberInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MemberInfoModelImpl
    extends AbstractMemberInfoModel<KtNamedDeclaration, KotlinMemberInfo> {
        private MemberInfoModelImpl() {
        }
    }
}

