/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.migration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.intentions.declarations.ConvertMemberToExtensionIntention;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.CleanupFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrateExternalExtensionFix;
import org.jetbrains.kotlin.idea.quickfix.migration.MigrateExternalExtensionFix$fixNativeClass$;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\"#B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0002H\u0002J\"\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\"\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J4\u0010\u001a\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0004\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\b\b\u0002\u0010 \u001a\u00020!H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/quickfix/CleanupFix;", "declaration", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)V", "convertNativeAnnotationToJsName", "", "annotations", "Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$JsNativeAnnotations;", "fetchJsNativeAnnotations", "fixAnnotations", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixExtensionMemberDeclaration", "fixNativeClass", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getFamilyName", "", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "appendParameters", "Lorg/jetbrains/kotlin/psi/BuilderByPattern;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "lParenth", "rParenth", "skipLast", "", "Companion", "JsNativeAnnotations", "idea"})
public final class MigrateExternalExtensionFix
extends KotlinQuickFixAction<KtNamedDeclaration>
implements CleanupFix {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Fix with 'asDynamic'";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getElement();
        if (ktNamedDeclaration == null) {
            return;
        }
        KtNamedDeclaration declaration2 = ktNamedDeclaration;
        if (MigrateExternalExtensionFix.Companion.isMemberExtensionDeclaration(declaration2)) {
            this.fixExtensionMemberDeclaration(declaration2, editor2);
        } else if (MigrateExternalExtensionFix.Companion.isMemberDeclaration(declaration2)) {
            KtClassOrObject containingClass = KtPsiUtilKt.getContainingClassOrObject(declaration2);
            if (containingClass != null) {
                this.fixNativeClass(containingClass);
            }
        } else if (declaration2 instanceof KtClassOrObject) {
            this.fixNativeClass((KtClassOrObject)declaration2);
        }
    }

    private final void fixNativeClass(KtClassOrObject containingClass) {
        Object $receiver$iv = CollectionsKt.asSequence((Iterable)containingClass.getDeclarations());
        Sequence sequence2 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)fixNativeClass$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        List membersToFix2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)fixNativeClass.membersToFix.1.INSTANCE), (Function1)((Function1)new Function1<KtCallableDeclaration, Pair<? extends KtCallableDeclaration, ? extends JsNativeAnnotations>>(this){
            final /* synthetic */ MigrateExternalExtensionFix this$0;

            @NotNull
            public final Pair<KtCallableDeclaration, JsNativeAnnotations> invoke(@NotNull KtCallableDeclaration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return TuplesKt.to((Object)it, (Object)MigrateExternalExtensionFix.access$fetchJsNativeAnnotations(this.this$0, it));
            }
            {
                this.this$0 = migrateExternalExtensionFix;
                super(1);
            }
        })), (Function1)fixNativeClass.membersToFix.3.INSTANCE));
        $receiver$iv = CollectionsKt.asReversed((List)membersToFix2);
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Pair $memberDeclaration_annotations = (Pair)element$iv;
            KtCallableDeclaration memberDeclaration = (KtCallableDeclaration)$memberDeclaration_annotations.component1();
            JsNativeAnnotations annotations2 = (JsNativeAnnotations)$memberDeclaration_annotations.component2();
            if (!(annotations2.getNativeAnnotation() == null || annotations2.isGetter() || annotations2.isSetter() || annotations2.isInvoke())) {
                this.convertNativeAnnotationToJsName(memberDeclaration, annotations2);
                annotations2.getNativeAnnotation().delete();
                continue;
            }
            KtCallableDeclaration externalDeclaration = ConvertMemberToExtensionIntention.Companion.convert(memberDeclaration);
            this.fixExtensionMemberDeclaration(externalDeclaration, null);
        }
        JsNativeAnnotations classAnnotations = this.fetchJsNativeAnnotations(containingClass);
        this.fixAnnotations(containingClass, classAnnotations, null);
    }

    private final JsNativeAnnotations fetchJsNativeAnnotations(KtNamedDeclaration declaration2) {
        boolean isGetter = false;
        boolean isSetter = false;
        boolean isInvoke = false;
        KtAnnotationEntry nativeAnnotation = null;
        ArrayList<KtAnnotationEntry> nativeAnnotations = new ArrayList<KtAnnotationEntry>();
        Object object = declaration2.getModifierList();
        if (object != null && (object = ((KtModifierList)object).getAnnotationEntries()) != null) {
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                KtAnnotationEntry it;
                KtAnnotationEntry ktAnnotationEntry = it = (KtAnnotationEntry)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"it");
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(ktAnnotationEntry, PredefinedAnnotation.NATIVE_GETTER)) {
                    isGetter = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, PredefinedAnnotation.NATIVE_SETTER)) {
                    isSetter = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                if (MigrateExternalExtensionFix.Companion.isJsAnnotation(it, PredefinedAnnotation.NATIVE_INVOKE)) {
                    isInvoke = true;
                    nativeAnnotations.add(it);
                    continue;
                }
                if (!MigrateExternalExtensionFix.Companion.isJsAnnotation(it, PredefinedAnnotation.NATIVE)) continue;
                nativeAnnotations.add(it);
                nativeAnnotation = it;
            }
        }
        return new JsNativeAnnotations((List<? extends KtAnnotationEntry>)nativeAnnotations, nativeAnnotation, isGetter, isSetter, isInvoke);
    }

    private final void fixExtensionMemberDeclaration(KtNamedDeclaration declaration2, Editor editor2) {
        Name name2 = declaration2.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"declaration.nameAsSafeName");
        Name name3 = name2;
        JsNativeAnnotations annotations2 = this.fetchJsNativeAnnotations(declaration2);
        this.fixAnnotations(declaration2, annotations2, editor2);
        KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default(declaration2, false, 2, null);
        KtExpression body2 = CreateByPatternKt.buildExpression$default(ktPsiFactory, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(this, annotations2, declaration2, name3){
            final /* synthetic */ MigrateExternalExtensionFix this$0;
            final /* synthetic */ JsNativeAnnotations $annotations;
            final /* synthetic */ KtNamedDeclaration $declaration;
            final /* synthetic */ Name $name;

            public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                Name name2 = Name.identifier("asDynamic");
                Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"asDynamic\")");
                $receiver.appendName(name2);
                if (this.$annotations.isGetter()) {
                    $receiver.appendFixedText("()");
                    if (this.$declaration instanceof KtNamedFunction) {
                        MigrateExternalExtensionFix.appendParameters$default(this.this$0, $receiver, (KtNamedFunction)this.$declaration, "[", "]", false, 8, null);
                    }
                } else if (this.$annotations.isSetter()) {
                    $receiver.appendFixedText("()");
                    if (this.$declaration instanceof KtNamedFunction) {
                        MigrateExternalExtensionFix.access$appendParameters(this.this$0, $receiver, (KtNamedFunction)this.$declaration, "[", "]", true);
                        List<KtParameter> list2 = ((KtNamedFunction)this.$declaration).getValueParameters();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"declaration.valueParameters");
                        Object object = CollectionsKt.last(list2);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"declaration.valueParameters.last()");
                        Name name3 = ((KtParameter)object).getNameAsName();
                        if (name3 != null) {
                            Name name4;
                            Name it = name4 = name3;
                            $receiver.appendFixedText(" = ");
                            Name name5 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)name5, (String)"it");
                            $receiver.appendName(name5);
                        }
                    }
                } else if (this.$annotations.isInvoke()) {
                    $receiver.appendFixedText("()");
                    if (this.$declaration instanceof KtNamedFunction) {
                        MigrateExternalExtensionFix.appendParameters$default(this.this$0, $receiver, (KtNamedFunction)this.$declaration, "(", ")", false, 8, null);
                    }
                } else {
                    $receiver.appendFixedText("().");
                    $receiver.appendName(this.$name);
                    if (this.$declaration instanceof KtNamedFunction) {
                        MigrateExternalExtensionFix.appendParameters$default(this.this$0, $receiver, (KtNamedFunction)this.$declaration, "(", ")", false, 8, null);
                    }
                }
            }
            {
                this.this$0 = migrateExternalExtensionFix;
                this.$annotations = jsNativeAnnotations;
                this.$declaration = ktNamedDeclaration;
                this.$name = name2;
                super(1);
            }
        }, 1, null);
        if (declaration2 instanceof KtNamedFunction) {
            KtExpression ktExpression = ((KtNamedFunction)declaration2).getBodyExpression();
            if (ktExpression != null) {
                ktExpression.delete();
            }
            PsiElement psiElement2 = ((KtNamedFunction)declaration2).getEqualsToken();
            if (psiElement2 != null) {
                psiElement2.delete();
            }
            if (annotations2.isSetter() || annotations2.isInvoke()) {
                KtBlockExpression blockBody = KtPsiFactory.createSingleStatementBlock$default(ktPsiFactory, body2, null, null, 6, null);
                declaration2.add((PsiElement)blockBody);
            } else {
                declaration2.add(ktPsiFactory.createEQ());
                declaration2.add((PsiElement)body2);
            }
        } else if (declaration2 instanceof KtProperty) {
            KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration2).getSetter();
            if (ktPropertyAccessor != null) {
                ktPropertyAccessor.delete();
            }
            KtPropertyAccessor ktPropertyAccessor2 = ((KtProperty)declaration2).getGetter();
            if (ktPropertyAccessor2 != null) {
                ktPropertyAccessor2.delete();
            }
            KtPropertyAccessor getter2 = ktPsiFactory.createPropertyGetter(body2);
            declaration2.add(getter2);
            if (((KtProperty)declaration2).isVar()) {
                KtExpression setterBody2 = CreateByPatternKt.buildExpression$default(ktPsiFactory, false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(name3){
                    final /* synthetic */ Name $name;

                    public final void invoke(@NotNull BuilderByPattern<KtExpression> $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                        Name name2 = Name.identifier("asDynamic");
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"asDynamic\")");
                        $receiver.appendName(name2);
                        $receiver.appendFixedText("().");
                        $receiver.appendName(this.$name);
                        $receiver.appendFixedText(" = ");
                        Name name3 = Name.identifier("value");
                        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"value\")");
                        $receiver.appendName(name3);
                    }
                    {
                        this.$name = name2;
                        super(1);
                    }
                }, 1, null);
                KtProperty setterStubProperty = ktPsiFactory.createProperty("val x: Unit set(value) { Unit }");
                KtPropertyAccessor ktPropertyAccessor3 = setterStubProperty.getSetter();
                if (ktPropertyAccessor3 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor3, (String)"setterStubProperty.setter!!");
                KtBlockExpression ktBlockExpression = ktPropertyAccessor3.getBodyBlockExpression();
                if (ktBlockExpression == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktBlockExpression, (String)"setterStubProperty.setter!!.bodyBlockExpression!!");
                KtBlockExpression block = ktBlockExpression;
                List<KtExpression> list2 = block.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"block.statements");
                ((KtExpression)CollectionsKt.single(list2)).replace((PsiElement)setterBody2);
                KtPropertyAccessor ktPropertyAccessor4 = setterStubProperty.getSetter();
                if (ktPropertyAccessor4 == null) {
                    Intrinsics.throwNpe();
                }
                declaration2.add(ktPropertyAccessor4);
            }
        }
    }

    private final void fixAnnotations(KtNamedDeclaration declaration2, JsNativeAnnotations annotations2, Editor editor2) {
        Iterable $receiver$iv = annotations2.getAnnotations();
        for (Object element$iv : $receiver$iv) {
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
            it.delete();
        }
        if (declaration2 instanceof KtClassOrObject) {
            declaration2.addModifier(KtTokens.EXTERNAL_KEYWORD);
        } else {
            declaration2.addModifier(KtTokens.INLINE_KEYWORD);
            declaration2.removeModifier(KtTokens.EXTERNAL_KEYWORD);
        }
        if (declaration2 instanceof KtFunction) {
            KtModifierListOwner ktModifierListOwner = declaration2;
            FqName fqName2 = KotlinBuiltIns.FQ_NAMES.suppress;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.suppress");
            ModifierListModifactorKt.addAnnotation$default(ktModifierListOwner, fqName2, "\"NOTHING_TO_INLINE\"", null, null, 12, null);
        }
        this.convertNativeAnnotationToJsName(declaration2, annotations2);
        if (declaration2 instanceof KtFunction && !((KtFunction)declaration2).hasDeclaredReturnType() && !annotations2.isSetter() && !annotations2.isInvoke() && editor2 != null) {
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)declaration2;
            SimpleType simpleType2 = PlatformKt.getBuiltIns(declaration2).getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"declaration.builtIns.unitType");
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor2, ktCallableDeclaration, simpleType2);
        }
    }

    private final void convertNativeAnnotationToJsName(KtNamedDeclaration declaration2, JsNativeAnnotations annotations2) {
        KtAnnotationEntry nativeAnnotation = annotations2.getNativeAnnotation();
        if (nativeAnnotation != null) {
            List<? extends ValueArgument> list2 = nativeAnnotation.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"nativeAnnotation.valueArguments");
            Collection collection = list2;
            if (!collection.isEmpty()) {
                KtModifierListOwner ktModifierListOwner = declaration2;
                FqName fqName2 = new FqName("JsName");
                List<? extends ValueArgument> list3 = nativeAnnotation.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"nativeAnnotation.valueArguments");
                ModifierListModifactorKt.addAnnotation$default(ktModifierListOwner, fqName2, CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, (Function1)convertNativeAnnotationToJsName.1.INSTANCE, (int)31, null), null, null, 12, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendParameters(@NotNull BuilderByPattern<KtExpression> $receiver, KtNamedFunction declaration2, String lParenth, String rParenth, boolean skipLast) {
        List list2;
        $receiver.appendFixedText(lParenth);
        boolean bl = false;
        List list3 = declaration2.getValueParameters();
        List it = list3;
        if (skipLast) {
            List list4 = it;
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"it");
            list2 = CollectionsKt.take((Iterable)list4, (int)(it.size() - 1));
        } else {
            List list5 = it;
            list2 = list5;
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"it");
        }
        Iterator iterator2 = ((Iterable)list2).iterator();
        while (iterator2.hasNext()) {
            void index2;
            KtParameter param;
            KtParameter ktParameter = param = (KtParameter)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"param");
            if (ktParameter.getNameAsName() != null) {
                Object paramName = list3;
                if (index2 > 0) {
                    $receiver.appendFixedText(",");
                }
                Object object = paramName;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"paramName");
                $receiver.appendName((Name)object);
            }
            ++index2;
        }
        $receiver.appendFixedText(rParenth);
    }

    static /* synthetic */ void appendParameters$default(MigrateExternalExtensionFix migrateExternalExtensionFix, BuilderByPattern builderByPattern, KtNamedFunction ktNamedFunction, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        migrateExternalExtensionFix.appendParameters(builderByPattern, ktNamedFunction, string, string2, bl);
    }

    public MigrateExternalExtensionFix(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        super((PsiElement)declaration2);
    }

    public static final /* synthetic */ JsNativeAnnotations access$fetchJsNativeAnnotations(MigrateExternalExtensionFix $this, KtNamedDeclaration declaration2) {
        return $this.fetchJsNativeAnnotations(declaration2);
    }

    public static final /* synthetic */ void access$appendParameters(MigrateExternalExtensionFix $this, BuilderByPattern $receiver, KtNamedFunction declaration2, String lParenth, String rParenth, boolean skipLast) {
        $this.appendParameters($receiver, declaration2, lParenth, rParenth, skipLast);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003JC\u0010\u0015\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\rR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$JsNativeAnnotations;", "", "annotations", "", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "nativeAnnotation", "isGetter", "", "isSetter", "isInvoke", "(Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;ZZZ)V", "getAnnotations", "()Ljava/util/List;", "()Z", "getNativeAnnotation", "()Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "idea"})
    private static final class JsNativeAnnotations {
        @NotNull
        private final List<KtAnnotationEntry> annotations;
        @Nullable
        private final KtAnnotationEntry nativeAnnotation;
        private final boolean isGetter;
        private final boolean isSetter;
        private final boolean isInvoke;

        @NotNull
        public final List<KtAnnotationEntry> getAnnotations() {
            return this.annotations;
        }

        @Nullable
        public final KtAnnotationEntry getNativeAnnotation() {
            return this.nativeAnnotation;
        }

        public final boolean isGetter() {
            return this.isGetter;
        }

        public final boolean isSetter() {
            return this.isSetter;
        }

        public final boolean isInvoke() {
            return this.isInvoke;
        }

        public JsNativeAnnotations(@NotNull List<? extends KtAnnotationEntry> annotations2, @Nullable KtAnnotationEntry nativeAnnotation, boolean isGetter, boolean isSetter, boolean isInvoke) {
            Intrinsics.checkParameterIsNotNull(annotations2, (String)"annotations");
            this.annotations = annotations2;
            this.nativeAnnotation = nativeAnnotation;
            this.isGetter = isGetter;
            this.isSetter = isSetter;
            this.isInvoke = isInvoke;
        }

        @NotNull
        public final List<KtAnnotationEntry> component1() {
            return this.annotations;
        }

        @Nullable
        public final KtAnnotationEntry component2() {
            return this.nativeAnnotation;
        }

        public final boolean component3() {
            return this.isGetter;
        }

        public final boolean component4() {
            return this.isSetter;
        }

        public final boolean component5() {
            return this.isInvoke;
        }

        @NotNull
        public final JsNativeAnnotations copy(@NotNull List<? extends KtAnnotationEntry> annotations2, @Nullable KtAnnotationEntry nativeAnnotation, boolean isGetter, boolean isSetter, boolean isInvoke) {
            Intrinsics.checkParameterIsNotNull(annotations2, (String)"annotations");
            return new JsNativeAnnotations(annotations2, nativeAnnotation, isGetter, isSetter, isInvoke);
        }

        @NotNull
        public static /* synthetic */ JsNativeAnnotations copy$default(JsNativeAnnotations jsNativeAnnotations, List list2, KtAnnotationEntry ktAnnotationEntry, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = jsNativeAnnotations.annotations;
            }
            if ((n & 2) != 0) {
                ktAnnotationEntry = jsNativeAnnotations.nativeAnnotation;
            }
            if ((n & 4) != 0) {
                bl = jsNativeAnnotations.isGetter;
            }
            if ((n & 8) != 0) {
                bl2 = jsNativeAnnotations.isSetter;
            }
            if ((n & 0x10) != 0) {
                bl3 = jsNativeAnnotations.isInvoke;
            }
            return jsNativeAnnotations.copy(list2, ktAnnotationEntry, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "JsNativeAnnotations(annotations=" + this.annotations + ", nativeAnnotation=" + this.nativeAnnotation + ", isGetter=" + this.isGetter + ", isSetter=" + this.isSetter + ", isInvoke=" + this.isInvoke + ")";
        }

        public int hashCode() {
            List<KtAnnotationEntry> list2 = this.annotations;
            KtAnnotationEntry ktAnnotationEntry = this.nativeAnnotation;
            int n = ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (ktAnnotationEntry != null ? ktAnnotationEntry.hashCode() : 0)) * 31;
            int n2 = this.isGetter ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            int n3 = (n + n2) * 31;
            int n4 = this.isSetter ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.isInvoke ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            return n5 + n6;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JsNativeAnnotations)) break block3;
                    JsNativeAnnotations jsNativeAnnotations = (JsNativeAnnotations)object;
                    if (!Intrinsics.areEqual(this.annotations, jsNativeAnnotations.annotations) || !Intrinsics.areEqual((Object)this.nativeAnnotation, (Object)jsNativeAnnotations.nativeAnnotation) || !(this.isGetter == jsNativeAnnotations.isGetter) || !(this.isSetter == jsNativeAnnotations.isSetter) || !(this.isInvoke == jsNativeAnnotations.isInvoke)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J%\u0010\f\u001a\u00020\b*\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0012\u001a\u00020\b*\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/migration/MigrateExternalExtensionFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "isMemberDeclaration", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "isMemberExtensionDeclaration", "isJsAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "predefinedAnnotations", "", "Lorg/jetbrains/kotlin/js/PredefinedAnnotation;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;[Lorg/jetbrains/kotlin/js/PredefinedAnnotation;)Z", "isJsNativeAnnotation", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isJsAnnotation(@NotNull KtAnnotationEntry $receiver, PredefinedAnnotation ... predefinedAnnotations) {
            PredefinedAnnotation[] $receiver$iv;
            BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
            AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)bindingContext2.get(BindingContext.ANNOTATION, $receiver);
            if (annotationDescriptor == null) return false;
            PredefinedAnnotation[] predefinedAnnotationArray = $receiver$iv = predefinedAnnotations;
            int n = predefinedAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                PredefinedAnnotation element$iv;
                PredefinedAnnotation it = element$iv = predefinedAnnotationArray[n2];
                if (Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)it.getFqName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private final boolean isJsNativeAnnotation(@NotNull KtAnnotationEntry $receiver) {
            return this.isJsAnnotation($receiver, PredefinedAnnotation.NATIVE, PredefinedAnnotation.NATIVE_GETTER, PredefinedAnnotation.NATIVE_SETTER, PredefinedAnnotation.NATIVE_INVOKE);
        }

        private final boolean isMemberExtensionDeclaration(PsiElement psiElement2) {
            return psiElement2 instanceof KtNamedFunction && ((KtNamedFunction)psiElement2).getReceiverTypeReference() != null || psiElement2 instanceof KtProperty && ((KtProperty)psiElement2).getReceiverTypeReference() != null;
        }

        private final boolean isMemberDeclaration(PsiElement psiElement2) {
            return psiElement2 instanceof KtNamedFunction && ((KtNamedFunction)psiElement2).getReceiverTypeReference() == null || psiElement2 instanceof KtProperty && ((KtProperty)psiElement2).getReceiverTypeReference() == null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement e = psiElement2;
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, ErrorsJs.WRONG_EXTERNAL_DECLARATION)) {
                if (this.isMemberExtensionDeclaration(e)) {
                    void $receiver$iv;
                    PsiElement psiElement3 = e;
                    boolean strict$iv = true;
                    if (PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClassOrObject.class, (boolean)strict$iv) == null) {
                        PsiElement psiElement4 = e;
                        if (psiElement4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                        }
                        return new MigrateExternalExtensionFix((KtNamedDeclaration)psiElement4);
                    }
                }
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.DEPRECATION_ERROR) || Intrinsics.areEqual(diagnosticFactory, Errors.DEPRECATION)) {
                Object object;
                PsiElement psiElement5;
                Object $receiver$iv = e;
                boolean strict$iv = false;
                KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtAnnotationEntry.class, (boolean)strict$iv);
                if (ktAnnotationEntry != null) {
                    if (this.isJsNativeAnnotation(ktAnnotationEntry)) {
                        $receiver$iv = e;
                        strict$iv = false;
                        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtNamedDeclaration.class, (boolean)strict$iv);
                        if (ktNamedDeclaration != null) {
                            Object it = $receiver$iv = ktNamedDeclaration;
                            return new MigrateExternalExtensionFix((KtNamedDeclaration)it);
                        }
                    }
                }
                if (!((psiElement5 = e) instanceof KtNamedDeclaration)) {
                    psiElement5 = null;
                }
                if ((object = (KtNamedDeclaration)psiElement5) != null && (object = object.getModifierList()) != null && (object = ((KtModifierList)object).getAnnotationEntries()) != null) {
                    boolean bl;
                    block16: {
                        $receiver$iv = (Iterable)object;
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            bl = false;
                        } else {
                            Iterator iterator2 = $receiver$iv.iterator();
                            while (iterator2.hasNext()) {
                                KtAnnotationEntry it;
                                Object element$iv = iterator2.next();
                                KtAnnotationEntry ktAnnotationEntry2 = it = (KtAnnotationEntry)element$iv;
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry2, (String)"it");
                                if (!Companion.isJsNativeAnnotation(ktAnnotationEntry2)) continue;
                                bl = true;
                                break block16;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        PsiElement psiElement6 = e;
                        if (psiElement6 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
                        }
                        return new MigrateExternalExtensionFix((KtNamedDeclaration)psiElement6);
                    }
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

