/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix.expectactual;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.expectactual.AbstractCreateDeclarationFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualClassFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualFunctionFix;
import org.jetbrains.kotlin.idea.quickfix.expectactual.CreateActualPropertyFix;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.MultiTargetPlatformKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u001bBF\b\u0002\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012%\u0010\t\u001a!\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\n\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\u0010\u000eJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFix;", "D", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/AbstractCreateDeclarationFix;", "declaration", "actualModule", "Lcom/intellij/openapi/module/Module;", "actualPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "generateIt", "Lkotlin/Function3;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lcom/intellij/openapi/project/Project;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;Lkotlin/jvm/functions/Function3;)V", "findExistingFileToCreateDeclaration", "Lorg/jetbrains/kotlin/psi/KtFile;", "originalFile", "originalDeclaration", "getText", "", "invoke", "", "project", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Companion", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualClassFix;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualPropertyFix;", "Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFunctionFix;", "idea"})
public abstract class CreateActualFix<D extends KtNamedDeclaration>
extends AbstractCreateDeclarationFix<D> {
    private final MultiTargetPlatform.Specific actualPlatform;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getText() {
        return "Create actual " + this.getElementType() + " for module " + this.getModule().getName() + " (" + this.actualPlatform.getPlatform() + ')';
    }

    @Override
    protected final void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtFile ktFile = this.getOrCreateImplementationFile();
        if (ktFile == null) {
            return;
        }
        KtFile actualFile = ktFile;
        this.doGenerate(project, editor2, file, actualFile, null);
    }

    @Override
    @Nullable
    protected KtFile findExistingFileToCreateDeclaration(@NotNull KtFile originalFile, @NotNull KtNamedDeclaration originalDeclaration) {
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        Intrinsics.checkParameterIsNotNull((Object)originalDeclaration, (String)"originalDeclaration");
        for (KtDeclaration otherDeclaration : originalFile.getDeclarations()) {
            if (otherDeclaration == originalDeclaration || !PsiUtilsKt.hasExpectModifier(otherDeclaration)) continue;
            KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.singleOrNull((Iterable)ExpectActualUtilKt.actualsForExpected(otherDeclaration, this.getModule()));
            if (ktDeclaration == null) {
                continue;
            }
            KtDeclaration actualDeclaration = ktDeclaration;
            return actualDeclaration.getContainingKtFile();
        }
        return null;
    }

    private CreateActualFix(D declaration2, Module actualModule, MultiTargetPlatform.Specific actualPlatform, Function3<? super KtPsiFactory, ? super Project, ? super D, ? extends D> generateIt) {
        super(declaration2, actualModule, generateIt);
        this.actualPlatform = actualPlatform;
    }

    public /* synthetic */ CreateActualFix(KtNamedDeclaration declaration2, Module actualModule, MultiTargetPlatform.Specific actualPlatform, Function3 generateIt, DefaultConstructorMarker $constructor_marker) {
        this(declaration2, actualModule, actualPlatform, generateIt);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/expectactual/CreateActualFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            ModuleSourceInfo moduleSourceInfo;
            Map compatibility;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            Object d = DiagnosticFactory.cast(diagnostic, Errors.NO_ACTUAL_FOR_EXPECT);
            Intrinsics.checkExpressionValueIsNotNull(d, (String)"DiagnosticFactory.cast(d\u2026ors.NO_ACTUAL_FOR_EXPECT)");
            DiagnosticWithParameters3 d2 = (DiagnosticWithParameters3)d;
            Object e = d2.getPsiElement();
            if (!(e instanceof KtNamedDeclaration)) {
                e = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)e;
            if (ktNamedDeclaration == null) {
                return null;
            }
            KtNamedDeclaration declaration2 = ktNamedDeclaration;
            Object c = d2.getC();
            Intrinsics.checkExpressionValueIsNotNull(c, (String)"d.c");
            Map map2 = compatibility = (Map)c;
            if (!map2.isEmpty() && !(declaration2 instanceof KtFunction)) {
                return null;
            }
            Object b = d2.getB();
            Intrinsics.checkExpressionValueIsNotNull(b, (String)"d.b");
            ModuleDescriptor actualModuleDescriptor = (ModuleDescriptor)b;
            ModuleInfo moduleInfo2 = actualModuleDescriptor.getCapability(ModuleInfo.Companion.getCapability());
            if (!(moduleInfo2 instanceof ModuleSourceInfo)) {
                moduleInfo2 = null;
            }
            if ((moduleSourceInfo = (ModuleSourceInfo)moduleInfo2) == null || (moduleSourceInfo = moduleSourceInfo.getModule()) == null) {
                return null;
            }
            ModuleSourceInfo actualModule = moduleSourceInfo;
            MultiTargetPlatform multiTargetPlatform = MultiTargetPlatformKt.getMultiTargetPlatform(actualModuleDescriptor);
            if (!(multiTargetPlatform instanceof MultiTargetPlatform.Specific)) {
                multiTargetPlatform = null;
            }
            MultiTargetPlatform.Specific specific = (MultiTargetPlatform.Specific)multiTargetPlatform;
            if (specific == null) {
                return null;
            }
            MultiTargetPlatform.Specific actualPlatform = specific;
            KtNamedDeclaration ktNamedDeclaration2 = declaration2;
            return ktNamedDeclaration2 instanceof KtClassOrObject ? (IntentionAction)new CreateActualClassFix((KtClassOrObject)declaration2, (Module)actualModule, actualPlatform) : (ktNamedDeclaration2 instanceof KtFunction ? (IntentionAction)new CreateActualFunctionFix((KtFunction)declaration2, (Module)actualModule, actualPlatform) : (ktNamedDeclaration2 instanceof KtProperty ? (IntentionAction)new CreateActualPropertyFix((KtProperty)declaration2, (Module)actualModule, actualPlatform) : null));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

