/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.AddArrayOfTypeFix;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFix;
import org.jetbrains.kotlin.idea.quickfix.AddToStringFix;
import org.jetbrains.kotlin.idea.quickfix.CastExpressionFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeCallableReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeToUseSpreadOperatorFix;
import org.jetbrains.kotlin.idea.quickfix.ConvertCollectionFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.LetImplementInterfaceFix;
import org.jetbrains.kotlin.idea.quickfix.NumberConversionFix;
import org.jetbrains.kotlin.idea.quickfix.QuickFixFactoryForTypeMismatchError;
import org.jetbrains.kotlin.idea.quickfix.WrapWithCollectionLiteralCallFix;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFix;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "reflectToRegularFunctionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Companion", "idea"})
public final class QuickFixFactoryForTypeMismatchError
extends KotlinIntentionActionsFactory {
    private static final Logger LOG;
    public static final Companion Companion;

    private final KotlinType reflectToRegularFunctionType(@NotNull KotlinType $receiver) {
        Annotations annotations2 = $receiver.getAnnotations();
        FqName fqName2 = KotlinBuiltIns.FQ_NAMES.extensionFunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.FQ_NAMES.extensionFunctionType");
        boolean isTypeAnnotatedWithExtensionFunctionType = annotations2.findAnnotation(fqName2) != null;
        int parameterCount = isTypeAnnotatedWithExtensionFunctionType ? $receiver.getArguments().size() - 2 : $receiver.getArguments().size() - 1;
        Annotations annotations3 = $receiver.getAnnotations();
        ClassDescriptor classDescriptor2 = TypeUtilsKt.getBuiltIns($receiver).getFunction(parameterCount);
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"builtIns.getFunction(parameterCount)");
        return KotlinTypeFactory.simpleNotNullType(annotations3, classDescriptor2, $receiver.getArguments());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        KotlinType parameterVarargType;
        KotlinType valueArgumentType;
        Object object;
        KotlinType kotlinType2;
        KtIfExpression parentIf;
        PsiElement it;
        KotlinType expressionType;
        KotlinType expectedType;
        PsiElement diagnosticElement;
        BindingContext context;
        LinkedList<KotlinQuickFixAction> actions;
        block40: {
            block42: {
                block41: {
                    KtAnnotationEntry annotationEntry2;
                    KtFunction declaration2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    PsiElement expressionParent;
                    KtCallableDeclaration function2;
                    KotlinType kotlinType3;
                    Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                    actions = new LinkedList<KotlinQuickFixAction>();
                    PsiFile psiFile = diagnostic.getPsiFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    KtDeclarationContainer $receiver$iv = (KtFile)psiFile;
                    context = ResolutionUtils.getResolutionFacade((KtElement)((Object)$receiver$iv)).analyzeWithAllCompilerChecks(CollectionsKt.listOf((Object)$receiver$iv)).getBindingContext();
                    PsiElement psiElement2 = diagnostic.getPsiElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                    diagnosticElement = psiElement2;
                    if (!(diagnosticElement instanceof KtExpression)) {
                        LOG.error("Unexpected element: " + diagnosticElement.getText());
                        return CollectionsKt.emptyList();
                    }
                    DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
                    if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_MISMATCH)) {
                        Object d = Errors.TYPE_MISMATCH.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.TYPE_MISMATCH.cast(diagnostic)");
                        DiagnosticWithParameters2 diagnosticWithParameters2 = (DiagnosticWithParameters2)d;
                        Object a = diagnosticWithParameters2.getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)diagnosticWithParameters2.getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.NULL_FOR_NONNULL_TYPE)) {
                        Object d = Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.NULL_FOR_NONNULL_TYPE.cast(diagnostic)");
                        DiagnosticWithParameters1 diagnosticWithParameters1 = (DiagnosticWithParameters1)d;
                        Object a = diagnosticWithParameters1.getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = TypeUtilsKt.makeNullable(expectedType);
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH)) {
                        Object d = Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.TYPE_INFERENCE_EX\u2026MISMATCH.cast(diagnostic)");
                        DiagnosticWithParameters2 diagnosticWithParameters2 = (DiagnosticWithParameters2)d;
                        Object a = diagnosticWithParameters2.getA();
                        Intrinsics.checkExpressionValueIsNotNull(a, (String)"diagnosticWithParameters.a");
                        expectedType = (KotlinType)a;
                        expressionType = (KotlinType)diagnosticWithParameters2.getB();
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.CONSTANT_EXPECTED_TYPE_MISMATCH)) {
                        Object d = Errors.CONSTANT_EXPECTED_TYPE_MISMATCH.cast(diagnostic);
                        Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.CONSTANT_EXPECTED\u2026MISMATCH.cast(diagnostic)");
                        DiagnosticWithParameters2 diagnosticWithParameters2 = (DiagnosticWithParameters2)d;
                        Object b = diagnosticWithParameters2.getB();
                        Intrinsics.checkExpressionValueIsNotNull(b, (String)"diagnosticWithParameters.b");
                        expectedType = (KotlinType)b;
                        expressionType = context.getType((KtExpression)diagnosticElement);
                    } else if (Intrinsics.areEqual(diagnosticFactory, Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED)) {
                        IntegerValueTypeConstant.Companion companion;
                        CompileTimeConstant compileTimeConstant = (CompileTimeConstant)context.get(BindingContext.COMPILE_TIME_VALUE, diagnosticElement);
                        if (!(compileTimeConstant instanceof IntegerValueTypeConstant)) return CollectionsKt.emptyList();
                        IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)compileTimeConstant;
                        SimpleType simpleType2 = org.jetbrains.kotlin.types.TypeUtils.NO_EXPECTED_TYPE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"NO_EXPECTED_TYPE");
                        expectedType = integerValueTypeConstant.getType(simpleType2);
                        IntegerValueTypeConstant.Companion $receiver = companion = IntegerValueTypeConstant.Companion;
                        IntegerValueTypeConstant signedConstantValue = $receiver.convertToSignedConstant((IntegerValueTypeConstant)compileTimeConstant, ResolutionUtils.findModuleDescriptor((KtElement)diagnosticElement));
                        SimpleType simpleType3 = org.jetbrains.kotlin.types.TypeUtils.NO_EXPECTED_TYPE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"NO_EXPECTED_TYPE");
                        expressionType = signedConstantValue.getType(simpleType3);
                    } else {
                        LOG.error("Unexpected diagnostic: " + DefaultErrorMessages.render(diagnostic));
                        return CollectionsKt.emptyList();
                    }
                    if (expressionType == null) {
                        LOG.error("No type inferred: " + ((KtExpression)diagnosticElement).getText());
                        return CollectionsKt.emptyList();
                    }
                    if (TypeUtilsKt.isSignedOrUnsignedNumberType(expressionType) && TypeUtilsKt.isSignedOrUnsignedNumberType(expectedType)) {
                        void var7_8;
                        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = null;
                        if (diagnosticElement instanceof KtConstantExpression && !KotlinBuiltIns.isChar(expectedType)) {
                            WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix2 = new WrongPrimitiveLiteralFix((KtConstantExpression)diagnosticElement, expectedType);
                            actions.add(wrongPrimitiveLiteralFix2);
                        }
                        actions.add(new NumberConversionFix((KtExpression)diagnosticElement, expectedType, (IntentionAction)var7_8));
                    }
                    if (KotlinBuiltIns.isCharSequenceOrNullableCharSequence(expectedType) || KotlinBuiltIns.isStringOrNullableString(expectedType)) {
                        actions.add(new AddToStringFix((KtExpression)diagnosticElement, false));
                        if (expectedType.isMarkedNullable() && expressionType.isMarkedNullable()) {
                            actions.add(new AddToStringFix((KtExpression)diagnosticElement, true));
                        }
                    }
                    if (TypeUtilsKt.isInterface(expectedType)) {
                        KtClassOrObject ktClassOrObject;
                        PsiElement psiElement3;
                        PsiElement psiElement4;
                        ClassifierDescriptor classifierDescriptor = expressionType.getConstructor().getDeclarationDescriptor();
                        if (classifierDescriptor != null) {
                            ClassifierDescriptor classifierDescriptor2;
                            ClassifierDescriptor it2;
                            ClassifierDescriptor classifierDescriptor3 = it2 = (classifierDescriptor2 = classifierDescriptor);
                            Intrinsics.checkExpressionValueIsNotNull((Object)classifierDescriptor3, (String)"it");
                            psiElement4 = DescriptorToSourceUtils.descriptorToDeclaration(classifierDescriptor3);
                        } else {
                            psiElement4 = psiElement3 = null;
                        }
                        if (!(psiElement4 instanceof KtClassOrObject)) {
                            psiElement3 = null;
                        }
                        if ((ktClassOrObject = (KtClassOrObject)psiElement3) != null && Intrinsics.areEqual((Object)expectedType, (Object)org.jetbrains.kotlin.types.TypeUtils.makeNotNullable(expressionType)) ^ true) {
                            actions.add(new LetImplementInterfaceFix(ktClassOrObject, expectedType, expressionType));
                        }
                    }
                    actions.addAll((Collection)WrapWithCollectionLiteralCallFix.Companion.create(expectedType, expressionType, (KtExpression)diagnosticElement));
                    ConvertCollectionFix.CollectionType collectionType = ConvertCollectionFix.Companion.getConversionTypeOrNull(expressionType, expectedType);
                    if (collectionType != null) {
                        ConvertCollectionFix.CollectionType collectionType2;
                        ConvertCollectionFix.CollectionType collectionType3 = collectionType2 = collectionType;
                        actions.add(new ConvertCollectionFix((KtExpression)diagnosticElement, collectionType3));
                    }
                    doCreateActions.2 var7_14 = doCreateActions.2.INSTANCE;
                    if (Intrinsics.areEqual(diagnostic.getFactory(), Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED) ^ true && !(diagnosticElement instanceof KtBinaryExpressionWithTypeRHS) && !(((KtExpression)diagnosticElement).getParent() instanceof KtBinaryExpressionWithTypeRHS)) {
                        actions.add(new CastExpressionFix(var7_14.invoke((KtExpression)diagnosticElement), expectedType));
                    }
                    if (!expectedType.isMarkedNullable() && org.jetbrains.kotlin.types.TypeUtils.isNullableType(expressionType) && TypeUtilsKt.isSubtypeOf(expressionType, kotlinType3 = TypeUtilsKt.makeNullable(expectedType))) {
                        actions.add(new AddExclExclCallFix((PsiElement)var7_14.invoke((KtExpression)diagnosticElement)));
                    }
                    Function3 function3 = new Function3<D, KotlinType, Function2<? super D, ? super KotlinType, ? extends KotlinQuickFixAction<? extends KtCallableDeclaration>>, Unit>(this, context, actions){
                        final /* synthetic */ QuickFixFactoryForTypeMismatchError this$0;
                        final /* synthetic */ BindingContext $context;
                        final /* synthetic */ LinkedList $actions;

                        public final <D extends KtCallableDeclaration> void invoke(@NotNull D callable2, @NotNull KotlinType expressionType, @NotNull Function2<? super D, ? super KotlinType, ? extends KotlinQuickFixAction<? extends KtCallableDeclaration>> createFix) {
                            Intrinsics.checkParameterIsNotNull(callable2, (String)"callable");
                            Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
                            Intrinsics.checkParameterIsNotNull(createFix, (String)"createFix");
                            LexicalScope scope2 = ScopeUtils.getResolutionScope(callable2, this.$context, ResolutionUtils.getResolutionFacade(callable2));
                            KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(expressionType, scope2, false);
                            ClassifierDescriptor classifierDescriptor = typeToInsert.getConstructor().getDeclarationDescriptor();
                            if ((classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) == FunctionClassDescriptor.Kind.KFunction) {
                                this.$actions.add(createFix.invoke(callable2, (Object)QuickFixFactoryForTypeMismatchError.access$reflectToRegularFunctionType(this.this$0, typeToInsert)));
                            }
                            this.$actions.add(createFix.invoke(callable2, (Object)typeToInsert));
                        }
                        {
                            this.this$0 = quickFixFactoryForTypeMismatchError;
                            this.$context = bindingContext2;
                            this.$actions = linkedList;
                            super(3);
                        }
                    };
                    KtProperty property = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtProperty.class);
                    if (property != null) {
                        KtPropertyAccessor getter2 = property.getGetter();
                        KtExpression initializer2 = property.getInitializer();
                        if (QuickFixUtil.canEvaluateTo(initializer2, (KtExpression)diagnosticElement) || getter2 != null && QuickFixUtil.canFunctionOrGetterReturnExpression(getter2, (KtExpression)diagnosticElement)) {
                            function3.invoke((KtCallableDeclaration)property, expressionType, doCreateActions.4.INSTANCE);
                        }
                    }
                    KtCallableDeclaration ktCallableDeclaration = function2 = (expressionParent = ((KtExpression)diagnosticElement).getParent()) instanceof KtReturnExpression ? BindingContextUtilsKt.getTargetFunction((KtReturnExpression)expressionParent, context) : (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtFunction.class, (boolean)true);
                    if (function2 instanceof KtFunction && QuickFixUtil.canFunctionOrGetterReturnExpression(function2, (KtExpression)diagnosticElement)) {
                        function3.invoke(function2, expressionType, doCreateActions.5.INSTANCE);
                    }
                    if (diagnosticElement instanceof KtOperationExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if (diagnosticElement instanceof KtCallExpression && (resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)diagnosticElement, context)) != null && (declaration2 = QuickFixFactoryForTypeMismatchError.Companion.getFunctionDeclaration(resolvedCall2)) != null) {
                        actions.add(new ChangeCallableReturnTypeFix.ForCalled(declaration2, expectedType));
                    }
                    if ((annotationEntry2 = (KtAnnotationEntry)PsiTreeUtil.getParentOfType((PsiElement)diagnosticElement, KtAnnotationEntry.class)) == null) break block40;
                    if (!KotlinBuiltIns.isArray(expectedType)) break block41;
                    KotlinType kotlinType4 = expectedType.getArguments().get(0).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType4, (String)"expectedType.arguments[0].type");
                    if (TypeUtilsKt.isSubtypeOf(expressionType, kotlinType4)) break block42;
                }
                if (!KotlinBuiltIns.isPrimitiveArray(expectedType)) break block40;
            }
            actions.add(new AddArrayOfTypeFix((KtExpression)diagnosticElement, expectedType));
        }
        PsiElement $receiver$iv = diagnosticElement;
        KtParameter ktParameter = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtParameter.class, (boolean)true);
        if (ktParameter != null && Intrinsics.areEqual((Object)(it = ($receiver$iv = ktParameter)).getDefaultValue(), (Object)diagnosticElement)) {
            actions.add(new ChangeParameterTypeFix((KtParameter)it, expressionType));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getParentResolvedCall((KtElement)diagnosticElement, context, true);
        if (resolvedCall3 == null) return actions;
        KtIfExpression ktIfExpression = parentIf = QuickFixUtil.getParentIfForBranch((KtExpression)diagnosticElement);
        KtExpression argumentExpression2 = ktIfExpression != null ? (KtExpression)ktIfExpression : (KtExpression)diagnosticElement;
        Call call2 = resolvedCall3.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(call2, argumentExpression2);
        if (valueArgument == null) return actions;
        ValueParameterDescriptor correspondingParameterDescriptor = CallUtilKt.getParameterForArgument(resolvedCall3, valueArgument);
        PsiElement psiElement5 = QuickFixUtil.safeGetDeclaration(correspondingParameterDescriptor);
        if (!(psiElement5 instanceof KtParameter)) {
            psiElement5 = null;
        }
        KtParameter correspondingParameter = (KtParameter)psiElement5;
        KtExpression expressionFromArgument = valueArgument.getArgumentExpression();
        DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
        if (Intrinsics.areEqual(diagnosticFactory, Errors.NULL_FOR_NONNULL_TYPE) || Intrinsics.areEqual(diagnosticFactory, Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED)) {
            kotlinType2 = expressionType;
        } else {
            KtExpression ktExpression = expressionFromArgument;
            if (ktExpression != null) {
                object = ktExpression;
                KtExpression it3 = object;
                kotlinType2 = context.getType(it3);
            } else {
                kotlinType2 = valueArgumentType = null;
            }
        }
        if (valueArgumentType == null) return actions;
        if (correspondingParameter != null) {
            KtCallableDeclaration callable2;
            KtCallableDeclaration ktCallableDeclaration = callable2 = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)correspondingParameter, KtCallableDeclaration.class, (boolean)true);
            LexicalScope scope2 = ktCallableDeclaration != null ? ScopeUtils.getResolutionScope(ktCallableDeclaration, context, ResolutionUtils.getResolutionFacade(callable2)) : null;
            KotlinType typeToInsert = TypeUtils.approximateWithResolvableType(valueArgumentType, scope2, true);
            actions.add(new ChangeParameterTypeFix(correspondingParameter, typeToInsert));
        }
        ValueParameterDescriptor valueParameterDescriptor = correspondingParameterDescriptor;
        KotlinType kotlinType5 = parameterVarargType = valueParameterDescriptor != null ? valueParameterDescriptor.getVarargElementType() : null;
        if (parameterVarargType == null && !Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor()), (Object)new FqName("kotlin.collections.mapOf")) || !KotlinBuiltIns.isArray(valueArgumentType) || !(!(object = (Collection)expressionType.getArguments()).isEmpty()) || !Intrinsics.areEqual((Object)expressionType.getArguments().get(0).getType().getConstructor(), (Object)expectedType.getConstructor())) return actions;
        actions.add(new ChangeToUseSpreadOperatorFix((KtExpression)diagnosticElement));
        return actions;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(QuickFixFactoryForTypeMismatchError.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Quick\u2026ismatchError::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ KotlinType access$reflectToRegularFunctionType(QuickFixFactoryForTypeMismatchError $this, KotlinType $receiver) {
        return $this.reflectToRegularFunctionType($receiver);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/QuickFixFactoryForTypeMismatchError$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getFunctionDeclaration", "Lorg/jetbrains/kotlin/psi/KtFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "idea"})
    public static final class Companion {
        private final KtFunction getFunctionDeclaration(ResolvedCall<?> resolvedCall2) {
            PsiElement result2 = QuickFixUtil.safeGetDeclaration(resolvedCall2.getResultingDescriptor());
            if (result2 instanceof KtFunction) {
                return (KtFunction)result2;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

