/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "element", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "", "Companion", "idea"})
public final class MoveWhenElseBranchFix
extends KotlinQuickFixAction<KtWhenExpression> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Move else branch to the end";
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtWhenExpression ktWhenExpression = (KtWhenExpression)this.getElement();
        if (ktWhenExpression == null) {
            return false;
        }
        KtWhenExpression element3 = ktWhenExpression;
        return KtPsiUtil.checkWhenExpressionHasSingleElse(element3);
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Object v4;
        KtWhenEntry lastEntry;
        KtWhenExpression element3;
        block7: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtWhenExpression ktWhenExpression = (KtWhenExpression)this.getElement();
            if (ktWhenExpression == null) {
                return;
            }
            element3 = ktWhenExpression;
            List<KtWhenEntry> list2 = element3.getEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.entries");
            List<KtWhenEntry> entries2 = list2;
            KtWhenEntry ktWhenEntry = (KtWhenEntry)CollectionsKt.lastOrNull(entries2);
            if (ktWhenEntry == null) {
                return;
            }
            lastEntry = ktWhenEntry;
            Iterable $receiver$iv = entries2;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                KtWhenEntry it;
                KtWhenEntry ktWhenEntry2 = it = (KtWhenEntry)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry2, (String)"it");
                if (!ktWhenEntry2.isElse()) continue;
                if (found$iv) {
                    v4 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v4 = !found$iv ? null : single$iv;
        }
        KtWhenEntry ktWhenEntry = v4;
        if (ktWhenEntry == null) {
            return;
        }
        KtWhenEntry elseEntry = ktWhenEntry;
        Editor editor3 = editor2;
        if (editor3 == null) {
            Intrinsics.throwNpe();
        }
        CaretModel caretModel = editor3.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor!!.caretModel");
        int cursorOffset = caretModel.getOffset() - elseEntry.getTextOffset();
        PsiElement psiElement2 = element3.addAfter((PsiElement)elseEntry, (PsiElement)lastEntry);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenEntry");
        }
        KtWhenEntry insertedBranch = (KtWhenEntry)psiElement2;
        elseEntry.delete();
        KtWhenEntry insertedWhenEntry = (KtWhenEntry)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)insertedBranch));
        CaretModel caretModel2 = editor2.getCaretModel();
        KtWhenEntry ktWhenEntry3 = insertedWhenEntry;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry3, (String)"insertedWhenEntry");
        caretModel2.moveToOffset(ktWhenEntry3.getTextOffset() + cursorOffset);
    }

    public MoveWhenElseBranchFix(@NotNull KtWhenExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/MoveWhenElseBranchFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected MoveWhenElseBranchFix createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
            PsiElement $receiver$iv = psiElement2;
            KtWhenExpression ktWhenExpression = (KtWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtWhenExpression.class, (boolean)false);
            if (ktWhenExpression == null) {
                return null;
            }
            KtWhenExpression whenExpression2 = ktWhenExpression;
            return new MoveWhenElseBranchFix(whenExpression2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

