/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.callableBuilder.CallableInfo;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.createCallable.CreatePropertyDelegateAccessorsActionFactory;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\"\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;", "element", "makeVar", "", "actionText", "", "deleteInitializer", "(Lorg/jetbrains/kotlin/psi/KtValVarKeywordOwner;ZLjava/lang/String;Z)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "Companion", "idea"})
public final class ChangeVariableMutabilityFix
extends KotlinQuickFixAction<KtValVarKeywordOwner> {
    private final boolean makeVar;
    private final String actionText;
    private final boolean deleteInitializer;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAL_WITH_SETTER_FACTORY;
    @NotNull
    private static final Companion.ReassignmentActionFactory VAL_REASSIGNMENT_FACTORY;
    @NotNull
    private static final Companion.ReassignmentActionFactory CAPTURED_VAL_INITIALIZATION_FACTORY;
    @NotNull
    private static final Companion.ReassignmentActionFactory CAPTURED_MEMBER_VAL_INITIALIZATION_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAR_OVERRIDDEN_BY_VAL_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory VAR_ANNOTATION_PARAMETER_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory LATEINIT_VAL_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory CONST_VAL_FACTORY;
    @NotNull
    private static final KotlinSingleIntentionActionFactory DELEGATED_PROPERTY_VAL_FACTORY;
    public static final Companion Companion;

    @NotNull
    public String getText() {
        String string = this.actionText;
        if (string == null) {
            string = (this.makeVar ? "Change to var" : "Change to val") + (this.deleteInitializer ? " and delete initializer" : "");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtValVarKeywordOwner ktValVarKeywordOwner = (KtValVarKeywordOwner)this.getElement();
        if (ktValVarKeywordOwner == null) {
            return false;
        }
        KtValVarKeywordOwner element3 = ktValVarKeywordOwner;
        PsiElement psiElement2 = element3.getValOrVarKeyword();
        if (psiElement2 == null || (psiElement2 = psiElement2.getNode()) == null || (psiElement2 = psiElement2.getElementType()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.valOrVarKeyword?\u2026ementType ?: return false");
        PsiElement valOrVar = psiElement2;
        return Intrinsics.areEqual((Object)valOrVar, (Object)((Object)KtTokens.VAR_KEYWORD)) != this.makeVar;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            KtValVarKeywordOwner ktValVarKeywordOwner = (KtValVarKeywordOwner)this.getElement();
            if (ktValVarKeywordOwner == null) {
                return;
            }
            KtValVarKeywordOwner element3 = ktValVarKeywordOwner;
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            PsiElement newKeyword = this.makeVar ? factory2.createVarKeyword() : factory2.createValKeyword();
            PsiElement psiElement2 = element3.getValOrVarKeyword();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            psiElement2.replace(newKeyword);
            if (!this.deleteInitializer) break block4;
            KtValVarKeywordOwner ktValVarKeywordOwner2 = element3;
            if (!(ktValVarKeywordOwner2 instanceof KtProperty)) {
                ktValVarKeywordOwner2 = null;
            }
            KtProperty ktProperty = (KtProperty)ktValVarKeywordOwner2;
            if (ktProperty != null) {
                ktProperty.setInitializer(null);
            }
        }
    }

    public ChangeVariableMutabilityFix(@NotNull KtValVarKeywordOwner element3, boolean makeVar, @Nullable String actionText, boolean deleteInitializer) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        super((PsiElement)element3);
        this.makeVar = makeVar;
        this.actionText = actionText;
        this.deleteInitializer = deleteInitializer;
    }

    public /* synthetic */ ChangeVariableMutabilityFix(KtValVarKeywordOwner ktValVarKeywordOwner, boolean bl, String string, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(ktValVarKeywordOwner, bl, string, bl2);
    }

    static {
        Companion = new Companion(null);
        VAL_WITH_SETTER_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPropertyAccessor");
                }
                KtPropertyAccessor accessor = (KtPropertyAccessor)psiElement2;
                KtProperty ktProperty = accessor.getProperty();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"accessor.property");
                return new ChangeVariableMutabilityFix(ktProperty, true, null, false, 12, null);
            }
        };
        DiagnosticFactory1<KtExpression, DeclarationDescriptor> diagnosticFactory1 = Errors.VAL_REASSIGNMENT;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory1, (String)"Errors.VAL_REASSIGNMENT");
        VAL_REASSIGNMENT_FACTORY = new Companion.ReassignmentActionFactory(diagnosticFactory1);
        DiagnosticFactory1<KtExpression, DeclarationDescriptor> diagnosticFactory12 = Errors.CAPTURED_VAL_INITIALIZATION;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory12, (String)"Errors.CAPTURED_VAL_INITIALIZATION");
        CAPTURED_VAL_INITIALIZATION_FACTORY = new Companion.ReassignmentActionFactory(diagnosticFactory12);
        DiagnosticFactory1<KtExpression, DeclarationDescriptor> diagnosticFactory13 = Errors.CAPTURED_MEMBER_VAL_INITIALIZATION;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory13, (String)"Errors.CAPTURED_MEMBER_VAL_INITIALIZATION");
        CAPTURED_MEMBER_VAL_INITIALIZATION_FACTORY = new Companion.ReassignmentActionFactory(diagnosticFactory13);
        VAR_OVERRIDDEN_BY_VAL_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                IntentionAction intentionAction;
                PsiElement element3;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement2 = diagnostic.getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"diagnostic.psiElement");
                PsiElement psiElement3 = element3 = psiElement2;
                if (psiElement3 instanceof KtProperty || psiElement3 instanceof KtParameter) {
                    PsiElement psiElement4 = element3;
                    if (psiElement4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValVarKeywordOwner");
                    }
                    intentionAction = new ChangeVariableMutabilityFix((KtValVarKeywordOwner)psiElement4, true, null, false, 12, null);
                } else {
                    intentionAction = null;
                }
                return intentionAction;
            }
        };
        VAR_ANNOTATION_PARAMETER_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                PsiElement psiElement2 = diagnostic.getPsiElement();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                }
                KtParameter element3 = (KtParameter)psiElement2;
                return new ChangeVariableMutabilityFix(element3, false, null, false, 12, null);
            }
        };
        LATEINIT_VAL_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                E lateinitElement;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                D d = Errors.INAPPLICABLE_LATEINIT_MODIFIER.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.INAPPLICABLE_LATE\u2026MODIFIER.cast(diagnostic)");
                E e = ((DiagnosticWithParameters1)d).getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.INAPPLICABLE_LATE\u2026st(diagnostic).psiElement");
                E $receiver$iv = lateinitElement = e;
                KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType($receiver$iv, KtProperty.class, (boolean)true);
                if (ktProperty == null) {
                    return null;
                }
                KtProperty property = ktProperty;
                PsiElement psiElement2 = property.getValOrVarKeyword();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"property.valOrVarKeyword");
                if (Intrinsics.areEqual((Object)psiElement2.getText(), (Object)"val") ^ true) {
                    return null;
                }
                return new ChangeVariableMutabilityFix(property, true, null, false, 12, null);
            }
        };
        CONST_VAL_FACTORY = new KotlinSingleIntentionActionFactory(){

            /*
             * WARNING - void declaration
             */
            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                void modifier;
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                D d = Errors.WRONG_MODIFIER_TARGET.cast(diagnostic);
                DiagnosticWithParameters2 $receiver = (DiagnosticWithParameters2)d;
                Pair pair2 = TuplesKt.to($receiver.getA(), $receiver.getPsiElement());
                KtModifierKeywordToken ktModifierKeywordToken = (KtModifierKeywordToken)((Object)pair2.component1());
                PsiElement element3 = (PsiElement)pair2.component2();
                if (Intrinsics.areEqual((Object)modifier, (Object)((Object)KtTokens.CONST_KEYWORD)) ^ true) {
                    return null;
                }
                PsiElement psiElement2 = element3;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
                PsiElement $receiver$iv = psiElement2;
                KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtProperty.class, (boolean)true);
                if (ktProperty == null) {
                    return null;
                }
                KtProperty property = ktProperty;
                return new ChangeVariableMutabilityFix(property, false, null, false, 12, null);
            }
        };
        DELEGATED_PROPERTY_VAL_FACTORY = new KotlinSingleIntentionActionFactory(){

            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                D d = Errors.DELEGATE_SPECIAL_FUNCTION_MISSING.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"Errors.DELEGATE_SPECIAL_\u2026_MISSING.cast(diagnostic)");
                E e = ((DiagnosticWithParameters2)d).getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull(e, (String)"Errors.DELEGATE_SPECIAL_\u2026st(diagnostic).psiElement");
                KtExpression element3 = (KtExpression)e;
                PsiElement $receiver$iv = (PsiElement)element3;
                KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtProperty.class, (boolean)true);
                if (ktProperty == null) {
                    return null;
                }
                KtProperty property = ktProperty;
                CallableInfo callableInfo = (CallableInfo)CollectionsKt.singleOrNull(CreatePropertyDelegateAccessorsActionFactory.INSTANCE.extractFixData(property, diagnostic));
                if (callableInfo == null) {
                    return null;
                }
                CallableInfo info = callableInfo;
                if (Intrinsics.areEqual((Object)info.getName(), (Object)OperatorNameConventions.SET_VALUE.asString()) ^ true) {
                    return null;
                }
                return new ChangeVariableMutabilityFix(property, false, "Change to val", false, 8, null);
            }
        };
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion;", "", "()V", "CAPTURED_MEMBER_VAL_INITIALIZATION_FACTORY", "Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion$ReassignmentActionFactory;", "getCAPTURED_MEMBER_VAL_INITIALIZATION_FACTORY", "()Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion$ReassignmentActionFactory;", "CAPTURED_VAL_INITIALIZATION_FACTORY", "getCAPTURED_VAL_INITIALIZATION_FACTORY", "CONST_VAL_FACTORY", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "getCONST_VAL_FACTORY", "()Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "DELEGATED_PROPERTY_VAL_FACTORY", "getDELEGATED_PROPERTY_VAL_FACTORY", "LATEINIT_VAL_FACTORY", "getLATEINIT_VAL_FACTORY", "VAL_REASSIGNMENT_FACTORY", "getVAL_REASSIGNMENT_FACTORY", "VAL_WITH_SETTER_FACTORY", "getVAL_WITH_SETTER_FACTORY", "VAR_ANNOTATION_PARAMETER_FACTORY", "getVAR_ANNOTATION_PARAMETER_FACTORY", "VAR_OVERRIDDEN_BY_VAL_FACTORY", "getVAR_OVERRIDDEN_BY_VAL_FACTORY", "ReassignmentActionFactory", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinSingleIntentionActionFactory getVAL_WITH_SETTER_FACTORY() {
            return VAL_WITH_SETTER_FACTORY;
        }

        @NotNull
        public final ReassignmentActionFactory getVAL_REASSIGNMENT_FACTORY() {
            return VAL_REASSIGNMENT_FACTORY;
        }

        @NotNull
        public final ReassignmentActionFactory getCAPTURED_VAL_INITIALIZATION_FACTORY() {
            return CAPTURED_VAL_INITIALIZATION_FACTORY;
        }

        @NotNull
        public final ReassignmentActionFactory getCAPTURED_MEMBER_VAL_INITIALIZATION_FACTORY() {
            return CAPTURED_MEMBER_VAL_INITIALIZATION_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getVAR_OVERRIDDEN_BY_VAL_FACTORY() {
            return VAR_OVERRIDDEN_BY_VAL_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getVAR_ANNOTATION_PARAMETER_FACTORY() {
            return VAR_ANNOTATION_PARAMETER_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getLATEINIT_VAL_FACTORY() {
            return LATEINIT_VAL_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getCONST_VAL_FACTORY() {
            return CONST_VAL_FACTORY;
        }

        @NotNull
        public final KotlinSingleIntentionActionFactory getDELEGATED_PROPERTY_VAL_FACTORY() {
            return DELEGATED_PROPERTY_VAL_FACTORY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u001b\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeVariableMutabilityFix$Companion$ReassignmentActionFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "factory", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;)V", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "idea"})
        public static final class ReassignmentActionFactory
        extends KotlinSingleIntentionActionFactory {
            @NotNull
            private final DiagnosticFactory1<?, DeclarationDescriptor> factory;

            @Override
            @Nullable
            protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                Object d = this.factory.cast(diagnostic);
                Intrinsics.checkExpressionValueIsNotNull(d, (String)"factory.cast(diagnostic)");
                Object a = ((DiagnosticWithParameters1)d).getA();
                Intrinsics.checkExpressionValueIsNotNull(a, (String)"factory.cast(diagnostic).a");
                DeclarationDescriptor propertyDescriptor2 = (DeclarationDescriptor)a;
                PsiElement psiElement2 = DescriptorToSourceUtils.descriptorToDeclaration(propertyDescriptor2);
                if (!(psiElement2 instanceof KtValVarKeywordOwner)) {
                    psiElement2 = null;
                }
                KtValVarKeywordOwner ktValVarKeywordOwner = (KtValVarKeywordOwner)psiElement2;
                if (ktValVarKeywordOwner == null) {
                    return null;
                }
                KtValVarKeywordOwner declaration2 = ktValVarKeywordOwner;
                return new ChangeVariableMutabilityFix(declaration2, true, null, false, 12, null);
            }

            @NotNull
            public final DiagnosticFactory1<?, DeclarationDescriptor> getFactory() {
                return this.factory;
            }

            public ReassignmentActionFactory(@NotNull DiagnosticFactory1<?, DeclarationDescriptor> factory2) {
                Intrinsics.checkParameterIsNotNull(factory2, (String)"factory");
                this.factory = factory2;
            }
        }
    }
}

