/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.util.UtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToLabeledReturnFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "element", "labeledReturn", "", "(Lorg/jetbrains/kotlin/psi/KtReturnExpression;Ljava/lang/String;)V", "getLabeledReturn", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "idea"})
public final class ChangeToLabeledReturnFix
extends KotlinQuickFixAction<KtReturnExpression> {
    @NotNull
    private final String labeledReturn;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getFamilyName() {
        return "Change to return with label";
    }

    @NotNull
    public String getText() {
        return "Change to '" + this.labeledReturn + '\'';
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        KtReturnExpression ktReturnExpression = (KtReturnExpression)this.getElement();
        if (ktReturnExpression == null) {
            return;
        }
        KtReturnExpression returnExpression = ktReturnExpression;
        KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
        KtExpression returnedExpression = returnExpression.getReturnedExpression();
        KtExpression newExpression2 = returnedExpression == null ? factory2.createExpression(this.labeledReturn) : CreateByPatternKt.createExpressionByPattern$default(factory2, "$0 $1", new Object[]{this.labeledReturn, returnedExpression}, false, 4, null);
        returnExpression.replace((PsiElement)newExpression2);
    }

    @NotNull
    public final String getLabeledReturn() {
        return this.labeledReturn;
    }

    public ChangeToLabeledReturnFix(@NotNull KtReturnExpression element3, @NotNull String labeledReturn) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)labeledReturn, (String)"labeledReturn");
        super((PsiElement)element3);
        this.labeledReturn = labeledReturn;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ChangeToLabeledReturnFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "findAccessibleLabels", "Lorg/jetbrains/kotlin/name/Name;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "position", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "idea"})
    public static final class Companion
    extends KotlinIntentionActionsFactory {
        /*
         * WARNING - void declaration
         */
        private final List<Name> findAccessibleLabels(BindingContext bindingContext2, KtReturnExpression position) {
            List result2 = new ArrayList();
            for (PsiElement parent2 : PsiUtilsKt.getParentsWithSelf((PsiElement)position)) {
                KtReferenceExpression callee;
                void label2;
                if (!(parent2 instanceof KtFunctionLiteral)) continue;
                Pair<Name, KtCallExpression> pair2 = UtilsKt.findLabelAndCall((KtFunctionLiteral)parent2);
                Name name2 = (Name)pair2.component1();
                KtCallExpression call2 = (KtCallExpression)pair2.component2();
                if (label2 != null) {
                    result2.add(label2);
                }
                KtCallExpression ktCallExpression = call2;
                KtExpression ktExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
                if (!(ktExpression instanceof KtReferenceExpression)) {
                    ktExpression = null;
                }
                if ((KtReferenceExpression)ktExpression == null) {
                    break;
                }
                if (InlineUtil.isInline((DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, callee))) continue;
                break;
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtReturnExpression)) {
                psiElement2 = null;
            }
            KtReturnExpression ktReturnExpression = (KtReturnExpression)psiElement2;
            if (ktReturnExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtReturnExpression expression2 = ktReturnExpression;
            Iterable iterable = $receiver$iv = (Iterable)this.findAccessibleLabels(ResolutionUtils.analyze$default(expression2, null, 1, null), expression2);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Name name2 = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                ChangeToLabeledReturnFix changeToLabeledReturnFix = new ChangeToLabeledReturnFix(expression2, "return@" + RenderingUtilsKt.render((Name)it));
                collection.add(changeToLabeledReturnFix);
            }
            return (List)destination$iv$iv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

