/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.perf;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassGenerationSupport;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclaration;
import org.jetbrains.kotlin.asJava.classes.KtUltraLightClass;
import org.jetbrains.kotlin.asJava.classes.UltraLightAnnotationsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightNullabilityAnnotation;
import org.jetbrains.kotlin.idea.perf.UltraLightChecker;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.junit.Assert;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\r*\u00060\u0013j\u0002`\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0004H\u0002J\f\u0010\u0017\u001a\u00020\u0004*\u00020\u0018H\u0002J\n\u0010\u0019\u001a\u00020\u0004*\u00020\u001aJ\f\u0010\u001b\u001a\u00020\u0004*\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u00020\u0004*\u00020\u001aH\u0002J\f\u0010\u001e\u001a\u00020\u0004*\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u0004*\u00020!2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010\"\u001a\u00020\u0004*\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0004H\u0002J\f\u0010%\u001a\u00020\u0004*\u00020\u0011H\u0002J\f\u0010&\u001a\u00020\u0004*\u00020'H\u0002J\f\u0010(\u001a\u00020\u0004*\u00020)H\u0002J\u0016\u0010*\u001a\u00020\u000f*\u00020!2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/perf/UltraLightChecker;", "", "()V", "NON_EXISTENT_QUALIFIED_CLASS_NAME", "", "allClasses", "", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkClassEquivalence", "Lorg/jetbrains/kotlin/asJava/classes/KtUltraLightClass;", "ktClass", "", "isPrimitiveOrNonExisting", "", "typeIfApplicable", "Lcom/intellij/psi/PsiType;", "appendSorted", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "list", "prependDefaultIndent", "renderAnnotation", "Lcom/intellij/psi/PsiAnnotation;", "renderClass", "Lcom/intellij/psi/PsiClass;", "renderEnumConstant", "Lcom/intellij/psi/PsiEnumConstant;", "renderMembers", "renderMethod", "Lcom/intellij/psi/PsiMethod;", "renderModifiers", "Lcom/intellij/psi/PsiModifierListOwner;", "renderRefList", "Lcom/intellij/psi/PsiReferenceList;", "keyword", "renderType", "renderTypeParams", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "renderVar", "Lcom/intellij/psi/PsiVariable;", "skipRenderingNullability", "idea-core"})
public final class UltraLightChecker {
    private static final String NON_EXISTENT_QUALIFIED_CLASS_NAME;
    public static final UltraLightChecker INSTANCE;

    public final void checkClassEquivalence(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        for (KtClassOrObject ktClass2 : this.allClasses(file)) {
            this.checkClassEquivalence(ktClass2);
        }
    }

    @NotNull
    public final List<KtClassOrObject> allClasses(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        List list2 = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).filter(KtClassOrObject.class).toList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"SyntaxTraverser.psiTrave\u2026ect::class.java).toList()");
        return list2;
    }

    @Nullable
    public final KtUltraLightClass checkClassEquivalence(@NotNull KtClassOrObject ktClass2) {
        Intrinsics.checkParameterIsNotNull((Object)ktClass2, (String)"ktClass");
        KtLightClassForSourceDeclaration gold = KtLightClassForSourceDeclaration.Companion.create(ktClass2);
        Project project = ktClass2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"ktClass.project");
        KtUltraLightClass ktUltraLightClass = LightClassGenerationSupport.Companion.getInstance(project).createUltraLightClass(ktClass2);
        if (ktUltraLightClass == null) {
            return null;
        }
        KtUltraLightClass ultraLightClass = ktUltraLightClass;
        if (gold != null) {
            String string = gold.getClass().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gold.javaClass.name");
            Assert.assertFalse((boolean)StringsKt.contains$default((CharSequence)string, (CharSequence)"Ultra", (boolean)false, (int)2, null));
        }
        KtLightClassForSourceDeclaration ktLightClassForSourceDeclaration = gold;
        String string = ktLightClassForSourceDeclaration != null ? this.renderClass(ktLightClassForSourceDeclaration) : null;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String goldText = string2;
        String ultraText = this.renderClass(ultraLightClass);
        if (Intrinsics.areEqual((Object)goldText, (Object)ultraText) ^ true) {
            Assert.assertEquals((Object)("// Classic implementation:\n" + goldText), (Object)("// Ultra-light implementation:\n" + ultraText));
        }
        return ultraLightClass;
    }

    private final String renderAnnotation(@NotNull PsiAnnotation $receiver) {
        StringBuilder stringBuilder = new StringBuilder().append("@").append($receiver.getQualifiedName()).append("(");
        PsiAnnotationParameterList psiAnnotationParameterList = $receiver.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationParameterList, (String)"parameterList");
        Object[] objectArray = psiAnnotationParameterList.getAttributes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"parameterList.attributes");
        return stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)renderAnnotation.1.INSTANCE, (int)31, null)).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String renderModifiers(@NotNull PsiModifierListOwner $receiver, PsiType typeIfApplicable) {
        void $receiver$iv$iv;
        String[] $receiver$iv;
        StringBuilder buffer = new StringBuilder();
        for (PsiAnnotation annotation2 : $receiver.getAnnotations()) {
            if (annotation2 instanceof KtLightNullabilityAnnotation && this.skipRenderingNullability($receiver, typeIfApplicable)) continue;
            PsiAnnotation psiAnnotation = annotation2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation, (String)"annotation");
            buffer.append(this.renderAnnotation(psiAnnotation));
            buffer.append($receiver instanceof PsiParameter ? " " : "\n");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)PsiModifier.MODIFIERS, (String)"PsiModifier.MODIFIERS");
        String[] stringArray = $receiver$iv = PsiModifier.MODIFIERS;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void p1 = element$iv$iv;
            if (!$receiver.hasModifierProperty((String)p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (String modifier : (List)destination$iv$iv) {
            buffer.append(modifier).append(" ");
        }
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    static /* synthetic */ String renderModifiers$default(UltraLightChecker ultraLightChecker, PsiModifierListOwner psiModifierListOwner, PsiType psiType, int n, Object object) {
        if ((n & 1) != 0) {
            psiType = null;
        }
        return ultraLightChecker.renderModifiers(psiModifierListOwner, psiType);
    }

    private final boolean skipRenderingNullability(@NotNull PsiModifierListOwner $receiver, PsiType typeIfApplicable) {
        return this.isPrimitiveOrNonExisting(typeIfApplicable) || UltraLightAnnotationsKt.isPrivateOrParameterInPrivateMethod($receiver);
    }

    private final boolean isPrimitiveOrNonExisting(PsiType typeIfApplicable) {
        if (typeIfApplicable instanceof PsiPrimitiveType) {
            return true;
        }
        PsiType psiType = typeIfApplicable;
        if (Intrinsics.areEqual((Object)(psiType != null ? psiType.getCanonicalText(false) : null), (Object)NON_EXISTENT_QUALIFIED_CLASS_NAME)) {
            return true;
        }
        return typeIfApplicable instanceof PsiPrimitiveType;
    }

    private final String renderType(@NotNull PsiType $receiver) {
        String string = $receiver.getCanonicalText(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getCanonicalText(true)");
        return string;
    }

    private final String renderRefList(@Nullable PsiReferenceList $receiver, String keyword) {
        block3: {
            block2: {
                if ($receiver == null) break block2;
                PsiClassType[] psiClassTypeArray = $receiver.getReferencedTypes();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiClassTypeArray, (String)"this.referencedTypes");
                PsiClassType[] psiClassTypeArray2 = psiClassTypeArray;
                if (!(psiClassTypeArray2.length == 0)) break block3;
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder().append(" ").append(keyword).append(" ");
        Object[] objectArray = $receiver.getReferencedTypes();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"referencedTypes");
        return stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)renderRefList.1.INSTANCE, (int)31, null)).toString();
    }

    private final String renderVar(@NotNull PsiVariable $receiver) {
        String result2;
        block1: {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append(this.renderModifiers((PsiModifierListOwner)$receiver, $receiver.getType()));
            PsiType psiType = $receiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"type");
            result2 = stringBuilder.append(this.renderType(psiType)).append(" ").append($receiver.getName()).toString();
            if ($receiver instanceof PsiParameter && ((PsiParameter)$receiver).isVarArgs()) {
                result2 = result2 + " /* vararg */";
            }
            Object object2 = $receiver.computeConstantValue();
            if (object2 == null) break block1;
            Object it = object = object2;
            result2 = result2 + " /* constant value " + it + " */";
        }
        return result2;
    }

    private final String renderTypeParams(@NotNull PsiTypeParameterListOwner $receiver) {
        String string;
        PsiTypeParameter[] psiTypeParameterArray = $receiver.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeParameterArray, (String)"typeParameters");
        PsiTypeParameter[] psiTypeParameterArray2 = psiTypeParameterArray;
        if (psiTypeParameterArray2.length == 0) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("<");
            Object[] objectArray = $receiver.getTypeParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"typeParameters");
            string = stringBuilder.append(ArraysKt.joinToString$default((Object[])objectArray, null, null, null, (int)0, null, (Function1)renderTypeParams.1.INSTANCE, (int)31, null)).append("> ").toString();
        }
        return string;
    }

    private final String renderMethod(@NotNull PsiMethod $receiver) {
        Object[] objectArray;
        Object object;
        StringBuilder stringBuilder;
        Object[] objectArray2;
        Object[] objectArray3;
        StringBuilder stringBuilder2 = new StringBuilder().append(this.renderModifiers((PsiModifierListOwner)$receiver, $receiver.getReturnType())).append($receiver.isVarArgs() ? "/* vararg */ " : "").append(this.renderTypeParams((PsiTypeParameterListOwner)$receiver));
        Object object2 = $receiver.getReturnType();
        if (object2 == null || (object2 = this.renderType((PsiType)object2)) == null) {
            object2 = "";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(object2).append(" ").append($receiver.getName()).append("(");
        PsiParameterList psiParameterList = $receiver.getParameterList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"parameterList");
        Object[] objectArray4 = psiParameterList.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray4, (String)"parameterList.parameters");
        StringBuilder stringBuilder4 = stringBuilder3.append(ArraysKt.joinToString$default((Object[])objectArray4, null, null, null, (int)0, null, (Function1)renderMethod.1.INSTANCE, (int)31, null)).append(")");
        PsiMethod psiMethod = $receiver;
        if (!(psiMethod instanceof PsiAnnotationMethod)) {
            psiMethod = null;
        }
        if ((objectArray3 = (Object[])psiMethod) != null && (objectArray3 = objectArray3.getDefaultValue()) != null) {
            objectArray2 = objectArray3;
            stringBuilder = stringBuilder4;
            Object[] it = objectArray2;
            StringBuilder stringBuilder5 = new StringBuilder().append(" default ");
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            object = stringBuilder5.append(it.getText()).toString();
            stringBuilder4 = stringBuilder;
            objectArray = object;
        } else {
            objectArray = null;
        }
        objectArray2 = objectArray;
        stringBuilder = stringBuilder4;
        Object object3 = objectArray2;
        if (objectArray2 == null) {
            object3 = "";
        }
        object = object3;
        StringBuilder stringBuilder6 = stringBuilder.append((String)object);
        PsiReferenceList psiReferenceList = $receiver.getThrowsList();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceList, (String)"throwsList");
        objectArray2 = psiReferenceList.getReferencedTypes();
        stringBuilder = stringBuilder6;
        Object[] thrownTypes = objectArray2;
        Intrinsics.checkExpressionValueIsNotNull((Object)thrownTypes, (String)"thrownTypes");
        Object[] objectArray5 = thrownTypes;
        object = objectArray5.length == 0 ? "" : " throws " + ArraysKt.joinToString$default((Object[])thrownTypes, null, null, null, (int)0, null, (Function1)renderMethod.3.1.INSTANCE, (int)31, null);
        return stringBuilder.append((String)object).append(";").toString();
    }

    private final String renderEnumConstant(@NotNull PsiEnumConstant $receiver) {
        StringBuilder stringBuilder;
        StringBuilder $receiver2;
        PsiEnumConstantInitializer psiEnumConstantInitializer = $receiver.getInitializingClass();
        if (psiEnumConstantInitializer == null) {
            String string = $receiver.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            return string;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiEnumConstantInitializer, (String)"initializingClass ?: return name");
        PsiEnumConstantInitializer initializingClass2 = psiEnumConstantInitializer;
        StringBuilder stringBuilder2 = $receiver2 = (stringBuilder = new StringBuilder());
        String string = $receiver.getName() + " {";
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        $receiver2.append(INSTANCE.renderMembers((PsiClass)initializingClass2));
        $receiver2.append("}");
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String renderClass(@NotNull PsiClass $receiver) {
        PsiField[] psiFieldArray;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String classWord = $receiver.isAnnotationType() ? "@interface" : ($receiver.isInterface() ? "interface" : ($receiver.isEnum() ? "enum" : "class"));
        PsiField[] $receiver2 = psiFieldArray = new StringBuilder();
        $receiver2.append(UltraLightChecker.renderModifiers$default(INSTANCE, (PsiModifierListOwner)$receiver, null, 1, null));
        $receiver2.append(classWord + ' ');
        $receiver2.append($receiver.getName() + " /* " + $receiver.getQualifiedName() + "*/");
        $receiver2.append(INSTANCE.renderTypeParams((PsiTypeParameterListOwner)$receiver));
        $receiver2.append(INSTANCE.renderRefList($receiver.getExtendsList(), "extends"));
        $receiver2.append(INSTANCE.renderRefList($receiver.getImplementsList(), "implements"));
        PsiField[] psiFieldArray2 = $receiver2;
        String string = " {";
        StringBuilder stringBuilder = psiFieldArray2.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        if ($receiver.isEnum()) {
            void $receiver$iv$iv;
            void $receiver$iv;
            PsiField[] psiFieldArray3 = $receiver.getFields();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFieldArray3, (String)"fields");
            psiFieldArray2 = psiFieldArray3;
            UltraLightChecker ultraLightChecker = INSTANCE;
            PsiField[] psiFieldArray4 = $receiver2;
            string = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof PsiEnumConstant)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            psiFieldArray4.append(ultraLightChecker.prependDefaultIndent(CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)",\n", null, null, (int)0, null, (Function1)renderClass.1.1.INSTANCE, (int)30, null)));
            $receiver2.append(";\n\n");
        }
        $receiver2.append(INSTANCE.renderMembers($receiver));
        $receiver2.append("}");
        String string2 = psiFieldArray.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String renderMembers(@NotNull PsiClass $receiver) {
        int n;
        String string;
        PsiMethod it;
        PsiMethod[] $receiver$iv$iv;
        PsiMethod[] $receiver$iv;
        StringBuilder stringBuilder;
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        PsiField[] psiFieldArray = $receiver.getFields();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFieldArray, (String)"fields");
        PsiField[] psiFieldArray2 = psiFieldArray;
        StringBuilder stringBuilder2 = $receiver2;
        UltraLightChecker ultraLightChecker = INSTANCE;
        void var7_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void var12_16 : $receiver$iv$iv) {
            it = var12_16;
            if (it instanceof PsiEnumConstant) continue;
            destination$iv$iv.add(var12_16);
        }
        Collection<String> collection = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (PsiMethod[])collection;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            void it2;
            PsiField psiField = (PsiField)t;
            collection = destination$iv$iv;
            StringBuilder stringBuilder3 = new StringBuilder();
            void v2 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            string = stringBuilder3.append(INSTANCE.prependDefaultIndent(INSTANCE.renderVar((PsiVariable)v2))).append(";\n\n").toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ultraLightChecker.appendSorted(stringBuilder2, (List<String>)collection);
        PsiMethod[] psiMethodArray = $receiver.getMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray, (String)"methods");
        $receiver$iv = psiMethodArray;
        stringBuilder2 = $receiver2;
        ultraLightChecker = INSTANCE;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.length);
        PsiMethod[] psiMethodArray2 = $receiver$iv$iv;
        int n2 = psiMethodArray2.length;
        for (n = 0; n < n2; ++n) {
            PsiMethod psiMethod;
            PsiMethod $i$f$mapTo = psiMethod = psiMethodArray2[n];
            collection = destination$iv$iv;
            StringBuilder stringBuilder4 = new StringBuilder();
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            string = stringBuilder4.append(INSTANCE.prependDefaultIndent(INSTANCE.renderMethod((PsiMethod)v5))).append("\n\n").toString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ultraLightChecker.appendSorted(stringBuilder2, (List<String>)collection);
        PsiClass[] psiClassArray = $receiver.getInnerClasses();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassArray, (String)"innerClasses");
        $receiver$iv = psiClassArray;
        stringBuilder2 = $receiver2;
        ultraLightChecker = INSTANCE;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList($receiver$iv.length);
        psiMethodArray2 = $receiver$iv$iv;
        int n3 = psiMethodArray2.length;
        for (n = 0; n < n3; ++n) {
            PsiMethod psiMethod;
            it = psiMethod = psiMethodArray2[n];
            collection = destination$iv$iv;
            StringBuilder stringBuilder5 = new StringBuilder().append("class ");
            PsiMethod psiMethod2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod2, (String)"it");
            string = INSTANCE.prependDefaultIndent(stringBuilder5.append(psiMethod2.getName()).append(" ...\n\n").toString());
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ultraLightChecker.appendSorted(stringBuilder2, (List<String>)collection);
        String string2 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void appendSorted(@NotNull StringBuilder $receiver, List<String> list2) {
        $receiver.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)list2), (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
    }

    private final String prependDefaultIndent(@NotNull String $receiver) {
        return StringsKt.prependIndent((String)$receiver, (String)"  ");
    }

    private UltraLightChecker() {
    }

    static {
        UltraLightChecker ultraLightChecker;
        INSTANCE = ultraLightChecker = new UltraLightChecker();
        NON_EXISTENT_QUALIFIED_CLASS_NAME = StringsKt.replace$default((String)"error/NonExistentClass", (String)"/", (String)".", (boolean)false, (int)4, null);
    }

    public static final /* synthetic */ String access$renderType(UltraLightChecker $this, PsiType $receiver) {
        return $this.renderType($receiver);
    }

    public static final /* synthetic */ String access$renderModifiers(UltraLightChecker $this, PsiModifierListOwner $receiver, PsiType typeIfApplicable) {
        return $this.renderModifiers($receiver, typeIfApplicable);
    }

    public static final /* synthetic */ String access$renderEnumConstant(UltraLightChecker $this, PsiEnumConstant $receiver) {
        return $this.renderEnumConstant($receiver);
    }
}

