/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.conventionNameCalls;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.conventionNameCalls.ReplaceContainsIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorChecks;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\u0002H\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/conventionNameCalls/ReplaceContainsIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "isOperatorOrCompatible", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFunctionDescriptor", "idea"})
public final class ReplaceContainsIntention
extends SelfTargetingRangeIntention<KtDotQualifiedExpression>
implements HighPriorityAction {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)UtilsKt.getCalleeName(element3), (Object)OperatorNameConventions.CONTAINS.asString()) ^ true) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall(element3, BodyResolveMode.PARTIAL);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
            return null;
        }
        Call call2 = resolvedCall3.getCall();
        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
        List<? extends ValueArgument> list2 = call2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedCall.call.valueArguments");
        ValueArgument valueArgument = (ValueArgument)CollectionsKt.singleOrNull(list2);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument argument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping(argument2);
        if (argumentMapping == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch");
        }
        if (((ArgumentMatch)argumentMapping).getValueParameter().getIndex() != 0) {
            return null;
        }
        CallableDescriptor target = resolvedCall3.getResultingDescriptor();
        KotlinType kotlinType2 = target.getReturnType();
        if (kotlinType2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"target.returnType ?: return null");
        KotlinType returnType2 = kotlinType2;
        if (!DescriptorUtilsKt.getBuiltIns(target).isBooleanOrSubtype(returnType2)) {
            return null;
        }
        if (!UtilsKt.isReceiverExpressionWithValue(element3)) {
            return null;
        }
        FunctionDescriptor functionDescriptor2 = this.getFunctionDescriptor(element3);
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        if (!this.isOperatorOrCompatible(functionDescriptor3)) {
            return null;
        }
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktExpression = ktCallExpression.getCalleeExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.callExpression!!.calleeExpression!!");
        return ktExpression.getTextRange();
    }

    private final boolean isOperatorOrCompatible(@NotNull FunctionDescriptor $receiver) {
        if ($receiver instanceof JavaMethodDescriptor) {
            return OperatorChecks.INSTANCE.check($receiver).isSuccess();
        }
        return $receiver.isOperator();
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @Nullable Editor editor2) {
        PsiElement previousElement2;
        PsiElement psiElement2;
        KtPrefixExpression prefixExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        List<KtValueArgument> list2 = ktCallExpression.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.callExpression!!.valueArguments");
        KtExpression ktExpression = ((KtValueArgument)CollectionsKt.single(list2)).getArgumentExpression();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.callExpression!!\u2026getArgumentExpression()!!");
        KtExpression argument2 = ktExpression;
        KtExpression receiver = element3.getReceiverExpression();
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null);
        PsiElement psiElement3 = element3.getParent();
        if (!(psiElement3 instanceof KtPrefixExpression)) {
            psiElement3 = null;
        }
        if ((prefixExpression = (KtPrefixExpression)psiElement3) != null && Intrinsics.areEqual((Object)prefixExpression.getOperationToken(), (Object)((Object)KtTokens.EXCL))) {
            psiElement2 = prefixExpression.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 !in $1", new Object[]{argument2, receiver}, false, 4, null));
        } else {
            PsiElement psiElement4 = element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(psiFactory, "$0 in $1", new Object[]{argument2, receiver}, false, 4, null));
            psiElement2 = psiElement4;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"element.replace(psiFacto\u2026$1\", argument, receiver))");
        }
        PsiElement expression2 = psiElement2;
        if (argument2 instanceof KtLambdaExpression && (previousElement2 = KtPsiUtil.skipSiblingsBackwardByPredicate(expression2, applyTo.previousElement.1.INSTANCE)) != null && previousElement2 instanceof KtExpression) {
            ((KtExpression)previousElement2).getParent().addAfter(psiFactory.createSemicolon(), previousElement2);
        }
    }

    private final FunctionDescriptor getFunctionDescriptor(KtDotQualifiedExpression element3) {
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(element3, null, 1, null);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Object d = resolvedCall3.getResultingDescriptor();
        if (!(d instanceof FunctionDescriptor)) {
            d = null;
        }
        return (FunctionDescriptor)d;
    }

    public ReplaceContainsIntention() {
        super(KtDotQualifiedExpression.class, "Replace 'contains' call with 'in' operator", null, 4, null);
    }
}

