/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.RenameProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RenameFileToMatchClassIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "startInWriteAction", "", "idea"})
public final class RenameFileToMatchClassIntention
extends SelfTargetingRangeIntention<KtClassOrObject> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtClassOrObject element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!element3.isTopLevel()) {
            return null;
        }
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
        String string = ktFile.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.containingKtFile.name");
        String fileName = string;
        if (Intrinsics.areEqual((Object)FileUtil.getNameWithoutExtension((String)fileName), (Object)element3.getName())) {
            return null;
        }
        this.setText("Rename file to " + element3.getName() + '.' + FileUtilRt.getExtension((String)fileName));
        PsiElement psiElement2 = element3.getNameIdentifier();
        return psiElement2 != null ? psiElement2.getTextRange() : null;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtClassOrObject element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtFile ktFile = element3.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"element.containingKtFile");
        KtFile file = ktFile;
        String string = FileUtilRt.getExtension((String)file.getName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtilRt.getExtension(file.name)");
        String extension = string;
        new RenameProcessor(file.getProject(), (PsiElement)file, element3.getName() + '.' + extension, RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE, RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE).run();
    }

    public RenameFileToMatchClassIntention() {
        super(KtClassOrObject.class, "", "Rename file to match top-level class name");
    }
}

