/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/RemoveEmptyClassBodyIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "()V", "addSemicolonAfterEmptyCompanion", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "applyTo", "isApplicableTo", "", "idea"})
public final class RemoveEmptyClassBodyIntention
extends SelfTargetingOffsetIndependentIntention<KtClassBody> {
    @Override
    public void applyTo(@NotNull KtClassBody element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement parent2 = element3.getParent();
        element3.delete();
        PsiElement psiElement2 = parent2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent");
        this.addSemicolonAfterEmptyCompanion(psiElement2, editor2);
    }

    private final void addSemicolonAfterEmptyCompanion(PsiElement element3, Editor editor2) {
        block6: {
            if (!(element3 instanceof KtObjectDeclaration)) {
                return;
            }
            if (!((KtObjectDeclaration)element3).isCompanion() || ((KtObjectDeclaration)element3).getNameIdentifier() != null) {
                return;
            }
            PsiElement psiElement2 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(element3, false, 1, null);
            if (psiElement2 == null) {
                return;
            }
            PsiElement next2 = psiElement2;
            ASTNode aSTNode = next2.getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"next.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.SEMICOLON))) {
                return;
            }
            PsiElement psiElement3 = next2.getFirstChild();
            if (psiElement3 == null || (psiElement3 = psiElement3.getNode()) == null) {
                return;
            }
            PsiElement firstChildNode = psiElement3;
            if (KtTokens.KEYWORDS.contains(firstChildNode.getElementType())) {
                return;
            }
            ((KtObjectDeclaration)element3).getParent().addAfter(KtPsiFactoryKt.KtPsiFactory$default(element3, false, 2, null).createSemicolon(), element3);
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block6;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset(element3) + 1);
        }
    }

    @Override
    public boolean isApplicableTo(@NotNull KtClassBody element3) {
        KtClass ktClass2;
        PsiElement it;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiElement $receiver$iv = (PsiElement)element3;
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtObjectDeclaration.class, (boolean)true);
        if (ktObjectDeclaration != null && (it = ($receiver$iv = ktObjectDeclaration)).isObjectLiteral()) {
            return false;
        }
        $receiver$iv = (PsiElement)element3;
        KtClass ktClass3 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)true);
        if (ktClass3 != null && !(it = (ktClass2 = ktClass3)).isTopLevel() && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(it, false, 1, null) instanceof KtSecondaryConstructor) {
            return false;
        }
        String string = element3.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
        return StringsKt.isBlank((CharSequence)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"{", (String)"", (boolean)false, (int)4, null), (String)"}", (String)"", (boolean)false, (int)4, null));
    }

    public RemoveEmptyClassBodyIntention() {
        super(KtClassBody.class, "Remove empty class body", null, 4, null);
    }
}

