/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimMarginToTrimIndentIntention;
import org.jetbrains.kotlin.idea.intentions.ConvertTrimMarginToTrimIndentIntentionKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertTrimMarginToTrimIndentIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertTrimMarginToTrimIndentIntention
extends SelfTargetingIntention<KtCallExpression> {
    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3, int caretOffset) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(element3);
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) return false;
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        String string = template2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"template.text");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) {
            return false;
        }
        KtExpression ktExpression2 = element3.getCalleeExpression();
        if (ktExpression2 == null) return false;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"element.calleeExpression ?: return false");
        KtExpression callee = ktExpression2;
        if (Intrinsics.areEqual((Object)callee.getText(), (Object)"trimMargin") ^ true) return false;
        CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor(callee);
        if (Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(callableDescriptor) : null), (Object)new FqName("kotlin.text.trimMargin")) ^ true) {
            return false;
        }
        String string2 = ConvertTrimMarginToTrimIndentIntentionKt.access$marginPrefix(element3);
        if (string2 == null) return false;
        String marginPrefix = string2;
        Object[] objectArray = template2.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"template.entries");
        Object[] entries2 = objectArray;
        Iterable $receiver$iv = CollectionsKt.listOfNotNull((Object[])new KtStringTemplateEntry[]{(KtStringTemplateEntry)ArraysKt.firstOrNull((Object[])entries2), (KtStringTemplateEntry)ArraysKt.lastOrNull((Object[])entries2)});
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object element$iv : $receiver$iv) {
                KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv;
                String string3 = it.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.text");
                if (ConvertTrimMarginToTrimIndentIntentionKt.access$isLineBreakOrBlank(string3)) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        $receiver$iv = CollectionsKt.dropLast((List)ArraysKt.drop((Object[])entries2, (int)1), (int)1);
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            String text2;
            KtStringTemplateEntry stringTemplateEntry;
            Object element$iv;
            if (!iterator2.hasNext()) return true;
            element$iv = iterator2.next();
            KtStringTemplateEntry ktStringTemplateEntry = stringTemplateEntry = (KtStringTemplateEntry)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"stringTemplateEntry");
            String string4 = text2 = ktStringTemplateEntry.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"text");
            if (!ConvertTrimMarginToTrimIndentIntentionKt.access$isLineBreakOrBlank(string4)) {
                String string5;
                block12: {
                    String $receiver$iv2 = text2;
                    int n = 0;
                    int n2 = ((CharSequence)$receiver$iv2).length();
                    while (n < n2) {
                        void index$iv;
                        char it = $receiver$iv2.charAt((int)index$iv);
                        if (!CharsKt.isWhitespace((char)it)) {
                            String string6 = $receiver$iv2;
                            String string7 = string6.substring((int)index$iv);
                            string5 = string7;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                            break block12;
                        }
                        ++index$iv;
                    }
                    string5 = "";
                }
                if (!StringsKt.startsWith$default((String)string5, (String)marginPrefix, (boolean)false, (int)2, null)) return false;
            }
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor2) {
        KtStringTemplateEntry[] $receiver$iv;
        StringBuilder stringBuilder;
        String string;
        Object v5;
        void $receiver$iv2;
        KtQualifiedExpression qualifiedExpression;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector(element3);
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return;
        }
        KtStringTemplateExpression template2 = ktStringTemplateExpression;
        String string2 = ConvertTrimMarginToTrimIndentIntentionKt.access$marginPrefix(element3);
        if (string2 == null) {
            return;
        }
        String marginPrefix = string2;
        Object[] objectArray = template2.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"template.entries");
        Sequence sequence2 = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)applyTo.indent.1.INSTANCE);
        Iterator iterator$iv = $receiver$iv2.iterator();
        if (!iterator$iv.hasNext()) {
            v5 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            String it = (String)minElem$iv;
            int minValue$iv = it.length();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                String it2 = (String)e$iv;
                int v$iv = it2.length();
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            }
            v5 = minElem$iv;
        }
        if ((string = (String)v5) == null) {
            string = "";
        }
        String indent2 = string;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        KtStringTemplateEntry[] ktStringTemplateEntryArray = template2.getEntries();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntryArray, (String)"template.entries");
        KtStringTemplateEntry[] ktStringTemplateEntryArray2 = $receiver$iv = ktStringTemplateEntryArray;
        int n = ktStringTemplateEntryArray2.length;
        for (int j = 0; j < n; ++j) {
            String string3;
            StringBuilder stringBuilder2;
            block11: {
                void $receiver$iv3;
                String text2;
                KtStringTemplateEntry element$iv;
                KtStringTemplateEntry entry;
                KtStringTemplateEntry ktStringTemplateEntry = entry = (element$iv = ktStringTemplateEntryArray2[j]);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktStringTemplateEntry, (String)"entry");
                String string4 = text2 = ktStringTemplateEntry.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"text");
                if (ConvertTrimMarginToTrimIndentIntentionKt.access$isLineBreakOrBlank(string4)) {
                    $receiver.append(text2);
                    continue;
                }
                $receiver.append(indent2);
                Intrinsics.checkExpressionValueIsNotNull((Object)entry.getText(), (String)"entry.text");
                stringBuilder2 = $receiver;
                int n2 = 0;
                int n3 = ((CharSequence)$receiver$iv3).length();
                while (n2 < n3) {
                    void index$iv;
                    char it = $receiver$iv3.charAt((int)index$iv);
                    if (!CharsKt.isWhitespace((char)it)) {
                        void var21_25 = $receiver$iv3;
                        String string5 = var21_25.substring((int)index$iv);
                        string3 = string5;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                        break block11;
                    }
                    ++index$iv;
                }
                string3 = "";
            }
            String string6 = string3;
            stringBuilder2.append(StringsKt.replaceFirst$default((String)string6, (String)marginPrefix, (String)"", (boolean)false, (int)4, null));
        }
        String string7 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
        String newTemplate = string7;
        qualifiedExpression.replace((PsiElement)KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression("\"\"\"" + newTemplate + "\"\"\".trimIndent()"));
    }

    public ConvertTrimMarginToTrimIndentIntention() {
        super(KtCallExpression.class, "Convert to 'trimIndent'", null, 4, null);
    }
}

