/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertNullablePropertyToLateinitIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "idea"})
public final class ConvertNullablePropertyToLateinitIntention
extends SelfTargetingIntention<KtProperty> {
    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        KtTypeReference typeReference;
        block15: {
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                if (element3.hasModifier(KtTokens.LATEINIT_KEYWORD) || element3.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                    return false;
                }
                if (!element3.isVar()) {
                    return false;
                }
                LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings(element3);
                if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitLocalVariables) && element3.isLocal()) {
                    return false;
                }
                if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitTopLevelProperties) && element3.isTopLevel()) {
                    return false;
                }
                KtPropertyAccessor ktPropertyAccessor = element3.getGetter();
                if ((ktPropertyAccessor != null ? Boolean.valueOf(ktPropertyAccessor.hasBody()) : null) != null) break block14;
                KtPropertyAccessor ktPropertyAccessor2 = element3.getSetter();
                if ((ktPropertyAccessor2 != null ? Boolean.valueOf(ktPropertyAccessor2.hasBody()) : null) == null) break block15;
            }
            return false;
        }
        if (!IfThenUtilsKt.isNullExpression(element3.getInitializer())) {
            return false;
        }
        KtTypeReference ktTypeReference = typeReference = element3.getTypeReference();
        if (!((ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtNullableType)) {
            return false;
        }
        BindingContext context = ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL);
        KotlinType kotlinType2 = (KotlinType)context.get(BindingContext.TYPE, typeReference);
        if (kotlinType2 == null || (kotlinType2 = TypeUtilsKt.makeNotNullable(kotlinType2)) == null) {
            return false;
        }
        KotlinType type2 = kotlinType2;
        if (KotlinBuiltIns.isPrimitiveType(type2) || InlineClassesUtilsKt.isInlineClassType(type2) || TypeUtils.isNullableType(type2)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
        if (!(declarationDescriptor instanceof VariableDescriptor)) {
            declarationDescriptor = null;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
        if (variableDescriptor == null) {
            return false;
        }
        VariableDescriptor descriptor2 = variableDescriptor;
        if (descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((Boolean)context.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2)), (Object)false)) {
            return false;
        }
        return descriptor2.getExtensionReceiverParameter() == null;
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtTypeReference ktTypeReference = element3.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        KotlinType kotlinType2 = (KotlinType)ResolutionUtils.analyze(element3, BodyResolveMode.PARTIAL).get(BindingContext.TYPE, typeReference);
        if (kotlinType2 == null || (kotlinType2 = TypeUtilsKt.makeNotNullable(kotlinType2)) == null) {
            return;
        }
        KotlinType notNullableType = kotlinType2;
        element3.addModifier(KtTokens.LATEINIT_KEYWORD);
        PsiModificationUtilsKt.setType$default((KtCallableDeclaration)element3, notNullableType, false, 2, null);
        element3.setInitializer(null);
    }

    public ConvertNullablePropertyToLateinitIntention() {
        super(KtProperty.class, "Convert to lateinit var", null, 4, null);
    }
}

