/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.formatter.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.collections.AbstractCallChainChecker;
import org.jetbrains.kotlin.idea.inspections.collections.SimplifyCallChainFix;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentList;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u001f\b\u0002\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000fH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0007\u001a\u0019\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifyCallChainFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "conversion", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;", "removeReceiverOfFirstCall", "", "runOptimizeImports", "modifyArguments", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;ZZLkotlin/jvm/functions/Function2;)V", "shortenedText", "", "apply", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "applyFix", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
public final class SimplifyCallChainFix
implements LocalQuickFix {
    private final String shortenedText;
    private final AbstractCallChainChecker.Conversion conversion;
    private final boolean removeReceiverOfFirstCall;
    private final boolean runOptimizeImports;
    private final Function2<KtPsiFactory, KtCallExpression, Unit> modifyArguments;

    @NotNull
    public String getName() {
        return "Merge call chain to '" + this.shortenedText + '\'';
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public final void apply(@NotNull KtQualifiedExpression qualifiedExpression) {
        PsiElement reformatted;
        KtExpression ktExpression;
        Object[] objectArray;
        Collection collection;
        Collection collection2;
        KtExpression ktExpression2;
        Intrinsics.checkParameterIsNotNull((Object)qualifiedExpression, (String)"qualifiedExpression");
        KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)qualifiedExpression, false, 2, null);
        KtExpression firstExpression = qualifiedExpression.getReceiverExpression();
        String operationSign = this.removeReceiverOfFirstCall ? "" : ((ktExpression2 = firstExpression) instanceof KtSafeQualifiedExpression ? "?." : (ktExpression2 instanceof KtQualifiedExpression ? "." : ""));
        String receiverExpressionOrEmptyString = !this.removeReceiverOfFirstCall && firstExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)firstExpression).getReceiverExpression().getText() : "";
        KtCallExpression ktCallExpression = AbstractCallChainChecker.Companion.getCallExpression(firstExpression);
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression firstCallExpression = ktCallExpression;
        this.modifyArguments.invoke((Object)factory2, (Object)firstCallExpression);
        KtValueArgumentList firstCallArgumentList = firstCallExpression.getValueArgumentList();
        KtExpression ktExpression3 = qualifiedExpression.getSelectorExpression();
        if (!(ktExpression3 instanceof KtCallExpression)) {
            ktExpression3 = null;
        }
        KtCallExpression ktCallExpression2 = (KtCallExpression)ktExpression3;
        if (ktCallExpression2 == null) {
            return;
        }
        KtCallExpression secondCallExpression = ktCallExpression2;
        KtValueArgumentList secondCallArgumentList = secondCallExpression.getValueArgumentList();
        apply.1 getTextInsideParentheses$ = apply.1.INSTANCE;
        List<KtLambdaArgument> list2 = firstCallExpression.getLambdaArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"firstCallExpression.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull(list2);
        KtLambdaExpression lambdaExpression2 = ktLambdaArgument != null ? ktLambdaArgument.getLambdaExpression() : null;
        String additionalArgument = this.conversion.getAdditionalArgument();
        Object object = secondCallArgumentList;
        boolean secondCallHasArguments = object != null && (object = ((KtValueArgumentList)object).getArguments()) != null && !(collection2 = (Collection)object).isEmpty();
        Object object2 = firstCallArgumentList;
        boolean firstCallHasArguments = object2 != null && (object2 = ((KtValueArgumentList)object2).getArguments()) != null && !(collection = (Collection)object2).isEmpty();
        Object object3 = secondCallArgumentList;
        int n = 0;
        Object[] objectArray2 = objectArray = new String[4];
        Object it = object3;
        Object object4 = secondCallHasArguments ? object3 : null;
        KtValueArgumentList ktValueArgumentList = object4;
        objectArray[n] = ktValueArgumentList != null ? getTextInsideParentheses$.invoke(ktValueArgumentList) : null;
        object3 = firstCallArgumentList;
        n = 1;
        objectArray = objectArray2;
        it = object3;
        object4 = firstCallHasArguments ? object3 : null;
        KtValueArgumentList ktValueArgumentList2 = object4;
        objectArray[n] = ktValueArgumentList2 != null ? getTextInsideParentheses$.invoke(ktValueArgumentList2) : null;
        object3 = additionalArgument;
        n = 2;
        objectArray = objectArray2;
        it = object3;
        objectArray[n] = object4 = !firstCallHasArguments && !secondCallHasArguments ? object3 : null;
        KtLambdaExpression ktLambdaExpression = lambdaExpression2;
        objectArray2[3] = ktLambdaExpression != null ? ktLambdaExpression.getText() : null;
        String argumentsText = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        String newCallText = this.conversion.getReplacement();
        KtExpression newQualifiedOrCallExpression = factory2.createExpression(receiverExpressionOrEmptyString + operationSign + newCallText + '(' + argumentsText + ')');
        Project project = qualifiedExpression.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"qualifiedExpression.project");
        Project project2 = project;
        KtFile ktFile = qualifiedExpression.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"qualifiedExpression.containingKtFile");
        KtFile file = ktFile;
        PsiElement $receiver$iv = (PsiElement)qualifiedExpression;
        PsiElement result$iv = $receiver$iv.replace((PsiElement)newQualifiedOrCallExpression);
        PsiElement psiElement2 = result$iv;
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        if ((ktExpression = (KtExpression)psiElement2) == null) {
            PsiElement psiElement3 = result$iv;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            ktExpression = ((KtParenthesizedExpression)psiElement3).getExpression();
            if (ktExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
        }
        KtExpression result2 = ktExpression;
        if (lambdaExpression2 != null) {
            KtCallExpression callExpression2;
            KtExpression ktExpression4 = result2;
            KtCallExpression ktCallExpression3 = callExpression2 = ktExpression4 instanceof KtQualifiedExpression ? org.jetbrains.kotlin.idea.intentions.UtilsKt.getCallExpression((KtQualifiedExpression)result2) : (ktExpression4 instanceof KtCallExpression ? (KtCallExpression)result2 : null);
            if (ktCallExpression3 != null) {
                PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(ktCallExpression3);
            }
        }
        KtFile ktFile2 = result2.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"result.containingKtFile");
        UtilsKt.commitAndUnblockDocument((PsiFile)ktFile2);
        PsiElement psiElement4 = CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)result2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"CodeStyleManager.getInst\u2026project).reformat(result)");
        PsiElement psiElement5 = reformatted = psiElement4;
        if (psiElement5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        }
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement5, null, 2, null);
        if (this.runOptimizeImports) {
            new OptimizeImportsProcessor(project2, (PsiFile)file).run();
        }
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtQualifiedExpression)) {
                psiElement2 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement2;
            if (ktQualifiedExpression == null) break block1;
            KtQualifiedExpression ktQualifiedExpression2 = ktQualifiedExpression;
            SimplifyCallChainFix simplifyCallChainFix = this;
            KtQualifiedExpression p1 = ktQualifiedExpression2;
            simplifyCallChainFix.apply(p1);
        }
    }

    public SimplifyCallChainFix(@NotNull AbstractCallChainChecker.Conversion conversion2, boolean removeReceiverOfFirstCall, boolean runOptimizeImports, @NotNull Function2<? super KtPsiFactory, ? super KtCallExpression, Unit> modifyArguments) {
        Intrinsics.checkParameterIsNotNull((Object)conversion2, (String)"conversion");
        Intrinsics.checkParameterIsNotNull(modifyArguments, (String)"modifyArguments");
        this.conversion = conversion2;
        this.removeReceiverOfFirstCall = removeReceiverOfFirstCall;
        this.runOptimizeImports = runOptimizeImports;
        this.modifyArguments = modifyArguments;
        this.shortenedText = StringsKt.substringAfterLast$default((String)this.conversion.getReplacement(), (String)".", null, (int)2, null);
    }

    public /* synthetic */ SimplifyCallChainFix(AbstractCallChainChecker.Conversion conversion2, boolean bl, boolean bl2, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            function2 = 1.INSTANCE;
        }
        this(conversion2, bl, bl2, (Function2<? super KtPsiFactory, ? super KtCallExpression, Unit>)function2);
    }
}

