/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\b\u001a\u00020\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00022\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"hasLastFunctionalParameterWithResult", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isCalling", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isFunctionOfAnyKind", "isIterable", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "isMap", "idea"})
public final class FunctionUtilsKt {
    public static final boolean isFunctionOfAnyKind(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor != null ? FunctionTypesKt.getFunctionalClassKind(classifierDescriptor) : null) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isMap(@Nullable KotlinType $receiver, @NotNull KotlinBuiltIns builtIns) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Object object = $receiver;
        if (!((object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) return false;
        ClassDescriptor classDescriptor3 = classDescriptor2;
        String string = classDescriptor3.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classDescriptor.name.asString()");
        if (!StringsKt.endsWith$default((String)string, (String)"Map", (boolean)false, (int)2, null)) return false;
        ClassDescriptor classDescriptor4 = builtIns.getMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"builtIns.map");
        if (!DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor4)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isIterable(@Nullable KotlinType $receiver, @NotNull KotlinBuiltIns builtIns) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        Object object = $receiver;
        if (!((object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor2 == null) return false;
        ClassDescriptor classDescriptor3 = classDescriptor2;
        String string = classDescriptor3.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classDescriptor.name.asString()");
        String className2 = string;
        if (StringsKt.endsWith$default((String)className2, (String)"List", (boolean)false, (int)2, null)) {
            ClassDescriptor classDescriptor4 = builtIns.getList();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor4, (String)"builtIns.list");
            if (DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor4)) return true;
        }
        if (StringsKt.endsWith$default((String)className2, (String)"Set", (boolean)false, (int)2, null)) {
            ClassDescriptor classDescriptor5 = builtIns.getSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor5, (String)"builtIns.set");
            if (DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor5)) return true;
        }
        ClassDescriptor classDescriptor6 = builtIns.getIterable();
        Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor6, (String)"builtIns.iterable");
        if (!DescriptorUtilsKt.isSubclassOf(classDescriptor3, classDescriptor6)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isCalling(@NotNull KtCallExpression $receiver, @NotNull FqName fqName2, @NotNull BindingContext context) {
        String string;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            String string2 = fqName2.asString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fqName.asString()");
            String $receiver$iv = string2;
            int n = StringsKt.getLastIndex((CharSequence)$receiver$iv);
            boolean bl = false;
            while (n >= 0) {
                void index$iv;
                char it = $receiver$iv.charAt((int)index$iv);
                if (!(it != '.')) {
                    String string3 = $receiver$iv;
                    void var8_8 = index$iv + true;
                    String string4 = string3.substring((int)var8_8);
                    string = string4;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    break block3;
                }
                --index$iv;
            }
            string = $receiver$iv;
        }
        String function2 = string;
        KtExpression ktExpression = $receiver.getCalleeExpression();
        if (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)function2) ^ true) {
            return false;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        return resolvedCall2 != null && FunctionUtilsKt.isCalling(resolvedCall2, fqName2);
    }

    public static /* synthetic */ boolean isCalling$default(KtCallExpression ktCallExpression, FqName fqName2, BindingContext bindingContext2, int n, Object object) {
        if ((n & 2) != 0) {
            bindingContext2 = ResolutionUtils.analyze(ktCallExpression, BodyResolveMode.PARTIAL);
        }
        return FunctionUtilsKt.isCalling(ktCallExpression, fqName2, bindingContext2);
    }

    public static final boolean isCalling(@NotNull ResolvedCall<? extends CallableDescriptor> $receiver, @NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe($receiver.getResultingDescriptor()), (Object)fqName2);
    }

    public static final boolean hasLastFunctionalParameterWithResult(@NotNull ResolvedCall<?> $receiver, @NotNull BindingContext context, @NotNull Function1<? super KotlinType, Boolean> predicate2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(predicate2, (String)"predicate");
        Object obj = $receiver.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resultingDescriptor");
        List<ValueParameterDescriptor> list2 = obj.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resultingDescriptor.valueParameters");
        ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)CollectionsKt.lastOrNull(list2);
        if (valueParameterDescriptor == null) {
            return false;
        }
        ValueParameterDescriptor lastParameter = valueParameterDescriptor;
        Object object = $receiver.getValueArguments().get(lastParameter);
        if (object == null || (object = object.getArguments()) == null || (object = (ValueArgument)CollectionsKt.singleOrNull((List)object)) == null) {
            return false;
        }
        Object lastArgument = object;
        Object object2 = lastArgument.getArgumentExpression();
        if (object2 == null || (object2 = CallUtilKt.getType((KtExpression)object2, context)) == null) {
            return false;
        }
        Object functionalType = object2;
        if (!FunctionUtilsKt.isFunctionOfAnyKind((KotlinType)functionalType)) {
            return false;
        }
        Object object3 = (TypeProjection)CollectionsKt.lastOrNull(((KotlinType)functionalType).getArguments());
        if (object3 == null || (object3 = object3.getType()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"functionalType.arguments\u2026l()?.type ?: return false");
        Object resultType = object3;
        return (Boolean)predicate2.invoke(resultType);
    }
}

