/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.collections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.collections.ConvertFlatMapToFlattenFix;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/collections/ConvertFlatMapToFlattenInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class ConvertFlatMapToFlattenInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.qualifiedExpressionVisitor((Function1<? super KtQualifiedExpression, Unit>)((Function1)new Function1<KtQualifiedExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtQualifiedExpression expression2) {
                String lambdaParameterName;
                String string;
                KtExpression ktExpression;
                KtElement ktElement;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                KtExpression ktExpression2 = expression2.getSelectorExpression();
                if (!(ktExpression2 instanceof KtCallExpression)) {
                    ktExpression2 = null;
                }
                KtCallExpression ktCallExpression = (KtCallExpression)ktExpression2;
                if (ktCallExpression == null) {
                    return;
                }
                KtCallExpression callExpression2 = ktCallExpression;
                KtExpression ktExpression3 = callExpression2.getCalleeExpression();
                if (ktExpression3 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"callExpression.calleeExpression ?: return");
                KtExpression calleeExpression2 = ktExpression3;
                if (!FunctionUtilsKt.isCalling$default(callExpression2, new FqName("kotlin.collections.flatMap"), null, 2, null)) {
                    return;
                }
                List<KtValueArgument> list2 = callExpression2.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull(list2);
                if (ktValueArgument == null) {
                    return;
                }
                KtValueArgument argument2 = ktValueArgument;
                KtValueArgument ktValueArgument2 = argument2;
                if (!(ktValueArgument2 instanceof KtLambdaArgument)) {
                    ktValueArgument2 = null;
                }
                if ((ktElement = (KtLambdaArgument)ktValueArgument2) == null || (ktElement = ktElement.getLambdaExpression()) == null) {
                    KtExpression ktExpression4 = argument2.getArgumentExpression();
                    if (!(ktExpression4 instanceof KtLambdaExpression)) {
                        ktExpression4 = null;
                    }
                    ktElement = (KtLambdaExpression)ktExpression4;
                }
                if (ktElement == null) {
                    return;
                }
                KtElement lambdaExpression2 = ktElement;
                Object object = ((KtLambdaExpression)lambdaExpression2).getBodyExpression();
                if (!((object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : (ktExpression = null)) instanceof KtNameReferenceExpression)) {
                    ktExpression = null;
                }
                KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
                if (ktNameReferenceExpression == null) {
                    return;
                }
                KtNameReferenceExpression reference2 = ktNameReferenceExpression;
                List<KtParameter> list3 = ((KtLambdaExpression)lambdaExpression2).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"lambdaExpression.valueParameters");
                List<KtParameter> lambdaParameters = list3;
                Collection collection = lambdaParameters;
                if (!collection.isEmpty()) {
                    KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull(lambdaParameters);
                    string = ktParameter != null ? ktParameter.getName() : null;
                } else {
                    string = lambdaParameterName = "it";
                }
                if (Intrinsics.areEqual((Object)reference2.getText(), (Object)lambdaParameterName) ^ true) {
                    return;
                }
                this.$holder.registerProblem((PsiElement)calleeExpression2, "flatMap call should be simplified to flatten()", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ConvertFlatMapToFlattenFix()});
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

