/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.SortModifiersFix;
import org.jetbrains.kotlin.idea.inspections.SortModifiersInspection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/SortModifiersInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class SortModifiersInspection
extends AbstractKotlinInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitModifierList(@NotNull KtModifierList list2) {
                Object v2;
                List modifiers2;
                boolean modifiersBeforeAnnotations;
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)list2, (String)"list");
                    super.visitModifierList(list2);
                    List modifierElements = SequencesKt.toList((Sequence)PsiUtilsKt.getAllChildren((PsiElement)list2));
                    modifiersBeforeAnnotations = false;
                    boolean seenModifiers = false;
                    for (PsiElement modifierElement : modifierElements) {
                        ASTNode aSTNode = modifierElement.getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"modifierElement.node");
                        if (aSTNode.getElementType() instanceof KtModifierKeywordToken) {
                            seenModifiers = true;
                            continue;
                        }
                        if (!seenModifiers || !(modifierElement instanceof KtAnnotationEntry) && !(modifierElement instanceof KtAnnotation)) continue;
                        modifiersBeforeAnnotations = true;
                    }
                    modifiers2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)modifierElements), (Function1)buildVisitor.visitModifierList.modifiers.1.INSTANCE));
                    if (modifiers2.isEmpty()) {
                        return;
                    }
                    Iterable $receiver$iv = modifierElements;
                    for (T element$iv : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        ASTNode aSTNode = it.getNode();
                        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                        if (!(aSTNode.getElementType() instanceof KtModifierKeywordToken)) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                PsiElement psiElement2 = v2;
                if (psiElement2 == null) {
                    return;
                }
                PsiElement startElement2 = psiElement2;
                List<KtModifierKeywordToken> sortedModifiers = AddRemoveModifierKt.sortModifiers(modifiers2);
                if (Intrinsics.areEqual((Object)modifiers2, sortedModifiers) && !modifiersBeforeAnnotations) {
                    return;
                }
                String message2 = modifiersBeforeAnnotations ? "Modifiers should follow annotations" : "Non-canonical modifiers order";
                ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor(startElement2, (PsiElement)list2, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$isOnTheFly, new LocalQuickFix[]{new SortModifiersFix(sortedModifiers)});
                Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"holder.manager.createPro\u2026ifiers)\n                )");
                ProblemDescriptor descriptor2 = problemDescriptor;
                this.$holder.registerProblem(descriptor2);
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$isOnTheFly = $captured_local_variable$1;
            }
        };
    }
}

