/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaArrowInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "DeleteFix", "idea"})
public final class RedundantLambdaArrowInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.lambdaExpressionVisitor((Function1<? super KtLambdaExpression, Unit>)((Function1)new Function1<KtLambdaExpression, Unit>(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public final void invoke(@NotNull KtLambdaExpression lambdaExpression2) {
                BindingContext context;
                Object callee;
                KtCallExpression callExpression2;
                Intrinsics.checkParameterIsNotNull((Object)lambdaExpression2, (String)"lambdaExpression");
                KtFunctionLiteral ktFunctionLiteral = lambdaExpression2.getFunctionLiteral();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFunctionLiteral, (String)"lambdaExpression.functionLiteral");
                KtFunctionLiteral functionLiteral = ktFunctionLiteral;
                PsiElement psiElement2 = functionLiteral.getArrow();
                if (psiElement2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"functionLiteral.arrow ?: return");
                PsiElement arrow = psiElement2;
                List<KtParameter> list2 = functionLiteral.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionLiteral.valueParameters");
                List<KtParameter> parameters2 = list2;
                KtParameter singleParameter = (KtParameter)CollectionsKt.singleOrNull(parameters2);
                Collection collection = parameters2;
                if (!collection.isEmpty()) {
                    KtParameter ktParameter = singleParameter;
                    if (ktParameter == null || !UnderscoreUtilKt.isSingleUnderscore(ktParameter)) {
                        KtParameter ktParameter2 = singleParameter;
                        if (Intrinsics.areEqual((Object)(ktParameter2 != null ? ktParameter2.getName() : null), (Object)"it") ^ true) {
                            return;
                        }
                    }
                }
                Object $receiver$iv = (PsiElement)lambdaExpression2;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtWhenEntry.class, (boolean)true);
                if (Intrinsics.areEqual((Object)(ktWhenEntry != null ? ktWhenEntry.getExpression() : null), (Object)lambdaExpression2)) {
                    return;
                }
                $receiver$iv = (PsiElement)lambdaExpression2;
                KtContainerNodeForControlStructureBody ktContainerNodeForControlStructureBody = (KtContainerNodeForControlStructureBody)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtContainerNodeForControlStructureBody.class, (boolean)true);
                if (ktContainerNodeForControlStructureBody != null) {
                    Object it = $receiver$iv = ktContainerNodeForControlStructureBody;
                    Iterable iterable = CollectionsKt.listOf((Object[])new KtNodeType[]{KtNodeTypes.THEN, KtNodeTypes.ELSE});
                    ASTNode aSTNode = it.getNode();
                    Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"it.node");
                    if (CollectionsKt.contains((Iterable)iterable, (Object)aSTNode.getElementType()) && Intrinsics.areEqual((Object)((KtContainerNodeForControlStructureBody)it).getExpression(), (Object)lambdaExpression2)) {
                        return;
                    }
                }
                PsiElement psiElement3 = lambdaExpression2.getParent();
                Object object = psiElement3 != null ? psiElement3.getParent() : null;
                if (!(object instanceof KtCallExpression)) {
                    object = null;
                }
                if ((callExpression2 = (KtCallExpression)object) != null) {
                    KtExpression ktExpression = callExpression2.getCalleeExpression();
                    if (!(ktExpression instanceof KtNameReferenceExpression)) {
                        ktExpression = null;
                    }
                    if ((callee = (KtNameReferenceExpression)ktExpression) != null && Intrinsics.areEqual((Object)((KtNameReferenceExpression)callee).getReferencedName(), (Object)"forEach")) {
                        KtParameter ktParameter = singleParameter;
                        if (Intrinsics.areEqual((Object)(ktParameter != null ? ktParameter.getName() : null), (Object)"it") ^ true) {
                            return;
                        }
                    }
                }
                if (!(callee = (Collection)parameters2).isEmpty() && (context = ResolutionUtils.analyze$default(lambdaExpression2, null, 1, null)).get(BindingContext.EXPECTED_EXPRESSION_TYPE, lambdaExpression2) == null) {
                    return;
                }
                int startOffset = PsiUtilsKt.getStartOffset(functionLiteral);
                KtParameter ktParameter = singleParameter;
                this.$holder.registerProblem(this.$holder.getManager().createProblemDescriptor((PsiElement)functionLiteral, new TextRange((ktParameter != null ? PsiUtilsKt.getStartOffset(ktParameter) : PsiUtilsKt.getStartOffset(arrow)) - startOffset, PsiUtilsKt.getEndOffset(arrow) - startOffset), "Redundant lambda arrow", ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$isOnTheFly, new LocalQuickFix[]{new DeleteFix()}));
            }
            {
                this.$holder = problemsHolder;
                this.$isOnTheFly = bl;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantLambdaArrowInspection$DeleteFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "idea"})
    public static final class DeleteFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return "Remove arrow";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                PsiElement psiElement2 = descriptor2.getPsiElement();
                if (!(psiElement2 instanceof KtFunctionLiteral)) {
                    psiElement2 = null;
                }
                KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)psiElement2;
                if (ktFunctionLiteral == null) {
                    return;
                }
                KtFunctionLiteral element3 = ktFunctionLiteral;
                FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element3);
                KtParameterList ktParameterList = element3.getValueParameterList();
                if (ktParameterList != null) {
                    ktParameterList.delete();
                }
                PsiElement psiElement3 = element3.getArrow();
                if (psiElement3 == null) break block3;
                psiElement3.delete();
            }
        }
    }
}

