/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspection;
import org.jetbrains.kotlin.idea.inspections.NamingConventionInspectionsKt;
import org.jetbrains.kotlin.idea.inspections.NamingRule;
import org.jetbrains.kotlin.idea.inspections.PackageNameInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection;", "Lorg/jetbrains/kotlin/idea/inspections/NamingConventionInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "RenamePackageFix", "idea"})
public final class PackageNameInspection
extends NamingConventionInspection {
    @NotNull
    private static final NamingRule[] PART_RULES;
    public static final Companion Companion;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return VisitorWrappersKt.packageDirectiveVisitor((Function1<? super KtPackageDirective, Unit>)((Function1)new Function1<KtPackageDirective, Unit>(this, holder){
            final /* synthetic */ PackageNameInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtPackageDirective directive) {
                String string;
                KtExpression packageNameExpression;
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                        KtExpression ktExpression = directive.getPackageNameExpression();
                        if (ktExpression == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"directive.packageNameExp\u2026n@packageDirectiveVisitor");
                        packageNameExpression = ktExpression;
                        String string2 = directive.getQualifiedName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"directive.qualifiedName");
                        String qualifiedName2 = string2;
                        CharSequence charSequence = qualifiedName2;
                        if (charSequence.length() == 0) break block6;
                        Regex regex = this.this$0.getNameRegex();
                        if (regex != null && !regex.matches((CharSequence)qualifiedName2)) break block7;
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)this.this$0.getNamePattern(), (Object)this.this$0.getDefaultNamePattern())) {
                    List<KtSimpleNameExpression> list2 = directive.getPackageNames();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"directive.packageNames");
                    string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)buildVisitor.partErrorMessage.1.INSTANCE));
                } else {
                    string = null;
                }
                String partErrorMessage2 = string;
                String descriptionTemplate = partErrorMessage2 != null ? "Package name <code>#ref</code> part " + partErrorMessage2 + " #loc" : "Package name <code>#ref</code> " + this.this$0.getDefaultErrorMessage() + " #loc";
                this.$holder.registerProblem((PsiElement)packageNameExpression, descriptionTemplate, new LocalQuickFix[]{new RenamePackageFix()});
            }
            {
                this.this$0 = packageNameInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    public PackageNameInspection() {
        super("Package", "[a-z_][a-zA-Z\\d_]*(\\.[a-z_][a-zA-Z\\d_]*)*", new NamingRule[0]);
    }

    static {
        Companion = new Companion(null);
        PART_RULES = new NamingRule[]{NamingConventionInspectionsKt.access$getNO_BAD_CHARACTERS_OR_UNDERSCORE$p(), NamingConventionInspectionsKt.access$getNO_START_UPPER$p()};
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection$RenamePackageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/RenameIdentifierFix;", "()V", "getElementToRename", "Lcom/intellij/psi/PsiElement;", "element", "idea"})
    private static final class RenamePackageFix
    extends RenameIdentifierFix {
        @Override
        @Nullable
        protected PsiElement getElementToRename(@NotNull PsiElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            PsiElement psiElement2 = element3;
            if (!(psiElement2 instanceof KtPackageDirective)) {
                psiElement2 = null;
            }
            KtPackageDirective ktPackageDirective = (KtPackageDirective)psiElement2;
            if (ktPackageDirective == null) {
                return null;
            }
            KtPackageDirective packageDirective = ktPackageDirective;
            return (PsiElement)JavaPsiFacade.getInstance((Project)((KtPackageDirective)element3).getProject()).findPackage(packageDirective.getQualifiedName());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/PackageNameInspection$Companion;", "", "()V", "PART_RULES", "", "Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "getPART_RULES", "()[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "[Lorg/jetbrains/kotlin/idea/inspections/NamingRule;", "idea"})
    public static final class Companion {
        @NotNull
        public final NamingRule[] getPART_RULES() {
            return PART_RULES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

