/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.AddNameToArgumentIntention;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/BooleanLiteralArgumentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "reportSingle", "", "(Z)V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "createOptionsPanel", "Ljavax/swing/JComponent;", "AddNamesToLastBooleanArgumentsFix", "idea"})
public final class BooleanLiteralArgumentInspection
extends AbstractKotlinInspection {
    @JvmField
    public boolean reportSingle;

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.valueArgumentVisitor((Function1<? super KtValueArgument, Unit>)((Function1)new Function1<KtValueArgument, Unit>(this, holder, isOnTheFly){
            final /* synthetic */ BooleanLiteralArgumentInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            /*
             * Could not resolve type clashes
             * Unable to fully structure code
             */
            public final void invoke(@NotNull KtValueArgument argument) {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
                                if (argument.getArgumentName() != null) {
                                    return;
                                }
                                v0 = argument.getArgumentExpression();
                                if (!(v0 instanceof KtConstantExpression)) {
                                    v0 = null;
                                }
                                v1 = (KtConstantExpression)v0;
                                if (v1 == null) {
                                    return;
                                }
                                argumentExpression = v1;
                                v2 = argumentExpression.getNode();
                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"argumentExpression.node");
                                if (Intrinsics.areEqual((Object)v2.getElementType(), (Object)KtNodeTypes.BOOLEAN_CONSTANT) ^ true) {
                                    return;
                                }
                                $receiver$iv = (PsiElement)argument;
                                v3 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallExpression.class, (boolean)true);
                                if (v3 == null) {
                                    return;
                                }
                                call = v3;
                                v4 = call.getValueArguments();
                                Intrinsics.checkExpressionValueIsNotNull(v4, (String)"call.valueArguments");
                                valueArguments = v4;
                                $receiver$iv = valueArguments;
                                if ($receiver$iv.isEmpty()) {
                                    v5 = CollectionsKt.emptyList();
                                } else {
                                    iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                                    while (iterator$iv.hasPrevious()) {
                                        it = iterator$iv.previous();
                                        if (Intrinsics.areEqual((Object)it, (Object)argument) ^ true) continue;
                                        iterator$iv.next();
                                        expectedSize$iv = $receiver$iv.size() - iterator$iv.nextIndex();
                                        if (expectedSize$iv == 0) {
                                            v5 = CollectionsKt.emptyList();
                                        } else {
                                            var10_11 = new ArrayList<E>(expectedSize$iv);
                                            $receiver$iv = var10_11;
                                            while (iterator$iv.hasNext()) {
                                                $receiver$iv.add(iterator$iv.next());
                                            }
                                            v5 = var10_11;
                                        }
                                        break block26;
                                    }
                                    v5 = CollectionsKt.toList($receiver$iv);
                                }
                            }
                            $receiver$iv = v5;
                            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                v6 = false;
                            } else {
                                for (Object element$iv : $receiver$iv) {
                                    it = element$iv;
                                    if (!(it.isNamed() == false)) continue;
                                    v6 = true;
                                    break block27;
                                }
                                v6 = false;
                            }
                        }
                        if (v6) {
                            return;
                        }
                        $receiver$iv = ResolutionUtils.analyze$default(argumentExpression, null, 1, null).getDiagnostics().forElement((PsiElement)argumentExpression);
                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                            v7 = false;
                        } else {
                            for (Object element$iv : $receiver$iv) {
                                it = (Diagnostic)element$iv;
                                if (!(it.getSeverity() == Severity.ERROR)) continue;
                                v7 = true;
                                break block28;
                            }
                            v7 = false;
                        }
                    }
                    if (v7) {
                        return;
                    }
                    v8 = ResolutionUtils.resolveToCall$default(call, null, 1, null);
                    if (v8 == null || (v8 = v8.getResultingDescriptor()) == null || !v8.hasStableParameterNames()) {
                        return;
                    }
                    $receiver$iv = SequencesKt.windowed$default((Sequence)CollectionsKt.asSequence((Iterable)valueArguments), (int)2, (int)1, (boolean)false, (int)4, null);
                    for (E element$iv : $receiver$iv) {
                        $prev_next = (List)element$iv /* !! */ ;
                        var10_11 = $prev_next;
                        prev = (KtValueArgument)var10_11.get(0);
                        var10_11 = $prev_next;
                        next = (KtValueArgument)var10_11.get(1);
                        if (!Intrinsics.areEqual((Object)next, (Object)argument) || prev.isNamed()) ** GOTO lbl-1000
                        v9 = prev.getArgumentExpression();
                        if (!(v9 instanceof KtConstantExpression)) {
                            v9 = null;
                        }
                        if (Intrinsics.areEqual((Object)((v10 = (KtConstantExpression)v9) != null && (v10 = v10.getNode()) != null ? v10.getElementType() : null), (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                            v11 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v11 = false;
                        }
                        if (!v11) continue;
                        v12 = true;
                        break block29;
                    }
                    v12 = false;
                }
                hasPreviousUnnamedBoolean = v12;
                fixes = new ArrayList<E>();
                if (hasPreviousUnnamedBoolean) {
                    element$iv = fixes;
                    element$iv /* !! */  = new AddNamesToLastBooleanArgumentsFix();
                    element$iv.add(element$iv /* !! */ );
                }
                element$iv = fixes;
                element$iv /* !! */  = new IntentionWrapper((IntentionAction)new AddNameToArgumentIntention(), (PsiFile)argument.getContainingKtFile());
                element$iv.add(element$iv /* !! */ );
                element$iv = fixes;
                var20_15 = this.this$0.reportSingle != false || hasPreviousUnnamedBoolean != false ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                var19_16 = this.$isOnTheFly;
                var18_17 = "Boolean literal argument without parameter name";
                var17_18 = (PsiElement)argument;
                var16_19 = this.$holder;
                var15_20 = this.this$0;
                thisCollection$iv = $receiver$iv;
                v13 = thisCollection$iv.toArray(new LocalQuickFix[0]);
                if (v13 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                v14 = var21_21 = v13;
                var15_20.registerProblemWithoutOfflineInformation(var16_19, var17_18, var18_17, var19_16, var20_15, Arrays.copyOf(v14, v14.length));
            }
            {
                this.this$0 = booleanLiteralArgumentInspection;
                this.$holder = problemsHolder;
                this.$isOnTheFly = bl;
                super(1);
            }
        }));
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Report also on call with single boolean literal argument", "reportSingle");
        return (JComponent)panel;
    }

    public BooleanLiteralArgumentInspection(boolean reportSingle) {
        this.reportSingle = reportSingle;
    }

    public /* synthetic */ BooleanLiteralArgumentInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public BooleanLiteralArgumentInspection() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/BooleanLiteralArgumentInspection$AddNamesToLastBooleanArgumentsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    private static final class AddNamesToLastBooleanArgumentsFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return "Add names to boolean arguments";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtValueArgument)) {
                psiElement2 = null;
            }
            KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
            if (ktValueArgument == null) {
                return;
            }
            KtValueArgument argument2 = ktValueArgument;
            PsiElement $receiver$iv = (PsiElement)argument2;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression call2 = ktCallExpression;
            List<KtValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.valueArguments");
            List<KtValueArgument> valueArguments = list2;
            boolean problemArgumentFound = false;
            for (KtValueArgument currentArgument : CollectionsKt.reversed((Iterable)valueArguments)) {
                KtConstantExpression ktConstantExpression;
                if (Intrinsics.areEqual((Object)currentArgument, (Object)argument2)) {
                    problemArgumentFound = true;
                } else if (!problemArgumentFound) continue;
                if (currentArgument.isNamed()) {
                    return;
                }
                KtExpression ktExpression = currentArgument.getArgumentExpression();
                if (!(ktExpression instanceof KtConstantExpression)) {
                    ktExpression = null;
                }
                if (Intrinsics.areEqual((Object)((ktConstantExpression = (KtConstantExpression)ktExpression) != null && (ktConstantExpression = ktConstantExpression.getNode()) != null ? ktConstantExpression.getElementType() : null), (Object)KtNodeTypes.BOOLEAN_CONSTANT) ^ true) {
                    return;
                }
                KtValueArgument ktValueArgument2 = currentArgument;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgument2, (String)"currentArgument");
                if (AddNameToArgumentIntention.Companion.apply(ktValueArgument2)) continue;
                return;
            }
        }
    }
}

