/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.caches.lightClasses.KtFakeLightClass;
import org.jetbrains.kotlin.idea.caches.lightClasses.KtFakeLightMethod;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasActualMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.HasExpectedMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.idea.presentation.DeclarationByModuleRenderer;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0004\u0001\u0007\u000b\u000f\u001a\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a\"\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a\"\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a\"\u0010&\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a(\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a(\u0010+\u001a\u00020\u001d2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150)2\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a\"\u0010-\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0010\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 H\u0002\u001a\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002010)H\u0002\u001a\u001e\u00103\u001a\u00020/*\u0002042\u0006\u00105\u001a\u00020\u00152\b\u00106\u001a\u0004\u0018\u00010\u0015H\u0002\u001a\u0012\u00107\u001a\b\u0012\u0004\u0012\u00020\u001508*\u00020\u0019H\u0000\u001a\u0018\u00109\u001a\u00020/*\u00020\u00152\n\b\u0002\u0010:\u001a\u0004\u0018\u000104H\u0002\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\"\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\"\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0013\u001a\u00020\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\"\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006;"}, d2={"EXPECTED_DECLARATION", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$EXPECTED_DECLARATION$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$EXPECTED_DECLARATION$1;", "IMPLEMENTED_MARK", "Ljavax/swing/Icon;", "IMPLEMENTING_MARK", "OVERRIDDEN_FUNCTION", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_FUNCTION$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_FUNCTION$1;", "OVERRIDDEN_MARK", "OVERRIDDEN_PROPERTY", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_PROPERTY$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$OVERRIDDEN_PROPERTY$1;", "OVERRIDING_MARK", "PLATFORM_ACTUAL", "org/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$PLATFORM_ACTUAL$1", "Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProviderKt$PLATFORM_ACTUAL$1;", "SUBCLASSED_CLASS", "Lcom/intellij/codeInsight/daemon/impl/MarkerType;", "expectOrActualAnchor", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "getExpectOrActualAnchor", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;)Lcom/intellij/psi/PsiElement;", "markerDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getMarkerDeclaration", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "collectActualMarkers", "", "declaration", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectExpectedMarkers", "collectInheritedClassMarker", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "collectMultiplatformMarkers", "collectOverriddenFunctions", "functions", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectOverriddenPropertyAccessors", "properties", "collectSuperDeclarationMarkers", "isImplementsAndNotOverrides", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "overriddenMembers", "areAnchorsOnOneLine", "Lcom/intellij/openapi/editor/Document;", "first", "second", "findMarkerBoundDeclarations", "Lkotlin/sequences/Sequence;", "requiresNoMarkers", "document", "idea"})
public final class KotlinLineMarkerProviderKt {
    private static final Icon OVERRIDING_MARK;
    private static final Icon IMPLEMENTING_MARK;
    private static final Icon OVERRIDDEN_MARK;
    private static final Icon IMPLEMENTED_MARK;
    private static final MarkerType SUBCLASSED_CLASS;
    private static final OVERRIDDEN_FUNCTION.1 OVERRIDDEN_FUNCTION;
    private static final OVERRIDDEN_PROPERTY.1 OVERRIDDEN_PROPERTY;
    private static final PLATFORM_ACTUAL.1 PLATFORM_ACTUAL;
    private static final EXPECTED_DECLARATION.1 EXPECTED_DECLARATION;

    @Nullable
    public static final KtDeclaration getMarkerDeclaration(@NotNull PsiElement $receiver) {
        KtDeclaration ktDeclaration;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        PsiElement psiElement2 = $receiver;
        if (!(psiElement2 instanceof KtDeclaration)) {
            psiElement2 = null;
        }
        if ((ktDeclaration = (KtDeclaration)psiElement2) == null) {
            PsiElement psiElement3 = $receiver.getParent();
            if (!(psiElement3 instanceof KtDeclaration)) {
                psiElement3 = null;
            }
            ktDeclaration = (KtDeclaration)psiElement3;
        }
        return ktDeclaration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isImplementsAndNotOverrides(CallableMemberDescriptor descriptor2, Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        boolean bl;
        if (descriptor2.getModality() == Modality.ABSTRACT) return false;
        Iterable $receiver$iv = overriddenMembers;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
            if (it.getModality() != Modality.ABSTRACT) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final void collectSuperDeclarationMarkers(KtDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        KtNamedDeclaration ktNamedDeclaration;
        boolean bl;
        boolean bl2 = bl = declaration2 instanceof KtNamedFunction || declaration2 instanceof KtProperty || declaration2 instanceof KtParameter;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = SuperDeclarationMarkerKt.resolveDeclarationWithParents(declaration2);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        boolean bl3 = KotlinLineMarkerProviderKt.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        KtDeclaration ktDeclaration = declaration2;
        if (!(ktDeclaration instanceof KtNamedDeclaration)) {
            ktDeclaration = null;
        }
        if ((ktNamedDeclaration = (KtNamedDeclaration)ktDeclaration) == null || (ktNamedDeclaration = ktNamedDeclaration.getNameIdentifier()) == null) {
            ktNamedDeclaration = declaration2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedDeclaration, (String)"(declaration as? KtNamed\u2026Identifier ?: declaration");
        KtNamedDeclaration anchor2 = ktNamedDeclaration;
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo((PsiElement)anchor2, anchor2.getTextRange(), bl3 ? IMPLEMENTING_MARK : OVERRIDING_MARK, 11, (Function)SuperDeclarationMarkerTooltip.INSTANCE, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)(declaration2 instanceof KtNamedFunction ? "Go to super method" : "Go to super property"), (String)"GotoSuperMethod");
        result2.add(lineMarkerInfo);
    }

    private static final void collectInheritedClassMarker(KtClass element3, Collection<LineMarkerInfo<?>> result2) {
        KtLightClass lightClass;
        if (!PsiModificationUtilsKt.isInheritable(element3)) {
            return;
        }
        KtLightClass ktLightClass = LightClassUtilsKt.toLightClass(element3);
        if (ktLightClass == null) {
            ktLightClass = lightClass = (KtLightClass)new KtFakeLightClass(element3);
        }
        if (ClassInheritorsSearch.search((PsiClass)lightClass, (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement2 = element3.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element3;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.nameIdentifier ?: element");
        PsiElement anchor2 = psiElement2;
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, anchor2.getTextRange(), element3.isInterface() ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, SUBCLASSED_CLASS.getTooltip(), SUBCLASSED_CLASS.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)(element3.isInterface() ? "Go to implementations" : "Go to subclasses"), (String)"GotoImplementation");
        result2.add(lineMarkerInfo);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenPropertyAccessors(Collection<? extends KtNamedDeclaration> properties2, Collection<LineMarkerInfo<?>> result2) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        HashMap mappingToJava = new HashMap();
        for (KtNamedDeclaration ktNamedDeclaration : properties2) {
            if (!PsiModificationUtilsKt.isOverridable(ktNamedDeclaration)) continue;
            $receiver$iv = OverridersSearchKt.toPossiblyFakeLightMethods(ktNamedDeclaration);
            Object object = $receiver$iv.iterator();
            while (object.hasNext()) {
                Iterator element$iv = object.next();
                PsiMethod it = (PsiMethod)element$iv;
                Map map2 = mappingToJava;
                KtNamedDeclaration ktNamedDeclaration2 = ktNamedDeclaration;
                map2.put(it, ktNamedDeclaration2);
            }
            $receiver$iv = mappingToJava;
            object = ktNamedDeclaration;
            $receiver$iv.put(ktNamedDeclaration, object);
        }
        Set set2 = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"mappingToJava.keys");
        Iterable $receiver$iv2 = set2;
        $receiver$iv = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> set3 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedDeclaration property : OverridenFunctionMarkerKt.getOverriddenDeclarations(mappingToJava, set3)) {
            PsiNameIdentifierOwner psiNameIdentifierOwner;
            ProgressManager.checkCanceled();
            KtNamedDeclaration ktNamedDeclaration = property;
            if (!(ktNamedDeclaration instanceof PsiNameIdentifierOwner)) {
                ktNamedDeclaration = null;
            }
            if ((psiNameIdentifierOwner = (PsiNameIdentifierOwner)ktNamedDeclaration) == null || (psiNameIdentifierOwner = psiNameIdentifierOwner.getNameIdentifier()) == null) {
                psiNameIdentifierOwner = property;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiNameIdentifierOwner, (String)"(property as? PsiNameIde\u2026ameIdentifier ?: property");
            PsiNameIdentifierOwner anchor2 = psiNameIdentifierOwner;
            LineMarkerInfo lineMarkerInfo = new LineMarkerInfo((PsiElement)anchor2, anchor2.getTextRange(), OverridenPropertyMarkerKt.isImplemented(property) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, OVERRIDDEN_PROPERTY.getTooltip(), OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to overridden properties", (String)"GotoImplementation");
            result2.add(lineMarkerInfo);
        }
    }

    private static final PsiElement getExpectOrActualAnchor(@NotNull KtNamedDeclaration $receiver) {
        PsiElement psiElement2;
        Object object = $receiver.getNameIdentifier();
        if (object == null) {
            KtNamedDeclaration ktNamedDeclaration = $receiver;
            if (ktNamedDeclaration instanceof KtConstructor) {
                object = ((KtConstructor)$receiver).getConstructorKeyword();
                if (object == null) {
                    KtParameterList ktParameterList = ((KtConstructor)$receiver).getValueParameterList();
                    object = ktParameterList != null ? ktParameterList.getLeftParenthesis() : null;
                }
            } else {
                object = psiElement2 = ktNamedDeclaration instanceof KtObjectDeclaration ? ((KtObjectDeclaration)$receiver).getObjectKeyword() : null;
            }
        }
        if (object == null) {
            psiElement2 = $receiver;
        }
        return psiElement2;
    }

    private static final void collectMultiplatformMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        if (ExpectActualUtilKt.isExpectDeclaration(declaration2)) {
            KotlinLineMarkerProviderKt.collectActualMarkers(declaration2, result2);
        } else if (ExpectActualUtilKt.isEffectivelyActual(declaration2)) {
            KotlinLineMarkerProviderKt.collectExpectedMarkers(declaration2, result2);
        }
    }

    private static final boolean areAnchorsOnOneLine(@NotNull Document $receiver, KtNamedDeclaration first, KtNamedDeclaration second) {
        if (second == null) {
            return false;
        }
        PsiElement firstAnchor = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(first);
        PsiElement secondAnchor = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(second);
        return FixersUtilKt.startLine(firstAnchor, $receiver) == FixersUtilKt.startLine(secondAnchor, $receiver);
    }

    private static final boolean requiresNoMarkers(@NotNull KtNamedDeclaration $receiver, Document document) {
        KtNamedDeclaration ktNamedDeclaration = $receiver;
        if (ktNamedDeclaration instanceof KtPrimaryConstructor) {
            return true;
        }
        if (ktNamedDeclaration instanceof KtParameter || ktNamedDeclaration instanceof KtEnumEntry) {
            List previousEnumEntry;
            Document document2 = document;
            if (document2 != null) {
                if (KotlinLineMarkerProviderKt.areAnchorsOnOneLine(document2, $receiver, KtPsiUtilKt.getContainingClassOrObject($receiver))) {
                    return true;
                }
            }
            if ($receiver instanceof KtEnumEntry) {
                KtElementImplStub ktElementImplStub = KtPsiUtilKt.getContainingClassOrObject($receiver);
                List list2 = ktElementImplStub != null && (ktElementImplStub = ((KtClassOrObject)ktElementImplStub).getBody()) != null ? ((KtClassBody)ktElementImplStub).getEnumEntries() : null;
                List list3 = list2;
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                List enumEntries = list3;
                previousEnumEntry = (KtEnumEntry)CollectionsKt.getOrNull((List)enumEntries, (int)(enumEntries.indexOf($receiver) - 1));
                Document document3 = document;
                if (document3 != null) {
                    if (KotlinLineMarkerProviderKt.areAnchorsOnOneLine(document3, $receiver, (KtNamedDeclaration)((Object)previousEnumEntry))) {
                        return true;
                    }
                }
            }
            if ($receiver instanceof KtParameter && ((KtParameter)$receiver).hasValOrVar()) {
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject($receiver);
                previousEnumEntry = ktClassOrObject != null ? ktClassOrObject.getPrimaryConstructorParameters() : null;
                Object object = previousEnumEntry;
                if (object == null) {
                    object = CollectionsKt.emptyList();
                }
                List parameters2 = object;
                KtParameter previousParameter = (KtParameter)CollectionsKt.getOrNull((List)parameters2, (int)(parameters2.indexOf($receiver) - 1));
                Document document4 = document;
                if (document4 != null) {
                    if (KotlinLineMarkerProviderKt.areAnchorsOnOneLine(document4, $receiver, previousParameter)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static /* synthetic */ boolean requiresNoMarkers$default(KtNamedDeclaration ktNamedDeclaration, Document document, int n, Object object) {
        if ((n & 1) != 0) {
            document = PsiDocumentManager.getInstance((Project)ktNamedDeclaration.getProject()).getDocument(ktNamedDeclaration.getContainingFile());
        }
        return KotlinLineMarkerProviderKt.requiresNoMarkers(ktNamedDeclaration, document);
    }

    @NotNull
    public static final Sequence<KtNamedDeclaration> findMarkerBoundDeclarations(@NotNull KtDeclaration $receiver) {
        Sequence sequence2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!($receiver instanceof KtClass) && !($receiver instanceof KtParameter)) {
            return SequencesKt.emptySequence();
        }
        Document document = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument($receiver.getContainingFile());
        Function2 takeBound$ = new Function2<Sequence<? extends T>, KtNamedDeclaration, Sequence<? extends T>>(document){
            final /* synthetic */ Document $document;

            @NotNull
            public final <T extends KtNamedDeclaration> Sequence<T> invoke(@NotNull Sequence<? extends T> $receiver, @NotNull KtNamedDeclaration bound) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)bound, (String)"bound");
                return SequencesKt.takeWhile($receiver, (Function1)((Function1)new Function1<T, Boolean>(this, bound){
                    final /* synthetic */ findMarkerBoundDeclarations.1 this$0;
                    final /* synthetic */ KtNamedDeclaration $bound;

                    public final boolean invoke(@NotNull T it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        Document document = this.this$0.$document;
                        return document != null && KotlinLineMarkerProviderKt.access$areAnchorsOnOneLine(document, this.$bound, it);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$bound = ktNamedDeclaration;
                        super(1);
                    }
                }));
            }
            {
                this.$document = document;
                super(2);
            }
        };
        Sequence sequence3 = $receiver;
        if (sequence3 instanceof KtParameter) {
            Sequence sequence4;
            Sequence it = sequence4 = $receiver;
            Object object = ((KtParameter)$receiver).hasValOrVar() ? sequence4 : null;
            if (object == null || (object = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)object)) == null || (object = ((KtClassOrObject)object).getPrimaryConstructorParameters()) == null) {
                return SequencesKt.emptySequence();
            }
            Object propertyParameters = object;
            sequence2 = SequencesKt.filter(takeBound$.invoke(SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)propertyParameters)), (Function1)((Function1)new Function1<KtParameter, Boolean>((KtDeclaration)$receiver){
                final /* synthetic */ KtDeclaration $this_findMarkerBoundDeclarations;

                public final boolean invoke(@NotNull KtParameter it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it != this.$this_findMarkerBoundDeclarations;
                }
                {
                    this.$this_findMarkerBoundDeclarations = ktDeclaration;
                    super(1);
                }
            })), (int)1), (KtNamedDeclaration)$receiver), (Function1)findMarkerBoundDeclarations.3.INSTANCE);
        } else if (sequence3 instanceof KtEnumEntry) {
            Object object = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)$receiver);
            if (object == null || (object = ((KtClassOrObject)object).getBody()) == null || (object = ((KtClassBody)object).getEnumEntries()) == null) {
                return SequencesKt.emptySequence();
            }
            Object enumEntries = object;
            sequence2 = takeBound$.invoke(SequencesKt.drop((Sequence)SequencesKt.dropWhile((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)enumEntries)), (Function1)((Function1)new Function1<KtEnumEntry, Boolean>((KtDeclaration)$receiver){
                final /* synthetic */ KtDeclaration $this_findMarkerBoundDeclarations;

                public final boolean invoke(@NotNull KtEnumEntry it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it != this.$this_findMarkerBoundDeclarations;
                }
                {
                    this.$this_findMarkerBoundDeclarations = ktDeclaration;
                    super(1);
                }
            })), (int)1), (KtNamedDeclaration)$receiver);
        } else if (sequence3 instanceof KtClass) {
            Sequence sequence5 = ((KtClass)$receiver).getPrimaryConstructor();
            Sequence sequence6 = sequence5 != null && (sequence5 = sequence5.getValueParameters()) != null && (sequence5 = CollectionsKt.asSequence((Iterable)((Iterable)sequence5))) != null && (sequence5 = takeBound$.invoke(sequence5, (KtNamedDeclaration)$receiver)) != null ? SequencesKt.filter(sequence5, (Function1)findMarkerBoundDeclarations.boundParameters.1.INSTANCE) : null;
            Sequence sequence7 = sequence6;
            if (sequence7 == null) {
                sequence7 = SequencesKt.emptySequence();
            }
            Sequence boundParameters2 = sequence7;
            Sequence sequence8 = $receiver;
            KtClass it = (KtClass)sequence8;
            Object object = (KtClass)(((KtClass)$receiver).isEnum() ? sequence8 : null);
            sequence8 = object != null && (object = ((KtClassOrObject)object).getBody()) != null && (object = ((KtClassBody)object).getEnumEntries()) != null && (object = CollectionsKt.asSequence((Iterable)((Iterable)object))) != null ? takeBound$.invoke(object, (KtNamedDeclaration)$receiver) : null;
            Sequence sequence9 = sequence8;
            if (sequence9 == null) {
                sequence9 = SequencesKt.emptySequence();
            }
            Sequence boundEnumEntries = sequence9;
            sequence2 = SequencesKt.plus((Sequence)boundParameters2, (Sequence)boundEnumEntries);
        } else {
            sequence2 = SequencesKt.emptySequence();
        }
        return sequence2;
    }

    private static final void collectActualMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        boolean bl;
        block7: {
            if (KotlinLineMarkerProviderKt.requiresNoMarkers$default(declaration2, null, 1, null)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor == null) {
                return;
            }
            MemberDescriptor descriptor2 = memberDescriptor;
            KtFile ktFile = declaration2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
            ModuleDescriptor commonModuleDescriptor = ResolutionUtils.findModuleDescriptor(ktFile);
            Iterable $receiver$iv = MultiplatformUtilKt.getImplementingDescriptors(commonModuleDescriptor);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleDescriptor it = (ModuleDescriptor)element$iv;
                    if (!ExpectActualUtilKt.hasActualsFor(it, descriptor2)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        PsiElement anchor2 = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(declaration2);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, anchor2.getTextRange(), KotlinIcons.ACTUAL, 11, PLATFORM_ACTUAL.getTooltip(), PLATFORM_ACTUAL.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to actual declarations", (String)"GotoImplementation");
        result2.add(lineMarkerInfo);
    }

    private static final void collectExpectedMarkers(KtNamedDeclaration declaration2, Collection<LineMarkerInfo<?>> result2) {
        boolean bl;
        block7: {
            if (KotlinLineMarkerProviderKt.requiresNoMarkers$default(declaration2, null, 1, null)) {
                return;
            }
            DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
            if (!(declarationDescriptor instanceof MemberDescriptor)) {
                declarationDescriptor = null;
            }
            MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
            if (memberDescriptor == null) {
                return;
            }
            MemberDescriptor descriptor2 = memberDescriptor;
            KtFile ktFile = declaration2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"declaration.containingKtFile");
            ModuleDescriptor platformModuleDescriptor = ResolutionUtils.findModuleDescriptor(ktFile);
            Iterable $receiver$iv = MultiplatformUtilKt.getImplementedDescriptors(platformModuleDescriptor);
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ModuleDescriptor it = (ModuleDescriptor)element$iv;
                    if (!ExpectActualUtilKt.hasDeclarationOf(it, descriptor2)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        PsiElement anchor2 = KotlinLineMarkerProviderKt.getExpectOrActualAnchor(declaration2);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, anchor2.getTextRange(), KotlinIcons.EXPECT, 11, EXPECTED_DECLARATION.getTooltip(), EXPECTED_DECLARATION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to expected declaration", null);
        result2.add(lineMarkerInfo);
    }

    /*
     * WARNING - void declaration
     */
    private static final void collectOverriddenFunctions(Collection<? extends KtNamedFunction> functions2, Collection<LineMarkerInfo<?>> result2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable method;
        HashMap mappingToJava = new HashMap();
        for (KtNamedFunction ktNamedFunction : functions2) {
            Object object;
            Map map2;
            if (!PsiModificationUtilsKt.isOverridable(ktNamedFunction)) continue;
            Object object2 = LightClassUtil.INSTANCE.getLightClassMethod(ktNamedFunction);
            if (object2 == null) {
                object2 = method = (PsiMethod)KtFakeLightMethod.Companion.get(ktNamedFunction);
            }
            if (method != null) {
                map2 = mappingToJava;
                object = ktNamedFunction;
                map2.put(method, object);
            }
            map2 = mappingToJava;
            object = ktNamedFunction;
            map2.put(ktNamedFunction, object);
        }
        Set set2 = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"mappingToJava.keys");
        method = $receiver$iv = (Iterable)set2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof PsiMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set<PsiClass> set3 = JavaPsiUtilsKt.collectContainingClasses((List)destination$iv$iv);
        for (KtNamedFunction function3 : OverridenFunctionMarkerKt.getOverriddenDeclarations(mappingToJava, set3)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = function3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = function3;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"function.nameIdentifier ?: function");
            PsiElement anchor2 = psiElement2;
            LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor2, anchor2.getTextRange(), OverridenPropertyMarkerKt.isImplemented(function3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, 11, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT);
            NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo, (String)"Go to overridden methods", (String)"GotoImplementation");
            result2.add(lineMarkerInfo);
        }
    }

    static {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Gutter.OverridingMethod");
        OVERRIDING_MARK = icon;
        Icon icon2 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Gutter.ImplementingMethod");
        IMPLEMENTING_MARK = icon2;
        Icon icon3 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Gutter.OverridenMethod");
        OVERRIDDEN_MARK = icon3;
        Icon icon4 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Gutter.ImplementedMethod");
        IMPLEMENTED_MARK = icon4;
        SUBCLASSED_CLASS = new MarkerType("SUBCLASSED_CLASS", (Function)SUBCLASSED_CLASS.1.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    PsiClass psiClass2;
                    PsiClass psiClass3 = JavaPsiUtilsKt.getPsiClass(element3);
                    if (psiClass3 == null) break block0;
                    PsiClass it = psiClass2 = psiClass3;
                    MarkerType.navigateToSubclassedClass((MouseEvent)e, (PsiClass)it, (PsiElementListCellRenderer)new DeclarationByModuleRenderer());
                }
            }
        });
        OVERRIDDEN_FUNCTION = new MarkerType("OVERRIDDEN_FUNCTION", OVERRIDDEN_FUNCTION.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler gutterIconNavigationHandler = super.getNavigationHandler();
                Intrinsics.checkExpressionValueIsNotNull((Object)gutterIconNavigationHandler, (String)"super.getNavigationHandler()");
                GutterIconNavigationHandler superHandler = gutterIconNavigationHandler;
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenFunctionMarkerKt.buildNavigateToOverriddenMethodPopup(null, element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        OVERRIDDEN_PROPERTY = new MarkerType("OVERRIDDEN_PROPERTY", OVERRIDDEN_PROPERTY.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(e, element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler gutterIconNavigationHandler = super.getNavigationHandler();
                Intrinsics.checkExpressionValueIsNotNull((Object)gutterIconNavigationHandler, (String)"super.getNavigationHandler()");
                GutterIconNavigationHandler superHandler = gutterIconNavigationHandler;
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return OverridenPropertyMarkerKt.buildNavigateToPropertyOverriddenDeclarationsPopup(null, element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        PLATFORM_ACTUAL = new MarkerType("PLATFORM_ACTUAL", PLATFORM_ACTUAL.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = HasActualMarkerKt.buildNavigateToActualDeclarationsPopup(element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler gutterIconNavigationHandler = super.getNavigationHandler();
                Intrinsics.checkExpressionValueIsNotNull((Object)gutterIconNavigationHandler, (String)"super.getNavigationHandler()");
                GutterIconNavigationHandler superHandler = gutterIconNavigationHandler;
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return HasActualMarkerKt.buildNavigateToActualDeclarationsPopup(element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
        EXPECTED_DECLARATION = new MarkerType("EXPECTED_DECLARATION", EXPECTED_DECLARATION.2.INSTANCE, new LineMarkerNavigator(){

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element3) {
                block0: {
                    NavigationPopupDescriptor navigationPopupDescriptor = HasExpectedMarkerKt.buildNavigateToExpectedDeclarationsPopup(element3);
                    if (navigationPopupDescriptor == null) break block0;
                    navigationPopupDescriptor.showPopup(e);
                }
            }
        }){

            @NotNull
            public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
                GutterIconNavigationHandler gutterIconNavigationHandler = super.getNavigationHandler();
                Intrinsics.checkExpressionValueIsNotNull((Object)gutterIconNavigationHandler, (String)"super.getNavigationHandler()");
                GutterIconNavigationHandler superHandler = gutterIconNavigationHandler;
                return (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>(superHandler){
                    final /* synthetic */ GutterIconNavigationHandler $superHandler;

                    public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                        this.$superHandler.navigate(e, elt);
                    }

                    @Nullable
                    public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                        return HasExpectedMarkerKt.buildNavigateToExpectedDeclarationsPopup(element3);
                    }
                    {
                        this.$superHandler = $captured_local_variable$0;
                    }
                };
            }
        };
    }

    public static final /* synthetic */ void access$collectInheritedClassMarker(KtClass element3, Collection result2) {
        KotlinLineMarkerProviderKt.collectInheritedClassMarker(element3, result2);
    }

    public static final /* synthetic */ void access$collectSuperDeclarationMarkers(KtDeclaration declaration2, Collection result2) {
        KotlinLineMarkerProviderKt.collectSuperDeclarationMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectMultiplatformMarkers(KtNamedDeclaration declaration2, Collection result2) {
        KotlinLineMarkerProviderKt.collectMultiplatformMarkers(declaration2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenFunctions(Collection functions2, Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenFunctions(functions2, result2);
    }

    public static final /* synthetic */ void access$collectOverriddenPropertyAccessors(Collection properties2, Collection result2) {
        KotlinLineMarkerProviderKt.collectOverriddenPropertyAccessors(properties2, result2);
    }

    public static final /* synthetic */ boolean access$areAnchorsOnOneLine(Document $receiver, KtNamedDeclaration first, KtNamedDeclaration second) {
        return KotlinLineMarkerProviderKt.areAnchorsOnOneLine($receiver, first, second);
    }
}

