/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.HighlighterExtension;
import org.jetbrains.kotlin.idea.highlighter.HighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor;", "Lorg/jetbrains/kotlin/idea/highlighter/AfterAnalysisHighlightingVisitor;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lcom/intellij/lang/annotation/AnnotationHolder;Lorg/jetbrains/kotlin/resolve/BindingContext;)V", "attributeKeyByPropertyType", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "highlightPropertyDeclaration", "", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "idea-core"})
public final class PropertiesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    @Override
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
        TextAttributesKey textAttributesKey;
        block9: {
            DeclarationDescriptor target;
            block8: {
                TextAttributesKey textAttributesKey2;
                block7: {
                    Object[] $receiver$iv;
                    TextAttributesKey textAttributesKey3;
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    if (expression2.getParent() instanceof KtThisExpression) {
                        return;
                    }
                    target = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
                    if (target instanceof SyntheticFieldDescriptor) {
                        PsiElement psiElement2 = (PsiElement)expression2;
                        TextAttributesKey textAttributesKey4 = KotlinHighlightingColors.BACKING_FIELD_VARIABLE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey4, (String)"BACKING_FIELD_VARIABLE");
                        HighlightingVisitor.highlightName$default((HighlightingVisitor)this, psiElement2, textAttributesKey4, null, 4, null);
                        return;
                    }
                    if (!(target instanceof PropertyDescriptor)) {
                        return;
                    }
                    TextAttributesKey resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
                    textAttributesKey = resolvedCall2;
                    if (textAttributesKey == null) break block8;
                    TextAttributesKey call2 = textAttributesKey3 = textAttributesKey;
                    Object[] objectArray = Extensions.getExtensions(HighlighterExtension.Companion.getEP_NAME());
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"Extensions.getExtensions\u2026lighterExtension.EP_NAME)");
                    for (Object element$iv : $receiver$iv = objectArray) {
                        HighlighterExtension extension = (HighlighterExtension)element$iv;
                        TextAttributesKey result$iv = extension.highlightCall((PsiElement)expression2, (ResolvedCall<?>)call2);
                        if (result$iv == null) continue;
                        textAttributesKey2 = result$iv;
                        break block7;
                    }
                    textAttributesKey2 = null;
                }
                textAttributesKey = textAttributesKey2;
                if (textAttributesKey2 != null) break block9;
            }
            textAttributesKey = this.attributeKeyByPropertyType((PropertyDescriptor)target);
        }
        TextAttributesKey attributesKey = textAttributesKey;
        HighlightingVisitor.highlightName$default((HighlightingVisitor)this, (PsiElement)expression2, attributesKey, null, 4, null);
    }

    @Override
    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        PsiElement psiElement2 = property.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"property.nameIdentifier ?: return");
        PsiElement nameIdentifier = psiElement2;
        VariableDescriptor propertyDescriptor2 = (VariableDescriptor)this.getBindingContext().get(BindingContext.VARIABLE, property);
        if (propertyDescriptor2 instanceof PropertyDescriptor) {
            this.highlightPropertyDeclaration(nameIdentifier, (PropertyDescriptor)propertyDescriptor2);
        }
        super.visitProperty(property);
    }

    @Override
    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        PsiElement psiElement2 = parameter.getNameIdentifier();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parameter.nameIdentifier ?: return");
        PsiElement nameIdentifier = psiElement2;
        PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)this.getBindingContext().get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor2 != null) {
            if (propertyDescriptor2.isVar()) {
                TextAttributesKey textAttributesKey = KotlinHighlightingColors.MUTABLE_VARIABLE;
                Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey, (String)"MUTABLE_VARIABLE");
                HighlightingVisitor.highlightName$default((HighlightingVisitor)this, nameIdentifier, textAttributesKey, null, 4, null);
            }
            this.highlightPropertyDeclaration(nameIdentifier, propertyDescriptor2);
        }
        super.visitParameter(parameter);
    }

    private final void highlightPropertyDeclaration(PsiElement elementToHighlight, PropertyDescriptor descriptor2) {
        TextAttributesKey textAttributesKey = this.attributeKeyForDeclarationFromExtensions(elementToHighlight, descriptor2);
        if (textAttributesKey == null) {
            textAttributesKey = this.attributeKeyByPropertyType(descriptor2);
        }
        HighlightingVisitor.highlightName$default((HighlightingVisitor)this, elementToHighlight, textAttributesKey, null, 4, null);
    }

    private final TextAttributesKey attributeKeyByPropertyType(PropertyDescriptor descriptor2) {
        TextAttributesKey textAttributesKey;
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            TextAttributesKey textAttributesKey2 = KotlinHighlightingColors.DYNAMIC_PROPERTY_CALL;
            textAttributesKey = textAttributesKey2;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey2, (String)"DYNAMIC_PROPERTY_CALL");
        } else if (descriptor2.getExtensionReceiverParameter() != null) {
            TextAttributesKey textAttributesKey3 = TowerUtilsKt.isSynthesized(descriptor2) ? KotlinHighlightingColors.SYNTHETIC_EXTENSION_PROPERTY : KotlinHighlightingColors.EXTENSION_PROPERTY;
            textAttributesKey = textAttributesKey3;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey3, (String)"if (descriptor.isSynthes\u2026Y else EXTENSION_PROPERTY");
        } else if (DescriptorUtils.isStaticDeclaration(descriptor2)) {
            TextAttributesKey textAttributesKey4 = KotlinHighlightingColors.PACKAGE_PROPERTY;
            textAttributesKey = textAttributesKey4;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey4, (String)"PACKAGE_PROPERTY");
        } else {
            TextAttributesKey textAttributesKey5 = KotlinHighlightingColors.INSTANCE_PROPERTY;
            textAttributesKey = textAttributesKey5;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey5, (String)"INSTANCE_PROPERTY");
        }
        return textAttributesKey;
    }

    public PropertiesHighlightingVisitor(@NotNull AnnotationHolder holder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        super(holder, bindingContext2);
    }
}

