/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinFormatterUsageCollector$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector;", "", "()V", "getEnumStringPropertyUsage", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "key", "", "value", "getProjectUsages", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "KotlinFormatterKind", "idea"})
public final class KotlinFormatterUsageCollector {
    private static final String GROUP_ID = "kotlin.formatter";
    private static final CommonCodeStyleSettings KOTLIN_DEFAULT_COMMON;
    private static final KotlinCodeStyleSettings KOTLIN_DEFAULT_CUSTOM;
    private static final CommonCodeStyleSettings KOTLIN_OBSOLETE_DEFAULT_COMMON;
    private static final KotlinCodeStyleSettings KOTLIN_OBSOLETE_DEFAULT_CUSTOM;
    public static final Companion Companion;

    @NotNull
    public final Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KotlinFormatterKind usedFormatter = Companion.getKotlinFormatterKind(project);
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"CodeStyleSettingsManager.getSettings(project)");
        CodeStyleSettings settings2 = codeStyleSettings;
        KotlinCommonCodeStyleSettings kotlinCommonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(settings2);
        KotlinCodeStyleSettings kotlinCustomSettings = KtCodeStyleSettingsKt.getKotlinCustomSettings(settings2);
        Object[] objectArray = new UsageDescriptor[2];
        objectArray[0] = StatisticsUtilKt.getEnumUsage((String)"kotlin.formatter.kind", (Enum)usedFormatter);
        String string = kotlinCustomSettings.CODE_STYLE_DEFAULTS;
        if (string == null) {
            string = kotlinCommonSettings.CODE_STYLE_DEFAULTS;
        }
        objectArray[1] = this.getEnumStringPropertyUsage("kotlin.formatter.defaults", string);
        return SetsKt.setOf((Object[])objectArray);
    }

    private final UsageDescriptor getEnumStringPropertyUsage(String key, String value) {
        StringBuilder stringBuilder = new StringBuilder().append(key).append(".");
        String string = String.valueOf(value);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"java.util.Locale.ENGLISH");
        Locale locale2 = locale;
        StringBuilder stringBuilder2 = stringBuilder;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        int n = 1;
        String string5 = stringBuilder2.append(string4).toString();
        return new UsageDescriptor(string5, n);
    }

    static {
        Object object;
        Companion = new Companion(null);
        CommonCodeStyleSettings it = object = new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings();
        KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings$default(KotlinStyleGuideCodeStyle.Companion, it, false, 2, null);
        KOTLIN_DEFAULT_COMMON = object;
        CommonCodeStyleSettings commonCodeStyleSettings = it = (object = KotlinCodeStyleSettings.DEFAULT.cloneSettings());
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings, (String)"it");
        KotlinStyleGuideCodeStyle.Companion.applyToKotlinCustomSettings$default(KotlinStyleGuideCodeStyle.Companion, (KotlinCodeStyleSettings)commonCodeStyleSettings, false, 2, null);
        Object object2 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"KotlinCodeStyleSettings.\u2026otlinCustomSettings(it) }");
        KOTLIN_DEFAULT_CUSTOM = object2;
        it = object = new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings();
        KotlinObsoleteCodeStyle.Companion.applyToCommonSettings$default(KotlinObsoleteCodeStyle.Companion, it, false, 2, null);
        KOTLIN_OBSOLETE_DEFAULT_COMMON = object;
        CommonCodeStyleSettings commonCodeStyleSettings2 = it = (object = KotlinCodeStyleSettings.DEFAULT.cloneSettings());
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCodeStyleSettings2, (String)"it");
        KotlinObsoleteCodeStyle.Companion.applyToKotlinCustomSettings$default(KotlinObsoleteCodeStyle.Companion, (KotlinCodeStyleSettings)commonCodeStyleSettings2, false, 2, null);
        Object object3 = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"KotlinCodeStyleSettings.\u2026otlinCustomSettings(it) }");
        KOTLIN_OBSOLETE_DEFAULT_CUSTOM = object3;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "", "(Ljava/lang/String;I)V", "IDEA_DEFAULT", "IDEA_CUSTOM", "IDEA_KOTLIN_WITH_CUSTOM", "IDEA_KOTLIN", "PROJECT_DEFAULT", "PROJECT_CUSTOM", "PROJECT_KOTLIN_WITH_CUSTOM", "PROJECT_KOTLIN", "IDEA_OFFICIAL_DEFAULT", "IDEA_OBSOLETE_KOTLIN", "IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM", "PROJECT_OFFICIAL_DEFAULT", "PROJECT_OBSOLETE_KOTLIN", "PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM", "idea"})
    public static final class KotlinFormatterKind
    extends Enum<KotlinFormatterKind> {
        public static final /* enum */ KotlinFormatterKind IDEA_DEFAULT;
        public static final /* enum */ KotlinFormatterKind IDEA_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_DEFAULT;
        public static final /* enum */ KotlinFormatterKind PROJECT_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_KOTLIN;
        public static final /* enum */ KotlinFormatterKind IDEA_OFFICIAL_DEFAULT;
        public static final /* enum */ KotlinFormatterKind IDEA_OBSOLETE_KOTLIN;
        public static final /* enum */ KotlinFormatterKind IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_OFFICIAL_DEFAULT;
        public static final /* enum */ KotlinFormatterKind PROJECT_OBSOLETE_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM;
        private static final /* synthetic */ KotlinFormatterKind[] $VALUES;

        static {
            KotlinFormatterKind[] kotlinFormatterKindArray = new KotlinFormatterKind[14];
            KotlinFormatterKind[] kotlinFormatterKindArray2 = kotlinFormatterKindArray;
            kotlinFormatterKindArray[0] = IDEA_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[1] = IDEA_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[2] = IDEA_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[3] = IDEA_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[4] = PROJECT_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[5] = PROJECT_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[6] = PROJECT_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[7] = PROJECT_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[8] = IDEA_OFFICIAL_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[9] = IDEA_OBSOLETE_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[10] = IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[11] = PROJECT_OFFICIAL_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[12] = PROJECT_OBSOLETE_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[13] = PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            $VALUES = kotlinFormatterKindArray;
        }

        public static KotlinFormatterKind[] values() {
            return (KotlinFormatterKind[])$VALUES.clone();
        }

        public static KotlinFormatterKind valueOf(String string) {
            return Enum.valueOf(KotlinFormatterKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$Companion;", "", "()V", "GROUP_ID", "", "KOTLIN_DEFAULT_COMMON", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "KOTLIN_DEFAULT_CUSTOM", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "KOTLIN_OBSOLETE_DEFAULT_COMMON", "KOTLIN_OBSOLETE_DEFAULT_CUSTOM", "getKotlinFormatterKind", "Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "project", "Lcom/intellij/openapi/project/Project;", "paired", "kind", "isProject", "", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinFormatterKind getKotlinFormatterKind(@NotNull Project project) {
            CodeStyleSettings it;
            CodeStyleSettings it2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            boolean isProject = CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
            boolean isDefaultOfficialCodeStyle2 = FormatterUtilKt.isDefaultOfficialCodeStyle();
            CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"CodeStyleSettingsManager.getSettings(project)");
            CodeStyleSettings settings2 = codeStyleSettings;
            KotlinCommonCodeStyleSettings kotlinCommonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(settings2);
            KotlinCodeStyleSettings kotlinCustomSettings = KtCodeStyleSettingsKt.getKotlinCustomSettings(settings2);
            boolean isDefaultKotlinCommonSettings = Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings());
            boolean isDefaultKotlinCustomSettings = Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)KotlinCodeStyleSettings.DEFAULT));
            if (isDefaultKotlinCommonSettings && isDefaultKotlinCustomSettings) {
                return isDefaultOfficialCodeStyle2 ? this.paired(KotlinFormatterKind.IDEA_OFFICIAL_DEFAULT, isProject) : this.paired(KotlinFormatterKind.IDEA_DEFAULT, isProject);
            }
            if (Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)KOTLIN_OBSOLETE_DEFAULT_COMMON) && Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)KOTLIN_OBSOLETE_DEFAULT_CUSTOM))) {
                return this.paired(KotlinFormatterKind.IDEA_OBSOLETE_KOTLIN, isProject);
            }
            if (Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)KOTLIN_DEFAULT_COMMON) && Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)KOTLIN_DEFAULT_CUSTOM))) {
                return this.paired(KotlinFormatterKind.IDEA_KOTLIN, isProject);
            }
            CodeStyleSettings codeStyleSettings2 = settings2.clone();
            CodeStyleSettings codeStyleSettings3 = settings2;
            CodeStyleSettings codeStyleSettings4 = it2 = codeStyleSettings2;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings4, (String)"it");
            KotlinStyleGuideCodeStyle.Companion.apply(codeStyleSettings4);
            CodeStyleSettings codeStyleSettings5 = codeStyleSettings2;
            boolean isKotlinOfficialLikeSettings = Intrinsics.areEqual((Object)codeStyleSettings3, (Object)codeStyleSettings5);
            if (isKotlinOfficialLikeSettings) {
                return this.paired(KotlinFormatterKind.IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM, isProject);
            }
            CodeStyleSettings codeStyleSettings6 = settings2.clone();
            codeStyleSettings3 = settings2;
            CodeStyleSettings codeStyleSettings7 = it = codeStyleSettings6;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings7, (String)"it");
            KotlinObsoleteCodeStyle.Companion.apply(codeStyleSettings7);
            codeStyleSettings5 = codeStyleSettings6;
            boolean isKotlinObsoleteLikeSettings = Intrinsics.areEqual((Object)codeStyleSettings3, (Object)codeStyleSettings5);
            if (isKotlinObsoleteLikeSettings) {
                return this.paired(KotlinFormatterKind.IDEA_KOTLIN_WITH_CUSTOM, isProject);
            }
            return this.paired(KotlinFormatterKind.IDEA_CUSTOM, isProject);
        }

        private final KotlinFormatterKind paired(KotlinFormatterKind kind, boolean isProject) {
            KotlinFormatterKind kotlinFormatterKind;
            if (!isProject) {
                return kind;
            }
            switch (KotlinFormatterUsageCollector$Companion$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_DEFAULT;
                    break;
                }
                case 2: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OFFICIAL_DEFAULT;
                    break;
                }
                case 3: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_CUSTOM;
                    break;
                }
                case 4: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_KOTLIN_WITH_CUSTOM;
                    break;
                }
                case 5: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_KOTLIN;
                    break;
                }
                case 6: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OBSOLETE_KOTLIN;
                    break;
                }
                case 7: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM;
                    break;
                }
                default: {
                    kotlinFormatterKind = kind;
                }
            }
            return kotlinFormatterKind;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

