/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinFindPropertyUsagesDialog
extends JavaFindUsagesDialog<KotlinPropertyFindUsagesOptions> {
    private StateRestoringCheckBox readAccesses;
    private StateRestoringCheckBox writeAccesses;
    private StateRestoringCheckBox overrideUsages;
    private StateRestoringCheckBox expectedUsages;

    public KotlinFindPropertyUsagesDialog(PsiElement element3, Project project, KotlinPropertyFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super(element3, project, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @NotNull
    protected KotlinPropertyFindUsagesOptions getFindUsagesOptions() {
        KotlinPropertyFindUsagesOptions kotlinPropertyFindUsagesOptions = (KotlinPropertyFindUsagesOptions)this.myFindUsagesOptions;
        if (kotlinPropertyFindUsagesOptions == null) {
            KotlinFindPropertyUsagesDialog.$$$reportNull$$$0(0);
        }
        return kotlinPropertyFindUsagesOptions;
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbToSkipResultsWhenOneUsage;
    }

    public void calcFindUsagesOptions(KotlinPropertyFindUsagesOptions options2) {
        super.calcFindUsagesOptions((JavaFindUsagesOptions)options2);
        options2.isReadAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses);
        options2.isWriteAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses);
        options2.setSearchOverrides(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.overrideUsages));
        if (this.expectedUsages != null) {
            options2.setSearchExpected(this.expectedUsages.isSelected());
        }
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.what.group", (Object[])new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        KotlinPropertyFindUsagesOptions options2 = this.getFindUsagesOptions();
        this.readAccesses = this.addCheckboxToPanel(KotlinBundle.message("find.what.property.readers.checkbox", new Object[0]), options2.isReadAccess, findWhatPanel, true);
        this.writeAccesses = this.addCheckboxToPanel(KotlinBundle.message("find.what.property.writers.checkbox", new Object[0]), options2.isWriteAccess, findWhatPanel, true);
        return findWhatPanel;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            KotlinFindPropertyUsagesDialog.$$$reportNull$$$0(1);
        }
        Utils.configureLabelComponent(coloredComponent, (KtNamedDeclaration)this.getPsiElement());
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        KtNamedDeclaration property = (KtNamedDeclaration)this.getPsiElement();
        boolean isAbstract = property.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean isOpen = property.hasModifier(KtTokens.OPEN_KEYWORD);
        if (isOpen || isAbstract) {
            this.overrideUsages = this.addCheckboxToPanel(isAbstract ? KotlinBundle.message("find.what.implementing.properties.checkbox", new Object[0]) : KotlinBundle.message("find.what.overriding.properties.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
        boolean isActual = PsiUtilsKt.hasActualModifier(property);
        KotlinPropertyFindUsagesOptions options2 = this.getFindUsagesOptions();
        if (isActual) {
            this.expectedUsages = this.addCheckboxToPanel("Expected properties", options2.getSearchExpected(), optionsPanel, false);
        }
    }

    protected void update() {
        this.setOKActionEnabled(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.readAccesses) || KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.writeAccesses));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindPropertyUsagesDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindPropertyUsagesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "configureLabelComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

