/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

public class MemberMatching {
    @Nullable
    private static KtTypeReference getReceiverType(@NotNull KtNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction instanceof KtCallableDeclaration) {
            return ((KtCallableDeclaration)propertyOrFunction).getReceiverTypeReference();
        }
        throw new IllegalArgumentException("Not a callable declaration: " + propertyOrFunction.getClass().getName());
    }

    @NotNull
    private static List<KtParameter> getValueParameters(@NotNull KtNamedDeclaration propertyOrFunction) {
        if (propertyOrFunction instanceof KtCallableDeclaration) {
            return ((KtCallableDeclaration)propertyOrFunction).getValueParameters();
        }
        throw new IllegalArgumentException("Not a callable declaration: " + propertyOrFunction.getClass().getName());
    }

    private static String getTypeShortName(@NotNull KtTypeReference typeReference) {
        KtTypeElement typeElement = typeReference.getTypeElement();
        assert (typeElement != null);
        return typeElement.accept(new KtVisitor<String, Void>(){

            @Override
            public String visitDeclaration(@NotNull KtDeclaration declaration2, Void data) {
                throw new IllegalStateException("This visitor shouldn't be invoked for " + declaration2.getClass());
            }

            @Override
            public String visitUserType(@NotNull KtUserType type2, Void data) {
                KtSimpleNameExpression referenceExpression = type2.getReferenceExpression();
                assert (referenceExpression != null);
                return referenceExpression.getReferencedName();
            }

            @Override
            public String visitFunctionType(@NotNull KtFunctionType type2, Void data) {
                return KotlinBuiltIns.getFunctionName(type2.getParameters().size() + (type2.getReceiverTypeReference() != null ? 1 : 0));
            }

            @Override
            public String visitNullableType(@NotNull KtNullableType nullableType, Void data) {
                KtTypeElement innerType = nullableType.getInnerType();
                assert (innerType != null) : "No inner type: " + nullableType;
                return innerType.accept(this, null);
            }

            @Override
            public String visitDynamicType(@NotNull KtDynamicType type2, Void data) {
                return "dynamic";
            }
        }, null);
    }

    private static boolean typesHaveSameShortName(@NotNull KtTypeReference a, @NotNull KtTypeReference b) {
        return MemberMatching.getTypeShortName(a).equals(MemberMatching.getTypeShortName(b));
    }

    static boolean sameReceiverPresenceAndParametersCount(@NotNull KtNamedDeclaration a, @NotNull KtNamedDeclaration b) {
        boolean sameReceiverPresence = MemberMatching.getReceiverType(a) == null == (MemberMatching.getReceiverType(b) == null);
        boolean sameParametersCount = MemberMatching.getValueParameters(a).size() == MemberMatching.getValueParameters(b).size();
        return sameReceiverPresence && sameParametersCount;
    }

    static boolean receiverAndParametersShortTypesMatch(@NotNull KtNamedDeclaration a, @NotNull KtNamedDeclaration b) {
        KtTypeReference bReceiver;
        KtTypeReference aReceiver = MemberMatching.getReceiverType(a);
        if (aReceiver == null != ((bReceiver = MemberMatching.getReceiverType(b)) == null)) {
            return false;
        }
        if (aReceiver != null && !MemberMatching.typesHaveSameShortName(aReceiver, bReceiver)) {
            return false;
        }
        List<KtParameter> aParameters = MemberMatching.getValueParameters(a);
        List<KtParameter> bParameters = MemberMatching.getValueParameters(b);
        if (aParameters.size() != bParameters.size()) {
            return false;
        }
        for (int i2 = 0; i2 < aParameters.size(); ++i2) {
            KtTypeReference aType = aParameters.get(i2).getTypeReference();
            KtTypeReference bType = bParameters.get(i2).getTypeReference();
            assert (aType != null);
            assert (bType != null);
            if (MemberMatching.typesHaveSameShortName(aType, bType)) continue;
            return false;
        }
        return true;
    }

    static boolean receiversMatch(@NotNull KtNamedDeclaration declaration2, @NotNull CallableDescriptor descriptor2) {
        KtTypeReference declarationReceiver = MemberMatching.getReceiverType(declaration2);
        ReceiverParameterDescriptor descriptorReceiver = descriptor2.getExtensionReceiverParameter();
        if (declarationReceiver == null && descriptorReceiver == null) {
            return true;
        }
        if (declarationReceiver != null && descriptorReceiver != null) {
            return declarationReceiver.getText().equals(DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(descriptorReceiver.getType()));
        }
        return false;
    }

    static boolean valueParametersTypesMatch(@NotNull KtNamedDeclaration declaration2, @NotNull CallableDescriptor descriptor2) {
        List<KtParameter> declarationParameters = MemberMatching.getValueParameters(declaration2);
        List<ValueParameterDescriptor> descriptorParameters = descriptor2.getValueParameters();
        if (descriptorParameters.size() != declarationParameters.size()) {
            return false;
        }
        for (int i2 = 0; i2 < descriptorParameters.size(); ++i2) {
            KotlinType typeToRender;
            boolean varargInDescriptor;
            ValueParameterDescriptor descriptorParameter = descriptorParameters.get(i2);
            KtParameter declarationParameter = declarationParameters.get(i2);
            KtTypeReference typeReference = declarationParameter.getTypeReference();
            if (typeReference == null) {
                return false;
            }
            KtModifierList modifierList = declarationParameter.getModifierList();
            boolean varargInDeclaration = modifierList != null && modifierList.hasModifier(KtTokens.VARARG_KEYWORD);
            boolean bl = varargInDescriptor = descriptorParameter.getVarargElementType() != null;
            if (varargInDeclaration != varargInDescriptor) {
                return false;
            }
            String declarationTypeText = typeReference.getText();
            KotlinType kotlinType2 = typeToRender = varargInDeclaration ? descriptorParameter.getVarargElementType() : descriptorParameter.getType();
            assert (typeToRender != null);
            String descriptorParameterText = DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(typeToRender);
            if (declarationTypeText.equals(descriptorParameterText)) continue;
            return false;
        }
        return true;
    }

    static boolean typeParametersMatch(@NotNull KtTypeParameterListOwner typeParameterListOwner, @NotNull List<TypeParameterDescriptor> typeParameterDescriptors) {
        List<KtTypeParameter> decompiledParameters = typeParameterListOwner.getTypeParameters();
        if (decompiledParameters.size() != typeParameterDescriptors.size()) {
            return false;
        }
        HashMultimap decompiledParameterToBounds = HashMultimap.create();
        for (KtTypeParameter parameter : decompiledParameters) {
            KtTypeReference extendsBound = parameter.getExtendsBound();
            if (extendsBound == null) continue;
            decompiledParameterToBounds.put((Object)parameter.getNameAsName(), (Object)extendsBound.getText());
        }
        for (KtTypeConstraint typeConstraint : typeParameterListOwner.getTypeConstraints()) {
            KtSimpleNameExpression typeParameterName = typeConstraint.getSubjectTypeParameterName();
            assert (typeParameterName != null);
            KtTypeReference bound = typeConstraint.getBoundTypeReference();
            assert (bound != null);
            decompiledParameterToBounds.put((Object)typeParameterName.getReferencedNameAsName(), (Object)bound.getText());
        }
        for (int i2 = 0; i2 < decompiledParameters.size(); ++i2) {
            HashSet decompiledUpperBounds;
            KtTypeParameter decompiledParameter = decompiledParameters.get(i2);
            TypeParameterDescriptor descriptor2 = typeParameterDescriptors.get(i2);
            Name name2 = decompiledParameter.getNameAsName();
            assert (name2 != null);
            if (!name2.equals(descriptor2.getName())) {
                return false;
            }
            HashSet descriptorUpperBounds = Sets.newHashSet((Iterable)ContainerUtil.map(descriptor2.getUpperBounds(), (Function)new Function<KotlinType, String>(){

                public String fun(KotlinType type2) {
                    return DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(type2);
                }
            }));
            KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(descriptor2);
            HashSet hashSet = decompiledUpperBounds = decompiledParameterToBounds.get((Object)descriptor2.getName()).isEmpty() ? Sets.newHashSet((Object[])new String[]{DescriptorRenderer.FQ_NAMES_IN_TYPES.renderType(builtIns.getDefaultBound())}) : Sets.newHashSet((Iterable)decompiledParameterToBounds.get((Object)descriptor2.getName()));
            if (descriptorUpperBounds.equals(decompiledUpperBounds)) continue;
            return false;
        }
        return true;
    }

    private MemberMatching() {
    }
}

