/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.classFile;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ClassFileViewProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.FileAttributeService;
import org.jetbrains.kotlin.idea.caches.IDEKotlinBinaryClassCache;
import org.jetbrains.kotlin.idea.decompiler.classFile.DirectoryBasedClassFinder;
import org.jetbrains.kotlin.idea.decompiler.classFile.IsKotlinBinary;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinderKt;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u001a\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e\"\u001f\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/idea/decompiler/classFile/IsKotlinBinary;", "kotlin.jvm.PlatformType", "getKEY", "()Lcom/intellij/openapi/util/Key;", "KOTLIN_COMPILED_FILE_ATTRIBUTE", "", "getKOTLIN_COMPILED_FILE_ATTRIBUTE", "()Ljava/lang/String;", "findMultifileClassParts", "", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "partNames", "isKotlinInternalCompiledFile", "", "fileContent", "", "isKotlinWithCompatibleAbiVersion", "idea-core"})
public final class ClassFileDecompilerUtilKt {
    @NotNull
    private static final String KOTLIN_COMPILED_FILE_ATTRIBUTE;
    @NotNull
    private static final Key<IsKotlinBinary> KEY;

    @NotNull
    public static final String getKOTLIN_COMPILED_FILE_ATTRIBUTE() {
        return KOTLIN_COMPILED_FILE_ATTRIBUTE;
    }

    @NotNull
    public static final Key<IsKotlinBinary> getKEY() {
        return KEY;
    }

    public static final boolean isKotlinWithCompatibleAbiVersion(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!IDEKotlinBinaryClassCache.isKotlinJvmCompiledFile$default(IDEKotlinBinaryClassCache.INSTANCE, file, null, 2, null)) {
            return false;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinClass = IDEKotlinBinaryClassCache.getKotlinBinaryClassHeaderData$default(IDEKotlinBinaryClassCache.INSTANCE, file, null, 2, null);
        return kotlinClass != null && kotlinClass.getMetadataVersion().isCompatible();
    }

    public static final boolean isKotlinInternalCompiledFile(@NotNull VirtualFile file, @Nullable byte[] fileContent) {
        boolean bl;
        block10: {
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (!file.isValid() || fileContent != null && fileContent.length == 0) break block9;
                if (file.exists()) break block10;
            }
            return false;
        }
        if (!IDEKotlinBinaryClassCache.INSTANCE.isKotlinJvmCompiledFile(file, fileContent)) {
            return false;
        }
        try {
            bl = fileContent == null ? ClassFileViewProvider.isInnerClass((VirtualFile)file) : ClassFileViewProvider.isInnerClass((VirtualFile)file, (byte[])fileContent);
        }
        catch (Exception exception) {
            Logger.getInstance((String)"org.jetbrains.kotlin.idea.decompiler.classFile.isKotlinInternalCompiledFile").debug(file.getPath(), (Throwable)exception);
            return false;
        }
        boolean innerClass = bl;
        if (innerClass) {
            return true;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData kotlinBinaryClassHeaderData = IDEKotlinBinaryClassCache.INSTANCE.getKotlinBinaryClassHeaderData(file, fileContent);
        if (kotlinBinaryClassHeaderData == null) {
            return false;
        }
        IDEKotlinBinaryClassCache.KotlinBinaryClassHeaderData header = kotlinBinaryClassHeaderData;
        if (header.getClassId().isLocal()) {
            return true;
        }
        return header.getKind() == KotlinClassHeader.Kind.SYNTHETIC_CLASS || header.getKind() == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    public static /* synthetic */ boolean isKotlinInternalCompiledFile$default(VirtualFile virtualFile, byte[] byArray, int n, Object object) {
        if ((n & 2) != 0) {
            byArray = null;
        }
        return ClassFileDecompilerUtilKt.isKotlinInternalCompiledFile(virtualFile, byArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KotlinJvmBinaryClass> findMultifileClassParts(@NotNull VirtualFile file, @NotNull ClassId classId, @NotNull List<String> partNames) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull(partNames, (String)"partNames");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        FqName packageFqName = fqName2;
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        DirectoryBasedClassFinder partsFinder = new DirectoryBasedClassFinder(virtualFile, packageFqName);
        Iterable iterable = $receiver$iv = (Iterable)partNames;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KotlinJvmBinaryClass kotlinJvmBinaryClass2;
            Object element$iv$iv = element$iv$iv$iv;
            String it = (String)element$iv$iv;
            if (KotlinClassFinderKt.findKotlinClass((KotlinClassFinder)partsFinder, new ClassId(packageFqName, Name.identifier(StringsKt.substringAfterLast$default((String)it, (char)'/', null, (int)2, null)))) == null) continue;
            KotlinJvmBinaryClass it$iv$iv = kotlinJvmBinaryClass2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    static {
        String string;
        String $receiver = string = "kotlin-compiled-file";
        FileAttributeService fileAttributeService = (FileAttributeService)ServiceManager.getService(FileAttributeService.class);
        if (fileAttributeService != null) {
            FileAttributeService.DefaultImpls.register$default(fileAttributeService, $receiver, 1, false, 4, null);
        }
        KOTLIN_COMPILED_FILE_ATTRIBUTE = string;
        Key key = Key.create((String)KOTLIN_COMPILED_FILE_ATTRIBUTE);
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<IsKotlinBinar\u2026_COMPILED_FILE_ATTRIBUTE)");
        KEY = key;
    }
}

