/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a;\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u0002H\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\r\u001aB\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\b\b\u0000\u0010\u0007*\u00020\b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00112\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001c\u0010\u001c\u001a\u00020\u0013*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001d\u001a\u00020\u001e\u001a\n\u0010\u001f\u001a\u00020\u0013*\u00020\u0003\u00a8\u0006 "}, d2={"findInsertAfterAnchor", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "body", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "insertMember", "T", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "declaration", "anchor", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "insertMembersAfter", "", "members", "", "moveCaretIntoGeneratedElement", "", "element", "moveCaretIntoGeneratedElementDocumentUnblocked", "", "removeAfterOffset", "offset", "", "whiteSpace", "Lcom/intellij/psi/PsiWhiteSpace;", "moveCaret", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "unblockDocument", "idea-core"})
public final class GenerateUtilKt {
    public static final void moveCaretIntoGeneratedElement(@NotNull Editor editor2, @NotNull PsiElement element3) {
        block0: {
            PsiElement psiElement2;
            PsiElement it;
            Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Project project = element3.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
            Project project2 = project;
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer(element3);
            Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026siElementPointer(element)");
            SmartPsiElementPointer pointer = smartPsiElementPointer;
            PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
            PsiElement psiElement3 = pointer.getElement();
            if (psiElement3 == null) break block0;
            PsiElement psiElement4 = it = (psiElement2 = psiElement3);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"it");
            GenerateUtilKt.moveCaretIntoGeneratedElementDocumentUnblocked(editor2, psiElement4);
        }
    }

    private static final boolean moveCaretIntoGeneratedElementDocumentUnblocked(Editor editor2, PsiElement element3) {
        KtExpression expression2;
        if (element3 instanceof KtDeclarationWithBody && ((KtDeclarationWithBody)element3).hasBody() && (expression2 = ((KtDeclarationWithBody)element3).getBodyExpression()) instanceof KtBlockExpression) {
            PsiElement lBrace = ((KtBlockExpression)expression2).getLBrace();
            PsiElement rBrace = ((KtBlockExpression)expression2).getRBrace();
            if (lBrace != null && rBrace != null) {
                Object element$iv3;
                PsiElement firstInBlock;
                block13: {
                    Object element$iv22;
                    block12: {
                        Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(lBrace, true, false);
                        for (Object element$iv22 : $receiver$iv) {
                            PsiElement it = (PsiElement)element$iv22;
                            if (!(!(it instanceof PsiWhiteSpace))) continue;
                            break block12;
                        }
                        throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                    }
                    firstInBlock = (PsiElement)element$iv22;
                    Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(rBrace, false, false);
                    for (Object element$iv3 : $receiver$iv) {
                        PsiElement it = (PsiElement)element$iv3;
                        if (!(!(it instanceof PsiWhiteSpace))) continue;
                        break block13;
                    }
                    throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                PsiElement lastInBlock = (PsiElement)element$iv3;
                TextRange textRange = firstInBlock.getTextRange();
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                int start2 = textRange.getStartOffset();
                TextRange textRange2 = lastInBlock.getTextRange();
                if (textRange2 == null) {
                    Intrinsics.throwNpe();
                }
                int end = textRange2.getEndOffset();
                GenerateUtilKt.moveCaret$default(editor2, Math.min(start2, end), null, 2, null);
                if (start2 < end) {
                    editor2.getSelectionModel().setSelection(start2, end);
                }
                return true;
            }
        }
        if (element3 instanceof KtDeclarationWithInitializer && ((KtDeclarationWithInitializer)element3).hasInitializer()) {
            TextRange initializerRange;
            KtExpression ktExpression = ((KtDeclarationWithInitializer)element3).getInitializer();
            if (ktExpression == null) {
                throw (Throwable)((Object)new AssertionError());
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"element.initializer ?: throw AssertionError()");
            expression2 = ktExpression;
            TextRange textRange = initializerRange = expression2.getTextRange();
            int offset2 = textRange != null ? textRange.getStartOffset() : element3.getTextOffset();
            GenerateUtilKt.moveCaret$default(editor2, offset2, null, 2, null);
            if (initializerRange != null) {
                PsiElement psiElement2 = (PsiElement)SequencesKt.lastOrNull(PsiUtilsKt.siblings((PsiElement)expression2, true, false));
                int endOffset = psiElement2 != null ? PsiUtilsKt.getEndOffset(psiElement2) : initializerRange.getEndOffset();
                editor2.getSelectionModel().setSelection(initializerRange.getStartOffset(), endOffset);
            }
            return true;
        }
        if (element3 instanceof KtProperty) {
            Iterator<KtPropertyAccessor> iterator2 = ((KtProperty)element3).getAccessors().iterator();
            while (iterator2.hasNext()) {
                KtPropertyAccessor accessor;
                KtPropertyAccessor ktPropertyAccessor = accessor = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor, (String)"accessor");
                if (!GenerateUtilKt.moveCaretIntoGeneratedElementDocumentUnblocked(editor2, ktPropertyAccessor)) continue;
                return true;
            }
        }
        GenerateUtilKt.moveCaret$default(editor2, PsiUtilsKt.getEndOffset(element3), null, 2, null);
        return false;
    }

    public static final void unblockDocument(@NotNull Editor $receiver) {
        block0: {
            Project project;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            Project project2 = $receiver.getProject();
            if (project2 == null) break block0;
            Project it = project = project2;
            PsiDocumentManager.getInstance((Project)it).doPostponedOperationsAndUnblockDocument($receiver.getDocument());
        }
    }

    public static final void moveCaret(@NotNull Editor $receiver, int offset2, @NotNull ScrollType scrollType) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)scrollType, (String)"scrollType");
        $receiver.getCaretModel().moveToOffset(offset2);
        $receiver.getScrollingModel().scrollToCaret(scrollType);
    }

    public static /* synthetic */ void moveCaret$default(Editor editor2, int n, ScrollType scrollType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            scrollType = ScrollType.RELATIVE;
        }
        GenerateUtilKt.moveCaret(editor2, n, scrollType);
    }

    private static final PsiElement findInsertAfterAnchor(Editor editor2, KtClassBody body2) {
        PsiElement psiElement2 = body2.getLBrace();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement afterAnchor = psiElement2;
        Editor editor3 = editor2;
        int offset2 = editor3 != null && (editor3 = editor3.getCaretModel()) != null ? editor3.getOffset() : PsiUtilsKt.getStartOffset((PsiElement)body2);
        PsiElement offsetCursorElement2 = PsiTreeUtil.findFirstParent((PsiElement)body2.getContainingFile().findElementAt(offset2), (Condition)((Condition)new Condition<PsiElement>(body2){
            final /* synthetic */ KtClassBody $body;

            public final boolean value(PsiElement it) {
                PsiElement psiElement2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"it");
                return Intrinsics.areEqual((Object)psiElement2.getParent(), (Object)this.$body);
            }
            {
                this.$body = ktClassBody;
            }
        }));
        if (offsetCursorElement2 instanceof PsiWhiteSpace) {
            return GenerateUtilKt.removeAfterOffset(offset2, (PsiWhiteSpace)offsetCursorElement2);
        }
        if (offsetCursorElement2 != null && Intrinsics.areEqual((Object)offsetCursorElement2, (Object)body2.getRBrace()) ^ true) {
            return offsetCursorElement2;
        }
        return afterAnchor;
    }

    private static final PsiElement removeAfterOffset(int offset2, PsiWhiteSpace whiteSpace) {
        ASTNode spaceNode;
        ASTNode aSTNode = spaceNode = whiteSpace.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"spaceNode");
        if (aSTNode.getTextRange().contains(offset2)) {
            String string = spaceNode.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"spaceNode.text");
            String string2 = string;
            int n = 0;
            int n2 = offset2 - spaceNode.getStartOffset();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String beforeWhiteSpaceText = string4;
            if (!StringUtil.containsLineBreak((CharSequence)beforeWhiteSpaceText)) {
                beforeWhiteSpaceText = beforeWhiteSpaceText + "\n";
            }
            Project project = whiteSpace.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"whiteSpace.project");
            KtPsiFactory factory2 = new KtPsiFactory(project, false, 2, null);
            PsiElement insertAfter = whiteSpace.getPrevSibling();
            whiteSpace.delete();
            PsiElement beforeSpace = factory2.createWhiteSpace(beforeWhiteSpaceText);
            PsiElement psiElement2 = insertAfter;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"insertAfter");
            psiElement2.getParent().addAfter(beforeSpace, insertAfter);
            PsiElement psiElement3 = insertAfter.getNextSibling();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"insertAfter.nextSibling");
            return psiElement3;
        }
        return (PsiElement)whiteSpace;
    }

    @NotNull
    public static final <T extends KtDeclaration> List<T> insertMembersAfter(@Nullable Editor editor2, @NotNull KtClassOrObject classOrObject, @NotNull Collection<? extends T> members2, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(members2, (String)"members");
        Collection<T> $receiver$iv = members2;
        if ($receiver$iv.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return (List)ApplicationUtilsKt.runWriteAction((Function0)new Function0<List<? extends T>>(members2, classOrObject, anchor2, editor2){
            final /* synthetic */ Collection $members;
            final /* synthetic */ KtClassOrObject $classOrObject;
            final /* synthetic */ PsiElement $anchor;
            final /* synthetic */ Editor $editor;

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final List<T> invoke() {
                block24: {
                    insertedMembers = new SmartList();
                    $receiver$iv = this.$members;
                    first$iv = new ArrayList<T>();
                    second$iv = new ArrayList<T>();
                    for (T element$iv : $receiver$iv) {
                        it = (KtDeclaration)element$iv;
                        if (it instanceof KtParameter) {
                            first$iv.add(element$iv);
                            continue;
                        }
                        second$iv.add(element$iv);
                    }
                    var4_8 = new Pair(first$iv, second$iv);
                    var2_9 = (List)var4_8.component1();
                    otherMembers = (List)var4_8.component2();
                    $receiver$iv$iv = $receiver$iv = (Iterable)parameters;
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        element$iv = element$iv$iv;
                        it = (KtDeclaration)element$iv;
                        if (!(this.$classOrObject instanceof KtClass)) {
                            v0 = null;
                        } else {
                            v1 = it;
                            if (v1 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParameter");
                            }
                            v2 = KtClassKt.createPrimaryConstructorParameterListIfAbsent((KtClass)this.$classOrObject).addParameter((KtParameter)v1);
                            if (v2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type T");
                            }
                            v0 = v2;
                        }
                        if (v0 == null) continue;
                        $i$a$1$partition = v0;
                        it$iv = $i$a$1$partition;
                        ((Collection)insertedMembers).add(it$iv);
                    }
                    (Collection)insertedMembers;
                    $receiver$iv = otherMembers;
                    if (!($receiver$iv.isEmpty() == false)) break block24;
                    body = KtClassOrObjectKt.getOrCreateBody(this.$classOrObject);
                    v3 = this.$anchor;
                    if (v3 == null) {
                        v3 = GenerateUtilKt.access$findInsertAfterAnchor(this.$editor, body);
                    }
                    if (v3 == null) {
                        return CollectionsKt.emptyList();
                    }
                    afterAnchor = v3;
                    $receiver$iv = otherMembers;
                    for (E item$iv : $receiver$iv) {
                        block25: {
                            block26: {
                                it = (KtDeclaration)item$iv;
                                var20_16 = (Collection)insertedMembers;
                                if (!(this.$classOrObject instanceof KtClass) || !((KtClass)this.$classOrObject).isEnum()) break block25;
                                $receiver$iv = ((KtClass)this.$classOrObject).getDeclarations();
                                $i$a$1$partition = $receiver$iv;
                                destination$iv$iv = new ArrayList<E>();
                                for (T element$iv$iv : $receiver$iv$iv) {
                                    if (!(element$iv$iv instanceof KtEnumEntry)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                enumEntries = (List)destination$iv$iv;
                                v4 = (KtEnumEntry)CollectionsKt.lastOrNull((List)enumEntries);
                                if (v4 != null) {
                                    v5 = v4;
                                } else {
                                    block23: {
                                        $receiver$iv = PsiUtilsKt.getAllChildren(this.$classOrObject);
                                        var12_12 = $receiver$iv.iterator();
                                        while (var12_12.hasNext()) {
                                            element$iv = var12_12.next();
                                            it = (PsiElement)element$iv;
                                            v6 = it.getNode();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it.node");
                                            if (!Intrinsics.areEqual((Object)v6.getElementType(), (Object)KtTokens.SEMICOLON)) continue;
                                            v7 = element$iv;
                                            break block23;
                                        }
                                        v7 = null;
                                    }
                                    v5 = bound = (PsiElement)v7;
                                }
                                if (it instanceof KtEnumEntry) break block26;
                                if (bound != null && PsiUtilsKt.getStartOffset(afterAnchor) <= PsiUtilsKt.getStartOffset(bound)) {
                                    afterAnchor = bound;
                                }
                                break block25;
                            }
                            if (bound != null) ** GOTO lbl-1000
                            v8 = body.getDeclarations();
                            Intrinsics.checkExpressionValueIsNotNull(v8, (String)"body.declarations");
                            $receiver$iv = v8;
                            if ($receiver$iv.isEmpty() == false) {
                                v9 = body.getLBrace();
                                if (v9 == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterAnchor = v9;
                            } else if (bound != null && PsiUtilsKt.getStartOffset(afterAnchor) > PsiUtilsKt.getStartOffset(bound)) {
                                v10 = bound.getPrevSibling();
                                if (v10 == null) {
                                    Intrinsics.throwNpe();
                                }
                                afterAnchor = v10;
                            }
                        }
                        v11 = body.addAfter(it, afterAnchor);
                        if (v11 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type T");
                        }
                        $receiver = var15_15 = (KtDeclaration)v11;
                        afterAnchor = $receiver;
                        var21_17 = var15_15;
                        var20_16.add(var21_17);
                    }
                    (Collection)insertedMembers;
                }
                ShortenReferences.process$default(ShortenReferences.DEFAULT, (Iterable)insertedMembers, null, 2, null);
                if (this.$editor != null) {
                    v12 = CollectionsKt.first((List)((List)insertedMembers));
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"insertedMembers.first()");
                    GenerateUtilKt.moveCaretIntoGeneratedElement(this.$editor, (PsiElement)v12);
                }
                codeStyleManager = CodeStyleManager.getInstance((Project)this.$classOrObject.getProject());
                $receiver$iv = (Iterable)insertedMembers;
                for (T element$iv : $receiver$iv) {
                    it = (KtDeclaration)element$iv;
                    codeStyleManager.reformat((PsiElement)it);
                }
                return (List)insertedMembers;
            }
            {
                this.$members = collection;
                this.$classOrObject = ktClassOrObject;
                this.$anchor = psiElement2;
                this.$editor = editor2;
                super(0);
            }
        });
    }

    @NotNull
    public static /* synthetic */ List insertMembersAfter$default(Editor editor2, KtClassOrObject ktClassOrObject, Collection collection, PsiElement psiElement2, int n, Object object) {
        if ((n & 8) != 0) {
            psiElement2 = null;
        }
        return GenerateUtilKt.insertMembersAfter(editor2, ktClassOrObject, collection, psiElement2);
    }

    @NotNull
    public static final <T extends KtDeclaration> T insertMember(@Nullable Editor editor2, @NotNull KtClassOrObject classOrObject, @NotNull T declaration2, @Nullable PsiElement anchor2) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        Intrinsics.checkParameterIsNotNull(declaration2, (String)"declaration");
        return (T)((KtDeclaration)CollectionsKt.single(GenerateUtilKt.insertMembersAfter(editor2, classOrObject, CollectionsKt.listOf(declaration2), anchor2)));
    }

    @NotNull
    public static /* synthetic */ KtDeclaration insertMember$default(Editor editor2, KtClassOrObject ktClassOrObject, KtDeclaration ktDeclaration, PsiElement psiElement2, int n, Object object) {
        if ((n & 8) != 0) {
            psiElement2 = null;
        }
        return GenerateUtilKt.insertMember(editor2, ktClassOrObject, ktDeclaration, psiElement2);
    }

    public static final /* synthetic */ PsiElement access$findInsertAfterAnchor(Editor editor2, KtClassBody body2) {
        return GenerateUtilKt.findInsertAfterAnchor(editor2, body2);
    }
}

