/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.MigrationInfo;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a \u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b*\u00060\u000bj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a \u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b*\u00060\u000bj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"KOTLIN_MIGRATION_NOTIFICATION_GROUP", "Lcom/intellij/notification/NotificationGroup;", "KOTLIN_MIGRATION_NOTIFICATION_ID", "", "showMigrationNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "migrationInfo", "Lorg/jetbrains/kotlin/idea/configuration/MigrationInfo;", "appendBr", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "Lkotlin/text/StringBuilder;", "line", "appendIndentBr", "idea"})
public final class MigrationNotificationKt {
    private static final String KOTLIN_MIGRATION_NOTIFICATION_ID = "Kotlin Migration";
    private static final NotificationGroup KOTLIN_MIGRATION_NOTIFICATION_GROUP = new NotificationGroup("Kotlin Migration", NotificationDisplayType.STICKY_BALLOON, true);

    public static final void showMigrationNotification(@NotNull Project project, @NotNull MigrationInfo migrationInfo) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)migrationInfo, (String)"migrationInfo");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        MigrationNotificationKt.appendBr($receiver, "Detected migration:");
        if (Intrinsics.areEqual((Object)migrationInfo.getOldStdlibVersion(), (Object)migrationInfo.getNewStdlibVersion()) ^ true) {
            MigrationNotificationKt.appendIndentBr($receiver, "Standard library: " + migrationInfo.getOldStdlibVersion() + " -> " + migrationInfo.getNewStdlibVersion());
        }
        if (migrationInfo.getOldLanguageVersion() != migrationInfo.getNewLanguageVersion()) {
            MigrationNotificationKt.appendIndentBr($receiver, "Language version: " + migrationInfo.getOldLanguageVersion() + " -> " + migrationInfo.getNewLanguageVersion());
        }
        if (Intrinsics.areEqual((Object)migrationInfo.getOldApiVersion(), (Object)migrationInfo.getNewApiVersion()) ^ true) {
            MigrationNotificationKt.appendIndentBr($receiver, "API version: " + migrationInfo.getOldApiVersion() + " -> " + migrationInfo.getNewApiVersion());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String detectedChangeMessage = string;
        StringBuilder notification2 = stringBuilder = KOTLIN_MIGRATION_NOTIFICATION_GROUP.createNotification(KOTLIN_MIGRATION_NOTIFICATION_ID, "Migrations for Kotlin code are available<br/><br/>" + detectedChangeMessage, NotificationType.WARNING, null);
        notification2.addAction((AnAction)new NotificationAction("Run migrations", project){
            final /* synthetic */ Project $project$inlined;
            {
                this.$project$inlined = project;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.$project$inlined);
                Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"SimpleDataContext.getProjectContext(project)");
                DataContext projectContext = dataContext;
                AnAction action2 = ActionManager.getInstance().getAction("KotlinCodeMigration");
                Notification.fire((Notification)notification2, (AnAction)action2, (DataContext)projectContext);
                notification2.expire();
            }
        });
        stringBuilder.notify(project);
    }

    private static final StringBuilder appendBr(@NotNull StringBuilder $receiver, String line) {
        return $receiver.append(line + "<br/>");
    }

    private static final StringBuilder appendIndentBr(@NotNull StringBuilder $receiver, String line) {
        return MigrationNotificationKt.appendBr($receiver, "&nbsp;&nbsp;" + line);
    }
}

