/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractKotlinUpDownMover;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

public class KotlinDeclarationMover
extends AbstractKotlinUpDownMover {
    private boolean moveEnumConstant = false;
    private static final Class[] DECLARATION_CONTAINER_CLASSES = new Class[]{KtClassBody.class, KtAnonymousInitializer.class, KtFunction.class, KtPropertyAccessor.class, KtFile.class};
    private static final Class[] CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES = new Class[]{KtClassBody.class, KtFile.class};

    private static int findNearestNonWhitespace(@NotNull CharSequence sequence2, int index2) {
        if (sequence2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(0);
        }
        char ch = sequence2.charAt(--index2);
        while (Character.isWhitespace(ch)) {
            ch = sequence2.charAt(--index2);
        }
        return index2;
    }

    public void afterMove(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(1);
        }
        if (file == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(2);
        }
        if (info == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(3);
        }
        super.afterMove(editor2, file, info, down);
        if (this.moveEnumConstant) {
            int end2;
            char c2;
            int end1;
            Document document = editor2.getDocument();
            CharSequence cs = document.getCharsSequence();
            char c1 = cs.charAt(end1 = KotlinDeclarationMover.findNearestNonWhitespace(cs, info.range1.getEndOffset()));
            if (c1 == (c2 = cs.charAt(end2 = KotlinDeclarationMover.findNearestNonWhitespace(cs, info.range2.getEndOffset()))) || c1 != ',' && c2 != ',') {
                return;
            }
            if (c1 == ';' || c2 == ';') {
                document.replaceString(end1, end1 + 1, (CharSequence)String.valueOf(c2));
                document.replaceString(end2, end2 + 1, (CharSequence)String.valueOf(c1));
            } else if (c1 == ',') {
                document.deleteString(end1, end1 + 1);
                document.insertString(end2 + 1, (CharSequence)",");
            } else {
                document.deleteString(end2, end2 + 1);
                document.insertString(end1 + 1, (CharSequence)",");
            }
        }
    }

    @NotNull
    private static List<PsiElement> getDeclarationAnchors(@NotNull KtDeclaration declaration2) {
        PsiElement nameIdentifier;
        if (declaration2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(4);
        }
        final ArrayList<PsiElement> memberSuspects = new ArrayList<PsiElement>();
        KtModifierList modifierList = declaration2.getModifierList();
        if (modifierList != null) {
            memberSuspects.add((PsiElement)modifierList);
        }
        if (declaration2 instanceof KtNamedDeclaration && (nameIdentifier = ((KtNamedDeclaration)declaration2).getNameIdentifier()) != null) {
            memberSuspects.add(nameIdentifier);
        }
        declaration2.accept(new KtVisitorVoid(){

            @Override
            public void visitClassInitializer(@NotNull KtClassInitializer initializer2) {
                PsiElement brace;
                if (initializer2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((brace = initializer2.getOpenBraceNode()) != null) {
                    memberSuspects.add(brace);
                }
            }

            @Override
            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                KtTypeReference returnTypeRef;
                KtTypeReference receiverTypeRef;
                KtTypeParameterList typeParameterList;
                PsiElement equalsToken;
                if (function2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((equalsToken = function2.getEqualsToken()) != null) {
                    memberSuspects.add(equalsToken);
                }
                if ((typeParameterList = function2.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = function2.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = function2.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }

            @Override
            public void visitProperty(@NotNull KtProperty property) {
                KtTypeReference returnTypeRef;
                KtTypeReference receiverTypeRef;
                KtTypeParameterList typeParameterList;
                PsiElement valOrVarKeyword;
                if (property == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((valOrVarKeyword = property.getValOrVarKeyword()) != null) {
                    memberSuspects.add(valOrVarKeyword);
                }
                if ((typeParameterList = property.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = property.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = property.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNamedFunction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<PsiElement> arrayList = memberSuspects;
        if (arrayList == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static KtDeclaration getMovableDeclaration(@Nullable PsiElement element3) {
        if (element3 == null) {
            return null;
        }
        KtDeclaration declaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element3, KtDeclaration.class, (boolean)false);
        if (declaration2 instanceof KtParameter) {
            return null;
        }
        if (declaration2 instanceof KtTypeParameter) {
            return KotlinDeclarationMover.getMovableDeclaration(declaration2.getParent());
        }
        return PsiTreeUtil.instanceOf((Object)PsiTreeUtil.getParentOfType((PsiElement)declaration2, (Class[])DECLARATION_CONTAINER_CLASSES), (Class[])CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES) ? declaration2 : null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element3) {
        if (element3 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(6);
        }
        return element3 instanceof KtDeclaration;
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element3, @NotNull Editor editor2, @NotNull LineRange oldRange) {
        PsiElement last;
        PsiElement first;
        if (element3 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(8);
        }
        if (oldRange == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(9);
        }
        if (element3 instanceof KtDeclaration) {
            first = element3.getFirstChild();
            last = element3.getLastChild();
            if (first == null || last == null) {
                return null;
            }
        } else {
            first = last = element3;
        }
        TextRange textRange1 = first.getTextRange();
        TextRange textRange2 = last.getTextRange();
        Document doc = editor2.getDocument();
        if (doc.getTextLength() < textRange2.getEndOffset()) {
            return null;
        }
        int startLine = editor2.offsetToLogicalPosition((int)textRange1.getStartOffset()).line;
        int endLine = editor2.offsetToLogicalPosition((int)textRange2.getEndOffset()).line + 1;
        if (element3 instanceof PsiComment || startLine == oldRange.startLine || startLine == oldRange.endLine || endLine == oldRange.startLine || endLine == oldRange.endLine) {
            return new LineRange(startLine, endLine);
        }
        TextRange lineTextRange = new TextRange(doc.getLineStartOffset(oldRange.startLine), doc.getLineEndOffset(oldRange.endLine));
        if (element3 instanceof KtDeclaration) {
            for (PsiElement anchor2 : KotlinDeclarationMover.getDeclarationAnchors((KtDeclaration)element3)) {
                TextRange suspectTextRange = anchor2.getTextRange();
                if (suspectTextRange == null || !lineTextRange.intersects(suspectTextRange)) continue;
                return new LineRange(startLine, endLine);
            }
        }
        return null;
    }

    @Nullable
    private static LineRange getTargetRange(@NotNull Editor editor2, @NotNull PsiElement sibling, boolean down, @NotNull PsiElement target) {
        KtClassOrObject ktClassOrObject;
        KtClassBody classBody;
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(10);
        }
        if (sibling == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(11);
        }
        if (target == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(12);
        }
        PsiElement start2 = sibling;
        PsiElement end = sibling;
        KtClassBody nextParent = null;
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE)) {
            PsiElement parent2 = sibling.getParent();
            if (!(parent2 instanceof KtClassBody)) {
                return null;
            }
            if (target instanceof KtEnumEntry) {
                return null;
            }
            KtClassOrObject ktClassOrObject2 = (KtClassOrObject)parent2.getParent();
            assert (ktClassOrObject2 != null);
            nextParent = ktClassOrObject2.getParent();
            if (!down) {
                start2 = ktClassOrObject2;
            }
        } else if (sibling instanceof KtClassOrObject && (classBody = (ktClassOrObject = (KtClassOrObject)sibling).getBody()) != null) {
            nextParent = classBody;
            if (!down) {
                start2 = classBody.getRBrace();
            }
            PsiElement psiElement2 = end = down ? classBody.getLBrace() : classBody.getRBrace();
        }
        if (nextParent != null) {
            if (target instanceof KtAnonymousInitializer && !(nextParent instanceof KtClassBody)) {
                return null;
            }
            if (target instanceof KtEnumEntry) {
                if (!(nextParent instanceof KtClassBody)) {
                    return null;
                }
                KtClassOrObject nextClassOrObject = (KtClassOrObject)nextParent.getParent();
                assert (nextClassOrObject != null);
                if (!nextClassOrObject.hasModifier(KtTokens.ENUM_KEYWORD)) {
                    return null;
                }
            }
        }
        if (target instanceof KtPropertyAccessor && !(sibling instanceof KtPropertyAccessor)) {
            return null;
        }
        return start2 != null && end != null ? new LineRange(start2, end, editor2.getDocument()) : null;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(13);
        }
        if (file == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(14);
        }
        if (info == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(15);
        }
        if (!super.checkAvailable(editor2, file, info, down)) {
            return false;
        }
        LineRange oldRange = info.toMove;
        Pair psiRange = KotlinDeclarationMover.getElementRange((Editor)editor2, (PsiFile)file, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        KtDeclaration firstDecl = KotlinDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getFirst());
        if (firstDecl == null) {
            return false;
        }
        this.moveEnumConstant = firstDecl instanceof KtEnumEntry;
        KtDeclaration lastDecl = KotlinDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getSecond());
        if (lastDecl == null) {
            return false;
        }
        LineRange sourceRange = this.getSourceRange(firstDecl, lastDecl, editor2, oldRange);
        if (sourceRange == null) {
            return false;
        }
        PsiElement sibling = KotlinDeclarationMover.getLastNonWhiteSiblingInLine(KotlinDeclarationMover.firstNonWhiteSibling(sourceRange, down), editor2, down);
        if (sibling == null) {
            info.toMove2 = null;
            return true;
        }
        info.toMove = sourceRange;
        info.toMove2 = KotlinDeclarationMover.getTargetRange(editor2, sibling, down, sourceRange.firstElement);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationAnchors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findNearestNonWhitespace";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "afterMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationAnchors";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkSourceElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementSourceLineRange";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

