/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

public abstract class AbstractKotlinUpDownMover
extends LineMover {
    protected AbstractKotlinUpDownMover() {
    }

    protected abstract boolean checkSourceElement(@NotNull PsiElement var1);

    protected abstract LineRange getElementSourceLineRange(@NotNull PsiElement var1, @NotNull Editor var2, @NotNull LineRange var3);

    @Nullable
    protected LineRange getSourceRange(@NotNull PsiElement firstElement, @NotNull PsiElement lastElement, @NotNull Editor editor2, LineRange oldRange) {
        KtBlockExpression block;
        if (firstElement == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(0);
        }
        if (lastElement == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(1);
        }
        if (editor2 == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(2);
        }
        PsiElement parent2 = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        int topExtension = 0;
        int bottomExtension = 0;
        if (parent2 instanceof KtFunctionLiteral && (block = ((KtFunctionLiteral)parent2).getBodyExpression()) != null) {
            PsiElement comment = null;
            boolean extendDown = false;
            if (AbstractKotlinUpDownMover.checkCommentAtBlockBound(firstElement, lastElement, block)) {
                comment = lastElement;
                extendDown = true;
                lastElement = block.getLastChild();
            } else if (AbstractKotlinUpDownMover.checkCommentAtBlockBound(lastElement, firstElement, block)) {
                comment = firstElement;
                firstElement = block.getFirstChild();
            }
            if (comment != null) {
                int extension = KotlinRefactoringUtilKt.getLineCount(comment);
                if (extendDown) {
                    bottomExtension = extension;
                } else {
                    topExtension = extension;
                }
            }
            parent2 = PsiTreeUtil.findCommonParent((PsiElement)firstElement, (PsiElement)lastElement);
        }
        if (parent2 == null) {
            return null;
        }
        Pair originalRange = AbstractKotlinUpDownMover.getElementRange((PsiElement)parent2, (PsiElement)firstElement, (PsiElement)lastElement);
        if (!this.checkSourceElement((PsiElement)originalRange.first) || !this.checkSourceElement((PsiElement)originalRange.second)) {
            return null;
        }
        LineRange lineRange1 = this.getElementSourceLineRange((PsiElement)originalRange.first, editor2, oldRange);
        if (lineRange1 == null) {
            return null;
        }
        LineRange lineRange2 = this.getElementSourceLineRange((PsiElement)originalRange.second, editor2, oldRange);
        if (lineRange2 == null) {
            return null;
        }
        LineRange parentLineRange = this.getElementSourceLineRange(parent2, editor2, oldRange);
        LineRange sourceRange = new LineRange(lineRange1.startLine - topExtension, lineRange2.endLine + bottomExtension);
        if (parentLineRange != null && sourceRange.startLine == parentLineRange.startLine && sourceRange.endLine == parentLineRange.endLine) {
            sourceRange.firstElement = sourceRange.lastElement = parent2;
        } else {
            sourceRange.firstElement = (PsiElement)originalRange.first;
            sourceRange.lastElement = (PsiElement)originalRange.second;
        }
        return sourceRange;
    }

    protected static int getElementLine(PsiElement element3, Editor editor2, boolean first) {
        if (element3 == null) {
            return -1;
        }
        Document doc = editor2.getDocument();
        TextRange spaceRange = element3.getTextRange();
        return first ? doc.getLineNumber(spaceRange.getStartOffset()) : doc.getLineNumber(spaceRange.getEndOffset());
    }

    protected static PsiElement getLastNonWhiteSiblingInLine(@Nullable PsiElement element3, @NotNull Editor editor2, boolean down) {
        if (editor2 == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(3);
        }
        if (element3 == null) {
            return null;
        }
        int line = AbstractKotlinUpDownMover.getElementLine(element3, editor2, down);
        PsiElement lastElement = element3;
        while (true) {
            if (lastElement == null) {
                return null;
            }
            PsiElement sibling = AbstractKotlinUpDownMover.firstNonWhiteSibling(lastElement, down);
            if (AbstractKotlinUpDownMover.getElementLine(sibling, editor2, down) != line) break;
            lastElement = sibling;
        }
        return lastElement;
    }

    private static boolean checkCommentAtBlockBound(PsiElement blockElement, PsiElement comment, KtBlockExpression block) {
        return PsiTreeUtil.isAncestor((PsiElement)block, (PsiElement)blockElement, (boolean)true) && comment instanceof PsiComment;
    }

    @Nullable
    protected static PsiElement getSiblingOfType(@NotNull PsiElement element3, boolean down, @NotNull Class<? extends PsiElement> type2) {
        if (element3 == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(4);
        }
        if (type2 == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(5);
        }
        return down ? PsiTreeUtil.getNextSiblingOfType((PsiElement)element3, type2) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)element3, type2);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull LineRange lineRange, boolean down) {
        if (lineRange == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(6);
        }
        return AbstractKotlinUpDownMover.firstNonWhiteElement((PsiElement)(down ? lineRange.lastElement.getNextSibling() : lineRange.firstElement.getPrevSibling()), (boolean)down);
    }

    @Nullable
    protected static PsiElement firstNonWhiteSibling(@NotNull PsiElement element3, boolean down) {
        if (element3 == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(7);
        }
        return AbstractKotlinUpDownMover.firstNonWhiteElement((PsiElement)(down ? element3.getNextSibling() : element3.getPrevSibling()), (boolean)down);
    }

    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor2 == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(8);
        }
        if (file == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(9);
        }
        if (info == null) {
            AbstractKotlinUpDownMover.$$$reportNull$$$0(10);
        }
        return file instanceof KtFile && super.checkAvailable(editor2, file, info, down);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastElement";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineRange";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/AbstractKotlinUpDownMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastNonWhiteSiblingInLine";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSiblingOfType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "firstNonWhiteSibling";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

