/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

public class MethodContext
extends CodegenContext<CallableMemberDescriptor> {
    private Label methodStartLabel;
    private Label methodEndLabel;
    private final FunctionDescriptor functionDescriptor;
    private final boolean isDefaultFunctionContext;

    protected MethodContext(@NotNull FunctionDescriptor functionDescriptor2, @NotNull OwnerKind contextKind, @NotNull CodegenContext parentContext, @Nullable MutableClosure closure, boolean isDefaultFunctionContext) {
        super(JvmCodegenUtil.getDirectMember(functionDescriptor2), contextKind, parentContext, closure, parentContext.hasThisDescriptor() ? parentContext.getThisDescriptor() : null, null);
        this.functionDescriptor = functionDescriptor2;
        this.isDefaultFunctionContext = isDefaultFunctionContext;
    }

    @Override
    @NotNull
    public CodegenContext getParentContext() {
        return super.getParentContext();
    }

    public StackValue getReceiverExpression(KotlinTypeMapper typeMapper2) {
        assert (this.getCallableDescriptorWithReceiver() != null);
        KotlinType kotlinType2 = this.getCallableDescriptorWithReceiver().getExtensionReceiverParameter().getType();
        Type asmType = typeMapper2.mapType(kotlinType2);
        return StackValue.local(AsmUtil.getReceiverIndex(this, (CallableMemberDescriptor)this.getContextDescriptor()), asmType, kotlinType2);
    }

    @Override
    public StackValue lookupInContext(DeclarationDescriptor d, @Nullable StackValue result2, GenerationState state, boolean ignoreNoOuter) {
        if (d instanceof SyntheticFieldDescriptor) {
            SyntheticFieldDescriptor fieldDescriptor = (SyntheticFieldDescriptor)d;
            d = fieldDescriptor.getPropertyDescriptor();
        }
        if (this.getContextDescriptor() == d) {
            return result2 != null ? result2 : StackValue.LOCAL_0;
        }
        return this.getParentContext().lookupInContext(d, result2, state, ignoreNoOuter);
    }

    @Nullable
    public StackValue generateReceiver(@NotNull CallableDescriptor descriptor2, @NotNull GenerationState state, boolean ignoreNoOuter) {
        if (CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction(this.getCallableDescriptorWithReceiver()) == descriptor2) {
            return this.getReceiverExpression(state.getTypeMapper());
        }
        ReceiverParameterDescriptor parameter = descriptor2.getExtensionReceiverParameter();
        return this.lookupInContext(parameter, StackValue.LOCAL_0, state, ignoreNoOuter);
    }

    @Override
    public StackValue getOuterExpression(StackValue prefix, boolean ignoreNoOuter) {
        return this.getParentContext().getOuterExpression(prefix, false);
    }

    @Nullable
    public Label getMethodStartLabel() {
        return this.methodStartLabel;
    }

    public void setMethodStartLabel(@NotNull Label methodStartLabel) {
        this.methodStartLabel = methodStartLabel;
    }

    @Nullable
    public Label getMethodEndLabel() {
        return this.methodEndLabel;
    }

    public void setMethodEndLabel(@NotNull Label methodEndLabel) {
        this.methodEndLabel = methodEndLabel;
    }

    public String toString() {
        return "Method: " + this.getContextDescriptor();
    }

    @Override
    public boolean isInlineMethodContext() {
        return InlineUtil.isInline(this.getFunctionDescriptor());
    }

    @NotNull
    public FunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public boolean isDefaultFunctionContext() {
        return this.isDefaultFunctionContext;
    }
}

