/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.context;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.annotations.jvm.ReadOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForFunctionDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyBackingField;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.SyntheticAccessorUtilKt;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.AnonymousClassContext;
import org.jetbrains.kotlin.codegen.context.ClassContext;
import org.jetbrains.kotlin.codegen.context.ClosureContext;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.DefaultImplsClassContext;
import org.jetbrains.kotlin.codegen.context.EnclosedValueDescriptor;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.InlineLambdaContext;
import org.jetbrains.kotlin.codegen.context.LocalLookup;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassFacadeContext;
import org.jetbrains.kotlin.codegen.context.MultifileClassPartContext;
import org.jetbrains.kotlin.codegen.context.PackageContext;
import org.jetbrains.kotlin.codegen.context.ScriptContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.load.java.JavaVisibilities;
import org.jetbrains.kotlin.load.java.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

public abstract class CodegenContext<T extends DeclarationDescriptor> {
    private final T contextDescriptor;
    private final OwnerKind contextKind;
    private final CodegenContext parentContext;
    private final ClassDescriptor thisDescriptor;
    @Nullable
    public final MutableClosure closure;
    private final LocalLookup enclosingLocalLookup;
    private final NullableLazyValue<StackValue.Field> outerExpression;
    private Map<DeclarationDescriptor, CodegenContext> childContexts;
    private Map<AccessorKey, AccessorForCallableDescriptor<?>> accessors;
    private Map<AccessorKey, AccessorForPropertyDescriptorFactory> propertyAccessorFactories;
    private AccessorForCompanionObjectInstanceFieldDescriptor accessorForCompanionObjectInstanceFieldDescriptor = null;

    public CodegenContext(@NotNull T contextDescriptor, @NotNull OwnerKind contextKind, @Nullable CodegenContext parentContext, @Nullable MutableClosure closure, @Nullable ClassDescriptor thisDescriptor, @Nullable LocalLookup localLookup) {
        this.contextDescriptor = contextDescriptor;
        this.contextKind = contextKind;
        this.parentContext = parentContext;
        this.closure = closure;
        this.thisDescriptor = thisDescriptor;
        this.enclosingLocalLookup = localLookup;
        this.outerExpression = LockBasedStorageManager.NO_LOCKS.createNullableLazyValue(this::computeOuterExpression);
        if (parentContext != null) {
            parentContext.addChild(this);
        }
    }

    @NotNull
    public GenerationState getState() {
        return this.parentContext.getState();
    }

    @NotNull
    public final ClassDescriptor getThisDescriptor() {
        if (this.thisDescriptor == null) {
            throw new UnsupportedOperationException("Context doesn't have a \"this\": " + this);
        }
        return this.thisDescriptor;
    }

    public final boolean hasThisDescriptor() {
        return this.thisDescriptor != null;
    }

    @NotNull
    public CodegenContext<? extends ClassOrPackageFragmentDescriptor> getClassOrPackageParentContext() {
        CodegenContext context = this;
        while (true) {
            if (context.getContextDescriptor() instanceof ClassOrPackageFragmentDescriptor) {
                return context;
            }
            context = context.getParentContext();
            assert (context != null) : "Context which is not top-level has no parent: " + this;
        }
    }

    @Nullable
    public final CallableDescriptor getCallableDescriptorWithReceiver() {
        if (this.contextDescriptor instanceof CallableDescriptor) {
            CallableDescriptor callableDescriptor = (CallableDescriptor)this.getContextDescriptor();
            return callableDescriptor.getExtensionReceiverParameter() != null ? callableDescriptor : null;
        }
        return null;
    }

    public StackValue getOuterExpression(@Nullable StackValue prefix, boolean ignoreNoOuter) {
        return this.getOuterExpression(prefix, ignoreNoOuter, true);
    }

    private StackValue getOuterExpression(@Nullable StackValue prefix, boolean ignoreNoOuter, boolean captureThis) {
        if (this.outerExpression.invoke() == null) {
            if (!ignoreNoOuter) {
                throw new UnsupportedOperationException("Don't know how to generate outer expression: " + this);
            }
            return null;
        }
        if (captureThis) {
            if (this.closure == null) {
                throw new IllegalStateException("Can't capture this for context without closure: " + this);
            }
            this.closure.setNeedsCaptureOuterClass();
        }
        return StackValue.changeReceiverForFieldAndSharedVar((StackValue.StackValueWithSimpleReceiver)this.outerExpression.invoke(), prefix);
    }

    @NotNull
    public T getContextDescriptor() {
        return this.contextDescriptor;
    }

    @NotNull
    public OwnerKind getContextKind() {
        return this.contextKind;
    }

    @NotNull
    public PackageContext intoPackagePart(@NotNull PackageFragmentDescriptor descriptor2, Type packagePartType, @Nullable KtFile sourceFile) {
        return new PackageContext(descriptor2, this, packagePartType, sourceFile);
    }

    @NotNull
    public MultifileClassPartContext intoMultifileClassPart(@NotNull PackageFragmentDescriptor descriptor2, @NotNull Type multifileClassType, @NotNull Type filePartType, @NotNull KtFile sourceFile) {
        return new MultifileClassPartContext(descriptor2, this, multifileClassType, filePartType, sourceFile);
    }

    @NotNull
    public FieldOwnerContext<PackageFragmentDescriptor> intoMultifileClass(@NotNull PackageFragmentDescriptor descriptor2, @NotNull Type multifileClassType, @NotNull Type filePartType) {
        return new MultifileClassFacadeContext(descriptor2, this, multifileClassType, filePartType);
    }

    public ClassContext intoDefaultImplsClass(ClassDescriptor descriptor2, ClassContext interfaceContext, GenerationState state) {
        return new DefaultImplsClassContext(state.getTypeMapper(), descriptor2, OwnerKind.DEFAULT_IMPLS, this, null, interfaceContext);
    }

    @NotNull
    public ClassContext intoClass(@NotNull ClassDescriptor descriptor2, @NotNull OwnerKind kind, @NotNull GenerationState state) {
        CodegenContext savedContext;
        if (CodegenContext.shouldAddChild(descriptor2) && (savedContext = this.findChildContext(descriptor2)) != null) {
            assert (savedContext.getContextKind() == kind) : "Kinds should be same, but: " + (Object)((Object)savedContext.getContextKind()) + "!= " + (Object)((Object)kind);
            return (ClassContext)savedContext;
        }
        ClassContext classContext = new ClassContext(state.getTypeMapper(), descriptor2, kind, this, null);
        if (descriptor2.getCompanionObjectDescriptor() != null) {
            classContext.intoClass(descriptor2.getCompanionObjectDescriptor(), OwnerKind.IMPLEMENTATION, state);
        }
        return classContext;
    }

    @NotNull
    public ClassContext intoAnonymousClass(@NotNull ClassDescriptor descriptor2, @NotNull ExpressionCodegen codegen, @NotNull OwnerKind ownerKind) {
        return new AnonymousClassContext(codegen.getState().getTypeMapper(), descriptor2, ownerKind, this, codegen);
    }

    @NotNull
    public MethodContext intoFunction(FunctionDescriptor descriptor2, boolean isDefaultFunctionContext) {
        return new MethodContext(descriptor2, this.getContextKind(), this, null, isDefaultFunctionContext);
    }

    @NotNull
    public MethodContext intoFunction(FunctionDescriptor descriptor2) {
        return this.intoFunction(descriptor2, false);
    }

    @NotNull
    public MethodContext intoInlinedLambda(FunctionDescriptor descriptor2, boolean isCrossInline, boolean isPropertyReference) {
        return new InlineLambdaContext(descriptor2, this.getContextKind(), this, null, isCrossInline, isPropertyReference);
    }

    @NotNull
    public ConstructorContext intoConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull KotlinTypeMapper typeMapper2) {
        return new ConstructorContext(descriptor2, this.getContextKind(), this, this.closure, typeMapper2);
    }

    @NotNull
    public ScriptContext intoScript(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> earlierScripts, @NotNull ClassDescriptor classDescriptor2, @NotNull KotlinTypeMapper typeMapper2) {
        return new ScriptContext(typeMapper2, script, earlierScripts, classDescriptor2, this);
    }

    @NotNull
    public ClosureContext intoClosure(@NotNull FunctionDescriptor funDescriptor, @NotNull LocalLookup localLookup, @NotNull KotlinTypeMapper typeMapper2) {
        return new ClosureContext(typeMapper2, funDescriptor, this, localLookup);
    }

    @NotNull
    public ClosureContext intoCoroutineClosure(@NotNull FunctionDescriptor jvmViewOfSuspendLambda, @NotNull FunctionDescriptor originalSuspendLambdaDescriptor, @NotNull LocalLookup localLookup, @NotNull KotlinTypeMapper typeMapper2) {
        return new ClosureContext(typeMapper2, jvmViewOfSuspendLambda, this, localLookup, originalSuspendLambdaDescriptor);
    }

    public ClassContext intoWrapperForErasedInlineClass(ClassDescriptor descriptor2, GenerationState state) {
        return new ClassContext(state.getTypeMapper(), descriptor2, OwnerKind.ERASED_INLINE_CLASS, this, null);
    }

    @Nullable
    public CodegenContext getParentContext() {
        return this.parentContext;
    }

    public boolean isContextWithUninitializedThis() {
        return false;
    }

    @Nullable
    public CodegenContext getEnclosingClassContext() {
        for (CodegenContext cur = this.getEnclosingThisContext(); cur != null; cur = cur.getParentContext()) {
            T curDescriptor = cur.getContextDescriptor();
            if (!(curDescriptor instanceof ClassDescriptor)) continue;
            return cur;
        }
        return null;
    }

    @Nullable
    public CodegenContext getEnclosingThisContext() {
        CodegenContext cur = this.getParentContext();
        while (cur != null && cur.isContextWithUninitializedThis()) {
            CodegenContext parent2 = cur.getParentContext();
            assert (parent2 != null) : "Context " + cur + " should have a parent";
            cur = parent2.getParentContext();
        }
        return cur;
    }

    @Nullable
    public ClassDescriptor getEnclosingClass() {
        CodegenContext enclosingClassContext = this.getEnclosingClassContext();
        if (enclosingClassContext == null) {
            return null;
        }
        return (ClassDescriptor)enclosingClassContext.getContextDescriptor();
    }

    @Nullable
    public CodegenContext findParentContextWithDescriptor(DeclarationDescriptor descriptor2) {
        CodegenContext c;
        for (c = this; c != null && (c.shouldSkipThisContextInHierarchy() || c.getContextDescriptor() != descriptor2); c = c.getParentContext()) {
        }
        return c;
    }

    private boolean shouldSkipThisContextInHierarchy() {
        return this.getContextKind() == OwnerKind.ERASED_INLINE_CLASS;
    }

    @NotNull
    private PropertyDescriptor getPropertyAccessor(@NotNull PropertyDescriptor propertyDescriptor2, @Nullable ClassDescriptor superCallTarget, boolean getterAccessorRequired, boolean setterAccessorRequired) {
        return this.getAccessor(propertyDescriptor2, AccessorKind.NORMAL, null, superCallTarget, getterAccessorRequired, setterAccessorRequired);
    }

    public <D extends CallableMemberDescriptor> D getAccessorForJvmDefaultCompatibility(@NotNull D descriptor2) {
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor propertyAccessor = this.getAccessor(((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty(), AccessorKind.JVM_DEFAULT_COMPATIBILITY, null, null, descriptor2 instanceof PropertyGetterDescriptor, descriptor2 instanceof PropertySetterDescriptor);
            return (D)(descriptor2 instanceof PropertyGetterDescriptor ? propertyAccessor.getGetter() : propertyAccessor.getSetter());
        }
        return this.getAccessor(descriptor2, AccessorKind.JVM_DEFAULT_COMPATIBILITY, null, null);
    }

    @NotNull
    private <D extends CallableMemberDescriptor> D getAccessor(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget) {
        return this.getAccessor(descriptor2, AccessorKind.NORMAL, null, superCallTarget);
    }

    @NotNull
    public <D extends CallableMemberDescriptor> D getAccessorForSuperCallIfNeeded(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget, @NotNull GenerationState state) {
        if (superCallTarget != null && !JvmCodegenUtil.isNonDefaultInterfaceMember(descriptor2)) {
            CodegenContext afterInline = this.getFirstCrossInlineOrNonInlineContext();
            CodegenContext c = afterInline.findParentContextWithDescriptor(superCallTarget);
            assert (c != null) : "Couldn't find a context for a super-call: " + descriptor2;
            if (c != afterInline.getParentContext()) {
                return c.getAccessor(descriptor2, superCallTarget);
            }
        }
        return descriptor2;
    }

    @NotNull
    public <D extends CallableMemberDescriptor> D getAccessor(@NotNull D possiblySubstitutedDescriptor, @NotNull AccessorKind accessorKind, @Nullable KotlinType delegateType, @Nullable ClassDescriptor superCallTarget) {
        return this.getAccessor(possiblySubstitutedDescriptor, accessorKind, delegateType, superCallTarget, true, true);
    }

    @NotNull
    private <D extends CallableMemberDescriptor> D getAccessor(@NotNull D possiblySubstitutedDescriptor, @NotNull AccessorKind accessorKind, @Nullable KotlinType delegateType, @Nullable ClassDescriptor superCallTarget, boolean getterAccessorRequired, boolean setterAccessorRequired) {
        DeclarationDescriptorNonRootImpl accessor;
        CallableMemberDescriptor descriptor2;
        AccessorKey key;
        if (this.accessors == null) {
            this.accessors = new LinkedHashMap();
        }
        if (this.propertyAccessorFactories == null) {
            this.propertyAccessorFactories = new LinkedHashMap<AccessorKey, AccessorForPropertyDescriptorFactory>();
        }
        if (this.propertyAccessorFactories.containsKey(key = new AccessorKey(descriptor2 = possiblySubstitutedDescriptor.getOriginal(), superCallTarget, accessorKind))) {
            return (D)this.propertyAccessorFactories.get(key).getOrCreateAccessorIfNeeded(getterAccessorRequired, setterAccessorRequired);
        }
        if (this.accessors.containsKey(key)) {
            AccessorForCallableDescriptor<?> accessor2 = this.accessors.get(key);
            assert (accessorKind == AccessorKind.NORMAL || accessor2 instanceof AccessorForPropertyBackingField) : "There is already exists accessor with isForBackingField = false in this context";
            return (D)((CallableMemberDescriptor)((Object)accessor2));
        }
        String nameSuffix = SyntheticAccessorUtilKt.getAccessorNameSuffix(descriptor2, key.superCallLabelTarget, accessorKind);
        if (descriptor2 instanceof SimpleFunctionDescriptor) {
            accessor = new AccessorForFunctionDescriptor((FunctionDescriptor)descriptor2, (DeclarationDescriptor)this.contextDescriptor, superCallTarget, nameSuffix, accessorKind);
        } else if (descriptor2 instanceof ClassConstructorDescriptor) {
            accessor = new AccessorForConstructorDescriptor((ClassConstructorDescriptor)descriptor2, (DeclarationDescriptor)this.contextDescriptor, superCallTarget, accessorKind);
        } else if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)descriptor2;
            if (accessorKind == AccessorKind.NORMAL || accessorKind == AccessorKind.JVM_DEFAULT_COMPATIBILITY) {
                AccessorForPropertyDescriptorFactory factory2 = new AccessorForPropertyDescriptorFactory(propertyDescriptor2, (DeclarationDescriptor)this.contextDescriptor, superCallTarget, nameSuffix, accessorKind);
                this.propertyAccessorFactories.put(key, factory2);
                this.accessors.put(key, factory2.getOrCreateAccessorWithSyntheticGetterAndSetter());
                return (D)factory2.getOrCreateAccessorIfNeeded(getterAccessorRequired, setterAccessorRequired);
            }
            accessor = new AccessorForPropertyBackingField(propertyDescriptor2, (DeclarationDescriptor)this.contextDescriptor, delegateType, accessorKind == AccessorKind.IN_CLASS_COMPANION ? null : propertyDescriptor2.getExtensionReceiverParameter(), accessorKind == AccessorKind.IN_CLASS_COMPANION ? null : propertyDescriptor2.getDispatchReceiverParameter(), nameSuffix, accessorKind);
        } else {
            throw new UnsupportedOperationException("Do not know how to create accessor for descriptor " + descriptor2 + " in context " + this);
        }
        this.accessors.put(key, (AccessorForCallableDescriptor<?>)((Object)accessor));
        return (D)accessor;
    }

    @Nullable
    protected StackValue.Field computeOuterExpression() {
        return null;
    }

    public StackValue lookupInContext(DeclarationDescriptor d, @Nullable StackValue result2, GenerationState state, boolean ignoreNoOuter) {
        StackValue resultValue2;
        StackValue myOuter = null;
        if (this.closure != null) {
            EnclosedValueDescriptor capturedVariable = this.closure.getCaptureVariables().get(d);
            if (capturedVariable != null) {
                return StackValue.changeReceiverForFieldAndSharedVar(capturedVariable.getInnerValue(), result2);
            }
            for (LocalLookup.LocalLookupCase aCase : LocalLookup.LocalLookupCase.values()) {
                if (!aCase.isCase(d)) continue;
                Type classType = state.getTypeMapper().mapType(this.getThisDescriptor());
                StackValue.StackValueWithSimpleReceiver innerValue = aCase.innerValue(d, this.enclosingLocalLookup, state, this.closure, classType);
                if (innerValue == null) break;
                return StackValue.changeReceiverForFieldAndSharedVar(innerValue, result2);
            }
            result2 = myOuter = this.getOuterExpression(result2, ignoreNoOuter, false);
        }
        if (myOuter != null && this.getEnclosingClass() == d) {
            resultValue2 = result2;
        } else {
            CodegenContext enclosingClassContext = this.getEnclosingThisContext();
            StackValue stackValue = resultValue2 = enclosingClassContext != null ? enclosingClassContext.lookupInContext(d, result2, state, ignoreNoOuter) : null;
        }
        if (myOuter != null && resultValue2 != null && !CodegenContext.isStaticField(resultValue2)) {
            this.closure.setNeedsCaptureOuterClass();
        }
        return resultValue2;
    }

    @NotNull
    @ReadOnly
    public Collection<? extends AccessorForCallableDescriptor<?>> getAccessors() {
        return this.accessors == null ? Collections.emptySet() : this.accessors.values();
    }

    @NotNull
    public <D extends CallableMemberDescriptor> D accessibleDescriptor(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget) {
        boolean sameJvmDefault;
        CodegenContext properContext = this.getFirstCrossInlineOrNonInlineContext();
        DeclarationDescriptor enclosing = descriptor2.getContainingDeclaration();
        boolean isInliningContext = properContext.isInlineMethodContext();
        boolean bl = sameJvmDefault = JvmAnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2) == JvmAnnotationUtilKt.isCallableMemberWithJvmDefaultAnnotation(properContext.contextDescriptor) || properContext.contextDescriptor instanceof AccessorForCallableDescriptor;
        if (!isInliningContext && (!properContext.hasThisDescriptor() || enclosing == properContext.getThisDescriptor() && sameJvmDefault || enclosing == properContext.getClassOrPackageParentContext().getContextDescriptor() && sameJvmDefault)) {
            return descriptor2;
        }
        return properContext.accessibleDescriptorIfNeeded(descriptor2, superCallTarget, isInliningContext);
    }

    @NotNull
    private <D extends CallableMemberDescriptor> D accessibleDescriptorIfNeeded(@NotNull D descriptor2, @Nullable ClassDescriptor superCallTarget, boolean withinInliningContext) {
        CodegenContext parentContextForClass;
        ClassDescriptor classDescriptor2;
        CodegenContext classContext;
        D unwrappedDescriptor = DescriptorUtils.unwrapFakeOverride(descriptor2);
        DeclarationDescriptor enclosed = descriptor2.getContainingDeclaration();
        CodegenContext descriptorContext = this.findParentContextWithDescriptor(enclosed);
        if (descriptorContext == null && DescriptorUtils.isCompanionObject(enclosed) && (classContext = this.findParentContextWithDescriptor(enclosed.getContainingDeclaration())) instanceof ClassContext) {
            descriptorContext = ((ClassContext)classContext).getCompanionObjectContext();
        }
        if (descriptorContext == null && JavaVisibilities.PROTECTED_STATIC_VISIBILITY == descriptor2.getVisibility() && !(descriptor2.getOriginal() instanceof SamConstructorDescriptor)) {
            descriptorContext = ExpressionCodegen.getParentContextSubclassOf((ClassDescriptor)enclosed, this);
            superCallTarget = (ClassDescriptor)enclosed;
        }
        if (descriptorContext == null && withinInliningContext && superCallTarget != null) {
            descriptorContext = ExpressionCodegen.getParentContextSubclassOf((ClassDescriptor)enclosed, this);
        }
        if (descriptorContext == null && descriptor2 instanceof ClassConstructorDescriptor && DescriptorUtils.isSealedClass(classDescriptor2 = ((ClassConstructorDescriptor)descriptor2).getContainingDeclaration()) && (parentContextForClass = this.findParentContextWithDescriptor(classDescriptor2.getContainingDeclaration())) != null) {
            descriptorContext = parentContextForClass.findChildContext(classDescriptor2);
        }
        if (descriptorContext == null) {
            return descriptor2;
        }
        if (JvmAnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2) && descriptorContext instanceof DefaultImplsClassContext) {
            descriptorContext = ((DefaultImplsClassContext)descriptorContext).getInterfaceContext();
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor2 = (PropertyDescriptor)descriptor2;
            int propertyAccessFlag = AsmUtil.getVisibilityAccessFlag(descriptor2);
            PropertyGetterDescriptor getter2 = propertyDescriptor2.getGetter();
            int getterAccessFlag = getter2 == null ? propertyAccessFlag : propertyAccessFlag | AsmUtil.getVisibilityAccessFlag(getter2);
            boolean getterAccessorRequired = CodegenContext.isAccessorRequired(getterAccessFlag, unwrappedDescriptor, descriptorContext, withinInliningContext, superCallTarget != null);
            PropertySetterDescriptor setter2 = propertyDescriptor2.getSetter();
            int setterAccessFlag = propertyAccessFlag;
            if (setter2 != null && setter2.getVisibility().normalize() != Visibilities.INVISIBLE_FAKE) {
                setterAccessFlag = propertyAccessFlag | AsmUtil.getVisibilityAccessFlag(setter2);
            }
            boolean setterAccessorRequired = CodegenContext.isAccessorRequired(setterAccessFlag, unwrappedDescriptor, descriptorContext, withinInliningContext, superCallTarget != null);
            if (!getterAccessorRequired && !setterAccessorRequired) {
                return descriptor2;
            }
            return (D)descriptorContext.getPropertyAccessor(propertyDescriptor2, superCallTarget, getterAccessorRequired, setterAccessorRequired);
        }
        int flag = AsmUtil.getVisibilityAccessFlag(unwrappedDescriptor);
        if (!CodegenContext.isAccessorRequired(flag, unwrappedDescriptor, descriptorContext, withinInliningContext, superCallTarget != null)) {
            return descriptor2;
        }
        return descriptorContext.getAccessor(descriptor2, superCallTarget);
    }

    private static boolean isAccessorRequired(int accessFlag, @NotNull CallableMemberDescriptor unwrappedDescriptor, @NotNull CodegenContext descriptorContext, boolean withinInline, boolean isSuperCall) {
        if (InlineOnlyKt.isEffectivelyInlineOnly(unwrappedDescriptor)) {
            return false;
        }
        return isSuperCall && withinInline || (accessFlag & 2) != 0 || (accessFlag & 4) != 0 && (withinInline || !CodegenContext.isInSamePackage(unwrappedDescriptor, descriptorContext.getContextDescriptor()));
    }

    private static boolean isInSamePackage(DeclarationDescriptor descriptor1, DeclarationDescriptor descriptor2) {
        PackageFragmentDescriptor package1 = DescriptorUtils.getParentOfType(descriptor1, PackageFragmentDescriptor.class, false);
        PackageFragmentDescriptor package2 = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
        return package2 != null && package1 != null && package1.getFqName().equals(package2.getFqName());
    }

    private void addChild(@NotNull CodegenContext child) {
        if (CodegenContext.shouldAddChild(child.contextDescriptor)) {
            if (this.childContexts == null) {
                this.childContexts = new HashMap<DeclarationDescriptor, CodegenContext>();
            }
            T childContextDescriptor = child.getContextDescriptor();
            this.childContexts.put((DeclarationDescriptor)childContextDescriptor, child);
        }
    }

    private static boolean shouldAddChild(@NotNull DeclarationDescriptor childContextDescriptor) {
        return DescriptorUtils.isCompanionObject(childContextDescriptor) || DescriptorUtils.isSealedClass(childContextDescriptor);
    }

    @Nullable
    protected CodegenContext findChildContext(@NotNull DeclarationDescriptor child) {
        return this.childContexts == null ? null : this.childContexts.get(child);
    }

    private static boolean isStaticField(@NotNull StackValue value) {
        return value instanceof StackValue.Field && ((StackValue.Field)value).isStaticPut;
    }

    public boolean isInlineMethodContext() {
        return false;
    }

    @NotNull
    public CodegenContext getFirstCrossInlineOrNonInlineContext() {
        return this;
    }

    @Nullable
    public LocalLookup getEnclosingLocalLookup() {
        return this.enclosingLocalLookup;
    }

    @NotNull
    public AccessorForCompanionObjectInstanceFieldDescriptor markCompanionObjectDescriptorWithAccessorRequired(@NotNull ClassDescriptor companionObjectDescriptor2) {
        assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Companion object expected: " + companionObjectDescriptor2;
        assert (this.accessorForCompanionObjectInstanceFieldDescriptor == null || this.accessorForCompanionObjectInstanceFieldDescriptor.getCompanionObjectDescriptor() == companionObjectDescriptor2) : "Unexpected companion object descriptor with accessor required: " + companionObjectDescriptor2 + "; should be " + this.accessorForCompanionObjectInstanceFieldDescriptor.getCompanionObjectDescriptor();
        if (this.accessorForCompanionObjectInstanceFieldDescriptor == null) {
            this.accessorForCompanionObjectInstanceFieldDescriptor = new AccessorForCompanionObjectInstanceFieldDescriptor(companionObjectDescriptor2, Name.identifier(JvmCodegenUtil.getCompanionObjectAccessorName(companionObjectDescriptor2)));
        }
        return this.accessorForCompanionObjectInstanceFieldDescriptor;
    }

    @Nullable
    public AccessorForCompanionObjectInstanceFieldDescriptor getAccessorForCompanionObjectDescriptorIfRequired() {
        return this.accessorForCompanionObjectInstanceFieldDescriptor;
    }

    private static class AccessorForPropertyDescriptorFactory {
        @NotNull
        private final PropertyDescriptor property;
        @NotNull
        private final DeclarationDescriptor containingDeclaration;
        @Nullable
        private final ClassDescriptor superCallTarget;
        @NotNull
        private final String nameSuffix;
        @NotNull
        private final AccessorKind accessorKind;
        private AccessorForPropertyDescriptor withSyntheticGetterAndSetter = null;
        private AccessorForPropertyDescriptor withSyntheticGetter = null;
        private AccessorForPropertyDescriptor withSyntheticSetter = null;

        public AccessorForPropertyDescriptorFactory(@NotNull PropertyDescriptor property, @NotNull DeclarationDescriptor containingDeclaration2, @Nullable ClassDescriptor superCallTarget, @NotNull String nameSuffix, @NotNull AccessorKind accessorKind) {
            this.property = property;
            this.containingDeclaration = containingDeclaration2;
            this.superCallTarget = superCallTarget;
            this.nameSuffix = nameSuffix;
            this.accessorKind = accessorKind;
        }

        public PropertyDescriptor getOrCreateAccessorIfNeeded(boolean getterAccessorRequired, boolean setterAccessorRequired) {
            if (getterAccessorRequired && setterAccessorRequired) {
                return this.getOrCreateAccessorWithSyntheticGetterAndSetter();
            }
            if (getterAccessorRequired && !setterAccessorRequired) {
                if (this.withSyntheticGetter == null) {
                    this.withSyntheticGetter = new AccessorForPropertyDescriptor(this.property, this.containingDeclaration, this.superCallTarget, this.nameSuffix, true, false, this.accessorKind);
                }
                return this.withSyntheticGetter;
            }
            if (!getterAccessorRequired && setterAccessorRequired) {
                if (this.withSyntheticSetter == null) {
                    this.withSyntheticSetter = new AccessorForPropertyDescriptor(this.property, this.containingDeclaration, this.superCallTarget, this.nameSuffix, false, true, this.accessorKind);
                }
                return this.withSyntheticSetter;
            }
            return this.property;
        }

        @NotNull
        public AccessorForPropertyDescriptor getOrCreateAccessorWithSyntheticGetterAndSetter() {
            if (this.withSyntheticGetterAndSetter == null) {
                this.withSyntheticGetterAndSetter = new AccessorForPropertyDescriptor(this.property, this.containingDeclaration, this.superCallTarget, this.nameSuffix, true, true, this.accessorKind);
            }
            return this.withSyntheticGetterAndSetter;
        }
    }

    private static class AccessorKey {
        public final DeclarationDescriptor descriptor;
        public final ClassDescriptor superCallLabelTarget;
        public final AccessorKind accessorKind;

        public AccessorKey(@NotNull DeclarationDescriptor descriptor2, @Nullable ClassDescriptor superCallLabelTarget, @NotNull AccessorKind accessorKind) {
            this.descriptor = descriptor2;
            this.superCallLabelTarget = superCallLabelTarget;
            this.accessorKind = accessorKind;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AccessorKey)) {
                return false;
            }
            AccessorKey other = (AccessorKey)obj;
            return this.descriptor.equals(other.descriptor) && this.accessorKind == other.accessorKind && (this.superCallLabelTarget == null ? other.superCallLabelTarget == null : this.superCallLabelTarget.equals(other.superCallLabelTarget));
        }

        public int hashCode() {
            return 31 * this.descriptor.hashCode() + this.accessorKind.hashCode() + (this.superCallLabelTarget == null ? 0 : this.superCallLabelTarget.hashCode());
        }

        public String toString() {
            return this.descriptor.toString();
        }
    }
}

