/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.ConstAndJvmFieldPropertiesLoweringKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetterCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetterCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstAndJvmFieldPropertiesLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "buildSubstitution", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "needBlock", "", "setOrGetExpr", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "receiver", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "substituteGetter", "irProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "substituteSetter", "visitCall", "visitProperty", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "backend"})
public final class ConstAndJvmFieldPropertiesLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, this);
    }

    @Override
    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        if (JvmCodegenUtil.isConstOrHasJvmFieldAnnotation(declaration2.getDescriptor())) {
            declaration2.setGetter(null);
            declaration2.setSetter(null);
        }
        return super.visitProperty(declaration2);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunction irFunction = expression2.getSymbol().getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irFunction;
        if (irSimpleFunction == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction irSimpleFunction2 = irSimpleFunction;
        IrProperty irProperty = irSimpleFunction2.getCorrespondingProperty();
        if (irProperty == null) {
            return super.visitCall(expression2);
        }
        IrProperty irProperty2 = irProperty;
        if (irProperty2.isConst()) {
            IrConst irConst;
            IrField irField = irProperty2.getBackingField();
            if (irField == null) {
                Intrinsics.throwNpe();
            }
            IrExpressionBody irExpressionBody = irField.getInitializer();
            if (irExpressionBody == null) {
                Intrinsics.throwNpe();
            }
            IrExpression irExpression = irExpressionBody.getExpression();
            if (irExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
            }
            IrConst it = irConst = (IrConst)irExpression;
            return it;
        }
        IrField irField = irProperty2.getBackingField();
        if (irField != null) {
            IrAnnotationContainer irAnnotationContainer = irField;
            FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"JVM_FIELD_ANNOTATION_FQ_NAME");
            if (IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName2)) {
                IrExpression irExpression;
                if (expression2 instanceof IrGetterCallImpl) {
                    irExpression = this.substituteGetter(irProperty2, expression2);
                } else {
                    boolean bl = expression2 instanceof IrSetterCallImpl;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    irExpression = this.substituteSetter(irProperty2, expression2);
                }
                return irExpression;
            }
        }
        if (irProperty2.getDescriptor() instanceof SyntheticJavaPropertyDescriptor) {
            expression2.setDispatchReceiver(expression2.getExtensionReceiver());
            expression2.setExtensionReceiver(null);
        }
        return super.visitCall(expression2);
    }

    private final IrExpression substituteSetter(IrProperty irProperty, IrCall expression2) {
        IrExpression irExpression;
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            Intrinsics.throwNpe();
        }
        IrField backingField2 = irField;
        IrExpression irExpression2 = expression2.getDispatchReceiver();
        if (irExpression2 != null) {
            IrExpression irExpression3;
            IrExpression it = irExpression3 = irExpression2;
            irExpression = super.visitExpression(it);
        } else {
            irExpression = null;
        }
        IrExpression receiver = irExpression;
        int n = expression2.getStartOffset();
        int n2 = expression2.getEndOffset();
        IrFieldSymbol irFieldSymbol = (IrFieldSymbol)backingField2.getSymbol();
        IrExpression irExpression4 = expression2.getValueArgument(expression2.getValueArgumentsCount() - 1);
        if (irExpression4 == null) {
            Intrinsics.throwNpe();
        }
        IrSetFieldImpl setExpr = new IrSetFieldImpl(n, n2, irFieldSymbol, receiver, super.visitExpression(irExpression4), expression2.getType(), expression2.getOrigin(), expression2.getSuperQualifierSymbol());
        return this.buildSubstitution(ConstAndJvmFieldPropertiesLoweringKt.access$isStaticField(backingField2), setExpr, receiver);
    }

    private final IrExpression substituteGetter(IrProperty irProperty, IrCall expression2) {
        IrExpression irExpression;
        IrField irField = irProperty.getBackingField();
        if (irField == null) {
            Intrinsics.throwNpe();
        }
        IrField backingField2 = irField;
        IrExpression irExpression2 = expression2.getDispatchReceiver();
        if (irExpression2 != null) {
            IrExpression irExpression3;
            IrExpression it = irExpression3 = irExpression2;
            irExpression = super.visitExpression(it);
        } else {
            irExpression = null;
        }
        IrExpression receiver = irExpression;
        IrGetFieldImpl getExpr = new IrGetFieldImpl(expression2.getStartOffset(), expression2.getEndOffset(), (IrFieldSymbol)backingField2.getSymbol(), expression2.getType(), receiver, expression2.getOrigin(), expression2.getSuperQualifierSymbol());
        return this.buildSubstitution(ConstAndJvmFieldPropertiesLoweringKt.access$isStaticField(backingField2), getExpr, receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression buildSubstitution(boolean needBlock, IrFieldAccessExpression setOrGetExpr, IrExpression receiver) {
        if (receiver != null && needBlock) {
            void this_$iv$iv$iv;
            void startOffset$iv$iv;
            void $receiver$iv$iv;
            IrGeneratorWithScope $receiver$iv = LowerUtilsKt.createIrBuilder(this.context, setOrGetExpr.getSymbol(), setOrGetExpr.getStartOffset(), setOrGetExpr.getEndOffset());
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = ((IrExpression)setOrGetExpr).getType();
            IrGeneratorWithScope irGeneratorWithScope = $receiver$iv;
            int n = ((IrExpression)setOrGetExpr).getStartOffset();
            int endOffset$iv$iv = ((IrExpression)setOrGetExpr).getEndOffset();
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($receiver$iv$iv.getContext(), $receiver$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv, origin$iv, resultType$iv, false, 64, null);
            void $receiver = this_$iv$iv$iv;
            IrTypeOperatorCallImpl receiverVoid = new IrTypeOperatorCallImpl(receiver.getStartOffset(), receiver.getEndOffset(), $receiver.getContext().getIrBuiltIns().getUnitType(), IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, $receiver.getContext().getIrBuiltIns().getUnitType(), IrTypesKt.getClassifierOrFail($receiver.getContext().getIrBuiltIns().getUnitType()), receiver);
            $receiver.unaryPlus(receiverVoid);
            setOrGetExpr.setReceiver(null);
            $receiver.unaryPlus(setOrGetExpr);
            return this_$iv$iv$iv.doBuild();
        }
        return setOrGetExpr;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public ConstAndJvmFieldPropertiesLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

