/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.ReferenceSymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.resolve.checkers.ExpectedActualDeclarationChecker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectedActualResolver;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u0002H\u0013\"\n\b\u0000\u0010\u0013\u0018\u0001*\u00020\u0014*\u0002H\u0013H\u0082\b\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0017H\u0002J\f\u0010\u0016\u001a\u00020\u0018*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/ExpectDeclarationsRemoving;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "copyDefaultArgumentsFromExpectToActual", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "remapExpectValue", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "findActualForExpect", "T", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;)Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "findActualForExpected", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "remapExpectValueSymbols", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.backend.common"})
public final class ExpectDeclarationsRemoving
implements FileLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        CollectionsKt.removeAll(irFile.getDeclarations(), (Function1)((Function1)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ ExpectDeclarationsRemoving this$0;

            public final boolean invoke(@NotNull IrDeclaration it) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DeclarationDescriptor descriptor2 = it.getDescriptor();
                if (descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect()) {
                    ExpectDeclarationsRemoving.access$copyDefaultArgumentsFromExpectToActual(this.this$0, it);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = expectDeclarationsRemoving;
                super(1);
            }
        }));
    }

    private final void copyDefaultArgumentsFromExpectToActual(IrDeclaration declaration2) {
        IrElementVisitorVoidKt.acceptVoid(declaration2, new IrElementVisitorVoid(this){
            final /* synthetic */ ExpectDeclarationsRemoving this$0;

            public void visitElement(@NotNull IrElement element3) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                IrElementVisitorVoidKt.acceptChildrenVoid(element3, this);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2) {
                IrValueParameter actualParameter;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2);
                IrExpressionBody irExpressionBody = declaration2.getDefaultValue();
                if (irExpressionBody == null) {
                    return;
                }
                IrExpressionBody defaultValue = irExpressionBody;
                IrDeclarationParent irDeclarationParent = declaration2.getParent();
                if (irDeclarationParent == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                IrFunction function2 = (IrFunction)irDeclarationParent;
                int index2 = declaration2.getIndex();
                boolean bl = Intrinsics.areEqual((Object)function2.getValueParameters().get(index2), (Object)declaration2);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                if (function2 instanceof IrConstructor) {
                    ClassDescriptor classDescriptor2 = ((IrConstructor)function2).getDescriptor().getConstructedClass();
                    Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor2, (String)"function.descriptor.constructedClass");
                    if (ExpectedActualDeclarationChecker.Companion.isOptionalAnnotationClass(classDescriptor2)) {
                        return;
                    }
                }
                if ((actualParameter = ExpectDeclarationsRemoving.access$findActualForExpected(this.this$0, function2).getValueParameters().get(index2)).getDefaultValue() != null) {
                    return;
                }
                IrExpressionBody irExpressionBody2 = defaultValue;
                IrValueParameter irValueParameter = actualParameter;
                IrExpressionBody it = irExpressionBody2;
                it.setExpression(ExpectDeclarationsRemoving.access$remapExpectValueSymbols(this.this$0, it.getExpression()));
                IrExpressionBody irExpressionBody3 = irExpressionBody2;
                irValueParameter.setDefaultValue(irExpressionBody3);
            }
            {
                this.this$0 = $outer;
            }

            public void visitElement(@NotNull IrElement element3, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                IrElementVisitorVoid.DefaultImpls.visitElement(this, element3, data);
            }

            public void visitValueParameter(@NotNull IrValueParameter declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitValueParameter(this, declaration2, data);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2);
            }

            public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer(this, declaration2, data);
            }

            public void visitBlock(@NotNull IrBlock expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2);
            }

            public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2);
            }

            public void visitBlockBody(@NotNull IrBlockBody body2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitBody(@NotNull IrBody body2) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2);
            }

            public void visitBody(@NotNull IrBody body2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitBranch(@NotNull IrBranch branch) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch);
            }

            public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                IrElementVisitorVoid.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitBreak(@NotNull IrBreak jump) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump);
            }

            public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                IrElementVisitorVoid.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump);
            }

            public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                IrElementVisitorVoid.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2);
            }

            public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCallableReference(@NotNull IrCallableReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2);
            }

            public void visitCallableReference(@NotNull IrCallableReference expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitCatch(@NotNull IrCatch aCatch) {
                Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch);
            }

            public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)aCatch, (String)"aCatch");
                IrElementVisitorVoid.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitClass(@NotNull IrClass declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2);
            }

            public void visitClass(@NotNull IrClass declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitClass(this, declaration2, data);
            }

            public void visitClassReference(@NotNull IrClassReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2);
            }

            public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitComposite(@NotNull IrComposite expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2);
            }

            public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitComposite(this, expression2, data);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2);
            }

            public <T> void visitConst(@NotNull IrConst<T> expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull(expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2);
            }

            public void visitConstructor(@NotNull IrConstructor declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitConstructor(this, declaration2, data);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2);
            }

            public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitContinue(@NotNull IrContinue jump) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump);
            }

            public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)jump, (String)"jump");
                IrElementVisitorVoid.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitDeclaration(@NotNull IrDeclaration declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2);
            }

            public void visitDeclaration(@NotNull IrDeclaration declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitDeclaration(this, declaration2, data);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2);
            }

            public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2);
            }

            public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
                Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop);
            }

            public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
                IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch);
            }

            public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
                IrElementVisitorVoid.DefaultImpls.visitElseBranch(this, branch, data);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2);
            }

            public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2);
            }

            public void visitEnumEntry(@NotNull IrEnumEntry declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitEnumEntry(this, declaration2, data);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2);
            }

            public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2);
            }

            public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration(this, declaration2, data);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2);
            }

            public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitExpression(@NotNull IrExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2);
            }

            public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2);
            }

            public void visitExpressionBody(@NotNull IrExpressionBody body2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2);
            }

            public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment(this, declaration2, data);
            }

            public void visitField(@NotNull IrField declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2);
            }

            public void visitField(@NotNull IrField declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitField(this, declaration2, data);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2);
            }

            public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitFile(@NotNull IrFile declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2);
            }

            public void visitFile(@NotNull IrFile declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitFile(this, declaration2, data);
            }

            public void visitFunction(@NotNull IrFunction declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2);
            }

            public void visitFunction(@NotNull IrFunction declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitFunction(this, declaration2, data);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2);
            }

            public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2);
            }

            public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitGetClass(@NotNull IrGetClass expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2);
            }

            public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2);
            }

            public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitGetField(@NotNull IrGetField expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2);
            }

            public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2);
            }

            public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2);
            }

            public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2);
            }

            public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2);
            }

            public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty(this, declaration2, data);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2);
            }

            public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitLoop(@NotNull IrLoop loop) {
                Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop);
            }

            public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
                IrElementVisitorVoid.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2);
            }

            public void visitMemberAccess(@NotNull IrMemberAccessExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2);
            }

            public void visitModuleFragment(@NotNull IrModuleFragment declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitModuleFragment(this, declaration2, data);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2);
            }

            public void visitPackageFragment(@NotNull IrPackageFragment declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitPackageFragment(this, declaration2, data);
            }

            public void visitProperty(@NotNull IrProperty declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2);
            }

            public void visitProperty(@NotNull IrProperty declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitProperty(this, declaration2, data);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2);
            }

            public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2);
            }

            public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitSetField(@NotNull IrSetField expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2);
            }

            public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitSetVariable(@NotNull IrSetVariable expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2);
            }

            public void visitSetVariable(@NotNull IrSetVariable expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSetVariable(this, expression2, data);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2);
            }

            public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitSimpleFunction(this, declaration2, data);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2);
            }

            public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread) {
                Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread);
            }

            public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)spread, (String)"spread");
                IrElementVisitorVoid.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2);
            }

            public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2);
            }

            public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2);
            }

            public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2);
            }

            public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
                IrElementVisitorVoid.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitThrow(@NotNull IrThrow expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2);
            }

            public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitTry(@NotNull IrTry aTry) {
                Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry);
            }

            public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
                IrElementVisitorVoid.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2);
            }

            public void visitTypeAlias(@NotNull IrTypeAlias declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitTypeAlias(this, declaration2, data);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2);
            }

            public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2);
            }

            public void visitTypeParameter(@NotNull IrTypeParameter declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitTypeParameter(this, declaration2, data);
            }

            public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitVararg(@NotNull IrVararg expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2);
            }

            public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitVariable(@NotNull IrVariable declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2);
            }

            public void visitVariable(@NotNull IrVariable declaration2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                IrElementVisitorVoid.DefaultImpls.visitVariable(this, declaration2, data);
            }

            public void visitVariableAccess(@NotNull IrValueAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitVariableAccess(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2);
            }

            public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementVisitorVoid.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop) {
                Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop);
            }

            public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
                Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
                IrElementVisitorVoid.DefaultImpls.visitWhileLoop(this, loop, data);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction findActualForExpected(@NotNull IrFunction $receiver) {
        void $receiver$iv;
        ExpectedActualResolver expectedActualResolver;
        MemberDescriptor memberDescriptor = $receiver.getDescriptor();
        ExpectDeclarationsRemoving expectDeclarationsRemoving = this;
        ReferenceSymbolTable referenceSymbolTable = this.context.getIr().getSymbols().getExternalSymbolTable();
        ExpectedActualResolver $receiver$iv2 = expectedActualResolver = ExpectedActualResolver.INSTANCE;
        void descriptor$iv = $receiver$iv;
        if (!descriptor$iv.isExpect()) {
            throw (Throwable)new IllegalStateException($receiver$iv2.toString());
        }
        MemberDescriptor memberDescriptor2 = (MemberDescriptor)CollectionsKt.singleOrNull($receiver$iv2.findCompatibleActualForExpected((MemberDescriptor)$receiver$iv, DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor$iv)));
        if (memberDescriptor2 == null) {
            throw (Throwable)new IllegalStateException(descriptor$iv.toString());
        }
        if (memberDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)memberDescriptor2;
        return IrUtilsKt.referenceFunction(referenceSymbolTable, functionDescriptor2).getOwner();
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass findActualForExpected(@NotNull IrClass $receiver) {
        void $receiver$iv;
        ExpectedActualResolver expectedActualResolver;
        MemberDescriptor memberDescriptor = $receiver.getDescriptor();
        ExpectDeclarationsRemoving expectDeclarationsRemoving = this;
        ReferenceSymbolTable referenceSymbolTable = this.context.getIr().getSymbols().getExternalSymbolTable();
        ExpectedActualResolver $receiver$iv2 = expectedActualResolver = ExpectedActualResolver.INSTANCE;
        void descriptor$iv = $receiver$iv;
        if (!descriptor$iv.isExpect()) {
            throw (Throwable)new IllegalStateException($receiver$iv2.toString());
        }
        MemberDescriptor memberDescriptor2 = (MemberDescriptor)CollectionsKt.singleOrNull($receiver$iv2.findCompatibleActualForExpected((MemberDescriptor)$receiver$iv, DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor$iv)));
        if (memberDescriptor2 == null) {
            throw (Throwable)new IllegalStateException(descriptor$iv.toString());
        }
        if (memberDescriptor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)memberDescriptor2;
        return (IrClass)referenceSymbolTable.referenceClass(classDescriptor2).getOwner();
    }

    private final <T extends MemberDescriptor> T findActualForExpect(@NotNull T $receiver) {
        ExpectedActualResolver expectedActualResolver;
        ExpectedActualResolver $receiver2 = expectedActualResolver = ExpectedActualResolver.INSTANCE;
        T descriptor2 = $receiver;
        if (!descriptor2.isExpect()) {
            throw (Throwable)new IllegalStateException($receiver2.toString());
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)CollectionsKt.singleOrNull($receiver2.findCompatibleActualForExpected($receiver, DescriptorUtilsKt.getModule(descriptor2)));
        if (memberDescriptor == null) {
            throw (Throwable)new IllegalStateException(descriptor2.toString());
        }
        Intrinsics.reifiedOperationMarker((int)1, (String)"T");
        return (T)memberDescriptor;
    }

    private final IrExpression remapExpectValueSymbols(@NotNull IrExpression $receiver) {
        return $receiver.transform(new IrElementTransformerVoid(this){
            final /* synthetic */ ExpectDeclarationsRemoving this$0;

            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.transformChildrenVoid(expression2);
                IrValueParameter irValueParameter = ExpectDeclarationsRemoving.access$remapExpectValue(this.this$0, expression2.getSymbol());
                if (irValueParameter == null) {
                    return expression2;
                }
                IrValueParameter newValue = irValueParameter;
                return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), newValue.getType(), newValue.getSymbol(), expression2.getOrigin());
            }
            {
                this.this$0 = $outer;
            }
        }, null);
    }

    private final IrValueParameter remapExpectValue(IrValueSymbol symbol2) {
        IrValueParameter irValueParameter;
        if (!(symbol2 instanceof IrValueParameterSymbol)) {
            return null;
        }
        IrValueParameter parameter = (IrValueParameter)((IrValueParameterSymbol)symbol2).getOwner();
        IrDeclarationParent parent2 = parameter.getParent();
        IrDeclarationParent irDeclarationParent = parent2;
        if (irDeclarationParent instanceof IrClass) {
            boolean bl = Intrinsics.areEqual((Object)parameter, (Object)((IrClass)parent2).getThisReceiver());
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            irValueParameter = this.findActualForExpected((IrClass)parent2).getThisReceiver();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
        } else if (irDeclarationParent instanceof IrFunction) {
            IrValueParameter irValueParameter2 = parameter;
            if (Intrinsics.areEqual((Object)irValueParameter2, (Object)((IrFunction)parent2).getDispatchReceiverParameter())) {
                irValueParameter = this.findActualForExpected((IrFunction)parent2).getDispatchReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
            } else if (Intrinsics.areEqual((Object)irValueParameter2, (Object)((IrFunction)parent2).getExtensionReceiverParameter())) {
                irValueParameter = this.findActualForExpected((IrFunction)parent2).getExtensionReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
            } else {
                boolean bl = Intrinsics.areEqual((Object)((IrFunction)parent2).getValueParameters().get(parameter.getIndex()), (Object)parameter);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                irValueParameter = this.findActualForExpected((IrFunction)parent2).getValueParameters().get(parameter.getIndex());
            }
        } else {
            throw (Throwable)new IllegalStateException(parent2.toString());
        }
        return irValueParameter;
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public ExpectDeclarationsRemoving(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    public static final /* synthetic */ void access$copyDefaultArgumentsFromExpectToActual(ExpectDeclarationsRemoving $this, IrDeclaration declaration2) {
        $this.copyDefaultArgumentsFromExpectToActual(declaration2);
    }

    public static final /* synthetic */ IrFunction access$findActualForExpected(ExpectDeclarationsRemoving $this, IrFunction $receiver) {
        return $this.findActualForExpected($receiver);
    }

    public static final /* synthetic */ IrExpression access$remapExpectValueSymbols(ExpectDeclarationsRemoving $this, IrExpression $receiver) {
        return $this.remapExpectValueSymbols($receiver);
    }

    public static final /* synthetic */ IrValueParameter access$remapExpectValue(ExpectDeclarationsRemoving $this, IrValueSymbol symbol2) {
        return $this.remapExpectValue(symbol2);
    }
}

