/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.PsiSelectionSearcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipSetterCallIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        List<PsiMethodCallExpression> methodCalls;
        Project project;
        Editor editor;
        if (element == null) {
            FlipSetterCallIntention.$$$reportNull$$$0(0);
        }
        if ((editor = FileEditorManager.getInstance((Project)(project = element.getProject())).getSelectedTextEditor()) != null && !(methodCalls = PsiSelectionSearcher.searchElementsInSelection(editor, project, PsiMethodCallExpression.class, false)).isEmpty()) {
            for (PsiMethodCallExpression call : methodCalls) {
                FlipSetterCallIntention.flipCall(call);
            }
            editor.getSelectionModel().removeSelection();
            return;
        }
        if (element instanceof PsiMethodCallExpression) {
            FlipSetterCallIntention.flipCall((PsiMethodCallExpression)element);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        SetterCallPredicate setterCallPredicate = new SetterCallPredicate();
        if (setterCallPredicate == null) {
            FlipSetterCallIntention.$$$reportNull$$$0(1);
        }
        return setterCallPredicate;
    }

    private static void flipCall(PsiMethodCallExpression call) {
        PsiExpression[] arguments = call.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return;
        }
        PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
        if (!(argument instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression call2 = (PsiMethodCallExpression)argument;
        PsiExpression qualifierExpression1 = ExpressionUtils.getQualifierOrThis(call.getMethodExpression());
        PsiExpression qualifierExpression2 = ExpressionUtils.getQualifierOrThis(call2.getMethodExpression());
        PsiMethod setter = call.resolveMethod();
        PsiMethod getter = call2.resolveMethod();
        PsiMethod get = PropertyUtil.getReversePropertyMethod(setter);
        PsiMethod set = PropertyUtil.getReversePropertyMethod(getter);
        if (get == null || set == null) {
            return;
        }
        CommentTracker ct = new CommentTracker();
        String text2 = ct.text((PsiElement)qualifierExpression2) + "." + set.getName() + "(" + ct.text((PsiElement)qualifierExpression1) + "." + get.getName() + "())";
        ct.replaceAndRestoreComments((PsiElement)call, text2);
    }

    private static boolean isSetGetMethodCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call1 = (PsiMethodCallExpression)element;
        PsiExpression[] arguments = call1.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
        if (!(argument instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call2 = (PsiMethodCallExpression)argument;
        PsiMethod setter = call1.resolveMethod();
        PsiMethod getter = call2.resolveMethod();
        PsiMethod get = PropertyUtil.getReversePropertyMethod(setter);
        PsiMethod set = PropertyUtil.getReversePropertyMethod(getter);
        if (setter == null || getter == null || get == null || set == null) {
            return false;
        }
        PsiParameter[] parameters2 = setter.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        PsiParameter parameter2 = parameters2[0];
        return parameter2.getType().equals(getter.getReturnType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/expression/FlipSetterCallIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/expression/FlipSetterCallIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SetterCallPredicate
    extends PsiElementEditorPredicate {
        private SetterCallPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element, @Nullable Editor editor) {
            if (editor != null && editor.getSelectionModel().hasSelection()) {
                List<PsiMethodCallExpression> list = PsiSelectionSearcher.searchElementsInSelection(editor, element.getProject(), PsiMethodCallExpression.class, false);
                for (PsiMethodCallExpression methodCallExpression : list) {
                    if (!FlipSetterCallIntention.isSetGetMethodCall((PsiElement)methodCallExpression)) continue;
                    return true;
                }
            }
            return FlipSetterCallIntention.isSetGetMethodCall(element);
        }
    }
}

