/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class SerializableInspectionBase
extends BaseInspection {
    private static final JComponent[] EMPTY_COMPONENT_ARRAY = new JComponent[0];
    public boolean ignoreAnonymousInnerClasses = false;
    public String superClassString = "java.awt.Component";
    protected List<String> superClassList = new ArrayList<String>();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            SerializableInspectionBase.$$$reportNull$$$0(0);
        }
        super.readSettings(node);
        SerializableInspectionBase.parseString(this.superClassString, this.superClassList);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SerializableInspectionBase.$$$reportNull$$$0(1);
        }
        if (!this.superClassList.isEmpty()) {
            this.superClassString = SerializableInspectionBase.formatString(this.superClassList);
        }
        super.writeSettings(node);
    }

    public final JComponent createOptionsPanel() {
        JComponent[] additionalOptions;
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel chooserList = UiUtils.createTreeClassChooserList(this.superClassList, InspectionGadgetsBundle.message("ignore.classes.in.hierarchy.column.name", new Object[0]), InspectionGadgetsBundle.message("choose.super.class.to.ignore", new Object[0]), new String[0]);
        UiUtils.setComponentSize(chooserList, 7, 25);
        CheckBox checkBox = new CheckBox(InspectionGadgetsBundle.message("ignore.anonymous.inner.classes", new Object[0]), (InspectionProfileEntry)this, "ignoreAnonymousInnerClasses");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        panel.add((Component)chooserList, constraints);
        for (JComponent additionalOption : additionalOptions = this.createAdditionalOptions()) {
            ++constraints.gridy;
            if (additionalOption instanceof JPanel) {
                constraints.fill = 1;
                constraints.weighty = 1.0;
            } else {
                constraints.fill = 2;
                constraints.weighty = 0.0;
            }
            panel.add((Component)additionalOption, constraints);
        }
        constraints.fill = 2;
        ++constraints.gridy;
        constraints.weighty = 0.0;
        panel.add((Component)checkBox, constraints);
        return panel;
    }

    @NotNull
    protected JComponent[] createAdditionalOptions() {
        if (EMPTY_COMPONENT_ARRAY == null) {
            SerializableInspectionBase.$$$reportNull$$$0(2);
        }
        return EMPTY_COMPONENT_ARRAY;
    }

    protected boolean isIgnoredSubclass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SerializableInspectionBase.$$$reportNull$$$0(3);
        }
        if (SerializationUtils.isDirectlySerializable(aClass)) {
            return false;
        }
        for (String superClassName : this.superClassList) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)superClassName)) continue;
            return true;
        }
        return false;
    }

    public final String getAlternativeID() {
        return "serial";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/serialization/SerializableInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/serialization/SerializableInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredSubclass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

