/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ImportUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionUtils {
    private static final Set<String> IMPLICIT_TO_STRING_METHOD_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"append", "format", "print", "printf", "println", "valueOf"});
    @NonNls
    static final Set<String> convertableBoxedClassNames = new HashSet<String>(3);
    private static final CallMatcher KNOWN_SIMPLE_CALLS;
    private static final CallMatcher GET_OR_DEFAULT;

    private ExpressionUtils() {
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression2) {
        return ExpressionUtils.computeConstantExpression(expression2, false);
    }

    @Nullable
    public static Object computeConstantExpression(@Nullable PsiExpression expression2, boolean throwConstantEvaluationOverflowException) {
        if (expression2 == null) {
            return null;
        }
        Project project = expression2.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiConstantEvaluationHelper constantEvaluationHelper = psiFacade.getConstantEvaluationHelper();
        return constantEvaluationHelper.computeConstantExpression((PsiElement)expression2, throwConstantEvaluationOverflowException);
    }

    public static boolean isConstant(PsiField field) {
        if (!field.hasModifierProperty("final")) {
            return false;
        }
        if (CollectionUtils.isEmptyArray((PsiVariable)field)) {
            return true;
        }
        PsiType type2 = field.getType();
        return ClassUtils.isImmutable(type2);
    }

    public static boolean hasExpressionCount(@Nullable PsiExpressionList expressionList, int count) {
        return ControlFlowUtils.hasChildrenOfTypeCount((PsiElement)expressionList, count, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getFirstExpressionInList(@Nullable PsiExpressionList expressionList) {
        return (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)expressionList, PsiExpression.class);
    }

    @Nullable
    public static PsiExpression getOnlyExpressionInList(@Nullable PsiExpressionList expressionList) {
        return ControlFlowUtils.getOnlyChildOfType((PsiElement)expressionList, PsiExpression.class);
    }

    public static boolean isDeclaredConstant(PsiExpression expression2) {
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiField.class);
        if (field == null) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiAssignmentExpression.class);
            if (assignmentExpression == null) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiField)) {
                return false;
            }
            field = (PsiField)target;
        }
        return field.hasModifierProperty("static") && field.hasModifierProperty("final");
    }

    @Contract(value="null -> false")
    public static boolean isEvaluatedAtCompileTime(@Nullable PsiExpression expression2) {
        if (expression2 instanceof PsiLiteralExpression) {
            return true;
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands2;
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
            for (PsiExpression operand2 : operands2 = polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand2)) continue;
                return false;
            }
            return true;
        }
        if (expression2 instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression2;
            PsiExpression operand3 = prefixExpression.getOperand();
            return ExpressionUtils.isEvaluatedAtCompileTime(operand3);
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiElement qualifier = referenceExpression.getQualifier();
            if (qualifier instanceof PsiThisExpression) {
                return false;
            }
            PsiElement element = referenceExpression.resolve();
            if (element instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)element;
                if (PsiTreeUtil.isAncestor((PsiElement)variable, (PsiElement)expression2, (boolean)true)) {
                    return false;
                }
                PsiExpression initializer = variable.getInitializer();
                return variable.hasModifierProperty("final") && ExpressionUtils.isEvaluatedAtCompileTime(initializer);
            }
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression deparenthesizedExpression = parenthesizedExpression.getExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(deparenthesizedExpression);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression2;
            PsiExpression condition2 = conditionalExpression.getCondition();
            PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
            PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
            return ExpressionUtils.isEvaluatedAtCompileTime(condition2) && ExpressionUtils.isEvaluatedAtCompileTime(thenExpression2) && ExpressionUtils.isEvaluatedAtCompileTime(elseExpression2);
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
            PsiTypeElement castType = typeCastExpression.getCastType();
            if (castType == null) {
                return false;
            }
            PsiType type2 = castType.getType();
            return TypeUtils.typeEquals("java.lang.String", type2) && ExpressionUtils.isEvaluatedAtCompileTime(typeCastExpression.getOperand());
        }
        return false;
    }

    @Nullable
    public static PsiLiteralExpression getLiteral(@Nullable PsiExpression expression2) {
        if ((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression) {
            return (PsiLiteralExpression)expression2;
        }
        if (!(expression2 instanceof PsiTypeCastExpression)) {
            return null;
        }
        PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)expression2;
        PsiExpression operand2 = ParenthesesUtils.stripParentheses(typeCastExpression.getOperand());
        if (!(operand2 instanceof PsiLiteralExpression)) {
            return null;
        }
        return (PsiLiteralExpression)operand2;
    }

    public static boolean isLiteral(@Nullable PsiExpression expression2) {
        return ExpressionUtils.getLiteral(expression2) != null;
    }

    public static boolean isEmptyStringLiteral(@Nullable PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiLiteralExpression)) {
            return false;
        }
        String text2 = expression2.getText();
        return "\"\"".equals(text2);
    }

    @Contract(value="null -> false")
    public static boolean isNullLiteral(@Nullable PsiExpression expression2) {
        return (expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)expression2)) instanceof PsiLiteralExpression && ((PsiLiteralExpression)expression2).getValue() == null;
    }

    public static Stream<PsiExpression> nonStructuralChildren(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(0);
        }
        return ((StreamEx)StreamEx.ofTree((Object)expression2, e -> {
            if (e instanceof PsiConditionalExpression) {
                PsiConditionalExpression ternary = (PsiConditionalExpression)e;
                return StreamEx.of((Object[])new PsiExpression[]{ternary.getThenExpression(), ternary.getElseExpression()}).nonNull();
            }
            if (e instanceof PsiParenthesizedExpression) {
                return StreamEx.ofNullable((Object)((PsiParenthesizedExpression)e).getExpression());
            }
            return null;
        }).remove(e -> e instanceof PsiConditionalExpression || e instanceof PsiParenthesizedExpression)).map(e -> {
            PsiExpression operand2;
            if (e instanceof PsiTypeCastExpression && (operand2 = ((PsiTypeCastExpression)e).getOperand()) != null && !(e.getType() instanceof PsiPrimitiveType) && (!(operand2.getType() instanceof PsiPrimitiveType) || PsiType.NULL.equals((Object)operand2.getType()))) {
                return PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2);
            }
            return e;
        }).nonNull().flatMap(e -> {
            if (e instanceof PsiMethodCallExpression && GET_OR_DEFAULT.matches((PsiExpression)e)) {
                return StreamEx.of((Object[])new PsiExpression[]{e, ((PsiMethodCallExpression)e).getArgumentList().getExpressions()[1]});
            }
            return StreamEx.of((Object)e);
        });
    }

    public static boolean isZero(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        PsiType expressionType = expression2.getType();
        Object value2 = ConstantExpressionUtil.computeCastTo((PsiExpression)expression2, (PsiType)expressionType);
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Double && (Double)value2 == 0.0) {
            return true;
        }
        if (value2 instanceof Float && ((Float)value2).floatValue() == 0.0f) {
            return true;
        }
        if (value2 instanceof Integer && (Integer)value2 == 0) {
            return true;
        }
        if (value2 instanceof Long && (Long)value2 == 0L) {
            return true;
        }
        if (value2 instanceof Short && (Short)value2 == 0) {
            return true;
        }
        if (value2 instanceof Character && ((Character)value2).charValue() == '\u0000') {
            return true;
        }
        return value2 instanceof Byte && (Byte)value2 == 0;
    }

    public static boolean isOne(@Nullable PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        Object value2 = ExpressionUtils.computeConstantExpression(expression2);
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Double && (Double)value2 == 1.0) {
            return true;
        }
        if (value2 instanceof Float && ((Float)value2).floatValue() == 1.0f) {
            return true;
        }
        if (value2 instanceof Integer && (Integer)value2 == 1) {
            return true;
        }
        if (value2 instanceof Long && (Long)value2 == 1L) {
            return true;
        }
        if (value2 instanceof Short && (Short)value2 == 1) {
            return true;
        }
        if (value2 instanceof Character && ((Character)value2).charValue() == '\u0001') {
            return true;
        }
        return value2 instanceof Byte && (Byte)value2 == 1;
    }

    public static boolean isNegation(@Nullable PsiExpression condition2, boolean ignoreNegatedNullComparison, boolean ignoreNegatedZeroComparison) {
        if ((condition2 = ParenthesesUtils.stripParentheses(condition2)) instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition2;
            IElementType tokenType = prefixExpression.getOperationTokenType();
            return tokenType.equals(JavaTokenType.EXCL);
        }
        if (condition2 instanceof PsiBinaryExpression) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition2;
            PsiExpression lhs = ParenthesesUtils.stripParentheses(binaryExpression.getLOperand());
            PsiExpression rhs = ParenthesesUtils.stripParentheses(binaryExpression.getROperand());
            if (lhs == null || rhs == null) {
                return false;
            }
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (tokenType.equals(JavaTokenType.NE)) {
                if (ignoreNegatedNullComparison) {
                    String lhsText = lhs.getText();
                    String rhsText = rhs.getText();
                    if ("null".equals(lhsText) || "null".equals(rhsText)) {
                        return false;
                    }
                }
                return !ignoreNegatedZeroComparison || !ExpressionUtils.isZeroLiteral(lhs) && !ExpressionUtils.isZeroLiteral(rhs);
            }
        }
        return false;
    }

    private static boolean isZeroLiteral(PsiExpression expression2) {
        if (!(expression2 instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
        Object value2 = literalExpression.getValue();
        return value2 instanceof Integer ? (Integer)value2 == 0 : value2 instanceof Long && (Long)value2 == 0L;
    }

    public static boolean isOffsetArrayAccess(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        PsiExpression strippedExpression;
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(1);
        }
        if (!((strippedExpression = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiArrayAccessExpression)) {
            return false;
        }
        PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)strippedExpression;
        PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
        if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)arrayExpression)) {
            return false;
        }
        PsiExpression index = arrayAccessExpression.getIndexExpression();
        if (index == null) {
            return false;
        }
        return ExpressionUtils.expressionIsOffsetVariableLookup(index, variable);
    }

    private static boolean expressionIsOffsetVariableLookup(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(2);
        }
        if (ExpressionUtils.isReferenceTo(expression2, variable)) {
            return true;
        }
        PsiExpression strippedExpression = ParenthesesUtils.stripParentheses(expression2);
        if (!(strippedExpression instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)strippedExpression;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (!JavaTokenType.PLUS.equals(tokenType) && !JavaTokenType.MINUS.equals(tokenType)) {
            return false;
        }
        PsiExpression lhs = binaryExpression.getLOperand();
        if (ExpressionUtils.expressionIsOffsetVariableLookup(lhs, variable)) {
            return true;
        }
        PsiExpression rhs = binaryExpression.getROperand();
        return ExpressionUtils.expressionIsOffsetVariableLookup(rhs, variable) && !JavaTokenType.MINUS.equals(tokenType);
    }

    public static boolean isVariableLessThanComparison(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        PsiBinaryExpression binaryExpression;
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(3);
        }
        if ((binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ParenthesesUtils.stripParentheses(expression2), PsiBinaryExpression.class)) == null) {
            return false;
        }
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            return ExpressionUtils.isReferenceTo(binaryExpression.getLOperand(), variable);
        }
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            return ExpressionUtils.isReferenceTo(binaryExpression.getROperand(), variable);
        }
        return false;
    }

    public static boolean isVariableGreaterThanComparison(@Nullable PsiExpression expression2, @NotNull PsiVariable variable) {
        PsiBinaryExpression binaryExpression;
        if (variable == null) {
            ExpressionUtils.$$$reportNull$$$0(4);
        }
        if ((binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)ParenthesesUtils.stripParentheses(expression2), PsiBinaryExpression.class)) == null) {
            return false;
        }
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.GT) || tokenType.equals(JavaTokenType.GE)) {
            return ExpressionUtils.isReferenceTo(binaryExpression.getLOperand(), variable);
        }
        if (tokenType.equals(JavaTokenType.LT) || tokenType.equals(JavaTokenType.LE)) {
            return ExpressionUtils.isReferenceTo(binaryExpression.getROperand(), variable);
        }
        return false;
    }

    public static boolean isStringConcatenationOperand(PsiExpression expression2) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (!(parent instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
        if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
            return false;
        }
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        if (operands2.length < 2) {
            return false;
        }
        for (int i = 0; i < operands2.length; ++i) {
            PsiExpression operand2 = operands2[i];
            if (PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2) == expression2) {
                return i == 0 && TypeUtils.isJavaLangString(operands2[1].getType());
            }
            PsiType type2 = operand2.getType();
            if (!TypeUtils.isJavaLangString(type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasType(@Nullable PsiExpression expression2, @NonNls @NotNull String typeName) {
        if (typeName == null) {
            ExpressionUtils.$$$reportNull$$$0(5);
        }
        if (expression2 == null) {
            return false;
        }
        PsiType type2 = expression2.getType();
        return TypeUtils.typeEquals(typeName, type2);
    }

    public static boolean hasStringType(@Nullable PsiExpression expression2) {
        return ExpressionUtils.hasType(expression2, "java.lang.String");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConversionToStringNecessary(PsiExpression expression2, boolean throwable) {
        PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression2);
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            PsiType type2 = polyadicExpression.getType();
            if (!TypeUtils.typeEquals("java.lang.String", type2)) {
                return true;
            }
            PsiExpression[] operands2 = polyadicExpression.getOperands();
            boolean expressionSeen = false;
            int i = 0;
            int length = operands2.length;
            while (i < length) {
                PsiExpression operand2 = operands2[i];
                if (PsiTreeUtil.isAncestor((PsiElement)operand2, (PsiElement)expression2, (boolean)false)) {
                    if (i > 0) {
                        return true;
                    }
                    expressionSeen = true;
                } else if ((!expressionSeen || i == 1) && TypeUtils.isJavaLangString(operand2.getType())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(parent instanceof PsiExpressionList)) return true;
        PsiExpressionList expressionList = (PsiExpressionList)parent;
        PsiElement grandParent = expressionList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return true;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
        String name = methodExpression1.getReferenceName();
        PsiExpression[] expressions2 = expressionList.getExpressions();
        if ("insert".equals(name)) {
            if (expressions2.length < 2) return true;
            if (!expression2.equals(ParenthesesUtils.stripParentheses(expressions2[1]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("append".equals(name)) {
            if (expressions2.length < 1) return true;
            if (!expression2.equals(ParenthesesUtils.stripParentheses(expressions2[0]))) {
                return true;
            }
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.lang.StringBuilder", "java.lang.StringBuffer")) return false;
            return true;
        }
        if ("print".equals(name) || "println".equals(name)) {
            if (ExpressionUtils.isCallToMethodIn(methodCallExpression, "java.io.PrintStream", "java.io.PrintWriter")) return false;
            return true;
        }
        if (!("trace".equals(name) || "debug".equals(name) || "info".equals(name) || "warn".equals(name))) {
            if (!"error".equals(name)) return true;
        }
        if (!ExpressionUtils.isCallToMethodIn(methodCallExpression, "org.slf4j.Logger")) {
            return true;
        }
        int l = 1;
        int i = 0;
        while (i < expressions2.length) {
            PsiExpression expression1 = expressions2[i];
            if (i == 0 && TypeUtils.expressionHasTypeOrSubtype(expression1, "org.slf4j.Marker")) {
                l = 2;
            }
            if (expression1 == expression2) {
                if (i < l) return true;
                if (throwable && i == expressions2.length - 1) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private static boolean isCallToMethodIn(PsiMethodCallExpression methodCallExpression, String ... classNames) {
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        for (String className : classNames) {
            if (!className.equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNegative(@NotNull PsiExpression expression2) {
        PsiElement parent;
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(6);
        }
        if (!((parent = expression2.getParent()) instanceof PsiPrefixExpression)) {
            return false;
        }
        PsiPrefixExpression prefixExpression = (PsiPrefixExpression)parent;
        IElementType tokenType = prefixExpression.getOperationTokenType();
        return JavaTokenType.MINUS.equals(tokenType);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiVariable getVariableFromNullComparison(PsiExpression expression2, boolean equals) {
        PsiReferenceExpression referenceExpression = ExpressionUtils.getReferenceExpressionFromNullComparison(expression2, equals);
        PsiElement target = referenceExpression != null ? referenceExpression.resolve() : null;
        return target instanceof PsiVariable ? (PsiVariable)target : null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    public static PsiReferenceExpression getReferenceExpressionFromNullComparison(PsiExpression expression2, boolean equals) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
        IElementType tokenType = polyadicExpression.getOperationTokenType();
        if (equals ? !JavaTokenType.EQEQ.equals(tokenType) : !JavaTokenType.NE.equals(tokenType)) {
            return null;
        }
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        if (operands2.length != 2) {
            return null;
        }
        PsiExpression comparedToNull = null;
        if (PsiType.NULL.equals((Object)operands2[0].getType())) {
            comparedToNull = operands2[1];
        } else if (PsiType.NULL.equals((Object)operands2[1].getType())) {
            comparedToNull = operands2[0];
        }
        comparedToNull = ParenthesesUtils.stripParentheses(comparedToNull);
        return comparedToNull instanceof PsiReferenceExpression ? (PsiReferenceExpression)comparedToNull : null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithNull(@NotNull PsiBinaryExpression binOp) {
        IElementType tokenType;
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(7);
        }
        if (!(tokenType = binOp.getOperationTokenType()).equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(8);
        }
        return ExpressionUtils.getValueComparedWithZero(binOp, JavaTokenType.EQEQ);
    }

    @Nullable
    public static PsiExpression getValueComparedWithZero(@NotNull PsiBinaryExpression binOp, IElementType opType) {
        if (binOp == null) {
            ExpressionUtils.$$$reportNull$$$0(9);
        }
        if (!binOp.getOperationTokenType().equals(opType)) {
            return null;
        }
        PsiExpression rOperand = binOp.getROperand();
        if (rOperand == null) {
            return null;
        }
        PsiExpression lOperand = binOp.getLOperand();
        if (ExpressionUtils.isZero(lOperand)) {
            return rOperand;
        }
        if (ExpressionUtils.isZero(rOperand)) {
            return lOperand;
        }
        return null;
    }

    public static boolean isConcatenation(PsiElement element) {
        if (!(element instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiType type2 = expression2.getType();
        return type2 != null && type2.equalsToText("java.lang.String");
    }

    public static boolean isAnnotatedNotNull(PsiExpression expression2) {
        return ExpressionUtils.isAnnotated(expression2, false);
    }

    public static boolean isAnnotatedNullable(PsiExpression expression2) {
        return ExpressionUtils.isAnnotated(expression2, true);
    }

    private static boolean isAnnotated(PsiExpression expression2, boolean nullable) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)target;
        return nullable ? NullableNotNullManager.isNullable((PsiModifierListOwner)modifierListOwner) : NullableNotNullManager.isNotNull((PsiModifierListOwner)modifierListOwner);
    }

    @Contract(value="null -> false")
    public static boolean isSafelyRecomputableExpression(@Nullable PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiLiteralExpression || expression2 instanceof PsiThisExpression || expression2 instanceof PsiClassObjectAccessExpression || ExpressionUtils.isEvaluatedAtCompileTime(expression2)) {
            return true;
        }
        if (expression2 instanceof PsiReferenceExpression) {
            PsiElement target = ((PsiReferenceExpression)expression2).resolve();
            if (target instanceof PsiLocalVariable || target instanceof PsiParameter) {
                return true;
            }
            PsiExpression qualifier = ((PsiReferenceExpression)expression2).getQualifierExpression();
            if (target == null && qualifier == null) {
                return true;
            }
            if (target instanceof PsiField) {
                PsiField field = (PsiField)target;
                if (!field.hasModifierProperty("final")) {
                    return false;
                }
                return qualifier == null || qualifier instanceof PsiThisExpression || field.hasModifierProperty("static");
            }
        }
        if (expression2 instanceof PsiMethodCallExpression) {
            return KNOWN_SIMPLE_CALLS.test((PsiMethodCallExpression)expression2);
        }
        return false;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiAssignmentExpression getAssignment(PsiElement element) {
        PsiAssignmentExpression assignment;
        if (element instanceof PsiExpressionStatement) {
            element = ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiExpression && (element = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element))) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)element).getOperationTokenType().equals(JavaTokenType.EQ)) {
            return assignment;
        }
        return null;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static PsiExpression getAssignmentTo(PsiElement element, PsiVariable target) {
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && ExpressionUtils.isReferenceTo(assignment.getLExpression(), target)) {
            return assignment.getRExpression();
        }
        return null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLiteral(PsiElement element, Object value2) {
        return element instanceof PsiLiteralExpression && value2.equals(((PsiLiteralExpression)element).getValue());
    }

    public static boolean isAutoBoxed(@NotNull PsiExpression expression2) {
        PsiMethodCallExpression methodCallExpression;
        PsiMethod method;
        PsiElement grandParent;
        PsiElement parent;
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(10);
        }
        if ((parent = expression2.getParent()) instanceof PsiParenthesizedExpression) {
            return false;
        }
        if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (method = (methodCallExpression = (PsiMethodCallExpression)grandParent).resolveMethod()) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.invoke.MethodHandle.PolymorphicSignature", (int)0)) {
            return false;
        }
        PsiType expressionType = expression2.getType();
        if (PsiPrimitiveType.getUnboxedType((PsiType)expressionType) != null && parent instanceof PsiUnaryExpression) {
            IElementType sign = ((PsiUnaryExpression)parent).getOperationTokenType();
            return sign == JavaTokenType.PLUSPLUS || sign == JavaTokenType.MINUSMINUS;
        }
        if (expressionType == null || expressionType.equals(PsiType.VOID) || !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expressionType)) {
            return false;
        }
        PsiPrimitiveType primitiveType = (PsiPrimitiveType)expressionType;
        PsiClassType boxedType = primitiveType.getBoxedType((PsiElement)expression2);
        if (boxedType == null) {
            return false;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType(expression2, false, true);
        if (expectedType == null || ClassUtils.isPrimitive(expectedType)) {
            return false;
        }
        if (!expectedType.isAssignableFrom((PsiType)boxedType)) {
            if (!(expectedType instanceof PsiClassType) || !PsiUtil.isConstantExpression((PsiExpression)expression2)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)expectedType;
            String className = classType.getCanonicalText();
            if (!convertableBoxedClassNames.contains(className)) {
                return false;
            }
            if (!(PsiType.BYTE.equals((Object)expressionType) || PsiType.CHAR.equals((Object)expressionType) || PsiType.SHORT.equals((Object)expressionType) || PsiType.INT.equals((Object)expressionType))) {
                return false;
            }
        }
        return true;
    }

    @Contract(value="null, _ -> null; !null, null -> null")
    public static PsiExpression getOtherOperand(@Nullable PsiBinaryExpression binOp, @Nullable PsiVariable variable) {
        if (binOp == null || variable == null) {
            return null;
        }
        if (ExpressionUtils.isReferenceTo(binOp.getLOperand(), variable)) {
            return binOp.getROperand();
        }
        if (ExpressionUtils.isReferenceTo(binOp.getROperand(), variable)) {
            return binOp.getLOperand();
        }
        return null;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean isReferenceTo(PsiExpression expression2, PsiVariable variable) {
        if (variable == null) {
            return false;
        }
        if (!((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)expression2;
        if ((variable instanceof PsiLocalVariable || variable instanceof PsiParameter) && ref.isQualified()) {
            return false;
        }
        return ref.isReferenceTo((PsiElement)variable);
    }

    @Contract(value="null -> null", pure=true)
    public static PsiMethodCallExpression getCallForQualifier(PsiExpression qualifier) {
        PsiElement gParent;
        PsiReferenceExpression methodExpression;
        if (qualifier == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)qualifier.getParent());
        if (parent instanceof PsiReferenceExpression && PsiTreeUtil.isAncestor((PsiElement)(methodExpression = (PsiReferenceExpression)parent).getQualifierExpression(), (PsiElement)qualifier, (boolean)false) && (gParent = methodExpression.getParent()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)gParent;
        }
        return null;
    }

    @Nullable
    public static PsiExpression getArrayFromLengthExpression(PsiExpression expression2) {
        if (!((expression2 = ParenthesesUtils.stripParentheses(expression2)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression reference = (PsiReferenceExpression)expression2;
        String referenceName = reference.getReferenceName();
        if (!"length".equals(referenceName)) {
            return null;
        }
        PsiExpression qualifier = reference.getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type2 = qualifier.getType();
        if (type2 == null || type2.getArrayDimensions() <= 0) {
            return null;
        }
        return qualifier;
    }

    @NotNull
    public static PsiExpression getQualifierOrThis(@NotNull PsiReferenceExpression ref) {
        PsiClass memberClass;
        PsiExpression qualifier;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(11);
        }
        if ((qualifier = ref.getQualifierExpression()) != null) {
            PsiExpression psiExpression = qualifier;
            if (psiExpression == null) {
                ExpressionUtils.$$$reportNull$$$0(12);
            }
            return psiExpression;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
        PsiMember member = (PsiMember)ObjectUtils.tryCast((Object)ref.resolve(), PsiMember.class);
        if (member != null && (memberClass = member.getContainingClass()) != null) {
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)ref);
            if (containingClass == null) {
                containingClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class});
            }
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
                containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
                while (containingClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
                    containingClass = ClassUtils.getContainingClass((PsiElement)containingClass);
                }
                if (containingClass != null) {
                    PsiExpression psiExpression = factory.createExpressionFromText(containingClass.getQualifiedName() + "." + "this", (PsiElement)ref);
                    if (psiExpression == null) {
                        ExpressionUtils.$$$reportNull$$$0(13);
                    }
                    return psiExpression;
                }
            }
        }
        PsiExpression psiExpression = factory.createExpressionFromText("this", (PsiElement)ref);
        if (psiExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(14);
        }
        return psiExpression;
    }

    public static void bindReferenceTo(@NotNull PsiReferenceExpression ref, @NotNull String newName) {
        PsiMember member;
        PsiMember member2;
        PsiElement nameElement;
        if (ref == null) {
            ExpressionUtils.$$$reportNull$$$0(15);
        }
        if (newName == null) {
            ExpressionUtils.$$$reportNull$$$0(16);
        }
        if ((nameElement = ref.getReferenceNameElement()) == null) {
            throw new IllegalStateException("Name element is null: " + ref);
        }
        if (newName.equals(nameElement.getText())) {
            return;
        }
        PsiClass aClass = null;
        if (ref.getQualifierExpression() == null && (member2 = (PsiMember)ObjectUtils.tryCast((Object)ref.resolve(), PsiMember.class)) != null && ImportUtils.isStaticallyImported(member2, (PsiElement)ref)) {
            aClass = member2.getContainingClass();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
        PsiIdentifier identifier = factory.createIdentifier(newName);
        nameElement.replace((PsiElement)identifier);
        if (aClass != null && ((member = (PsiMember)ObjectUtils.tryCast((Object)ref.resolve(), PsiMember.class)) == null || member.getContainingClass() != aClass)) {
            ref.setQualifierExpression((PsiExpression)factory.createReferenceExpression(aClass));
        }
    }

    public static void bindCallTo(@NotNull PsiMethodCallExpression call, @NotNull String newName) {
        if (call == null) {
            ExpressionUtils.$$$reportNull$$$0(17);
        }
        if (newName == null) {
            ExpressionUtils.$$$reportNull$$$0(18);
        }
        ExpressionUtils.bindReferenceTo(call.getMethodExpression(), newName);
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiExpression resolveExpression(@Nullable PsiExpression expression2) {
        PsiExpression initializer;
        PsiReferenceExpression reference;
        PsiLocalVariable variable;
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiReferenceExpression && (variable = (PsiLocalVariable)ObjectUtils.tryCast((Object)(reference = (PsiReferenceExpression)expression2).resolve(), PsiLocalVariable.class)) != null && (initializer = variable.getInitializer()) != null && ReferencesSearch.search((PsiElement)variable).allMatch(ref -> ref == reference)) {
            return initializer;
        }
        return expression2;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiLocalVariable resolveLocalVariable(@Nullable PsiExpression expression2) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)expression2, PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return null;
        }
        return (PsiLocalVariable)ObjectUtils.tryCast((Object)referenceExpression.resolve(), PsiLocalVariable.class);
    }

    public static boolean isOctalLiteral(PsiLiteralExpression literal) {
        PsiType type2 = literal.getType();
        if (!PsiType.INT.equals((Object)type2) && !PsiType.LONG.equals((Object)type2)) {
            return false;
        }
        if (literal.getValue() == null) {
            return false;
        }
        String text2 = literal.getText();
        if (text2.charAt(0) != '0' || text2.length() < 2) {
            return false;
        }
        char c1 = text2.charAt(1);
        return c1 == '_' || c1 >= '0' && c1 <= '7';
    }

    @Contract(value="null, _ -> false")
    public static boolean isMatchingChildAlwaysExecuted(@Nullable PsiExpression root, final @NotNull Predicate<? super PsiExpression> matcher) {
        if (matcher == null) {
            ExpressionUtils.$$$reportNull$$$0(19);
        }
        if (root == null) {
            return false;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitExpression(PsiExpression expression2) {
                super.visitExpression(expression2);
                if (matcher.test(expression2)) {
                    result.set(true);
                    this.stopWalking();
                }
            }

            public void visitConditionalExpression(PsiConditionalExpression expression2) {
                if (ExpressionUtils.isMatchingChildAlwaysExecuted(expression2.getCondition(), matcher) || ExpressionUtils.isMatchingChildAlwaysExecuted(expression2.getThenExpression(), matcher) && ExpressionUtils.isMatchingChildAlwaysExecuted(expression2.getElseExpression(), matcher)) {
                    result.set(true);
                    this.stopWalking();
                }
            }

            public void visitPolyadicExpression(PsiPolyadicExpression expression2) {
                IElementType type2 = expression2.getOperationTokenType();
                if (type2.equals(JavaTokenType.OROR) || type2.equals(JavaTokenType.ANDAND)) {
                    PsiExpression firstOperand = (PsiExpression)ArrayUtil.getFirstElement((Object[])expression2.getOperands());
                    if (ExpressionUtils.isMatchingChildAlwaysExecuted(firstOperand, matcher)) {
                        result.set(true);
                        this.stopWalking();
                    }
                } else {
                    super.visitPolyadicExpression(expression2);
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
            }
        });
        return result.get();
    }

    @Contract(value="null -> false")
    public static boolean isNewObject(@Nullable PsiExpression expression2) {
        return expression2 != null && ExpressionUtils.nonStructuralChildren(expression2).allMatch(call -> {
            if (call instanceof PsiNewExpression) {
                return true;
            }
            if (call instanceof PsiMethodCallExpression) {
                ContractReturnValue returnValue = JavaMethodContractUtil.getNonFailingReturnValue(JavaMethodContractUtil.getMethodCallContracts((PsiCallExpression)call));
                return ContractReturnValue.returnNew().equals(returnValue);
            }
            return false;
        });
    }

    public static boolean isDifference(@NotNull PsiExpression from, @NotNull PsiExpression to, @NotNull PsiExpression diff) {
        Integer fromConstant;
        if (from == null) {
            ExpressionUtils.$$$reportNull$$$0(20);
        }
        if (to == null) {
            ExpressionUtils.$$$reportNull$$$0(21);
        }
        if (diff == null) {
            ExpressionUtils.$$$reportNull$$$0(22);
        }
        if ((diff = PsiUtil.skipParenthesizedExprDown((PsiExpression)diff)) == null) {
            return false;
        }
        if (ExpressionUtils.isZero(from) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)to, (PsiElement)diff)) {
            return true;
        }
        if (diff instanceof PsiBinaryExpression && ((PsiBinaryExpression)diff).getOperationTokenType().equals(JavaTokenType.MINUS)) {
            PsiExpression left = ((PsiBinaryExpression)diff).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)diff).getROperand();
            if (right != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)to, (PsiElement)left) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)from, (PsiElement)right)) {
                return true;
            }
        }
        if ((fromConstant = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(from), Integer.class)) == null) {
            return false;
        }
        Integer toConstant = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(to), Integer.class);
        if (toConstant == null) {
            return false;
        }
        Integer diffConstant = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(diff), Integer.class);
        if (diffConstant == null) {
            return false;
        }
        return diffConstant == toConstant - fromConstant;
    }

    @Nullable
    public static PsiExpression getConstantArrayElement(PsiVariable array, int index) {
        if (index < 0) {
            return null;
        }
        PsiExpression[] elements = ExpressionUtils.getConstantArrayElements(array);
        if (elements == null || index >= elements.length) {
            return null;
        }
        return elements[index];
    }

    @Nullable
    public static PsiExpression[] getConstantArrayElements(PsiVariable array) {
        PsiExpression initializer = array.getInitializer();
        if (initializer instanceof PsiNewExpression) {
            initializer = ((PsiNewExpression)initializer).getArrayInitializer();
        }
        if (!(initializer instanceof PsiArrayInitializerExpression)) {
            return null;
        }
        PsiExpression[] initializers = ((PsiArrayInitializerExpression)initializer).getInitializers();
        if (!(!(array instanceof PsiField) || array.hasModifierProperty("private") && array.hasModifierProperty("static"))) {
            return null;
        }
        Boolean isConstantArray = (Boolean)CachedValuesManager.getCachedValue((PsiElement)array, () -> CachedValueProvider.Result.create((Object)ExpressionUtils.isConstantArray(array), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return Boolean.TRUE.equals(isConstantArray) ? initializers : null;
    }

    private static boolean isConstantArray(PsiVariable array) {
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)array, (Class[])new Class[]{array instanceof PsiField ? PsiClass.class : PsiCodeBlock.class});
        if (scope == null) {
            return false;
        }
        return PsiTreeUtil.processElements((PsiElement)scope, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)e;
            if (!ref.isReferenceTo((PsiElement)array)) {
                return true;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getParent());
            if (parent instanceof PsiForeachStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForeachStatement)parent).getIteratedValue(), (PsiElement)ref, (boolean)false)) {
                return true;
            }
            if (parent instanceof PsiReferenceExpression) {
                if (ExpressionUtils.isReferenceTo(ExpressionUtils.getArrayFromLengthExpression((PsiExpression)parent), array)) {
                    return true;
                }
                if (parent.getParent() instanceof PsiMethodCallExpression && MethodCallUtils.isCallToMethod((PsiMethodCallExpression)parent.getParent(), "java.lang.Object", null, "clone", PsiType.EMPTY_ARRAY)) {
                    return true;
                }
            }
            return parent instanceof PsiArrayAccessExpression && !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)parent));
        });
    }

    public static boolean isLocallyDefinedExpression(PsiExpression expression2) {
        return PsiTreeUtil.processElements((PsiElement)expression2, e -> {
            PsiElement target;
            if (e instanceof PsiMethodCallExpression) {
                return false;
            }
            if (e instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)e).resolve()) instanceof PsiField) {
                return ((PsiField)target).hasModifierProperty("final");
            }
            return !(e instanceof PsiArrayAccessExpression);
        });
    }

    @Nullable
    @Contract(value="null, _, _ -> null", pure=true)
    public static TextRange findStringLiteralRange(PsiExpression expression2, int from, int to) {
        if (to < 0 || from > to) {
            return null;
        }
        if (expression2 == null || !TypeUtils.isJavaLangString(expression2.getType())) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            String value2 = (String)ObjectUtils.tryCast((Object)((PsiLiteralExpression)expression2).getValue(), String.class);
            if (value2 == null || value2.length() < from || value2.length() < to) {
                return null;
            }
            return CodeInsightUtilCore.mapBackStringRange((String)expression2.getText(), (int)from, (int)to);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiExpression operand2 = ((PsiParenthesizedExpression)expression2).getExpression();
            TextRange range = ExpressionUtils.findStringLiteralRange(operand2, from, to);
            return range == null ? null : range.shiftRight(operand2.getStartOffsetInParent());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiExpression[] operands2;
            PsiPolyadicExpression concatenation = (PsiPolyadicExpression)expression2;
            if (concatenation.getOperationTokenType() != JavaTokenType.PLUS) {
                return null;
            }
            for (PsiExpression operand3 : operands2 = concatenation.getOperands()) {
                Object constantValue = ExpressionUtils.computeConstantExpression(operand3);
                if (constantValue == null) {
                    return null;
                }
                String stringValue = constantValue.toString();
                if (from < stringValue.length()) {
                    if (to > stringValue.length()) {
                        return null;
                    }
                    TextRange range = ExpressionUtils.findStringLiteralRange(operand3, from, to);
                    return range == null ? null : range.shiftRight(operand3.getStartOffsetInParent());
                }
                from -= stringValue.length();
                to -= stringValue.length();
            }
        }
        return null;
    }

    public static PsiExpression replacePolyadicWithParent(PsiExpression expressionToReplace, PsiExpression replacement) {
        return ExpressionUtils.replacePolyadicWithParent(expressionToReplace, replacement, new CommentTracker());
    }

    @Nullable
    public static PsiExpression replacePolyadicWithParent(PsiExpression expressionToReplace, PsiExpression replacement, CommentTracker tracker) {
        PsiElement parent = expressionToReplace.getParent();
        if (parent instanceof PsiPolyadicExpression && replacement instanceof PsiPolyadicExpression) {
            int idx;
            PsiPolyadicExpression parentPolyadic = (PsiPolyadicExpression)parent;
            PsiPolyadicExpression childPolyadic = (PsiPolyadicExpression)replacement;
            IElementType parentTokenType = parentPolyadic.getOperationTokenType();
            IElementType childTokenType = childPolyadic.getOperationTokenType();
            if (PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)parentTokenType) == PsiPrecedenceUtil.getPrecedenceForOperator((IElementType)childTokenType) && ((idx = ArrayUtil.indexOf((Object[])parentPolyadic.getOperands(), (Object)expressionToReplace)) > 0 || idx == 0 && parentTokenType == childTokenType)) {
                PsiElement[] children;
                PsiPolyadicExpression copyParentPolyadic = (PsiPolyadicExpression)parent.copy();
                copyParentPolyadic.getOperands()[idx].replace((PsiElement)replacement);
                PsiExpression recreateCopyFromText = JavaPsiFacade.getElementFactory((Project)parent.getProject()).createExpressionFromText(copyParentPolyadic.getText(), parent);
                for (PsiElement child : children = parent.getChildren()) {
                    if (child == expressionToReplace) continue;
                    tracker.markUnchanged(child);
                }
                return (PsiExpression)tracker.replaceAndRestoreComments(parent, (PsiElement)recreateCopyFromText);
            }
        }
        return null;
    }

    public static boolean isVoidContext(PsiExpression expression2) {
        PsiElement element = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        if (element instanceof PsiExpressionStatement) {
            if (element.getParent() instanceof PsiSwitchLabeledRuleStatement) {
                PsiSwitchBlock block = ((PsiSwitchLabeledRuleStatement)element.getParent()).getEnclosingSwitchBlock();
                return !(block instanceof PsiSwitchExpression);
            }
            return true;
        }
        if (element instanceof PsiExpressionList && element.getParent() instanceof PsiExpressionListStatement) {
            return true;
        }
        return element instanceof PsiLambdaExpression && PsiType.VOID.equals((Object)LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)element)));
    }

    @Nullable
    public static PsiExpression getExpressionComparedTo(@NotNull PsiExpression expression2) {
        PsiMethodCallExpression call;
        PsiBinaryExpression binOp;
        PsiElement parent;
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(23);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiBinaryExpression && ComparisonUtils.isEqualityComparison((PsiExpression)(binOp = (PsiBinaryExpression)parent))) {
            PsiExpression leftOperand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
            PsiExpression rightOperand2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
            return PsiTreeUtil.isAncestor((PsiElement)leftOperand2, (PsiElement)expression2, (boolean)false) ? rightOperand2 : leftOperand2;
        }
        if (parent instanceof PsiExpressionList && (call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)parent.getParent(), PsiMethodCallExpression.class)) != null && MethodCallUtils.isEqualsCall(call)) {
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)call.getMethodExpression().getQualifierExpression());
        }
        call = ExpressionUtils.getCallForQualifier(expression2);
        if (call != null && MethodCallUtils.isEqualsCall(call)) {
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions())));
        }
        return null;
    }

    public static boolean isArrayCreationExpression(@NotNull PsiNewExpression expression2) {
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(24);
        }
        return expression2.getArrayInitializer() != null || expression2.getArrayDimensions().length > 0;
    }

    @NotNull
    public static PsiExpression getTopLevelExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            ExpressionUtils.$$$reportNull$$$0(25);
        }
        while (true) {
            PsiElement parent;
            if ((parent = expression2.getParent()) instanceof PsiExpression && !(parent instanceof PsiLambdaExpression)) {
                expression2 = (PsiExpression)parent;
                continue;
            }
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiExpression)) break;
            expression2 = (PsiExpression)parent.getParent();
        }
        PsiExpression psiExpression = expression2;
        if (psiExpression == null) {
            ExpressionUtils.$$$reportNull$$$0(26);
        }
        return psiExpression;
    }

    public static PsiElement getPassThroughParent(PsiExpression expression2) {
        PsiElement parent;
        while (true) {
            PsiElement exitedElement;
            if ((parent = expression2.getParent()) instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
                expression2 = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != expression2) {
                expression2 = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiExpressionStatement) {
                PsiSwitchBlock block;
                PsiElement grandParent = parent.getParent();
                if (!(grandParent instanceof PsiSwitchLabeledRuleStatement) || !((block = ((PsiSwitchLabeledRuleStatement)grandParent).getEnclosingSwitchBlock()) instanceof PsiSwitchExpression)) break;
                expression2 = (PsiExpression)block;
                continue;
            }
            if (!(parent instanceof PsiBreakStatement) || !((exitedElement = ((PsiBreakStatement)parent).findExitedElement()) instanceof PsiSwitchExpression)) break;
            expression2 = (PsiExpression)exitedElement;
        }
        return parent;
    }

    public static boolean isImplicitToStringCall(PsiExpression expression2) {
        if (ExpressionUtils.isStringConcatenationOperand(expression2)) {
            return true;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
        while (parent instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)expression2, (boolean)false)) {
            parent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
        }
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return false;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)grandParent;
            if (!IMPLICIT_TO_STRING_METHOD_NAMES.contains(call.getMethodExpression().getReferenceName())) {
                return false;
            }
            PsiExpression[] arguments = expressionList.getExpressions();
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String className = containingClass.getQualifiedName();
            if (className == null) {
                return false;
            }
            switch (methodName) {
                case "append": {
                    if (arguments.length != 1) {
                        return false;
                    }
                    if (!className.equals("java.lang.StringBuilder") && !className.equals("java.lang.StringBuffer")) {
                        return false;
                    }
                    return !ExpressionUtils.hasCharArrayParameter(method);
                }
                case "valueOf": {
                    if (arguments.length != 1 || !"java.lang.String".equals(className)) {
                        return false;
                    }
                    return !ExpressionUtils.hasCharArrayParameter(method);
                }
                case "print": 
                case "println": {
                    if (arguments.length != 1 || ExpressionUtils.hasCharArrayParameter(method)) {
                        return false;
                    }
                    return "java.util.Formatter".equals(className) || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintStream") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintWriter");
                }
                case "printf": 
                case "format": {
                    int minArguments;
                    if (arguments.length < 1) {
                        return false;
                    }
                    PsiParameterList parameterList = method.getParameterList();
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    PsiParameter parameter2 = parameters2[0];
                    PsiType firstParameterType = parameter2.getType();
                    int n = minArguments = firstParameterType.equalsToText("java.util.Locale") ? 4 : 3;
                    if (arguments.length < minArguments) {
                        return false;
                    }
                    return "java.lang.String".equals(className) || "java.util.Formatter".equals(className) || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintStream") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"java.io.PrintWriter");
                }
            }
        }
        return false;
    }

    private static boolean hasCharArrayParameter(PsiMethod method) {
        PsiParameter parameter2 = (PsiParameter)ArrayUtil.getFirstElement((Object[])method.getParameterList().getParameters());
        return parameter2 == null || parameter2.getType().equalsToText("char[]");
    }

    static {
        convertableBoxedClassNames.add("java.lang.Byte");
        convertableBoxedClassNames.add("java.lang.Character");
        convertableBoxedClassNames.add("java.lang.Short");
        KNOWN_SIMPLE_CALLS = CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet", "emptyIterator", "emptyMap", "emptySortedMap", "emptySortedSet", "emptyListIterator").parameterCount(0);
        GET_OR_DEFAULT = CallMatcher.instanceCall("java.util.Map", "getOrDefault").parameterCount(2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binOp";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/psiutils/ExpressionUtils";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierOrThis";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nonStructuralChildren";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetArrayAccess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expressionIsOffsetVariableLookup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVariableLessThanComparison";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isVariableGreaterThanComparison";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isNegative";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithNull";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValueComparedWithZero";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAutoBoxed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierOrThis";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "bindReferenceTo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "bindCallTo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingChildAlwaysExecuted";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDifference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionComparedTo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isArrayCreationExpression";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

