/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PlaceholderCountMatchesArgumentCountInspection
extends BaseInspection {
    @NonNls
    static final Set<String> loggingMethodNames = ContainerUtilRt.newHashSet((Object[])new String[]{"log", "trace", "debug", "info", "warn", "error", "fatal"});

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.display.name", new Object[0]);
        if (string == null) {
            PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer argumentCount = (Integer)infos[0];
        Integer placeholderCount = (Integer)infos[1];
        String string = argumentCount > placeholderCount ? InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.more.problem.descriptor", argumentCount, placeholderCount) : InspectionGadgetsBundle.message("placeholder.count.matches.argument.count.fewer.problem.descriptor", argumentCount, placeholderCount);
        if (string == null) {
            PlaceholderCountMatchesArgumentCountInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PlaceholderCountMatchesArgumentCountVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/logging/PlaceholderCountMatchesArgumentCountInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class PlaceholderCountMatchesArgumentCountVisitor
    extends BaseInspectionVisitor {
        private PlaceholderCountMatchesArgumentCountVisitor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
            PsiExpression logStringArgument;
            int placeholderCount;
            PsiExpression argument;
            PsiType argumentType;
            int index;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!loggingMethodNames.contains(name)) {
                return;
            }
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.slf4j.Logger") && !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"org.apache.logging.log4j.Logger")) {
                return;
            }
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            if (parameters2.length == 0) {
                return;
            }
            if (!TypeUtils.isJavaLangString(parameters2[0].getType())) {
                if (parameters2.length < 2 || !TypeUtils.isJavaLangString(parameters2[1].getType())) {
                    return;
                }
                index = 2;
            } else {
                index = 1;
            }
            PsiExpression[] arguments = expression2.getArgumentList().getExpressions();
            int argumentCount = arguments.length - index;
            boolean lastArgumentIsException = PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(arguments[arguments.length - 1]);
            if (argumentCount == 1 && (argumentType = (argument = arguments[index]).getType()) instanceof PsiArrayType) {
                if (!argumentType.equalsToText("java.lang.Object[]") || !(argument instanceof PsiNewExpression)) return;
                PsiNewExpression newExpression = (PsiNewExpression)argument;
                PsiArrayInitializerExpression arrayInitializerExpression = newExpression.getArrayInitializer();
                if (arrayInitializerExpression == null) return;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                argumentCount = initializers.length;
                lastArgumentIsException = initializers.length > 0 && PlaceholderCountMatchesArgumentCountVisitor.hasThrowableType(initializers[initializers.length - 1]);
            }
            if ((placeholderCount = PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(logStringArgument = arguments[index - 1])) < 0 || placeholderCount == argumentCount && (!lastArgumentIsException || argumentCount > 1) || placeholderCount == argumentCount - 1 && lastArgumentIsException) {
                return;
            }
            this.registerError((PsiElement)logStringArgument, lastArgumentIsException ? argumentCount - 1 : argumentCount, placeholderCount);
        }

        private static boolean hasThrowableType(PsiExpression lastArgument) {
            PsiType type2 = lastArgument.getType();
            if (type2 instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type2;
                for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                    if (InheritanceUtil.isInheritor((PsiType)disjunction, (String)"java.lang.Throwable")) continue;
                    return false;
                }
                return true;
            }
            return InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Throwable");
        }

        public static int countPlaceholders(PsiExpression expression2) {
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            if (value2 == null) {
                StringBuilder builder = new StringBuilder();
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(expression2, builder) ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders(builder.toString()) : -1;
            }
            return value2 instanceof String ? PlaceholderCountMatchesArgumentCountVisitor.countPlaceholders((String)value2) : 0;
        }

        private static boolean buildString(PsiExpression expression2, StringBuilder builder) {
            if (expression2 == null) {
                return false;
            }
            PsiType type2 = expression2.getType();
            if (expression2 instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
                return PlaceholderCountMatchesArgumentCountVisitor.buildString(parenthesizedExpression.getExpression(), builder);
            }
            if (expression2 instanceof PsiPolyadicExpression) {
                if (!TypeUtils.isJavaLangString(type2) && !PsiType.CHAR.equals((Object)type2)) {
                    return true;
                }
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression2;
                for (PsiExpression operand2 : polyadicExpression.getOperands()) {
                    if (PlaceholderCountMatchesArgumentCountVisitor.buildString(operand2, builder)) continue;
                    return false;
                }
                return true;
            }
            if (expression2 instanceof PsiLiteralExpression) {
                if (TypeUtils.isJavaLangString(type2) || PsiType.CHAR.equals((Object)type2)) {
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)expression2;
                    builder.append(literalExpression.getValue());
                }
                return true;
            }
            if (!TypeUtils.isJavaLangString(type2)) {
                return true;
            }
            Object value2 = ExpressionUtils.computeConstantExpression(expression2);
            if (value2 == null) {
                return false;
            }
            builder.append(value2);
            return true;
        }

        private static int countPlaceholders(String string) {
            int count = 0;
            int length = string.length();
            boolean escaped = false;
            boolean placeholder = false;
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                if (c == '\\') {
                    escaped = !escaped;
                    continue;
                }
                if (c == '{') {
                    if (escaped) continue;
                    placeholder = true;
                    continue;
                }
                if (c == '}') {
                    if (!placeholder) continue;
                    ++count;
                    placeholder = false;
                    continue;
                }
                escaped = false;
                placeholder = false;
            }
            return count;
        }
    }
}

