/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ImportUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceAssertEqualsFix
extends InspectionGadgetsFix {
    @NotNull
    private final String myMethodName;

    ReplaceAssertEqualsFix(@NotNull String methodName) {
        if (methodName == null) {
            ReplaceAssertEqualsFix.$$$reportNull$$$0(0);
        }
        this.myMethodName = methodName;
    }

    @NotNull
    public String getFamilyName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myMethodName});
        if (string == null) {
            ReplaceAssertEqualsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
        PsiElement grandParent = methodExpression.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        String className = containingClass.getQualifiedName();
        if (className == null) {
            return;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null && ImportUtils.addStaticImport(className, this.myMethodName, (PsiElement)methodExpression)) {
            PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, this.myMethodName, new CommentTracker());
        } else {
            PsiReplacementUtil.replaceExpression((PsiExpression)methodExpression, StringUtil.getQualifiedName((String)className, (String)this.myMethodName), new CommentTracker());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/junit/ReplaceAssertEqualsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/junit/ReplaceAssertEqualsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

