/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.encapsulation;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

class ReplaceWithCloneFix
extends InspectionGadgetsFix {
    private final String myName;

    ReplaceWithCloneFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myName + ".clone()"});
        if (string == null) {
            ReplaceWithCloneFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"clone()"});
        if (string == null) {
            ReplaceWithCloneFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
        if (referenceExpression.getType() instanceof PsiArrayType) {
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, referenceExpression.getText() + ".clone()");
        } else {
            String type2 = TypeUtils.expressionHasTypeOrSubtype((PsiExpression)referenceExpression, "java.util.Date", "java.util.Calendar");
            if (type2 == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)referenceExpression, '(' + type2 + ')' + referenceExpression.getText() + ".clone()");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/encapsulation/ReplaceWithCloneFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

