/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.fixes.CreateDefaultBranchFix;
import com.siyeh.ig.psiutils.SwitchUtils;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementsWithoutDefaultInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean m_ignoreFullyCoveredEnums = true;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statements.without.default.display.name", new Object[0]);
        if (string == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        if ("SwitchStatementWithoutDefaultBranch" == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(1);
        }
        return "SwitchStatementWithoutDefaultBranch";
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("switch.statement.without.default.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreFullyCoveredEnums");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(2);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitSwitchStatement(statement);
                int count = SwitchUtils.calculateBranchCount(statement);
                if (count < 0 || statement.getBody() == null) {
                    return;
                }
                boolean infoMode = false;
                if (count == 0 || SwitchStatementsWithoutDefaultInspection.this.m_ignoreFullyCoveredEnums && this.switchStatementIsFullyCoveredEnum(statement)) {
                    if (!isOnTheFly) {
                        return;
                    }
                    infoMode = true;
                }
                String message2 = InspectionGadgetsBundle.message("switch.statements.without.default.problem.descriptor", new Object[0]);
                if (infoMode || isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)SwitchStatementsWithoutDefaultInspection.this.getShortName(), (PsiElement)statement)) {
                    holder.registerProblem((PsiElement)statement, message2, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new CreateDefaultBranchFix((PsiSwitchBlock)statement, null)});
                } else {
                    holder.registerProblem(statement.getFirstChild(), message2, new LocalQuickFix[]{new CreateDefaultBranchFix((PsiSwitchBlock)statement, null)});
                }
            }

            private boolean switchStatementIsFullyCoveredEnum(PsiSwitchStatement statement) {
                PsiExpression expression2 = statement.getExpression();
                if (expression2 == null) {
                    return true;
                }
                PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
                if (aClass == null || !aClass.isEnum()) {
                    return false;
                }
                List labels2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement.getBody(), PsiSwitchLabelStatementBase.class);
                Set constants = StreamEx.of((Collection)labels2).flatCollection(SwitchUtils::findEnumConstants).toSet();
                for (PsiField field : aClass.getFields()) {
                    if (!(field instanceof PsiEnumConstant) || constants.remove(field)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection$1", "visitSwitchStatement"));
            }
        };
        if (javaElementVisitor == null) {
            SwitchStatementsWithoutDefaultInspection.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/controlflow/SwitchStatementsWithoutDefaultInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

