/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class StaticCallOnSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        if ("StaticMethodReferencedViaSubclass" == null) {
            StaticCallOnSubclassInspection.$$$reportNull$$$0(0);
        }
        return "StaticMethodReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.method.via.subclass.display.name", new Object[0]);
        if (string == null) {
            StaticCallOnSubclassInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        String string = InspectionGadgetsBundle.message("static.method.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
        if (string == null) {
            StaticCallOnSubclassInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticCallOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticCallOnSubclassVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/StaticCallOnSubclassInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class StaticCallOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticCallOnSubclassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                StaticCallOnSubclassVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            this.checkCallOnSubclass(method, methodExpression);
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            PsiElement resolve;
            super.visitMethodReferenceExpression(expression2);
            if (PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)expression2) && (resolve = expression2.resolve()) instanceof PsiMethod) {
                this.checkCallOnSubclass((PsiMethod)resolve, (PsiReferenceExpression)expression2);
            }
        }

        private void checkCallOnSubclass(@NotNull PsiMethod method, PsiReferenceExpression methodExpression) {
            if (method == null) {
                StaticCallOnSubclassVisitor.$$$reportNull$$$0(1);
            }
            if (!method.hasModifierProperty("static")) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)referent;
            PsiClass declaringClass = method.getContainingClass();
            if (declaringClass == null) {
                return;
            }
            if (declaringClass.equals(referencedClass) || declaringClass.isInterface()) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)methodExpression.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible((PsiMember)declaringClass, (PsiElement)methodExpression, null)) {
                return;
            }
            PsiElement referenceNameElement2 = methodExpression.getReferenceNameElement();
            if (referenceNameElement2 == null) {
                return;
            }
            this.registerError(referenceNameElement2, declaringClass, referencedClass);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/bugs/StaticCallOnSubclassInspection$StaticCallOnSubclassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkCallOnSubclass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StaticCallOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticCallOnSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("static.method.via.subclass.rationalize.quickfix", new Object[0]);
            if (string == null) {
                StaticCallOnSubclassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiIdentifier name = (PsiIdentifier)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiIdentifier.class);
            if (name == null) {
                return;
            }
            PsiReferenceExpression expression2 = (PsiReferenceExpression)ObjectUtils.tryCast((Object)name.getParent(), PsiReferenceExpression.class);
            if (expression2 == null) {
                return;
            }
            if (expression2 instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression2;
                PsiClass containingClass;
                PsiElement resolve = expression2.resolve();
                if (resolve instanceof PsiMethod && (containingClass = ((PsiMethod)resolve).getContainingClass()) != null && (qualifierExpression2 = expression2.getQualifierExpression()) instanceof PsiReferenceExpression) {
                    ((PsiReferenceExpression)qualifierExpression2).bindToElement((PsiElement)containingClass);
                }
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2.getParent(), PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            PsiExpressionList argumentList = call.getArgumentList();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            CommentTracker commentTracker = new CommentTracker();
            String argText = commentTracker.text((PsiElement)argumentList);
            String typeArgText = commentTracker.text((PsiElement)call.getTypeArgumentList());
            String methodName = expression2.getReferenceName();
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, containingClassName + '.' + typeArgText + methodName + argText, commentTracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/StaticCallOnSubclassInspection$StaticCallOnSubclassFix", "getFamilyName"));
        }
    }
}

