/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.BaseEqualsVisitor;
import com.siyeh.ig.bugs.InconvertibleTypesChecker;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    public boolean WARN_IF_NO_MUTUAL_SUBCLASS_FOUND = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.display.name", new Object[0]);
        if (string == null) {
            EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.between.inconvertible.types.mutual.subclass.option", new Object[0]), (InspectionProfileEntry)this, "WARN_IF_NO_MUTUAL_SUBCLASS_FOUND");
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        boolean convertible = (Boolean)infos[2];
        if (convertible) {
            String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.no.mutual.subclass.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
            if (string == null) {
                EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
        if (string == null) {
            EqualsBetweenInconvertibleTypesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsBetweenInconvertibleTypesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class EqualsBetweenInconvertibleTypesVisitor
    extends BaseEqualsVisitor {
        private EqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitBinaryExpression(PsiBinaryExpression expression2) {
            super.visitBinaryExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ) && !tokenType.equals(JavaTokenType.NE)) {
                return;
            }
            PsiExpression lhs = expression2.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiExpression rhs = expression2.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (lhsType == null || rhsType == null || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lhsType) || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rhsType) || !TypeUtils.areConvertible(lhsType, rhsType)) {
                return;
            }
            this.createInconvertibleTypesChecker().deepCheck(lhsType, rhsType, (PsiElement)expression2.getOperationSign(), new HashMap<PsiType, PsiType>(), EqualsBetweenInconvertibleTypesInspection.this.WARN_IF_NO_MUTUAL_SUBCLASS_FOUND, this.isOnTheFly());
        }

        @Override
        public void checkTypes(@NotNull PsiReferenceExpression expression2, @NotNull PsiType leftType, @NotNull PsiType rightType) {
            if (expression2 == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(0);
            }
            if (leftType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(1);
            }
            if (rightType == null) {
                EqualsBetweenInconvertibleTypesVisitor.$$$reportNull$$$0(2);
            }
            this.createInconvertibleTypesChecker().checkTypes(expression2, leftType, rightType, EqualsBetweenInconvertibleTypesInspection.this.WARN_IF_NO_MUTUAL_SUBCLASS_FOUND, this.isOnTheFly());
        }

        private InconvertibleTypesChecker createInconvertibleTypesChecker() {
            return new InconvertibleTypesChecker(){

                @Override
                protected void registerEqualsError(PsiElement highlightLocation, @NotNull PsiType leftType, @NotNull PsiType rightType, boolean convertible) {
                    if (leftType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (rightType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    EqualsBetweenInconvertibleTypesVisitor.this.registerError(highlightLocation, new Object[]{leftType, rightType, convertible});
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "leftType";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "rightType";
                            break;
                        }
                    }
                    objectArray[1] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection$EqualsBetweenInconvertibleTypesVisitor$1";
                    objectArray[2] = "registerEqualsError";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rightType";
                    break;
                }
            }
            objectArray[1] = "com/siyeh/ig/bugs/EqualsBetweenInconvertibleTypesInspection$EqualsBetweenInconvertibleTypesVisitor";
            objectArray[2] = "checkTypes";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

