/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ReorderingUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class VariableExtractor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceVariable.VariableExtractor");
    private final Project myProject;
    private final Editor myEditor;
    private final IntroduceVariableSettings mySettings;
    private final PsiExpression myExpression;
    private PsiElement myAnchor;
    private final PsiElement myContainer;
    private final PsiExpression[] myOccurrences;
    private final boolean myReplaceSelf;
    private final FieldConflictsResolver myFieldConflictsResolver;
    private final LogicalPosition myPosition;

    private VariableExtractor(Project project, PsiExpression expression2, Editor editor, PsiElement anchorStatement, PsiExpression[] occurrences, IntroduceVariableSettings settings) {
        this.myProject = project;
        this.myExpression = expression2;
        this.myEditor = editor;
        this.myOccurrences = occurrences;
        this.mySettings = settings;
        this.myContainer = anchorStatement.getParent();
        this.myAnchor = VariableExtractor.correctAnchor(expression2, anchorStatement, occurrences);
        this.myReplaceSelf = settings.isReplaceLValues() || !RefactoringUtil.isAssignmentLHS((PsiElement)expression2);
        PsiCodeBlock newDeclarationScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)this.myContainer, PsiCodeBlock.class, (boolean)false);
        this.myFieldConflictsResolver = new FieldConflictsResolver(settings.getEnteredName(), newDeclarationScope);
        this.myPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : null;
    }

    private SmartPsiElementPointer<PsiVariable> extractVariable() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        try {
            PsiExpression newExpr = this.myFieldConflictsResolver.fixInitializer(this.myExpression);
            PsiExpression initializer = RefactoringUtil.unparenthesizeExpression(newExpr);
            SmartTypePointer selectedType = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.mySettings.getSelectedType());
            initializer = IntroduceVariableBase.simplifyVariableInitializer(initializer, selectedType.getType());
            CommentTracker commentTracker = new CommentTracker();
            commentTracker.markUnchanged(initializer);
            initializer = (PsiExpression)initializer.copy();
            PsiType type2 = VariableExtractor.stripNullabilityAnnotationsFromTargetType(selectedType, this.myProject);
            PsiElement declaration2 = this.createDeclaration(type2, this.mySettings.getEnteredName(), initializer);
            this.replaceOccurrences(newExpr);
            this.ensureCodeBlock();
            PsiVariable var = this.addVariable(declaration2, initializer);
            if (this.myAnchor instanceof PsiExpressionStatement && ExpressionUtils.isReferenceTo(((PsiExpressionStatement)this.myAnchor).getExpression(), var)) {
                commentTracker.deleteAndRestoreComments(this.myAnchor);
                if (this.myEditor != null) {
                    this.myEditor.getCaretModel().moveToLogicalPosition(this.myPosition);
                    this.myEditor.getCaretModel().moveToOffset(var.getTextRange().getEndOffset());
                    this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    this.myEditor.getSelectionModel().removeSelection();
                }
            }
            this.highlight(var);
            PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)this.mySettings.isDeclareFinal());
            if (this.mySettings.isDeclareVarType()) {
                PsiTypeElement typeElement = var.getTypeElement();
                LOG.assertTrue(typeElement != null);
                IntroduceVariableBase.expandDiamondsAndReplaceExplicitTypeWithVar(typeElement, (PsiElement)var);
            }
            this.myFieldConflictsResolver.fix();
            return SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)var);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private void ensureCodeBlock() {
        if (this.myAnchor instanceof PsiStatement && RefactoringUtil.isLoopOrIf(this.myAnchor.getParent())) {
            this.myAnchor = BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)this.myAnchor);
        }
        if (this.myAnchor instanceof PsiExpression) {
            this.myAnchor = RefactoringUtil.getParentStatement((PsiElement)RefactoringUtil.ensureCodeBlock((PsiExpression)this.myAnchor), false);
        }
    }

    private void highlight(PsiVariable var) {
        if (this.myEditor != null) {
            PsiElement[] occurrences = PsiTreeUtil.collectElements((PsiElement)this.myContainer, e -> e instanceof PsiReference && ((PsiReference)e).isReferenceTo((PsiElement)var));
            IntroduceVariableBase.highlightReplacedOccurrences(this.myProject, this.myEditor, occurrences);
        }
    }

    private void replaceOccurrences(PsiExpression newExpr) {
        assert (this.myAnchor.isValid());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiExpression ref = elementFactory.createExpressionFromText(this.mySettings.getEnteredName(), null);
        boolean needReplaceSelf = this.myReplaceSelf;
        if (this.mySettings.isReplaceAllOccurrences()) {
            for (PsiExpression occurrence : this.myOccurrences) {
                PsiExpression correctedOccurrence = occurrence.equals(this.myExpression) ? newExpr : occurrence;
                correctedOccurrence = RefactoringUtil.outermostParenthesizedExpression(correctedOccurrence);
                if (!this.mySettings.isReplaceLValues() && RefactoringUtil.isAssignmentLHS((PsiElement)correctedOccurrence)) continue;
                PsiElement replacement = IntroduceVariableBase.replace(correctedOccurrence, ref, this.myProject);
                if (this.myAnchor.isValid()) continue;
                this.myAnchor = replacement;
            }
            needReplaceSelf &= newExpr instanceof PsiPolyadicExpression && newExpr.isValid() && !newExpr.isPhysical();
        }
        if (needReplaceSelf) {
            PsiElement replacement = IntroduceVariableBase.replace(newExpr, ref, this.myProject);
            if (!this.myAnchor.isValid()) {
                this.myAnchor = replacement;
            }
        }
    }

    private PsiVariable addVariable(PsiElement declaration2, PsiExpression initializer) {
        declaration2 = VariableExtractor.addDeclaration(declaration2, initializer, this.myAnchor);
        declaration2 = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(declaration2);
        return (PsiVariable)(declaration2 instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)declaration2).getDeclaredElements()[0] : declaration2);
    }

    @NotNull
    private PsiElement createDeclaration(@NotNull PsiType type2, @NotNull String name, PsiExpression initializer) {
        if (type2 == null) {
            VariableExtractor.$$$reportNull$$$0(0);
        }
        if (name == null) {
            VariableExtractor.$$$reportNull$$$0(1);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        if (this.myContainer instanceof PsiClass) {
            PsiField declaration2 = elementFactory.createField(name, type2);
            declaration2.setInitializer(initializer);
            PsiField psiField = declaration2;
            if (psiField == null) {
                VariableExtractor.$$$reportNull$$$0(2);
            }
            return psiField;
        }
        PsiDeclarationStatement psiDeclarationStatement = elementFactory.createVariableDeclarationStatement(name, type2, initializer, this.myContainer);
        if (psiDeclarationStatement == null) {
            VariableExtractor.$$$reportNull$$$0(3);
        }
        return psiDeclarationStatement;
    }

    private static PsiElement addDeclaration(PsiElement declaration2, PsiExpression initializer, PsiElement anchor) {
        PsiElement[] declaredElements;
        if (anchor instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()).length > 1) {
            final int[] usedFirstVar = new int[]{-1};
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    int i = ArrayUtilRt.find((Object[])declaredElements, (Object)expression2.resolve());
                    if (i > -1) {
                        usedFirstVar[0] = Math.max(i, usedFirstVar[0]);
                    }
                    super.visitReferenceExpression(expression2);
                }
            });
            if (usedFirstVar[0] > -1) {
                PsiVariable psiVariable = (PsiVariable)declaredElements[usedFirstVar[0]];
                psiVariable.normalizeDeclaration();
                PsiDeclarationStatement parDeclarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
                return anchor.getParent().addAfter(declaration2, (PsiElement)parDeclarationStatement);
            }
        }
        if (anchor instanceof PsiResourceListElement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)declaration2;
            PsiLocalVariable localVariable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
            PsiResourceVariable resourceVariable = JavaPsiFacade.getElementFactory((Project)anchor.getProject()).createResourceVariable(Objects.requireNonNull(localVariable.getName()), localVariable.getType(), initializer, anchor);
            return anchor.replace((PsiElement)resourceVariable);
        }
        return anchor.getParent().addBefore(declaration2, anchor);
    }

    @NotNull
    private static PsiType stripNullabilityAnnotationsFromTargetType(SmartTypePointer selectedType, final Project project) {
        PsiType type2 = selectedType.getType();
        if (type2 == null) {
            throw new IncorrectOperationException("Unexpected empty type pointer");
        }
        final PsiAnnotation[] annotations2 = type2.getAnnotations();
        PsiType psiType = type2.annotate(new TypeAnnotationProvider(){

            @NotNull
            public PsiAnnotation[] getAnnotations() {
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
                HashSet nullables = new HashSet();
                nullables.addAll(manager.getNotNulls());
                nullables.addAll(manager.getNullables());
                PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])Arrays.stream(annotations2).filter(annotation -> !nullables.contains(annotation.getQualifiedName())).toArray(PsiAnnotation[]::new);
                if (psiAnnotationArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return psiAnnotationArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/introduceVariable/VariableExtractor$2", "getAnnotations"));
            }
        });
        if (psiType == null) {
            VariableExtractor.$$$reportNull$$$0(4);
        }
        return psiType;
    }

    @NotNull
    private static PsiElement correctAnchor(PsiExpression expr, @NotNull PsiElement anchor, PsiExpression[] occurrences) {
        PsiSwitchBlock block;
        PsiExpression ancestorCandidate;
        PsiExpression condition2;
        if (anchor == null) {
            VariableExtractor.$$$reportNull$$$0(5);
        }
        PsiExpression firstOccurrence = StreamEx.of((Object[])occurrences).append((Object)expr).minBy(e -> e.getTextRange().getStartOffset()).orElse(null);
        if (anchor instanceof PsiWhileStatement && (condition2 = ((PsiWhileStatement)anchor).getCondition()) != null && firstOccurrence != null && PsiTreeUtil.isAncestor((PsiElement)condition2, (PsiElement)firstOccurrence, (boolean)false)) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition2), PsiPolyadicExpression.class);
            if (polyadic != null && JavaTokenType.ANDAND.equals(polyadic.getOperationTokenType())) {
                PsiExpression operand2 = (PsiExpression)ContainerUtil.find((Object[])polyadic.getOperands(), op -> PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)firstOccurrence, (boolean)false));
                LOG.assertTrue(operand2 != null);
                PsiExpression psiExpression = operand2;
                if (psiExpression == null) {
                    VariableExtractor.$$$reportNull$$$0(6);
                }
                return psiExpression;
            }
            PsiExpression psiExpression = condition2;
            if (psiExpression == null) {
                VariableExtractor.$$$reportNull$$$0(7);
            }
            return psiExpression;
        }
        if (firstOccurrence != null && ControlFlowUtils.canExtractStatement(firstOccurrence) && !PsiUtil.isAccessedForWriting((PsiExpression)firstOccurrence) && PsiTreeUtil.isAncestor((PsiElement)anchor, (PsiElement)(ancestorCandidate = ExpressionUtils.getTopLevelExpression(firstOccurrence)), (boolean)false) && ReorderingUtils.canExtract(ancestorCandidate, firstOccurrence) == ThreeState.NO) {
            PsiExpression psiExpression = firstOccurrence;
            if (psiExpression == null) {
                VariableExtractor.$$$reportNull$$$0(8);
            }
            return psiExpression;
        }
        if (anchor instanceof PsiTryStatement && firstOccurrence != null) {
            PsiResourceList resourceList = ((PsiTryStatement)anchor).getResourceList();
            PsiElement parent = firstOccurrence.getParent();
            if (resourceList != null && parent instanceof PsiResourceExpression && parent.getParent() == resourceList && InheritanceUtil.isInheritor((PsiType)firstOccurrence.getType(), (String)"java.lang.AutoCloseable")) {
                PsiElement psiElement = parent;
                if (psiElement == null) {
                    VariableExtractor.$$$reportNull$$$0(9);
                }
                return psiElement;
            }
        }
        if (anchor.getParent() instanceof PsiSwitchLabeledRuleStatement) {
            PsiExpression psiExpression = ExpressionUtils.getTopLevelExpression(expr);
            if (psiExpression == null) {
                VariableExtractor.$$$reportNull$$$0(10);
            }
            return psiExpression;
        }
        if (anchor instanceof PsiSwitchLabelStatement && (block = ((PsiSwitchLabelStatement)anchor).getEnclosingSwitchBlock()) instanceof PsiSwitchStatement) {
            PsiSwitchBlock psiSwitchBlock = block;
            if (psiSwitchBlock == null) {
                VariableExtractor.$$$reportNull$$$0(11);
            }
            return psiSwitchBlock;
        }
        if (RefactoringUtil.isLoopOrIf(anchor.getParent())) {
            PsiElement psiElement = anchor;
            if (psiElement == null) {
                VariableExtractor.$$$reportNull$$$0(12);
            }
            return psiElement;
        }
        PsiElement child = VariableExtractor.locateAnchor(anchor);
        if (IntroduceVariableBase.isFinalVariableOnLHS(expr)) {
            child = child.getNextSibling();
        }
        PsiElement psiElement = child == null ? anchor : child;
        if (psiElement == null) {
            VariableExtractor.$$$reportNull$$$0(13);
        }
        return psiElement;
    }

    private static PsiElement locateAnchor(PsiElement child) {
        PsiElement prev;
        while (child != null && !((prev = child.getPrevSibling()) instanceof PsiStatement) && !PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.LBRACE)) {
            child = prev;
        }
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getNextSibling();
        }
        return child;
    }

    public static PsiVariable introduce(Project project, PsiExpression expr, Editor editor, PsiElement anchorStatement, PsiExpression[] occurrences, IntroduceVariableSettings settings) {
        Computable computation = new VariableExtractor(project, expr, editor, anchorStatement, occurrences, settings)::extractVariable;
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)ApplicationManager.getApplication().runWriteAction(computation);
        return pointer != null ? (PsiVariable)pointer.getElement() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceVariable/VariableExtractor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceVariable/VariableExtractor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "stripNullabilityAnnotationsFromTargetType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "correctAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeclaration";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "correctAnchor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

