/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.rename.RenameJavaVariableProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExpressionToFieldHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler");
    private final boolean myIsConstant;
    private PsiClass myParentClass;

    protected BaseExpressionToFieldHandler(boolean isConstant) {
        this.myIsConstant = isConstant;
    }

    @Override
    protected boolean invokeImpl(final Project project, final @NotNull PsiExpression selectedExpr, final Editor editor) {
        AbstractInplaceIntroducer activeIntroducer;
        boolean shouldSuggestDialog;
        PsiType tempType;
        PsiElement element;
        PsiFile file;
        if (selectedExpr == null) {
            BaseExpressionToFieldHandler.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((file = (element = BaseExpressionToFieldHandler.getPhysicalElement(selectedExpr)).getContainingFile()) != null, (Object)"expr.getContainingFile() == null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + selectedExpr);
        }
        if ((tempType = BaseExpressionToFieldHandler.getTypeByExpression(selectedExpr)) == null || LambdaUtil.notInferredType((PsiType)tempType)) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"unknown.expression.type"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        if (PsiType.VOID.equals((Object)tempType)) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.expression.has.void.type"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        String switchLabelError = RefactoringUtil.checkEnumConstantInSwitchLabel(selectedExpr);
        if (switchLabelError != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)switchLabelError, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        this.myParentClass = this.getParentClass(selectedExpr);
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>();
        PsiClass aClass = this.myParentClass;
        while (aClass != null) {
            classes2.add(aClass);
            PsiField psiField = ConvertToFieldRunnable.checkForwardRefs(selectedExpr, aClass);
            if (psiField != null && psiField.getParent() == aClass) break;
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        }
        boolean bl = shouldSuggestDialog = (activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor)) instanceof InplaceIntroduceConstantPopup && activeIntroducer.startsOnTheSameElement((PsiElement)selectedExpr, null);
        if (classes2.size() == 1 || editor == null || ApplicationManager.getApplication().isUnitTestMode() || shouldSuggestDialog) {
            return !this.convertExpressionToField(selectedExpr, editor, file, project, tempType);
        }
        if (!classes2.isEmpty()) {
            PsiClass selection = AnonymousTargetClassPreselectionUtil.getPreselection(classes2, this.myParentClass);
            NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])classes2.toArray(PsiClass.EMPTY_ARRAY)), (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)("Choose class to introduce " + (this.myIsConstant ? "constant" : "field")), (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AnonymousTargetClassPreselectionUtil.rememberSelection(aClass, BaseExpressionToFieldHandler.this.myParentClass);
                    BaseExpressionToFieldHandler.this.myParentClass = aClass;
                    BaseExpressionToFieldHandler.this.convertExpressionToField(selectedExpr, editor, file, project, tempType);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$1", "execute"));
                }
            }, (PsiElement)selection).showInBestPositionFor(editor);
        }
        return true;
    }

    private boolean convertExpressionToField(PsiExpression selectedExpr, @Nullable Editor editor, PsiFile file, Project project, PsiType tempType) {
        if (this.myParentClass == null) {
            if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{this.getRefactoringName()}), (String)this.getRefactoringName(), (String)this.getHelpID());
                return true;
            }
            if ("package-info.java".equals(file.getName())) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"error.not.supported.for.package.info", (Object[])new Object[]{this.getRefactoringName()}), (String)this.getRefactoringName(), (String)this.getHelpID());
                return true;
            }
            LOG.error((Object)file);
            return true;
        }
        if (!this.validClass(this.myParentClass, editor)) {
            return true;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return true;
        }
        OccurrenceManager occurrenceManager = this.createOccurrenceManager(selectedExpr, this.myParentClass);
        PsiExpression[] occurrences = occurrenceManager.getOccurrences();
        PsiElement anchorStatementIfAll = occurrenceManager.getAnchorStatementForAll();
        List<RangeHighlighter> highlighters = null;
        if (editor != null) {
            highlighters = RefactoringUtil.highlightAllOccurrences(project, (PsiElement[])occurrences, editor);
        }
        PsiElement tempAnchorElement = RefactoringUtil.getParentExpressionAnchorElement((PsiElement)selectedExpr);
        if (!Comparing.strEqual((String)IntroduceConstantHandler.REFACTORING_NAME, (String)this.getRefactoringName()) && IntroduceFieldHandler.isInSuperOrThis(selectedExpr) && this.isStaticFinalInitializer(selectedExpr) != null) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"invalid.expression.context"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)this.getRefactoringName(), (String)this.getHelpID());
            return true;
        }
        Settings settings = this.showRefactoringDialog(project, editor, this.myParentClass, selectedExpr, tempType, occurrences, tempAnchorElement, anchorStatementIfAll);
        if (settings == null) {
            return true;
        }
        if (settings.getForcedType() != null) {
            tempType = settings.getForcedType();
        }
        PsiType type2 = tempType;
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter highlighter : highlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
        ConvertToFieldRunnable runnable = new ConvertToFieldRunnable(settings.getSelectedExpr(), settings, type2, settings.getOccurrences(), occurrenceManager, anchorStatementIfAll, tempAnchorElement, editor, this.myParentClass);
        WriteCommandAction.writeCommandAction((Project)project).withName(this.getRefactoringName()).run(() -> runnable.run());
        return false;
    }

    public static void setModifiers(PsiField field, Settings settings) {
        if (!settings.isIntroduceEnumConstant()) {
            if (settings.isDeclareStatic()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            }
            if (settings.isDeclareFinal()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            }
            if (settings.isAnnotateAsNonNls()) {
                PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)field.getProject()).createAnnotationFromText("@org.jetbrains.annotations.NonNls", (PsiElement)field);
                PsiModifierList modifierList = field.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.addAfter((PsiElement)annotation, null);
            }
        }
        JavaCodeStyleManager.getInstance((Project)field.getProject()).shortenClassReferences((PsiElement)field);
    }

    public static PsiElement getPhysicalElement(PsiExpression selectedExpr) {
        PsiElement element = (PsiElement)selectedExpr.getUserData(ElementToWorkOn.PARENT);
        if (element == null) {
            element = selectedExpr;
        }
        return element;
    }

    private static TextAttributes highlightAttributes() {
        return EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    @Nullable
    protected PsiElement isStaticFinalInitializer(PsiExpression expr) {
        PsiClass parentClass;
        PsiClass psiClass = parentClass = expr != null ? this.getParentClass(expr) : null;
        if (parentClass == null) {
            return null;
        }
        IsStaticFinalInitializerExpression visitor = new IsStaticFinalInitializerExpression(parentClass, expr);
        expr.accept((PsiElementVisitor)visitor);
        return visitor.getElementReference();
    }

    protected abstract OccurrenceManager createOccurrenceManager(PsiExpression var1, PsiClass var2);

    protected final PsiClass getParentClass() {
        return this.myParentClass;
    }

    protected abstract boolean validClass(PsiClass var1, Editor var2);

    private static PsiElement getNormalizedAnchor(PsiElement anchorElement) {
        PsiElement prev;
        PsiElement child = anchorElement;
        while (child != null && !RefactoringUtil.isExpressionAnchorElement(prev = child.getPrevSibling()) && !PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.LBRACE)) {
            child = prev;
        }
        PsiElement anchor = (child = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child)) != null ? child : anchorElement;
        return anchor;
    }

    protected abstract String getHelpID();

    protected abstract Settings showRefactoringDialog(Project var1, Editor var2, PsiClass var3, PsiExpression var4, PsiType var5, PsiExpression[] var6, PsiElement var7, PsiElement var8);

    private static PsiType getTypeByExpression(PsiExpression expr) {
        return RefactoringUtil.getTypeByExpressionWithExpectedType(expr);
    }

    public PsiClass getParentClass(@NotNull PsiExpression initializerExpression) {
        PsiElement element;
        if (initializerExpression == null) {
            BaseExpressionToFieldHandler.$$$reportNull$$$0(1);
        }
        if ((element = (PsiElement)initializerExpression.getUserData(ElementToWorkOn.PARENT)) == null) {
            element = initializerExpression.getParent();
        }
        for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
            if (!(parent instanceof PsiClass) || parent instanceof PsiAnonymousClass && this.myIsConstant) continue;
            return (PsiClass)parent;
        }
        return null;
    }

    public static PsiMethod getEnclosingConstructor(PsiClass parentClass, PsiElement element) {
        PsiMethod[] constructors;
        if (element == null) {
            return null;
        }
        for (PsiMethod constructor : constructors = parentClass.getConstructors()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)element, (boolean)false)) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != parentClass) {
                return null;
            }
            return constructor;
        }
        return null;
    }

    private static void addInitializationToSetUp(PsiExpression initializer, PsiField field, PsiExpression[] occurrences, boolean replaceAll, PsiClass parentClass) throws IncorrectOperationException {
        PsiExpressionStatement expressionStatement;
        PsiAssignmentExpression expr;
        PsiExpression rExpression;
        PsiMethod setupMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod(parentClass);
        assert (setupMethod != null);
        PsiElement anchor = null;
        if (PsiTreeUtil.isAncestor((PsiElement)setupMethod, (PsiElement)initializer, (boolean)true)) {
            anchor = replaceAll ? RefactoringUtil.getAnchorElementForMultipleExpressions(occurrences, (PsiElement)setupMethod) : PsiTreeUtil.getParentOfType((PsiElement)initializer, PsiStatement.class);
        }
        LOG.assertTrue((rExpression = (expr = (PsiAssignmentExpression)(expressionStatement = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)parentClass.getProject()).createStatementFromText(field.getName() + "= expr;", null)).getExpression()).getRExpression()) != null);
        rExpression.replace((PsiElement)initializer);
        PsiCodeBlock body2 = setupMethod.getBody();
        assert (body2 != null);
        body2.addBefore((PsiElement)expressionStatement, anchor);
    }

    private static void addInitializationToConstructors(PsiExpression initializerExpression, PsiField field, PsiMethod enclosingConstructor, PsiClass parentClass) {
        try {
            PsiClass aClass = field.getContainingClass();
            PsiMethod[] constructors = aClass.getConstructors();
            boolean added = false;
            for (PsiMethod constructor : constructors) {
                String text2;
                PsiExpression expression2;
                PsiStatement first;
                PsiStatement[] statements;
                PsiCodeBlock body2;
                if (constructor == enclosingConstructor || (body2 = constructor.getBody()) == null || (statements = body2.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text2 = ((PsiMethodCallExpression)expression2).getMethodExpression().getText())) continue;
                PsiStatement assignment = BaseExpressionToFieldHandler.createAssignment(field, initializerExpression, body2.getLastChild(), parentClass);
                assignment = (PsiStatement)body2.add((PsiElement)assignment);
                ChangeContextUtil.decodeContextInfo((PsiElement)assignment, field.getContainingClass(), (PsiExpression)RefactoringChangeUtil.createThisExpression(field.getManager(), null));
                added = true;
            }
            if (!added && enclosingConstructor == null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)field.getProject());
                PsiMethod constructor = (PsiMethod)aClass.add((PsiElement)factory.createConstructor());
                PsiCodeBlock body3 = constructor.getBody();
                PsiStatement assignment = BaseExpressionToFieldHandler.createAssignment(field, initializerExpression, body3.getLastChild(), parentClass);
                assignment = (PsiStatement)body3.add((PsiElement)assignment);
                ChangeContextUtil.decodeContextInfo((PsiElement)assignment, field.getContainingClass(), (PsiExpression)RefactoringChangeUtil.createThisExpression(field.getManager(), null));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiField createField(String fieldName, PsiType type2, PsiExpression initializerExpr, boolean includeInitializer, PsiClass parentClass) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("private int ");
        pattern.append(fieldName);
        if (includeInitializer) {
            pattern.append("=0");
        }
        pattern.append(";");
        PsiManager psiManager = parentClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        try {
            PsiField field = factory.createFieldFromText(pattern.toString(), null);
            PsiTypeElement typeElement = factory.createTypeElement(type2);
            field.getTypeElement().replace((PsiElement)typeElement);
            field = (PsiField)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)field);
            if (includeInitializer) {
                field.getInitializer().replace((PsiElement)initializerExpr);
            }
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiStatement createAssignment(PsiField field, PsiExpression initializerExpr, PsiElement context, PsiClass parentClass) {
        try {
            String pattern = "x=0;";
            PsiManager psiManager = parentClass.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)statement);
            PsiAssignmentExpression expr = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression rExpression = expr.getRExpression();
            LOG.assertTrue(rExpression != null);
            rExpression.replace((PsiElement)initializerExpr);
            PsiReferenceExpression fieldReference = RenameJavaVariableProcessor.createMemberReference((PsiMember)field, context);
            expr.getLExpression().replace((PsiElement)fieldReference);
            return statement;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected abstract boolean accept(ElementToWorkOn var1);

    protected ElementToWorkOn.ElementsProcessor<ElementToWorkOn> getElementProcessor(final Project project, final Editor editor) {
        return new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            @Override
            public boolean accept(ElementToWorkOn el) {
                return BaseExpressionToFieldHandler.this.accept(el);
            }

            @Override
            public void pass(ElementToWorkOn elementToWorkOn) {
                boolean hasRunTemplate;
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getExpression() == null && elementToWorkOn.getLocalVariable() == null) {
                    ElementToWorkOn.showNothingSelectedErrorMessage(editor, BaseExpressionToFieldHandler.this.getRefactoringName(), BaseExpressionToFieldHandler.this.getHelpID(), project);
                    return;
                }
                boolean bl = hasRunTemplate = LookupManager.getActiveLookup((Editor)editor) == null;
                if (elementToWorkOn.getExpression() == null) {
                    boolean result;
                    PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
                    boolean bl2 = result = BaseExpressionToFieldHandler.this.invokeImpl(project, localVariable, editor) && hasRunTemplate;
                    if (result) {
                        editor.getSelectionModel().removeSelection();
                    }
                } else if (BaseExpressionToFieldHandler.this.invokeImpl(project, elementToWorkOn.getExpression(), editor) && hasRunTemplate) {
                    editor.getSelectionModel().removeSelection();
                }
            }
        };
    }

    protected abstract String getRefactoringName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IsStaticFinalInitializerExpression
    extends ClassMemberReferencesVisitor {
        private PsiElement myElementReference;
        private final PsiExpression myInitializer;
        private boolean myCheckThrowables = true;

        IsStaticFinalInitializerExpression(PsiClass aClass, PsiExpression initializer) {
            super(aClass);
            this.myInitializer = initializer;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression2) {
            PsiElement psiElement = expression2.resolve();
            if ((psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) && !PsiTreeUtil.isAncestor((PsiElement)this.myInitializer, (PsiElement)psiElement, (boolean)false)) {
                this.myElementReference = expression2;
            } else {
                super.visitReferenceExpression(expression2);
            }
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)expression2)) {
                super.visitMethodReferenceExpression(expression2);
            }
        }

        public void visitCallExpression(PsiCallExpression callExpression) {
            super.visitCallExpression(callExpression);
            if (!this.myCheckThrowables) {
                return;
            }
            List<PsiClassType> checkedExceptions = ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{callExpression});
            if (!checkedExceptions.isEmpty()) {
                this.myElementReference = callExpression;
            }
        }

        public void visitClass(PsiClass aClass) {
            this.myCheckThrowables = false;
            super.visitClass(aClass);
        }

        public void visitLambdaExpression(PsiLambdaExpression expression2) {
            this.myCheckThrowables = false;
            super.visitLambdaExpression(expression2);
        }

        @Override
        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (!classMember.hasModifierProperty("static")) {
                this.myElementReference = classMemberReference;
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myElementReference != null) {
                return;
            }
            super.visitElement(element);
        }

        @Nullable
        public PsiElement getElementReference() {
            return this.myElementReference;
        }
    }

    public static class ConvertToFieldRunnable
    implements Runnable {
        private PsiExpression mySelectedExpr;
        private final Settings mySettings;
        private final PsiElement myAnchorElement;
        private final Project myProject;
        private final String myFieldName;
        private final PsiType myType;
        private final PsiExpression[] myOccurrences;
        private final boolean myReplaceAll;
        private final OccurrenceManager myOccurrenceManager;
        private final PsiElement myAnchorStatementIfAll;
        private final PsiElement myAnchorElementIfOne;
        private final Boolean myOutOfCodeBlockExtraction;
        private final PsiElement myElement;
        private boolean myDeleteSelf;
        private final Editor myEditor;
        private final PsiClass myParentClass;
        private PsiField myField;

        public ConvertToFieldRunnable(PsiExpression selectedExpr, Settings settings, PsiType type2, PsiExpression[] occurrences, OccurrenceManager occurrenceManager, PsiElement anchorStatementIfAll, PsiElement anchorElementIfOne, Editor editor, PsiClass parentClass) {
            PsiStatement statement;
            this.mySelectedExpr = selectedExpr;
            this.mySettings = settings;
            this.myAnchorElement = settings.isReplaceAll() ? anchorStatementIfAll : anchorElementIfOne;
            this.myProject = selectedExpr.getProject();
            this.myFieldName = settings.getFieldName();
            this.myType = type2;
            this.myOccurrences = occurrences;
            this.myReplaceAll = settings.isReplaceAll();
            this.myOccurrenceManager = occurrenceManager;
            this.myAnchorStatementIfAll = anchorStatementIfAll;
            this.myAnchorElementIfOne = anchorElementIfOne;
            this.myOutOfCodeBlockExtraction = (Boolean)selectedExpr.getUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK);
            this.myDeleteSelf = this.myOutOfCodeBlockExtraction != null;
            this.myElement = BaseExpressionToFieldHandler.getPhysicalElement(selectedExpr);
            if (this.myElement.getParent() instanceof PsiExpressionStatement && BaseExpressionToFieldHandler.getNormalizedAnchor(this.myAnchorElement).equals(this.myAnchorElement) && selectedExpr.isPhysical() && (statement = (PsiStatement)this.myElement.getParent()).getParent() instanceof PsiCodeBlock) {
                this.myDeleteSelf = true;
            }
            this.myEditor = editor;
            this.myParentClass = parentClass;
        }

        @Override
        public void run() {
            try {
                PsiMember anchorMember;
                PsiClass destClass;
                InitializationPlace initializerPlace = this.mySettings.getInitializerPlace();
                PsiLocalVariable localVariable = this.mySettings.getLocalVariable();
                boolean deleteLocalVariable = this.mySettings.isDeleteLocalVariable();
                PsiExpression initializer = null;
                if (localVariable != null) {
                    initializer = localVariable.getInitializer();
                } else if (!(this.mySelectedExpr instanceof PsiReferenceExpression) || ((PsiReferenceExpression)this.mySelectedExpr).resolve() != null) {
                    initializer = this.mySelectedExpr;
                }
                SmartTypePointer type2 = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.myType);
                initializer = IntroduceVariableBase.simplifyVariableInitializer(initializer, this.myType, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION);
                PsiMethod enclosingConstructor = BaseExpressionToFieldHandler.getEnclosingConstructor(this.myParentClass, this.myAnchorElement);
                PsiClass psiClass = destClass = this.mySettings.getDestinationClass() == null ? this.myParentClass : this.mySettings.getDestinationClass();
                if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)destClass.getContainingFile())) {
                    return;
                }
                ChangeContextUtil.encodeContextInfo((PsiElement)destClass, true);
                this.myField = this.mySettings.isIntroduceEnumConstant() ? EnumConstantsUtil.createEnumConstant(destClass, this.myFieldName, initializer) : BaseExpressionToFieldHandler.createField(this.myFieldName, type2.getType(), initializer, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION && initializer != null, this.myParentClass);
                BaseExpressionToFieldHandler.setModifiers(this.myField, this.mySettings);
                PsiElement finalAnchorElement = null;
                if (destClass == this.myParentClass) {
                    for (finalAnchorElement = this.myAnchorElement; finalAnchorElement != null && finalAnchorElement.getParent() != destClass; finalAnchorElement = finalAnchorElement.getParent()) {
                    }
                }
                PsiMember psiMember = anchorMember = finalAnchorElement instanceof PsiMember ? (PsiMember)finalAnchorElement : null;
                if (anchorMember instanceof PsiEnumConstant && destClass == anchorMember.getContainingClass() && initializer != null && PsiTreeUtil.isAncestor((PsiElement)((PsiEnumConstant)anchorMember).getArgumentList(), (PsiElement)initializer, (boolean)false)) {
                    String initialName = "Constants";
                    String constantsClassName = "Constants";
                    PsiClass innerClass = destClass.findInnerClassByName(constantsClassName, true);
                    if (innerClass == null || !ConvertToFieldRunnable.isConstantsClass(innerClass)) {
                        int i = 1;
                        while (destClass.findInnerClassByName(constantsClassName, true) != null) {
                            constantsClassName = "Constants" + i++;
                        }
                        PsiClass psiClass2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createClass(constantsClassName);
                        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass2, (String)"private", (boolean)true);
                        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass2, (String)"static", (boolean)true);
                        destClass = (PsiClass)destClass.add((PsiElement)psiClass2);
                    } else {
                        destClass = innerClass;
                    }
                    anchorMember = null;
                }
                this.myField = ConvertToFieldRunnable.appendField(initializer, initializerPlace, destClass, this.myParentClass, this.myField, anchorMember);
                if (!this.mySettings.isIntroduceEnumConstant()) {
                    VisibilityUtil.fixVisibility((PsiExpression[])this.myOccurrences, (PsiMember)this.myField, (String)this.mySettings.getFieldVisibility());
                }
                PsiStatement assignStatement = null;
                PsiElement anchorElementHere = null;
                if (initializerPlace == InitializationPlace.IN_CURRENT_METHOD && initializer != null || initializerPlace == InitializationPlace.IN_CONSTRUCTOR && enclosingConstructor != null && initializer != null) {
                    PsiElement anchorInConstructor;
                    anchorElementHere = this.myReplaceAll ? (enclosingConstructor != null ? ((anchorInConstructor = RefactoringUtil.getAnchorElementForMultipleExpressions(this.mySettings.myOccurrences, (PsiElement)enclosingConstructor)) != null ? anchorInConstructor : this.myAnchorStatementIfAll) : this.myAnchorStatementIfAll) : this.myAnchorElementIfOne;
                    assignStatement = BaseExpressionToFieldHandler.createAssignment(this.myField, initializer, anchorElementHere, this.myParentClass);
                    if (anchorElementHere != null && !RefactoringUtil.isLoopOrIf(anchorElementHere.getParent())) {
                        anchorElementHere.getParent().addBefore((PsiElement)assignStatement, BaseExpressionToFieldHandler.getNormalizedAnchor(anchorElementHere));
                    }
                }
                if (initializerPlace == InitializationPlace.IN_CONSTRUCTOR && initializer != null) {
                    BaseExpressionToFieldHandler.addInitializationToConstructors(initializer, this.myField, enclosingConstructor, this.myParentClass);
                }
                if (initializerPlace == InitializationPlace.IN_SETUP_METHOD && initializer != null) {
                    BaseExpressionToFieldHandler.addInitializationToSetUp(initializer, this.myField, this.myOccurrences, this.myReplaceAll, this.myParentClass);
                }
                if (this.mySelectedExpr.getParent() instanceof PsiParenthesizedExpression) {
                    this.mySelectedExpr = (PsiExpression)this.mySelectedExpr.getParent();
                }
                if (this.myOutOfCodeBlockExtraction != null) {
                    PsiElement parent;
                    int endOffset = ((RangeMarker)this.mySelectedExpr.getUserData(ElementToWorkOn.TEXT_RANGE)).getEndOffset();
                    PsiElement endElement = this.myElement.getContainingFile().findElementAt(endOffset);
                    while (!((parent = endElement.getParent()) instanceof PsiClass)) {
                        endElement = parent;
                    }
                    PsiElement last = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endElement);
                    if (last.getTextRange().getStartOffset() < this.myElement.getTextRange().getStartOffset()) {
                        last = this.myElement;
                    }
                    this.myElement.getParent().deleteChildRange(this.myElement, last);
                } else if (this.myDeleteSelf) {
                    this.myElement.getParent().delete();
                }
                if (this.myReplaceAll) {
                    ArrayList<PsiElement> array = new ArrayList<PsiElement>();
                    for (PsiExpression occurrence : this.myOccurrences) {
                        PsiElement replaced;
                        occurrence = RefactoringUtil.outermostParenthesizedExpression(occurrence);
                        if (this.myDeleteSelf && occurrence.equals(this.mySelectedExpr) || (replaced = RefactoringUtil.replaceOccurenceWithFieldRef(occurrence, this.myField, destClass)) == null) continue;
                        array.add(replaced);
                    }
                    if (this.myEditor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                        PsiElement[] exprsToHighlight = PsiUtilCore.toPsiElementArray(array);
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
                        highlightManager.addOccurrenceHighlights(this.myEditor, exprsToHighlight, BaseExpressionToFieldHandler.highlightAttributes(), true, null);
                        WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                    }
                } else if (!this.myDeleteSelf) {
                    this.mySelectedExpr = RefactoringUtil.outermostParenthesizedExpression(this.mySelectedExpr);
                    RefactoringUtil.replaceOccurenceWithFieldRef(this.mySelectedExpr, this.myField, destClass);
                }
                if (anchorElementHere != null && RefactoringUtil.isLoopOrIf(anchorElementHere.getParent())) {
                    RefactoringUtil.putStatementInLoopBody(assignStatement, anchorElementHere.getParent(), anchorElementHere);
                }
                if (localVariable != null && deleteLocalVariable) {
                    localVariable.normalizeDeclaration();
                    localVariable.getParent().delete();
                }
                ChangeContextUtil.decodeContextInfo((PsiElement)destClass, destClass, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        static boolean isConstantsClass(PsiClass innerClass) {
            if (innerClass.getMethods().length != 0) {
                return false;
            }
            for (PsiField field : innerClass.getFields()) {
                if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
                return false;
            }
            return true;
        }

        static PsiField appendField(PsiExpression initializer, InitializationPlace initializerPlace, PsiClass destClass, PsiClass parentClass, PsiField psiField, PsiMember anchorMember) {
            return ConvertToFieldRunnable.appendField(destClass, psiField, (PsiElement)anchorMember, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION ? ConvertToFieldRunnable.checkForwardRefs(initializer, parentClass) : null);
        }

        public static PsiField appendField(PsiClass destClass, PsiField psiField, PsiElement anchorMember, PsiField forwardReference) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)anchorMember, PsiClass.class);
            if (anchorMember instanceof PsiField && anchorMember.getParent() == parentClass && destClass == parentClass && ((PsiField)anchorMember).hasModifierProperty("static") == psiField.hasModifierProperty("static")) {
                return (PsiField)destClass.addBefore((PsiElement)psiField, anchorMember);
            }
            if (anchorMember instanceof PsiClassInitializer && anchorMember.getParent() == parentClass && destClass == parentClass) {
                PsiField field = (PsiField)destClass.addBefore((PsiElement)psiField, anchorMember);
                destClass.addBefore(CodeEditUtil.createLineFeed((PsiManager)field.getManager()), anchorMember);
                return field;
            }
            if (forwardReference != null && forwardReference.getParent() == destClass) {
                return (PsiField)destClass.addAfter((PsiElement)psiField, (PsiElement)forwardReference);
            }
            return (PsiField)destClass.add((PsiElement)psiField);
        }

        @Nullable
        private static PsiField checkForwardRefs(final @Nullable PsiExpression initializer, final PsiClass parentClass) {
            if (initializer == null) {
                return null;
            }
            final PsiField[] refConstantFields = new PsiField[1];
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    super.visitReferenceExpression(expression2);
                    PsiElement resolve = expression2.resolve();
                    if (resolve instanceof PsiField && PsiTreeUtil.isAncestor((PsiElement)parentClass, (PsiElement)resolve, (boolean)false) && ((PsiField)resolve).hasInitializer() && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)resolve, (boolean)false) && (refConstantFields[0] == null || refConstantFields[0].getTextOffset() < resolve.getTextOffset())) {
                        refConstantFields[0] = (PsiField)resolve;
                    }
                }
            });
            return refConstantFields[0];
        }

        public PsiField getField() {
            return this.myField;
        }
    }

    public static class TargetDestination {
        private final String myQualifiedName;
        private final Project myProject;
        private PsiClass myParentClass;
        private PsiClass myTargetClass;

        public TargetDestination(String qualifiedName, PsiClass parentClass) {
            this.myQualifiedName = qualifiedName;
            this.myParentClass = parentClass;
            this.myProject = parentClass.getProject();
        }

        public TargetDestination(@NotNull PsiClass targetClass) {
            if (targetClass == null) {
                TargetDestination.$$$reportNull$$$0(0);
            }
            this.myTargetClass = targetClass;
            this.myQualifiedName = targetClass.getQualifiedName();
            this.myProject = targetClass.getProject();
        }

        @Nullable
        public PsiClass getTargetClass() {
            PsiDirectory[] directories;
            if (this.myTargetClass != null) {
                return this.myTargetClass;
            }
            String packageName = StringUtil.getPackageName((String)this.myQualifiedName);
            String shortName = StringUtil.getShortName((String)this.myQualifiedName);
            if (Comparing.strEqual((String)this.myParentClass.getQualifiedName(), (String)packageName)) {
                this.myTargetClass = (PsiClass)this.myParentClass.add((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createClass(shortName));
                return this.myTargetClass;
            }
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            PsiDirectory psiDirectory = psiPackage != null ? ((directories = psiPackage.getDirectories(GlobalSearchScope.allScope((Project)this.myProject))).length > 1 ? DirectoryChooserUtil.chooseDirectory((PsiDirectory[])directories, null, (Project)this.myProject, new HashMap()) : directories[0]) : PackageUtil.findOrCreateDirectoryForPackage(this.myProject, packageName, this.myParentClass.getContainingFile().getContainingDirectory(), false);
            this.myTargetClass = psiDirectory != null ? JavaDirectoryService.getInstance().createClass(psiDirectory, shortName) : null;
            return this.myTargetClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$TargetDestination", "<init>"));
        }
    }

    public static class Settings {
        private final String myFieldName;
        private final PsiType myForcedType;
        private final boolean myReplaceAll;
        private final boolean myDeclareStatic;
        private final boolean myDeclareFinal;
        private final InitializationPlace myInitializerPlace;
        private final String myVisibility;
        private final boolean myDeleteLocalVariable;
        private final TargetDestination myTargetClass;
        private final boolean myAnnotateAsNonNls;
        private final boolean myIntroduceEnumConstant;
        private final PsiExpression mySelectedExpr;
        private PsiExpression[] myOccurrences;
        private final PsiLocalVariable myLocalVariable;

        public PsiLocalVariable getLocalVariable() {
            return this.myLocalVariable;
        }

        public boolean isDeleteLocalVariable() {
            return this.myDeleteLocalVariable;
        }

        public String getFieldName() {
            return this.myFieldName;
        }

        public boolean isDeclareStatic() {
            return this.myDeclareStatic;
        }

        public boolean isDeclareFinal() {
            return this.myDeclareFinal;
        }

        public InitializationPlace getInitializerPlace() {
            return this.myInitializerPlace;
        }

        public String getFieldVisibility() {
            return this.myVisibility;
        }

        @Nullable
        public PsiClass getDestinationClass() {
            return this.myTargetClass != null ? this.myTargetClass.getTargetClass() : null;
        }

        public PsiType getForcedType() {
            return this.myForcedType;
        }

        public boolean isReplaceAll() {
            return this.myReplaceAll;
        }

        public boolean isAnnotateAsNonNls() {
            return this.myAnnotateAsNonNls;
        }

        public boolean isIntroduceEnumConstant() {
            return this.myIntroduceEnumConstant;
        }

        public Settings(String fieldName, PsiExpression selectedExpr, PsiExpression[] occurrences, boolean replaceAll, boolean declareStatic, boolean declareFinal, InitializationPlace initializerPlace, String visibility, PsiLocalVariable localVariableToRemove, PsiType forcedType, boolean deleteLocalVariable, TargetDestination targetDestination, boolean annotateAsNonNls, boolean introduceEnumConstant) {
            this.myFieldName = fieldName;
            this.myOccurrences = occurrences;
            this.mySelectedExpr = selectedExpr;
            this.myReplaceAll = replaceAll;
            this.myDeclareStatic = declareStatic;
            this.myDeclareFinal = declareFinal;
            this.myInitializerPlace = initializerPlace;
            this.myVisibility = visibility;
            this.myLocalVariable = localVariableToRemove;
            this.myDeleteLocalVariable = deleteLocalVariable;
            this.myForcedType = forcedType;
            this.myTargetClass = targetDestination;
            this.myAnnotateAsNonNls = annotateAsNonNls;
            this.myIntroduceEnumConstant = introduceEnumConstant;
        }

        public Settings(String fieldName, PsiExpression selectedExpression, PsiExpression[] occurrences, boolean replaceAll, boolean declareStatic, boolean declareFinal, InitializationPlace initializerPlace, String visibility, PsiLocalVariable localVariableToRemove, PsiType forcedType, boolean deleteLocalVariable, PsiClass targetClass, boolean annotateAsNonNls, boolean introduceEnumConstant) {
            this(fieldName, selectedExpression, occurrences, replaceAll, declareStatic, declareFinal, initializerPlace, visibility, localVariableToRemove, forcedType, deleteLocalVariable, new TargetDestination(targetClass), annotateAsNonNls, introduceEnumConstant);
        }

        public PsiExpression getSelectedExpr() {
            return this.mySelectedExpr;
        }

        public PsiExpression[] getOccurrences() {
            return this.myOccurrences;
        }

        public void setOccurrences(PsiExpression[] occurrences) {
            this.myOccurrences = occurrences;
        }
    }

    public static enum InitializationPlace {
        IN_CURRENT_METHOD,
        IN_FIELD_DECLARATION,
        IN_CONSTRUCTOR,
        IN_SETUP_METHOD;

    }
}

