/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodHandler;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;

public class InlineMethodDialog
extends InlineOptionsWithSearchSettingsDialog {
    public static final String REFACTORING_NAME = RefactoringBundle.message((String)"inline.method.title");
    private final PsiJavaCodeReferenceElement myReferenceElement;
    private final Editor myEditor;
    private final boolean myAllowInlineThisOnly;
    private final PsiMethod myMethod;
    private final int myOccurrencesNumber;

    public InlineMethodDialog(Project project, PsiMethod method, PsiJavaCodeReferenceElement ref, Editor editor, boolean allowInlineThisOnly) {
        super(project, true, (PsiElement)method);
        this.myMethod = method;
        this.myReferenceElement = ref;
        this.myEditor = editor;
        this.myAllowInlineThisOnly = allowInlineThisOnly;
        this.myInvokedOnReference = ref != null;
        this.myOccurrencesNumber = this.getNumberOfOccurrences((PsiNameIdentifierOwner)method);
        this.setTitle(REFACTORING_NAME);
        this.init();
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected String getNameLabelText() {
        String occurrencesString = this.myOccurrencesNumber > -1 ? "has " + this.myOccurrencesNumber + " occurrence" + (this.myOccurrencesNumber == 1 ? "" : "s") : "";
        String methodText = PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
        return RefactoringBundle.message((String)"inline.method.method.label", (Object[])new Object[]{methodText, occurrencesString});
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.invocation.only.and.keep.the.method");
    }

    protected String getInlineAllText() {
        return RefactoringBundle.message((String)(this.myMethod.isWritable() ? "all.invocations.and.remove.the.method" : "all.invocations.in.project"));
    }

    protected String getKeepTheDeclarationText() {
        if (this.myMethod.isWritable()) {
            return RefactoringBundle.message((String)"all.invocations.keep.the.method");
        }
        return super.getKeepTheDeclarationText();
    }

    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineMethodProcessor(this.getProject(), this.myMethod, this.myReferenceElement, this.myEditor, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences(), !this.isKeepTheDeclaration()));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_METHOD_THIS = this.isInlineThisOnly();
        }
    }

    protected String getHelpId() {
        return this.myMethod.isConstructor() ? "refactoring.inlineConstructor" : "refactoring.inlineMethod";
    }

    protected boolean canInlineThisOnly() {
        return InlineMethodHandler.checkRecursive(this.myMethod) || this.myAllowInlineThisOnly;
    }

    protected boolean ignoreOccurrence(PsiReference reference) {
        return PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStatementBase.class) == null;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_METHOD_THIS;
    }

    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = searchInComments;
    }

    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
    }

    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = searchInTextOccurrences;
    }
}

